/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalAndFolderVariablesDecorator$;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksUnionSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.service.SqlTasksFilterSupport$;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.service.TaskSearchService;
import com.xebialabs.xlrelease.views.ReleaseTasks;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.TaskSearchView;
import com.xebialabs.xlrelease.views.TasksFilters;
import com.xebialabs.xlrelease.views.converters.TasksViewConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0005a\u0001B\n\u0015\u0001uA\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\tw\u0001\u0011\t\u0011)A\u0005y!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0006\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0011B/\t\u0011\u0001\u0004!\u0011!Q\u0001\n\u0005D\u0001\u0002\u001a\u0001\u0003\u0006\u0004%\t!\u001a\u0005\tU\u0002\u0011\t\u0011)A\u0005M\"A1\u000e\u0001BC\u0002\u0013\rA\u000e\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003n\u0011!\t\bA!b\u0001\n\u0007\u0011\b\"CA\u000b\u0001\t\u0005\t\u0015!\u0003t\u0011\u001d\t9\u0002\u0001C\u0001\u00033Aq!!\r\u0001\t\u0003\n\u0019\u0004C\u0004\u0002h\u0001!I!!\u001b\t\u000f\u0005%\u0006\u0001\"\u0003\u0002,\"9\u0011Q\u001b\u0001\u0005\n\u0005]'\u0001F*rYR\u000b7o[*fCJ\u001c\u0007nU3sm&\u001cWM\u0003\u0002\u0016-\u000591/\u001a:wS\u000e,'BA\f\u0019\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001a5\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00027\u0005\u00191m\\7\u0004\u0001M!\u0001A\b\u0014+!\tyB%D\u0001!\u0015\t\t#%\u0001\u0003mC:<'\"A\u0012\u0002\t)\fg/Y\u0005\u0003K\u0001\u0012aa\u00142kK\u000e$\bCA\u0014)\u001b\u0005!\u0012BA\u0015\u0015\u0005E!\u0016m]6TK\u0006\u00148\r[*feZL7-\u001a\t\u0003WAj\u0011\u0001\f\u0006\u0003[9\nQa\u001d7gi)T\u0011aL\u0001\tOJL'P\u001f7fI&\u0011\u0011\u0007\f\u0002\b\u0019><w-\u001b8h\u0003-\u0011x\u000e\\3TKJ4\u0018nY3\u0011\u0005QJT\"A\u001b\u000b\u0005Y:\u0014\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005aB\u0012\u0001\u00033fa2|\u00170\u001b;\n\u0005i*$a\u0003*pY\u0016\u001cVM\u001d<jG\u0016\f\u0011\u0003^1tW\u0006\u001b7-Z:t'\u0016\u0014h/[2f!\t9S(\u0003\u0002?)\t\tB+Y:l\u0003\u000e\u001cWm]:TKJ4\u0018nY3\u0002%Q\f7o[:WS\u0016<8i\u001c8wKJ$XM\u001d\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000b!bY8om\u0016\u0014H/\u001a:t\u0015\t)e#A\u0003wS\u0016<8/\u0003\u0002H\u0005\n\u0011B+Y:lgZKWm^\"p]Z,'\u000f^3s\u0003A!WmY8sCR|'oU3sm&\u001cW\r\u0005\u0002K\u001f6\t1J\u0003\u0002M\u001b\u0006A\u0011N\u001c;fe:\fGN\u0003\u0002O-\u0005\u0019\u0011\r]5\n\u0005A[%\u0001I%oi\u0016\u0014h.\u00197NKR\fG-\u0019;b\t\u0016\u001cwN]1u_J\u001cVM\u001d<jG\u0016\f!C]3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dKB\u00111KW\u0007\u0002)*\u0011QKV\u0001\fa\u0016\u00148/[:uK:\u001cWM\u0003\u0002X1\u0006\u00191/\u001d7\u000b\u0005e3\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u00111\f\u0016\u0002\u0013%\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW-A\buCN\\\u0007+\u001a:tSN$XM\\2f!\t\u0019f,\u0003\u0002`)\nyA+Y:l!\u0016\u00148/[:uK:\u001cW-\u0001\nd_6lWM\u001c;QKJ\u001c\u0018n\u001d;f]\u000e,\u0007CA*c\u0013\t\u0019GK\u0001\nD_6lWM\u001c;QKJ\u001c\u0018n\u001d;f]\u000e,\u0017!\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;feV\ta\r\u0005\u0002hQ6\ta+\u0003\u0002j-\n!2+\u001d7SKB|7/\u001b;pef\fE-\u00199uKJ\f!C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3sA\u0005\u0011\u0002/\u001a:nSN\u001c\u0018n\u001c8F]\u001a|'oY3s+\u0005i\u0007C\u0001\u001bo\u0013\tyWG\u0001\nQKJl\u0017n]:j_:,eNZ8sG\u0016\u0014\u0018a\u00059fe6L7o]5p]\u0016sgm\u001c:dKJ\u0004\u0013AC:rY\u0012K\u0017\r\\3diV\t1\u000fE\u0002u\u0003\u001fq1!^A\u0005\u001d\r1\u0018Q\u0001\b\u0004o\u0006\u0005aB\u0001=\u0000\u001d\tIhP\u0004\u0002{{6\t1P\u0003\u0002}9\u00051AH]8pizJ\u0011aG\u0005\u00033iI!a\u0006\r\n\u0007\u0005\ra#\u0001\u0002eE&\u0019q+a\u0002\u000b\u0007\u0005\ra#\u0003\u0003\u0002\f\u00055\u0011AC*rY\n+\u0018\u000e\u001c3fe*\u0019q+a\u0002\n\t\u0005E\u00111\u0003\u0002\b\t&\fG.Z2u\u0015\u0011\tY!!\u0004\u0002\u0017M\fH\u000eR5bY\u0016\u001cG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015-\u0005m\u0011QDA\u0010\u0003C\t\u0019#!\n\u0002(\u0005%\u00121FA\u0017\u0003_\u0001\"a\n\u0001\t\u000bIr\u0001\u0019A\u001a\t\u000bmr\u0001\u0019\u0001\u001f\t\u000b}r\u0001\u0019\u0001!\t\u000b!s\u0001\u0019A%\t\u000bEs\u0001\u0019\u0001*\t\u000bqs\u0001\u0019A/\t\u000b\u0001t\u0001\u0019A1\t\u000b\u0011t\u0001\u0019\u00014\t\u000b-t\u00019A7\t\u000bEt\u00019A:\u0002#\u001d,G\u000fV1tWN\u0014\u0015PU3mK\u0006\u001cX\r\u0006\u0004\u00026\u0005u\u0012q\t\t\u0005\u0003o\tI$D\u0001E\u0013\r\tY\u0004\u0012\u0002\u000f)\u0006\u001c8nU3be\u000eDg+[3x\u0011\u001d\tyd\u0004a\u0001\u0003\u0003\nA\u0002^1tWN4\u0015\u000e\u001c;feN\u0004B!a\u000e\u0002D%\u0019\u0011Q\t#\u0003\u0019Q\u000b7o[:GS2$XM]:\t\u000f\u0005%s\u00021\u0001\u0002L\u0005!B.[7jiR\u000b7o[:IS:$x\n\u001d;j_:\u00042aHA'\u0013\r\ty\u0005\t\u0002\b\u0013:$XmZ3sQ\ry\u00111\u000b\t\u0005\u0003+\n\u0019'\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003;\ny&A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005\u0005$$\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\t)'a\u0016\u0003\u000bQKW.\u001a3\u0002\tQLW.Z\u000b\u0005\u0003W\n\u0019\b\u0006\u0003\u0002n\u0005UE\u0003BA8\u0003\u0017\u0003B!!\u001d\u0002t1\u0001AaBA;!\t\u0007\u0011q\u000f\u0002\u0002\u0003F!\u0011\u0011PAC!\u0011\tY(!!\u000e\u0005\u0005u$BAA@\u0003\u0015\u00198-\u00197b\u0013\u0011\t\u0019)! \u0003\u000f9{G\u000f[5oOB!\u00111PAD\u0013\u0011\tI)! \u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\u000eB!\t\u0019AAH\u0003\u0015\u0011Gn\\2l!\u0019\tY(!%\u0002p%!\u00111SA?\u0005!a$-\u001f8b[\u0016t\u0004bBAL!\u0001\u0007\u0011\u0011T\u0001\u0005I\u0016\u001c8\r\u0005\u0003\u0002\u001c\u0006\rf\u0002BAO\u0003?\u00032A_A?\u0013\u0011\t\t+! \u0002\rA\u0013X\rZ3g\u0013\u0011\t)+a*\u0003\rM#(/\u001b8h\u0015\u0011\t\t+! \u0002%M|'\u000f\u001e\"z%\u0016dW-Y:f)&$H.\u001a\u000b\u0005\u0003[\u000by\f\u0005\u0004\u00020\u0006U\u0016\u0011X\u0007\u0003\u0003cS1!a-#\u0003\u0011)H/\u001b7\n\t\u0005]\u0016\u0011\u0017\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u00028\u0005m\u0016bAA_\t\na!+\u001a7fCN,G+Y:lg\"9\u0011\u0011Y\tA\u0002\u0005\r\u0017!\u0004:fY\u0016\f7/Z:UCN\\7\u000f\u0005\u0004\u0002F\u0006=\u0017\u0011\u0018\b\u0005\u0003\u000f\fYMD\u0002{\u0003\u0013L!!a \n\t\u00055\u0017QP\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t.a5\u0003\u0007M+\u0017O\u0003\u0003\u0002N\u0006u\u0014!D:fCJ\u001c\u0007\u000eV1tW&#7\u000f\u0006\u0004\u0002Z\u0006U\u0018q\u001f\t\u0007\u0003\u000b\fy-a7\u0011\t\u0005u\u0017q\u001e\b\u0005\u0003?\fYO\u0004\u0003\u0002b\u0006%h\u0002BAr\u0003Ot1a^As\u0013\tIf#\u0003\u0002X1&\u0011QKV\u0005\u0004\u0003[$\u0016\u0001B\"j\u0013\u0012LA!!=\u0002t\n!1)[%e\u0015\r\ti\u000f\u0016\u0005\b\u0003\u007f\u0011\u0002\u0019AA!\u0011\u001d\tIP\u0005a\u0001\u0003w\fQ\u0001\\5nSR\u0004B!a\u001f\u0002~&!\u0011q`A?\u0005\rIe\u000e\u001e")
public class SqlTaskSearchService
implements TaskSearchService,
Logging {
    private final RoleService roleService;
    private final TaskAccessService taskAccessService;
    private final TasksViewConverter tasksViewConverter;
    private final InternalMetadataDecoratorService decoratorService;
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final CommentPersistence commentPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final PermissionEnforcer permissionEnforcer;
    private final SqlBuilder.Dialect sqlDialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskSearchService sqlTaskSearchService = this;
        synchronized (sqlTaskSearchService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    @Timed
    public TaskSearchView getTasksByRelease(TasksFilters tasksFilters, Integer limitTasksHintOption) {
        int limit = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)limitTasksHintOption).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 30));
        Seq taskIds = (Seq)this.time("finding task ids", (Function0 & Serializable & scala.Serializable)() -> this.searchTaskIds(tasksFilters, limit));
        Seq releaseIds = (Seq)((SeqLike)taskIds.map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.releaseIdFrom((String)x$1), Seq$.MODULE$.canBuildFrom())).distinct();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Found ").append(taskIds.size()).append(" tasks in ").append(releaseIds.size()).append(" releases for user ").append(Permissions.getAuthenticatedUserName()).toString());
        List allowedTaskTypesForAuthenticatedUser = (List)this.time("fetching allowed task types for authenticated user", (Function0 & Serializable & scala.Serializable)() -> $this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser());
        Tuple2 queryReleases = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withReleaseIds((Seq<String>)releaseIds).build();
        Seq releasesTasks = (Seq)this.time("total time to create releasesTasks", (Function0 & Serializable & scala.Serializable)() -> {
            Seq releases = (Seq)((GenericTraversableTemplate)this.time("de-serializing releases", (Function0 & Serializable & scala.Serializable)() -> {
                ResolveOptions resolveOptions = new ResolveOptionsBuilder().build();
                return (Seq)$this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)queryReleases).map((Function1 & Serializable & scala.Serializable)releaseData -> this.repositoryAdapter().tryDeserialize(resolveOptions, (ReleaseRow)releaseData), Seq$.MODULE$.canBuildFrom());
            })).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
            $this.decoratorService.decorate((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(releases).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ReleaseGlobalAndFolderVariablesDecorator$.MODULE$.GLOBAL_AND_FOLDER_VARIABLES(), EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))).asJava());
            Map<String, Object> commentsByTasks = $this.commentPersistence.countByTasks((Seq<Integer>)((Seq)releases.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getCiUid(), Seq$.MODULE$.canBuildFrom())));
            return (Seq)releases.map((Function1 & Serializable & scala.Serializable)release -> {
                Buffer orderedTasks = (Buffer)((TraversableLike)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)taskIds.exists((Function1 & Serializable & scala.Serializable)foundId -> BoxesRunTime.boxToBoolean((boolean)SqlTaskSearchService.$anonfun$getTasksByRelease$14(task, foundId)))))).sortBy((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToInteger((int)taskIds.indexWhere((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)SqlTaskSearchService.$anonfun$getTasksByRelease$16(task, id)))), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)task -> {
                    TaskFullView fullView = $this.tasksViewConverter.toFullView(task, allowedTaskTypesForAuthenticatedUser);
                    fullView.setNumberOfComments(BoxesRunTime.unboxToInt((Object)commentsByTasks.getOrElse((Object)Ids.getFolderlessId((String)fullView.getId()), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)));
                    return fullView;
                }, Buffer$.MODULE$.canBuildFrom());
                return new ReleaseTasks(release, (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(orderedTasks).asJava());
            }, Seq$.MODULE$.canBuildFrom());
        });
        return new TaskSearchView(this.sortByReleaseTitle((Seq<ReleaseTasks>)releasesTasks), taskIds.size() >= limit);
    }

    private <A> A time(String desc, Function0<A> block) {
        long startTime = System.currentTimeMillis();
        Object res = block.apply();
        long endTime = System.currentTimeMillis();
        long total = endTime - startTime;
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("TIME: ").append(desc).append(" took ").append(total).toString());
        return (A)res;
    }

    private List<ReleaseTasks> sortByReleaseTitle(Seq<ReleaseTasks> releasesTasks) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)releasesTasks.sortBy((Function1 & Serializable & scala.Serializable)releaseTasks -> (String)Option$.MODULE$.apply((Object)releaseTasks.getTitle()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (Ordering)Ordering.String$.MODULE$)).asJava();
    }

    private Seq<String> searchTaskIds(TasksFilters tasksFilters, int limit) {
        Iterable principals = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
        Buffer roleIds = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Buffer$.MODULE$.canBuildFrom());
        Tuple2<String, Seq<Object>> tasksQuery = ((TasksUnionSqlBuilder)SqlTasksFilterSupport$.MODULE$.sqlBuilderByFilters(tasksFilters, (Iterable<String>)principals, (Iterable<String>)roleIds, this.permissionEnforcer(), this.sqlDialect()).limit(limit)).build();
        return this.taskPersistence.findTaskIdsByQuery(tasksQuery);
    }

    public static final /* synthetic */ boolean $anonfun$getTasksByRelease$14(Task task$1, String foundId) {
        return task$1.getId().endsWith(foundId);
    }

    public static final /* synthetic */ boolean $anonfun$getTasksByRelease$16(Task task$2, String id) {
        return task$2.getId().startsWith(id);
    }

    public SqlTaskSearchService(RoleService roleService, TaskAccessService taskAccessService, TasksViewConverter tasksViewConverter, InternalMetadataDecoratorService decoratorService, ReleasePersistence releasePersistence, TaskPersistence taskPersistence, CommentPersistence commentPersistence, SqlRepositoryAdapter repositoryAdapter, PermissionEnforcer permissionEnforcer, SqlBuilder.Dialect sqlDialect) {
        this.roleService = roleService;
        this.taskAccessService = taskAccessService;
        this.tasksViewConverter = tasksViewConverter;
        this.decoratorService = decoratorService;
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.commentPersistence = commentPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.permissionEnforcer = permissionEnforcer;
        this.sqlDialect = sqlDialect;
        Logging.$init$((Logging)this);
    }
}

