/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.IdMatchers;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.reflect.ScalaSignature;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001\u0002\u0006\f\u0001YA\u0001\"\n\u0001\u0003\u0006\u0004%\tA\n\u0005\t[\u0001\u0011\t\u0011)A\u0005O!Aa\u0006\u0001BC\u0002\u0013\u0005q\u0006\u0003\u00054\u0001\t\u0005\t\u0015!\u00031\u0011\u0015!\u0004\u0001\"\u00016\u0011\u0015I\u0004\u0001\"\u0011;\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u0015q\b\u0001\"\u0003\u0000\u0011\u001d\tY\u0001\u0001C\u0005\u0003\u001b\u0011QcU9m!2\fg.\u0013;f[J+\u0007o\\:ji>\u0014\u0018P\u0003\u0002\r\u001b\u0005\u00191/\u001d7\u000b\u00059y\u0011A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011\u0001#E\u0001\nq2\u0014X\r\\3bg\u0016T!AE\n\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u000b\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u00019R$\t\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005yyR\"A\u0007\n\u0005\u0001j!A\u0005)mC:LE/Z7SKB|7/\u001b;pef\u0004\"AI\u0012\u000e\u0003-I!\u0001J\u0006\u0003-\u0011+7/\u001a:jC2L'0\u0019;j_:\u001cV\u000f\u001d9peR\f!C]3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dKV\tq\u0005\u0005\u0002)W5\t\u0011F\u0003\u0002+\u0017\u0005Y\u0001/\u001a:tSN$XM\\2f\u0013\ta\u0013F\u0001\nSK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0017a\u0005:fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016\u0004\u0013!\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;feV\t\u0001\u0007\u0005\u0002#c%\u0011!g\u0003\u0002\u0015'Fd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0002%I,\u0007o\\:ji>\u0014\u00180\u00113baR,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007Y:\u0004\b\u0005\u0002#\u0001!)Q%\u0002a\u0001O!)a&\u0002a\u0001a\u00051Q\r_5tiN$\"a\u000f \u0011\u0005aa\u0014BA\u001f\u001a\u0005\u001d\u0011un\u001c7fC:DQa\u0010\u0004A\u0002\u0001\u000b!!\u001b3\u0011\u0005\u0005\u001bfB\u0001\"R\u001d\t\u0019\u0005K\u0004\u0002E\u001f:\u0011QI\u0014\b\u0003\r6s!a\u0012'\u000f\u0005![U\"A%\u000b\u0005)+\u0012A\u0002\u001fs_>$h(C\u0001\u0015\u0013\t\u00112#\u0003\u0002\u0011#%\u0011abD\u0005\u0003\u00195I!AK\u0006\n\u0005IK\u0013\u0001B\"j\u0013\u0012L!\u0001V+\u0003\t\rK\u0017\n\u001a\u0006\u0003%&B#AB,\u0011\u0005asV\"A-\u000b\u0005i[\u0016a\u0003;sC:\u001c\u0018m\u0019;j_:T!\u0001\u0004/\u000b\u0005u{\u0011A\u00013c\u0013\ty\u0016L\u0001\u0006JgJ+\u0017\rZ(oYfD#AB1\u0011\u0005\tLW\"A2\u000b\u0005\u0011,\u0017AC1o]>$\u0018\r^5p]*\u0011amZ\u0001\b[\u0016$(/[2t\u0015\tA7#\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\tQ7MA\u0003US6,G-\u0001\u0005gS:$')_%e+\ti\u0007\u000f\u0006\u0002oyB\u0011q\u000e\u001d\u0007\u0001\t\u0015\txA1\u0001s\u0005\u0005!\u0016CA:w!\tAB/\u0003\u0002v3\t9aj\u001c;iS:<\u0007CA<{\u001b\u0005A(BA=\u0010\u0003\u0019!w.\\1j]&\u00111\u0010\u001f\u0002\t!2\fg.\u0013;f[\")qh\u0002a\u0001\u0001\"\u0012q!Y\u0001\rM&tG\r\u00157b]&#X-\\\u000b\u0005\u0003\u0003\t)\u0001\u0006\u0003\u0002\u0004\u0005\u001d\u0001cA8\u0002\u0006\u0011)\u0011\u000f\u0003b\u0001e\"1\u0011\u0011\u0002\u0005A\u0002\u0001\u000bAaY5JI\u0006Ya-\u001b8e%\u0016dW-Y:f+\u0011\ty!!\u0007\u0015\t\u0005E\u0011q\u0003\t\u0004o\u0006M\u0011bAA\u000bq\n9!+\u001a7fCN,\u0007\"B \n\u0001\u0004\u0001EaBA\u000b\u0013\t\u0007\u00111D\t\u0004g\u0006u\u0001c\u0001\r\u0002 %\u0019\u0011\u0011E\r\u0003\u0007\u0005s\u0017\u0010K\u0002\u0001\u0003K\u00012\u0001WA\u0014\u0013\r\tI#\u0017\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0002")
public class SqlPlanItemRepository
implements PlanItemRepository,
DeserializationSupport {
    private final ReleasePersistence releasePersistence;
    private final SqlRepositoryAdapter repositoryAdapter;

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData);
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String id) {
        boolean bl;
        try {
            this.findPlanItem(id);
            bl = true;
        }
        catch (NotFoundException notFoundException) {
            bl = false;
        }
        return bl;
    }

    @Timed
    public <T extends PlanItem> T findById(String id) {
        return this.findPlanItem(id);
    }

    private <T extends PlanItem> T findPlanItem(String ciId) {
        Release release;
        String string = CiId$.MODULE$.RichCiId(ciId).normalized();
        Option option = IdMatchers.ReleaseId$.MODULE$.unapply(string);
        if (!option.isEmpty()) {
            String id = (String)option.get();
            release = this.findRelease(id);
        } else {
            Option option2 = IdMatchers.PhaseId$.MODULE$.unapply(string);
            if (!option2.isEmpty()) {
                String id = (String)option2.get();
                release = this.findRelease(Ids.releaseIdFrom((String)id)).getPhase(id);
            } else {
                Option option3 = IdMatchers.TaskId$.MODULE$.unapply(string);
                if (!option3.isEmpty()) {
                    String id = (String)option3.get();
                    release = this.findRelease(Ids.releaseIdFrom((String)id)).getTask(id);
                } else {
                    throw new NotFoundException(new StringBuilder(17).append("Item [").append(string).append("] not found").toString(), new Object[0]);
                }
            }
        }
        return (T)release;
    }

    private <Release> Release findRelease(String id) {
        String releaseId = Ids.releaseIdFrom((String)CiId$.MODULE$.RichCiId(id).normalized());
        return (Release)this.releasePersistence().findByReleaseId(releaseId).map((Function1 & Serializable & scala.Serializable)releaseData -> this.deserializeRelease((ReleaseRow)releaseData)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(20).append("Release [").append(id).append("] not found").toString(), new Object[0]);
        });
    }

    public SqlPlanItemRepository(ReleasePersistence releasePersistence, SqlRepositoryAdapter repositoryAdapter) {
        this.releasePersistence = releasePersistence;
        this.repositoryAdapter = repositoryAdapter;
        DeserializationSupport.$init$(this);
    }
}

