/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalVariablesDecorator$;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksUnionSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.service.SqlTasksFilterSupport$;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.service.TaskSearchService;
import com.xebialabs.xlrelease.views.ReleaseTasks;
import com.xebialabs.xlrelease.views.TaskSearchView;
import com.xebialabs.xlrelease.views.TasksFilters;
import com.xebialabs.xlrelease.views.converters.TasksViewConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001B\u0001\u0003\u0001-\u0011AcU9m)\u0006\u001c8nU3be\u000eD7+\u001a:wS\u000e,'BA\u0002\u0005\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u0002\u0004\u0002\u0013ad'/\u001a7fCN,'BA\u0004\t\u0003%AXMY5bY\u0006\u00147OC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001A\u0002\u0006\r\u0011\u00055\u0011R\"\u0001\b\u000b\u0005=\u0001\u0012\u0001\u00027b]\u001eT\u0011!E\u0001\u0005U\u00064\u0018-\u0003\u0002\u0014\u001d\t1qJ\u00196fGR\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003#Q\u000b7o[*fCJ\u001c\u0007nU3sm&\u001cW\r\u0005\u0002\u001a=5\t!D\u0003\u0002\u001c9\u0005)1\u000f\u001c45U*\tQ$\u0001\u0005he&T(\u0010\\3e\u0013\ty\"DA\u0004M_\u001e<\u0017N\\4\t\u0011\u0005\u0002!\u0011!Q\u0001\n\t\n1B]8mKN+'O^5dKB\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\tg\u0016\u001cWO]5us*\u0011qEB\u0001\tI\u0016\u0004Hn\\=ji&\u0011\u0011\u0006\n\u0002\f%>dWmU3sm&\u001cW\r\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0003E!\u0018m]6BG\u000e,7o]*feZL7-\u001a\t\u0003+5J!A\f\u0002\u0003#Q\u000b7o[!dG\u0016\u001c8oU3sm&\u001cW\r\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0003I!\u0018m]6t-&,woQ8om\u0016\u0014H/\u001a:\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014AC2p]Z,'\u000f^3sg*\u0011a\u0007B\u0001\u0006m&,wo]\u0005\u0003qM\u0012!\u0003V1tWN4\u0016.Z<D_:4XM\u001d;fe\"A!\b\u0001B\u0001B\u0003%1(\u0001\teK\u000e|'/\u0019;peN+'O^5dKB\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\tS:$XM\u001d8bY*\u0011\u0001\tB\u0001\u0004CBL\u0017B\u0001\">\u0005\u0001Je\u000e^3s]\u0006dW*\u001a;bI\u0006$\u0018\rR3d_J\fGo\u001c:TKJ4\u0018nY3\t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0015\u000b!C]3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dKB\u0011a)T\u0007\u0002\u000f*\u0011\u0001*S\u0001\fa\u0016\u00148/[:uK:\u001cWM\u0003\u0002K\u0017\u0006\u00191/\u001d7\u000b\u00051#\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011aj\u0012\u0002\u0013%\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW\r\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003R\u0003=!\u0018m]6QKJ\u001c\u0018n\u001d;f]\u000e,\u0007C\u0001$S\u0013\t\u0019vIA\bUCN\\\u0007+\u001a:tSN$XM\\2f\u0011!)\u0006A!b\u0001\n\u00031\u0016!\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;feV\tq\u000b\u0005\u0002Y36\t\u0011*\u0003\u0002[\u0013\n!2+\u001d7SKB|7/\u001b;pef\fE-\u00199uKJD\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006IaV\u0001\u0013e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\b\u0005\u0003\u0005_\u0001\t\u0015\r\u0011b\u0001`\u0003I\u0001XM]7jgNLwN\\#oM>\u00148-\u001a:\u0016\u0003\u0001\u0004\"aI1\n\u0005\t$#A\u0005)fe6L7o]5p]\u0016sgm\u001c:dKJD\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I\u0001Y\u0001\u0014a\u0016\u0014X.[:tS>tWI\u001c4pe\u000e,'\u000f\t\u0005\tM\u0002\u0011)\u0019!C\u0002O\u0006Q1/\u001d7ES\u0006dWm\u0019;\u0016\u0003!\u0004\"!\u001b?\u000f\u0005)LhBA6x\u001d\taWO\u0004\u0002ni:\u0011an\u001d\b\u0003_Jl\u0011\u0001\u001d\u0006\u0003c*\ta\u0001\u0010:p_Rt\u0014\"A\u0005\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t1H!\u0001\u0002eE&\u0011!\n\u001f\u0006\u0003m\u0012I!A_>\u0002\u0015M\u000bHNQ;jY\u0012,'O\u0003\u0002Kq&\u0011QP \u0002\b\t&\fG.Z2u\u0015\tQ8\u0010C\u0005\u0002\u0002\u0001\u0011\t\u0011)A\u0005Q\u0006Y1/\u001d7ES\u0006dWm\u0019;!\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000f\ta\u0001P5oSRtD\u0003FA\u0005\u0003\u0017\ti!a\u0004\u0002\u0012\u0005M\u0011QCA\f\u00033\tY\u0002\u0005\u0002\u0016\u0001!1\u0011%a\u0001A\u0002\tBaaKA\u0002\u0001\u0004a\u0003B\u0002\u0019\u0002\u0004\u0001\u0007\u0011\u0007\u0003\u0004;\u0003\u0007\u0001\ra\u000f\u0005\u0007\t\u0006\r\u0001\u0019A#\t\rA\u000b\u0019\u00011\u0001R\u0011\u0019)\u00161\u0001a\u0001/\"1a,a\u0001A\u0004\u0001DaAZA\u0002\u0001\bA\u0007bBA\u0010\u0001\u0011\u0005\u0013\u0011E\u0001\u0012O\u0016$H+Y:lg\nK(+\u001a7fCN,GCBA\u0012\u0003W\t)\u0004\u0005\u0003\u0002&\u0005\u001dR\"A\u001b\n\u0007\u0005%RG\u0001\bUCN\\7+Z1sG\"4\u0016.Z<\t\u0011\u00055\u0012Q\u0004a\u0001\u0003_\tA\u0002^1tWN4\u0015\u000e\u001c;feN\u0004B!!\n\u00022%\u0019\u00111G\u001b\u0003\u0019Q\u000b7o[:GS2$XM]:\t\u0011\u0005]\u0012Q\u0004a\u0001\u0003s\tA\u0003\\5nSR$\u0016m]6t\u0011&tGo\u00149uS>t\u0007cA\u0007\u0002<%\u0019\u0011Q\b\b\u0003\u000f%sG/Z4fe\"\"\u0011QDA!!\u0011\t\u0019%!\u0015\u000e\u0005\u0005\u0015#\u0002BA$\u0003\u0013\n!\"\u00198o_R\fG/[8o\u0015\u0011\tY%!\u0014\u0002\u000f5,GO]5dg*\u0019\u0011q\n\u0005\u0002\u0011\r|G-\u00195bY\u0016LA!a\u0015\u0002F\t)A+[7fI\"9\u0011q\u000b\u0001\u0005\n\u0005e\u0013\u0001\u0002;j[\u0016,B!a\u0017\u0002dQ!\u0011QLAC)\u0011\ty&a\u001f\u0011\t\u0005\u0005\u00141\r\u0007\u0001\t!\t)'!\u0016C\u0002\u0005\u001d$!A!\u0012\t\u0005%\u0014Q\u000f\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0011\u0011qN\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003g\niGA\u0004O_RD\u0017N\\4\u0011\t\u0005-\u0014qO\u0005\u0005\u0003s\niGA\u0002B]fD\u0011\"! \u0002V\u0011\u0005\r!a \u0002\u000b\tdwnY6\u0011\r\u0005-\u0014\u0011QA0\u0013\u0011\t\u0019)!\u001c\u0003\u0011q\u0012\u0017P\\1nKzB\u0001\"a\"\u0002V\u0001\u0007\u0011\u0011R\u0001\u0005I\u0016\u001c8\r\u0005\u0003\u0002\f\u0006Me\u0002BAG\u0003\u001f\u00032a\\A7\u0013\u0011\t\t*!\u001c\u0002\rA\u0013X\rZ3g\u0013\u0011\t)*a&\u0003\rM#(/\u001b8h\u0015\u0011\t\t*!\u001c\t\u000f\u0005m\u0005\u0001\"\u0003\u0002\u001e\u0006\u00112o\u001c:u\u0005f\u0014V\r\\3bg\u0016$\u0016\u000e\u001e7f)\u0011\ty*!-\u0011\r\u0005\u0005\u0016qUAV\u001b\t\t\u0019KC\u0002\u0002&B\tA!\u001e;jY&!\u0011\u0011VAR\u0005\u0011a\u0015n\u001d;\u0011\t\u0005\u0015\u0012QV\u0005\u0004\u0003_+$\u0001\u0004*fY\u0016\f7/\u001a+bg.\u001c\b\u0002CAZ\u00033\u0003\r!!.\u0002\u001bI,G.Z1tKN$\u0016m]6t!\u0019\t9,!1\u0002,:!\u0011\u0011XA_\u001d\ry\u00171X\u0005\u0003\u0003_JA!a0\u0002n\u00059\u0001/Y2lC\u001e,\u0017\u0002BAb\u0003\u000b\u00141aU3r\u0015\u0011\ty,!\u001c\t\u000f\u0005%\u0007\u0001\"\u0003\u0002L\u0006i1/Z1sG\"$\u0016m]6JIN$b!!4\u0002j\u0006-\bCBA\\\u0003\u0003\fy\r\u0005\u0003\u0002R\u0006\rh\u0002BAj\u0003?tA!!6\u0002^:!\u0011q[An\u001d\ra\u0017\u0011\\\u0005\u0003\u0019\u0012I!AS&\n\u0005!K\u0015bAAq\u000f\u0006!1)[%e\u0013\u0011\t)/a:\u0003\t\rK\u0017\n\u001a\u0006\u0004\u0003C<\u0005\u0002CA\u0017\u0003\u000f\u0004\r!a\f\t\u0011\u00055\u0018q\u0019a\u0001\u0003_\fQ\u0001\\5nSR\u0004B!a\u001b\u0002r&!\u00111_A7\u0005\rIe\u000e\u001e")
public class SqlTaskSearchService
implements TaskSearchService,
Logging {
    private final RoleService roleService;
    private final TaskAccessService taskAccessService;
    private final TasksViewConverter tasksViewConverter;
    private final InternalMetadataDecoratorService decoratorService;
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final PermissionEnforcer permissionEnforcer;
    private final SqlBuilder.Dialect sqlDialect;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskSearchService sqlTaskSearchService = this;
        synchronized (sqlTaskSearchService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    @Timed
    public TaskSearchView getTasksByRelease(TasksFilters tasksFilters, Integer limitTasksHintOption) {
        int limit = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)limitTasksHintOption).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 30));
        Seq taskIds = (Seq)this.time("finding task ids", (Function0 & Serializable & scala.Serializable)() -> this.searchTaskIds(tasksFilters, limit));
        Seq releaseIds = (Seq)((SeqLike)taskIds.map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.releaseIdFrom((String)x$1), Seq$.MODULE$.canBuildFrom())).distinct();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " tasks in ", " releases for user ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)taskIds.size()), BoxesRunTime.boxToInteger((int)releaseIds.size()), Permissions.getAuthenticatedUserName()})));
        List allowedTaskTypesForAuthenticatedUser = (List)this.time("fetching allowed task types for authenticated user", (Function0 & Serializable & scala.Serializable)() -> $this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser());
        Tuple2 queryReleases = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withReleaseIds((Seq<String>)releaseIds).build();
        Seq releasesTasks = (Seq)this.time("total time to create releasesTasks", (Function0 & Serializable & scala.Serializable)() -> (Seq)((TraversableLike)((GenericTraversableTemplate)this.time("de-serializing releases", (Function0 & Serializable & scala.Serializable)() -> {
            boolean bl = this.repositoryAdapter().tryDeserialize$default$1();
            return (Seq)$this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)queryReleases).map((Function1 & Serializable & scala.Serializable)releaseData -> this.repositoryAdapter().tryDeserialize(bl, (ReleaseRow)releaseData), Seq$.MODULE$.canBuildFrom());
        })).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).flatMap((Function1 & Serializable & scala.Serializable)foundRelease -> {
            $this.decoratorService.decorate((ConfigurationItem)foundRelease, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ReleaseGlobalVariablesDecorator$.MODULE$.GLOBAL_VARIABLES(), EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))).asJava());
            return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)BoxedUnit.UNIT).map((Function1 & Serializable & scala.Serializable)x$2 -> {
                Buffer orderedTasks = (Buffer)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(foundRelease.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)taskIds.exists((Function1 & Serializable & scala.Serializable)foundId -> BoxesRunTime.boxToBoolean((boolean)SqlTaskSearchService.$anonfun$getTasksByRelease$14(task, foundId)))))).sortBy((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToInteger((int)taskIds.indexWhere((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)SqlTaskSearchService.$anonfun$getTasksByRelease$16(task, id)))), (Ordering)Ordering.Int$.MODULE$);
                return new Tuple2(x$2, (Object)orderedTasks);
            }).map((Function1 & Serializable & scala.Serializable)x$3 -> {
                Tuple2 tuple2 = x$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Buffer orderedTasks = (Buffer)tuple2._2();
                ReleaseTasks releaseTasks = new ReleaseTasks(foundRelease, $this.tasksViewConverter.toFullView((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(orderedTasks).asJava(), allowedTaskTypesForAuthenticatedUser));
                return releaseTasks;
            }));
        }, Seq$.MODULE$.canBuildFrom()));
        return new TaskSearchView(this.sortByReleaseTitle((Seq<ReleaseTasks>)releasesTasks), taskIds.size() >= limit);
    }

    private <A> A time(String desc, Function0<A> block) {
        long startTime = System.currentTimeMillis();
        Object res = block.apply();
        long endTime = System.currentTimeMillis();
        long total = endTime - startTime;
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIME: ", " took ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc, BoxesRunTime.boxToLong((long)total)})));
        return (A)res;
    }

    private List<ReleaseTasks> sortByReleaseTitle(Seq<ReleaseTasks> releasesTasks) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)releasesTasks.sortBy((Function1 & Serializable & scala.Serializable)releaseTasks -> (String)Option$.MODULE$.apply((Object)releaseTasks.getTitle()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (Ordering)Ordering.String$.MODULE$)).asJava();
    }

    private Seq<String> searchTaskIds(TasksFilters tasksFilters, int limit) {
        Iterable principals = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
        Buffer roleIds = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getId(), Buffer$.MODULE$.canBuildFrom());
        Tuple2<String, Seq<Object>> tasksQuery = ((TasksUnionSqlBuilder)SqlTasksFilterSupport$.MODULE$.sqlBuilderByFilters(tasksFilters, (Iterable<String>)principals, (Iterable<String>)roleIds, this.permissionEnforcer(), this.sqlDialect()).limit(limit)).build();
        return this.taskPersistence.findTaskIdsByQuery(tasksQuery);
    }

    public static final /* synthetic */ boolean $anonfun$getTasksByRelease$14(Task task$1, String foundId) {
        return task$1.getId().endsWith(foundId);
    }

    public static final /* synthetic */ boolean $anonfun$getTasksByRelease$16(Task task$2, String id) {
        return task$2.getId().startsWith(id);
    }

    public SqlTaskSearchService(RoleService roleService, TaskAccessService taskAccessService, TasksViewConverter tasksViewConverter, InternalMetadataDecoratorService decoratorService, ReleasePersistence releasePersistence, TaskPersistence taskPersistence, SqlRepositoryAdapter repositoryAdapter, PermissionEnforcer permissionEnforcer, SqlBuilder.Dialect sqlDialect) {
        this.roleService = roleService;
        this.taskAccessService = taskAccessService;
        this.tasksViewConverter = tasksViewConverter;
        this.decoratorService = decoratorService;
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.permissionEnforcer = permissionEnforcer;
        this.sqlDialect = sqlDialect;
        Logging.$init$((Logging)this);
    }
}

