/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalVariablesDecorator$;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.search.PlanItemSearchResult;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.SqlReleasesFilterSupport$;
import com.xebialabs.xlrelease.service.SqlTemplatesFilterSupport$;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.views.TemplateFilters;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5h\u0001B\u0001\u0003\u0001-\u0011qcU9m%\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\u000b\u0005\r!\u0011aB:feZL7-\u001a\u0006\u0003\u000b\u0019\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005\u001dA\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005I\u0011aA2p[\u000e\u00011#\u0002\u0001\r%Yq\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\t!\"+\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016\u0004\"a\u0006\u000f\u000e\u0003aQ!!\u0007\u000e\u0002\u000bMdg\r\u000e6\u000b\u0003m\t\u0001b\u001a:jujdW\rZ\u0005\u0003;a\u0011q\u0001T8hO&tw\r\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005\r\"\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011Q\u0005\t\u0002\u0017\t\u0016\u001cXM]5bY&T\u0018\r^5p]N+\b\u000f]8si\"Aq\u0005\u0001B\u0001B\u0003%\u0001&\u0001\nsK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007CA\u0015-\u001b\u0005Q#BA\u0016!\u0003-\u0001XM]:jgR,gnY3\n\u00055R#A\u0005*fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016D\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001M\u0001\u0011CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\u0004\"aE\u0019\n\u0005I\u0012!\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0011!!\u0004A!b\u0001\n\u0003)\u0014!\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;feV\ta\u0007\u0005\u0002 o%\u0011\u0001\b\t\u0002\u0015'Fd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\t\u0011i\u0002!\u0011!Q\u0001\nY\n!C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3sA!AA\b\u0001BC\u0002\u0013\u0005Q(A\u0006uK\u0006l7+\u001a:wS\u000e,W#\u0001 \u0011\u0005My\u0014B\u0001!\u0003\u0005-!V-Y7TKJ4\u0018nY3\t\u0011\t\u0003!\u0011!Q\u0001\ny\nA\u0002^3b[N+'O^5dK\u0002B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!R\u0001\u0011I\u0016\u001cwN]1u_J\u001cVM\u001d<jG\u0016\u0004\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\u0011%tG/\u001a:oC2T!A\u0013\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0002M\u000f\n\u0001\u0013J\u001c;fe:\fG.T3uC\u0012\fG/\u0019#fG>\u0014\u0018\r^8s'\u0016\u0014h/[2f\u0011!q\u0005A!b\u0001\n\u0007y\u0015AC:rY\u0012K\u0017\r\\3diV\t\u0001\u000b\u0005\u0002RI:\u0011!+\u0019\b\u0003'~s!\u0001V/\u000f\u0005UcfB\u0001,\\\u001d\t9&,D\u0001Y\u0015\tI&\"\u0001\u0004=e>|GOP\u0005\u0002\u0013%\u0011q\u0001C\u0005\u0003\u000b\u0019I!A\u0018\u0003\u0002\u0005\u0011\u0014\u0017BA\u0011a\u0015\tqF!\u0003\u0002cG\u0006Q1+\u001d7Ck&dG-\u001a:\u000b\u0005\u0005\u0002\u0017BA3g\u0005\u001d!\u0015.\u00197fGRT!AY2\t\u0011!\u0004!\u0011!Q\u0001\nA\u000b1b]9m\t&\fG.Z2uA!A!\u000e\u0001BC\u0002\u0013\r1.\u0001\nqKJl\u0017n]:j_:,eNZ8sG\u0016\u0014X#\u00017\u0011\u00055\u0014X\"\u00018\u000b\u0005=\u0004\u0018\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005E4\u0011\u0001\u00033fa2|\u00170\u001b;\n\u0005Mt'A\u0005)fe6L7o]5p]\u0016sgm\u001c:dKJD\u0001\"\u001e\u0001\u0003\u0002\u0003\u0006I\u0001\\\u0001\u0014a\u0016\u0014X.[:tS>tWI\u001c4pe\u000e,'\u000f\t\u0005\to\u0002\u0011)\u0019!C\u0001q\u0006Y!o\u001c7f'\u0016\u0014h/[2f+\u0005I\bCA7{\u0013\tYhNA\u0006S_2,7+\u001a:wS\u000e,\u0007\u0002C?\u0001\u0005\u0003\u0005\u000b\u0011B=\u0002\u0019I|G.Z*feZL7-\u001a\u0011\t\u0013}\u0004!Q1A\u0005\u0002\u0005\u0005\u0011AC:fGV\u0014X\rZ\"jgV\u0011\u00111\u0001\t\u0005\u0003\u000b\t9!D\u0001#\u0013\r\tIA\t\u0002\u000b'\u0016\u001cWO]3e\u0007&\u001c\bBCA\u0007\u0001\t\u0005\t\u0015!\u0003\u0002\u0004\u0005Y1/Z2ve\u0016$7)[:!\u0011)\t\t\u0002\u0001B\u0001B\u0003%\u00111C\u0001\u001ce\u0016dW-Y:f\u000bb$XM\\:j_:\u001c(+\u001a9pg&$xN]=\u0011\t\u0005\u0015\u0011QC\u0005\u0004\u0003/\u0011#a\u0007*fY\u0016\f7/Z#yi\u0016t7/[8ogJ+\u0007o\\:ji>\u0014\u0018\u0010C\u0004\u0002\u001c\u0001!\t!!\b\u0002\rqJg.\u001b;?)Y\ty\"!\t\u0002$\u0005\u0015\u0012qEA\u0015\u0003W\ti#a\f\u00022\u0005M\u0002CA\n\u0001\u0011\u00199\u0013\u0011\u0004a\u0001Q!1q&!\u0007A\u0002ABa\u0001NA\r\u0001\u00041\u0004B\u0002\u001f\u0002\u001a\u0001\u0007a\b\u0003\u0004E\u00033\u0001\r!\u0012\u0005\u0007\u001d\u0006e\u00019\u0001)\t\r)\fI\u0002q\u0001m\u0011\u00199\u0018\u0011\u0004a\u0001s\"9q0!\u0007A\u0002\u0005\r\u0001\u0002CA\t\u00033\u0001\r!a\u0005\t\u000f\u0005]\u0002\u0001\"\u0011\u0002:\u000511/Z1sG\"$B\"a\u000f\u0002F\u0005e\u00131MA4\u0003c\u0002B!!\u0010\u0002B5\u0011\u0011q\b\u0006\u0004\u0003o!\u0011\u0002BA\"\u0003\u007f\u00111CU3mK\u0006\u001cXmU3be\u000eD'+Z:vYRD\u0001\"a\u0012\u00026\u0001\u0007\u0011\u0011J\u0001\u0010e\u0016dW-Y:fg\u001aKG\u000e^3sgB!\u00111JA+\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013!\u00024pe6\u001c(bAA*\u0013\u0006\u0011a/M\u0005\u0005\u0003/\niEA\bSK2,\u0017m]3t\r&dG/\u001a:t\u0011!\tY&!\u000eA\u0002\u0005u\u0013\u0001\u00029bO\u0016\u00042!DA0\u0013\r\t\tG\u0004\u0002\u0005\u0019>tw\r\u0003\u0005\u0002f\u0005U\u0002\u0019AA/\u00031qW/\u001c2fe\nK\b+Y4f\u0011!\tI'!\u000eA\u0002\u0005-\u0014!\u00023faRD\u0007cA\u0007\u0002n%\u0019\u0011q\u000e\b\u0003\u0007%sG\u000f\u0003\u0005\u0002t\u0005U\u0002\u0019AA;\u0003M1\u0017\u000e\u001c;fe>s\u0007+\u001a:nSN\u001c\u0018n\u001c8t!\ri\u0011qO\u0005\u0004\u0003sr!a\u0002\"p_2,\u0017M\u001c\u0015\u0005\u0003k\ti\b\u0005\u0003\u0002\u0000\u00055UBAAA\u0015\u0011\t\u0019)!\"\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002\b\u0006%\u0015aB7fiJL7m\u001d\u0006\u0004\u0003\u0017C\u0011\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005=\u0015\u0011\u0011\u0002\u0006)&lW\r\u001a\u0005\b\u0003'\u0003A\u0011IAK\u0003=\u0019X-\u0019:dQR+W\u000e\u001d7bi\u0016\u001cHCCA\u001e\u0003/\u000b9+!+\u0002,\"A\u0011\u0011TAI\u0001\u0004\tY*A\buK6\u0004H.\u0019;f\r&dG/\u001a:t!\u0011\ti*a)\u000e\u0005\u0005}%bAAQ\t\u0005)a/[3xg&!\u0011QUAP\u0005=!V-\u001c9mCR,g)\u001b7uKJ\u001c\b\u0002CA.\u0003#\u0003\r!!\u0018\t\u0011\u0005\u0015\u0014\u0011\u0013a\u0001\u0003;B\u0001\"!\u001b\u0002\u0012\u0002\u0007\u00111\u000e\u0015\u0005\u0003#\u000bi\bC\u0004\u00022\u0002!\t%a-\u0002+M,\u0017M]2i%\u0016dW-Y:fg\nKH+\u001b;mKRQ\u0011QWAi\u0003K\f9/!;\u0011\r\u0005]\u0016\u0011YAc\u001b\t\tIL\u0003\u0003\u0002<\u0006u\u0016\u0001B;uS2T!!a0\u0002\t)\fg/Y\u0005\u0005\u0003\u0007\fIL\u0001\u0003MSN$\b\u0003BAd\u0003\u001bl!!!3\u000b\u0007\u0005-G!\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003\u001f\fIMA\u0004SK2,\u0017m]3\t\u0011\u0005M\u0017q\u0016a\u0001\u0003+\fAB]3mK\u0006\u001cX\rV5uY\u0016\u0004B!a6\u0002`:!\u0011\u0011\\An!\t9f\"C\u0002\u0002^:\ta\u0001\u0015:fI\u00164\u0017\u0002BAq\u0003G\u0014aa\u0015;sS:<'bAAo\u001d!A\u00111LAX\u0001\u0004\ti\u0006\u0003\u0005\u0002f\u0005=\u0006\u0019AA/\u0011!\tI'a,A\u0002\u0005-\u0004\u0006BAX\u0003{Bq!a<\u0001\t\u0003\n\t0\u0001\u0012gS:$\u0017\t\u001c7SK2,\u0017m]3JIN\fe\u000e\u001a+ji2,7OQ=Ti\u0006$Xo\u001d\u000b\u0005\u0003g\fI\u0010\u0005\u0005\u0002X\u0006U\u0018Q[Ak\u0013\u0011\t90a9\u0003\u00075\u000b\u0007\u000f\u0003\u0005\u0002|\u00065\b\u0019AA\u007f\u0003!\u0019H/\u0019;vg\u0016\u001c\b#B\u0007\u0002\u0000\n\r\u0011b\u0001B\u0001\u001d\tQAH]3qK\u0006$X\r\u001a \u0011\t\t\u0015!1B\u0007\u0003\u0005\u000fQAA!\u0003\u0002J\u000611\u000f^1ukNLAA!\u0004\u0003\b\ti!+\u001a7fCN,7\u000b^1ukNDC!!<\u0002~!9!1\u0003\u0001\u0005B\tU\u0011a\u00074j]\u0012\fE\u000e\u001c+f[Bd\u0017\r^3JIN\fe\u000e\u001a+ji2,7\u000f\u0006\u0004\u0003\u0018\tu!q\u0004\t\u0005\u0003{\u0011I\"\u0003\u0003\u0003\u001c\u0005}\"\u0001\u0006)mC:LE/Z7TK\u0006\u00148\r\u001b*fgVdG\u000f\u0003\u0005\u0002\\\tE\u0001\u0019AA/\u0011!\t)G!\u0005A\u0002\u0005u\u0003\u0006\u0002B\t\u0003{BqA!\n\u0001\t\u0003\u00129#\u0001\ngS:$\u0017\t\u001c7UK6\u0004H.\u0019;f\u0013\u0012\u001cXC\u0001B\u0015!\u0019\t9,!1\u0002V\"\"!1EA?\u0011\u001d\u0011y\u0003\u0001C!\u0005O\tqCZ5oI\u0006cG.Q2uSZ,'+\u001a7fCN,\u0017\nZ:)\t\t5\u0012Q\u0010\u0005\b\u0005k\u0001A\u0011\tB\u0014\u0003a1\u0017N\u001c3BY2\u0004VM\u001c3j]\u001e\u0014V\r\\3bg\u0016LEm\u001d\u0015\u0005\u0005g\ti\bC\u0004\u0003<\u0001!IA!\u0010\u0002\u001bE,XM]=SK2,\u0017m]3t))\u0011yD!\u0015\u0003d\t\u0015$q\r\t\u0007\u0005\u0003\u0012Y%!2\u000f\t\t\r#q\t\b\u0004/\n\u0015\u0013\"A\b\n\u0007\t%c\"A\u0004qC\u000e\\\u0017mZ3\n\t\t5#q\n\u0002\u0004'\u0016\f(b\u0001B%\u001d!A!1\u000bB\u001d\u0001\u0004\u0011)&A\u0005tK\u0006\u00148\r[%egB9QBa\u0016\u0003\\\t\u0005\u0014b\u0001B-\u001d\tIa)\u001e8di&|g.\r\t\u0005\u0003\u000b\u0011i&C\u0002\u0003`\t\u0012A\u0001U1hKB1!\u0011\tB&\u0003+D\u0001\"a\u0017\u0003:\u0001\u0007\u0011Q\f\u0005\t\u0003K\u0012I\u00041\u0001\u0002^!A!\u0011\u000eB\u001d\u0001\u0004\u0011Y'\u0001\u0006qKJl\u0017n]:j_:\u0004BA!\u001c\u0003r5\u0011!q\u000e\u0006\u0004\u0005Sr\u0017\u0002\u0002B:\u0005_\u0012!\u0002U3s[&\u001c8/[8o\u0011\u001d\u00119\b\u0001C\u0005\u0005s\n\u0001DZ5oIJ+G.Z1tKN\u0014\u00150\u00133t\u0013:|%\u000fZ3s)\u0011\u0011yDa\u001f\t\u0011\tu$Q\u000fa\u0001\u0005C\n!B]3mK\u0006\u001cX-\u00133t\u0011\u001d\u0011\t\t\u0001C\u0005\u0005\u0007\u000ba\u0002^8TK\u0006\u00148\r\u001b*fgVdG\u000f\u0006\u0004\u0002<\t\u0015%q\u0011\u0005\t\u00037\u0012y\b1\u0001\u0002^!A!\u0011\u0012B@\u0001\u0004\u0011y$\u0001\u0005sK2,\u0017m]3t\u0011\u001d\u0011\u0019\u0006\u0001C\u0005\u0005\u001b#BAa$\u0003\u0014R!!\u0011\rBI\u0011!\tYFa#A\u0002\tm\u0003\u0002CA$\u0005\u0017\u0003\r!!\u0013\t\u000f\t]\u0005\u0001\"\u0003\u0003\u001a\u000692/Z1sG\"\u001cu.\u001c9mKR,GMU3mK\u0006\u001cXm\u001d\u000b\u0005\u00057\u0013)\u000b\u0006\u0005\u0003@\tu%\u0011\u0015BR\u0011!\u0011yJ!&A\u0002\tU\u0013AB4fi&#7\u000f\u0003\u0005\u0002\\\tU\u0005\u0019AA/\u0011!\t)G!&A\u0002\u0005u\u0003\u0002CA$\u0005+\u0003\r!!\u0013\t\u000f\t%\u0006\u0001\"\u0003\u0003,\u0006y1/Z1sG\"Le.\u0011:dQ&4X\r\u0006\u0005\u00026\n5&q\u0016BY\u0011!\t9Ea*A\u0002\u0005%\u0003\u0002CA3\u0005O\u0003\r!!\u0018\t\u0011\tM&q\u0015a\u0001\u0003;\naa\u001c4gg\u0016$\bb\u0002B\\\u0001\u0011\u0005#\u0011X\u0001\rKbL7\u000f^:Cs:\u000bW.\u001a\u000b\u0005\u0003k\u0012Y\f\u0003\u0005\u0003>\nU\u0006\u0019AAk\u00035\u0019\u0017M\u001c3jI\u0006$XMT1nK\"\"!QWA?\u0011\u001d\u0011\u0019\r\u0001C\u0005\u0005\u000b\f\u0011cY;se\u0016tG\u000f\u0015:j]\u000eL\u0007/\u00197t+\t\u00119\r\u0005\u0004\u0003B\t%\u0017Q[\u0005\u0005\u0005\u0017\u0014yE\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\u0011y\r\u0001C\u0005\u0005#\fabY;se\u0016tGOU8mK&#7/\u0006\u0002\u0003TB1!Q\u001bBp\u0005Gl!Aa6\u000b\t\te'1\\\u0001\b[V$\u0018M\u00197f\u0015\r\u0011iND\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002Bq\u0005/\u0014aAQ;gM\u0016\u0014\b\u0003\u0002Bs\u0005Wl!Aa:\u000b\t\t%\u0018QX\u0001\u0005Y\u0006tw-\u0003\u0003\u0002b\n\u001d\b")
public class SqlReleaseSearchService
implements ReleaseSearchService,
Logging,
DeserializationSupport {
    private final ReleasePersistence releasePersistence;
    private final ArchivingService archivingService;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final TeamService teamService;
    private final InternalMetadataDecoratorService decoratorService;
    private final SqlBuilder.Dialect sqlDialect;
    private final PermissionEnforcer permissionEnforcer;
    private final RoleService roleService;
    private final SecuredCis securedCis;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private Logger grizzled$slf4j$Logging$$_logger;
    private final long DEFAULT_NUMBER_OF_RELEASES_PER_PAGE;
    private final int DEFAULT_RELEASE_LOAD_DEPTH;
    private volatile boolean bitmap$0;

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public ReleaseSearchResult search(ReleasesFilters releasesFilters, long page, long numberByPage) {
        return ReleaseSearchService.search$((ReleaseSearchService)this, (ReleasesFilters)releasesFilters, (long)page, (long)numberByPage);
    }

    public ReleaseSearchResult search(ReleasesFilters releasesFilters, long page, long numberByPage, int depth) {
        return ReleaseSearchService.search$((ReleaseSearchService)this, (ReleasesFilters)releasesFilters, (long)page, (long)numberByPage, (int)depth);
    }

    public scala.collection.immutable.Map<String, String> findAllReleaseIdsAndTitlesByStatus(ReleaseStatus ... statuses) {
        return ReleaseSearchService.findAllReleaseIdsAndTitlesByStatus$((ReleaseSearchService)this, (ReleaseStatus[])statuses);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseSearchService sqlReleaseSearchService = this;
        synchronized (sqlReleaseSearchService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public long DEFAULT_NUMBER_OF_RELEASES_PER_PAGE() {
        return this.DEFAULT_NUMBER_OF_RELEASES_PER_PAGE;
    }

    public int DEFAULT_RELEASE_LOAD_DEPTH() {
        return this.DEFAULT_RELEASE_LOAD_DEPTH;
    }

    public void com$xebialabs$xlrelease$service$ReleaseSearchService$_setter_$DEFAULT_NUMBER_OF_RELEASES_PER_PAGE_$eq(long x$1) {
        this.DEFAULT_NUMBER_OF_RELEASES_PER_PAGE = x$1;
    }

    public void com$xebialabs$xlrelease$service$ReleaseSearchService$_setter_$DEFAULT_RELEASE_LOAD_DEPTH_$eq(int x$1) {
        this.DEFAULT_RELEASE_LOAD_DEPTH = x$1;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public TeamService teamService() {
        return this.teamService;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public RoleService roleService() {
        return this.roleService;
    }

    public SecuredCis securedCis() {
        return this.securedCis;
    }

    @Timed
    public ReleaseSearchResult search(ReleasesFilters releasesFilters, long page2, long numberByPage, int depth, boolean filterOnPermissions) {
        Seq<Release> seq;
        releasesFilters.checkConsistency();
        if (releasesFilters.hasASelectedFilter()) {
            Function1 & Serializable & scala.Serializable getIds = (Function1 & Serializable & scala.Serializable)page -> this.searchIds(releasesFilters, (Page)page);
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for releases by filters"})).s((Seq)Nil$.MODULE$));
            seq = releasesFilters.withOnlyArchived() ? (Seq<Release>)JavaConverters$.MODULE$.asScalaBufferConverter(this.searchInArchive(releasesFilters, numberByPage, numberByPage * page2)).asScala() : (releasesFilters.withInactive() || releasesFilters.withAborted() || releasesFilters.withCompleted() ? this.searchCompletedReleases(releasesFilters, (Function1<Page, Seq<String>>)getIds, page2, numberByPage) : this.queryReleases((Function1<Page, Seq<String>>)getIds, page2, numberByPage, XLReleasePermissions.VIEW_RELEASE));
        } else {
            seq = List$.MODULE$.empty();
        }
        Seq<Release> results = seq;
        return this.toSearchResult(page2, results);
    }

    @Timed
    public ReleaseSearchResult searchTemplates(TemplateFilters templateFilters, long page2, long numberByPage, int depth) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for templates by filters"})).s((Seq)Nil$.MODULE$));
        Seq<Release> templates = this.queryReleases((Function1<Page, Seq<String>>)(Function1 & Serializable & scala.Serializable)page -> this.searchIds$1((Page)page, templateFilters), page2, numberByPage, XLReleasePermissions.VIEW_TEMPLATE);
        return this.toSearchResult(page2, templates);
    }

    @Timed
    public List<Release> searchReleasesByTitle(String releaseTitle, long page2, long numberByPage, int depth) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for releases by title ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseTitle})));
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.queryReleases((Function1<Page, Seq<String>>)(Function1 & Serializable & scala.Serializable)page -> this.getIds$1((Page)page, releaseTitle), page2, numberByPage, XLReleasePermissions.VIEW_RELEASE)).asJava();
    }

    @Timed
    public scala.collection.immutable.Map<String, String> findAllReleaseIdsAndTitlesByStatus(Seq<ReleaseStatus> statuses) {
        ReleasesSqlBuilder sqlBuilder = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseIdAndTitle().withOneOfStatuses(statuses);
        Object object = !this.permissionEnforcer().isCurrentUserAdmin() ? sqlBuilder.withPermission(XLReleasePermissions.VIEW_RELEASE, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds()) : BoxedUnit.UNIT;
        Tuple2 sqlWithParams = sqlBuilder.build();
        return this.releasePersistence.findReleaseIdsAndTitlesByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).toMap(Predef$.MODULE$.$conforms());
    }

    @Timed
    public PlanItemSearchResult findAllTemplateIdsAndTitles(long page, long numberByPage) {
        ReleasesSqlBuilder sqlBuilder = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseIdAndTitle().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.TEMPLATE})))).orderBy(ReleaseOrderMode.title).withPage(new Page((long)((int)page), (long)((int)numberByPage), Predef$.MODULE$.int2Integer(0)));
        Object object = !this.permissionEnforcer().isCurrentUserAdmin() ? sqlBuilder.withPermission(XLReleasePermissions.VIEW_RELEASE, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds()) : BoxedUnit.UNIT;
        scala.collection.immutable.Map idToTitle = this.releasePersistence.findReleaseIdsAndTitlesByQuery((Tuple2<String, Seq<Object>>)sqlBuilder.build()).toMap(Predef$.MODULE$.$conforms());
        PlanItemSearchResult searchResult = new PlanItemSearchResult();
        searchResult.setPage(page + 1L);
        searchResult.setItems(JavaConverters$.MODULE$.mapAsJavaMap((Map)idToTitle));
        return searchResult;
    }

    @Timed
    public List<String> findAllTemplateIds() {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.TEMPLATE})))).build();
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams)).asJava();
    }

    @Timed
    public List<String> findAllActiveReleaseIds() {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])ReleaseStatus.ACTIVE_STATUSES)).build();
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams)).asJava();
    }

    @Timed
    public List<String> findAllPendingReleaseIds() {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for all pending releases"})).s((Seq)Nil$.MODULE$));
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.PLANNED})))).withAutoStart().build();
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams)).asJava();
    }

    private Seq<Release> queryReleases(Function1<Page, Seq<String>> searchIds, long page, long numberByPage, Permission permission) {
        Seq releaseIds = (Seq)searchIds.apply((Object)new Page((long)((int)page), (long)((int)numberByPage), Predef$.MODULE$.int2Integer(0)));
        Seq releases = releaseIds.nonEmpty() ? this.findReleasesByIdsInOrder((Seq<String>)releaseIds) : (Seq)Seq$.MODULE$.empty();
        releases.foreach((Function1 & Serializable & scala.Serializable)release -> {
            SqlReleaseSearchService.$anonfun$queryReleases$1(this, release);
            return BoxedUnit.UNIT;
        });
        this.decoratorService.decorate((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(releases).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ReleaseGlobalVariablesDecorator$.MODULE$.GLOBAL_VARIABLES(), EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))).asJava());
        return releases;
    }

    private Seq<Release> findReleasesByIdsInOrder(Seq<String> releaseIds) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withReleaseIds(releaseIds).build();
        Seq releasesUnordered = (Seq)((TraversableLike)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).map((Function1 & Serializable & scala.Serializable)releaseData -> this.deserializeRelease((ReleaseRow)releaseData), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> $this.releaseExtensionsRepository.decorate(release), Seq$.MODULE$.canBuildFrom());
        return (Seq)releasesUnordered.sortBy((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToInteger((int)releaseIds.indexOf((Object)r.getId())), (Ordering)Ordering.Int$.MODULE$);
    }

    private ReleaseSearchResult toSearchResult(long page, Seq<Release> releases) {
        ReleaseSearchResult searchResult = new ReleaseSearchResult();
        searchResult.setPage(page + 1L);
        searchResult.addReleases((List)JavaConverters$.MODULE$.seqAsJavaListConverter(releases).asJava());
        return searchResult;
    }

    private Seq<String> searchIds(ReleasesFilters releasesFilters, Page page) {
        Tuple2 sqlWithParams = SqlReleasesFilterSupport$.MODULE$.sqlBuilderByFilters(releasesFilters, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds(), this.permissionEnforcer(), this.sqlDialect()).selectReleaseId().withPage(page).build();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for a batch of releases by SQL query: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlWithParams._1()})));
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    private Seq<Release> searchCompletedReleases(ReleasesFilters releasesFilters, Function1<Page, Seq<String>> getIds, long page, long numberByPage) {
        Seq seq;
        Seq releases = this.queryReleases(getIds, page, numberByPage, XLReleasePermissions.VIEW_RELEASE);
        if (releases.nonEmpty()) {
            if ((long)releases.length() >= numberByPage) {
                seq = releases;
            } else {
                List<Release> archivedReleases = this.searchInArchive(releasesFilters, numberByPage - (long)releases.length(), 0L);
                seq = (Seq)releases.$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(archivedReleases).asScala(), Seq$.MODULE$.canBuildFrom());
            }
        } else {
            int numOfNonArchivedReleases = ((SeqLike)getIds.apply((Object)new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(0)))).length();
            long offset = numberByPage * page - (long)numOfNonArchivedReleases;
            seq = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.searchInArchive(releasesFilters, numberByPage, offset)).asScala();
        }
        return seq;
    }

    private List<Release> searchInArchive(ReleasesFilters releasesFilters, long numberByPage, long offset) {
        List releases = this.archivingService.searchReleases(releasesFilters, numberByPage, offset);
        this.decoratorService.decorate((Collection)releases, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ReleaseGlobalVariablesDecorator$.MODULE$.GLOBAL_VARIABLES(), EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))).asJava());
        return releases;
    }

    @Timed
    public boolean existsByName(String candidateName) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withReleaseName(candidateName).withPage(new Page(0L, 1L, Predef$.MODULE$.int2Integer(0))).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).nonEmpty();
    }

    private Iterable<String> currentPrincipals() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Buffer<String> currentRoleIds() {
        return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService().getRolesFor(Permissions.getAuthentication())).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), Buffer$.MODULE$.canBuildFrom());
    }

    private final Seq searchIds$1(Page page, TemplateFilters templateFilters$1) {
        Tuple2 sqlWithParams = SqlTemplatesFilterSupport$.MODULE$.sqlBuilderByFilters(templateFilters$1, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds(), this.permissionEnforcer(), this.sqlDialect()).selectReleaseId().withPage(page).build();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for a batch of templates by SQL query: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlWithParams._1()})));
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    private final Seq getIds$1(Page page, String releaseTitle$1) {
        ReleasesSqlBuilder sqlWithParams = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withTitle(releaseTitle$1).withPage(page);
        Object object = !this.permissionEnforcer().isCurrentUserAdmin() ? sqlWithParams.withPermission(XLReleasePermissions.VIEW_RELEASE, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds()) : BoxedUnit.UNIT;
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams.build());
    }

    public static final /* synthetic */ void $anonfun$queryReleases$1(SqlReleaseSearchService $this, Release release) {
        $this.teamService().decorateWithEffectiveTeams(release);
    }

    public SqlReleaseSearchService(ReleasePersistence releasePersistence, ArchivingService archivingService, SqlRepositoryAdapter repositoryAdapter, TeamService teamService, InternalMetadataDecoratorService decoratorService, SqlBuilder.Dialect sqlDialect, PermissionEnforcer permissionEnforcer, RoleService roleService, SecuredCis securedCis, ReleaseExtensionsRepository releaseExtensionsRepository) {
        this.releasePersistence = releasePersistence;
        this.archivingService = archivingService;
        this.repositoryAdapter = repositoryAdapter;
        this.teamService = teamService;
        this.decoratorService = decoratorService;
        this.sqlDialect = sqlDialect;
        this.permissionEnforcer = permissionEnforcer;
        this.roleService = roleService;
        this.securedCis = securedCis;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        ReleaseSearchService.$init$((ReleaseSearchService)this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
    }
}

