/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalVariablesDecorator$;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.search.PlanItemSearchResult;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.SqlReleasesFilterSupport$;
import com.xebialabs.xlrelease.service.SqlTemplatesFilterSupport$;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.views.TemplateFilters;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005h\u0001B\u0001\u0003\u0001-\u0011qcU9m%\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\u000b\u0005\r!\u0011aB:feZL7-\u001a\u0006\u0003\u000b\u0019\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005\u001dA\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005I\u0011aA2p[\u000e\u00011#\u0002\u0001\r%Yq\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\t!\"+\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016\u0004\"a\u0006\u000f\u000e\u0003aQ!!\u0007\u000e\u0002\u000bMdg\r\u000e6\u000b\u0003m\t\u0001b\u001a:jujdW\rZ\u0005\u0003;a\u0011q\u0001T8hO&tw\r\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005\r\"\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011Q\u0005\t\u0002\u0017\t\u0016\u001cXM]5bY&T\u0018\r^5p]N+\b\u000f]8si\"Aq\u0005\u0001B\u0001B\u0003%\u0001&\u0001\nsK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007CA\u0015-\u001b\u0005Q#BA\u0016!\u0003-\u0001XM]:jgR,gnY3\n\u00055R#A\u0005*fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016D\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001M\u0001\u0011CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\u0004\"aE\u0019\n\u0005I\u0012!\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0011!!\u0004A!b\u0001\n\u0003)\u0014!\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;feV\ta\u0007\u0005\u0002 o%\u0011\u0001\b\t\u0002\u0015'Fd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\t\u0011i\u0002!\u0011!Q\u0001\nY\n!C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3sA!AA\b\u0001BC\u0002\u0013\u0005Q(A\u0006uK\u0006l7+\u001a:wS\u000e,W#\u0001 \u0011\u0005My\u0014B\u0001!\u0003\u0005-!V-Y7TKJ4\u0018nY3\t\u0011\t\u0003!\u0011!Q\u0001\ny\nA\u0002^3b[N+'O^5dK\u0002B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!R\u0001\u0011I\u0016\u001cwN]1u_J\u001cVM\u001d<jG\u0016\u0004\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\u0011%tG/\u001a:oC2T!A\u0013\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0002M\u000f\n\u0001\u0013J\u001c;fe:\fG.T3uC\u0012\fG/\u0019#fG>\u0014\u0018\r^8s'\u0016\u0014h/[2f\u0011!q\u0005A!b\u0001\n\u0007y\u0015AC:rY\u0012K\u0017\r\\3diV\t\u0001\u000b\u0005\u0002RI:\u0011!+\u0019\b\u0003'~s!\u0001V/\u000f\u0005UcfB\u0001,\\\u001d\t9&,D\u0001Y\u0015\tI&\"\u0001\u0004=e>|GOP\u0005\u0002\u0013%\u0011q\u0001C\u0005\u0003\u000b\u0019I!A\u0018\u0003\u0002\u0005\u0011\u0014\u0017BA\u0011a\u0015\tqF!\u0003\u0002cG\u0006Q1+\u001d7Ck&dG-\u001a:\u000b\u0005\u0005\u0002\u0017BA3g\u0005\u001d!\u0015.\u00197fGRT!AY2\t\u0011!\u0004!\u0011!Q\u0001\nA\u000b1b]9m\t&\fG.Z2uA!A!\u000e\u0001BC\u0002\u0013\r1.\u0001\nqKJl\u0017n]:j_:,eNZ8sG\u0016\u0014X#\u00017\u0011\u00055\u0014X\"\u00018\u000b\u0005=\u0004\u0018\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005E4\u0011\u0001\u00033fa2|\u00170\u001b;\n\u0005Mt'A\u0005)fe6L7o]5p]\u0016sgm\u001c:dKJD\u0001\"\u001e\u0001\u0003\u0002\u0003\u0006I\u0001\\\u0001\u0014a\u0016\u0014X.[:tS>tWI\u001c4pe\u000e,'\u000f\t\u0005\to\u0002\u0011)\u0019!C\u0001q\u0006Y!o\u001c7f'\u0016\u0014h/[2f+\u0005I\bCA7{\u0013\tYhNA\u0006S_2,7+\u001a:wS\u000e,\u0007\u0002C?\u0001\u0005\u0003\u0005\u000b\u0011B=\u0002\u0019I|G.Z*feZL7-\u001a\u0011\t\u0013}\u0004!Q1A\u0005\u0002\u0005\u0005\u0011AC:fGV\u0014X\rZ\"jgV\u0011\u00111\u0001\t\u0005\u0003\u000b\t9!D\u0001#\u0013\r\tIA\t\u0002\u000b'\u0016\u001cWO]3e\u0007&\u001c\bBCA\u0007\u0001\t\u0005\t\u0015!\u0003\u0002\u0004\u0005Y1/Z2ve\u0016$7)[:!\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'\ta\u0001P5oSRtD\u0003FA\u000b\u0003/\tI\"a\u0007\u0002\u001e\u0005}\u0011\u0011EA\u0012\u0003K\t9\u0003\u0005\u0002\u0014\u0001!1q%a\u0004A\u0002!BaaLA\b\u0001\u0004\u0001\u0004B\u0002\u001b\u0002\u0010\u0001\u0007a\u0007\u0003\u0004=\u0003\u001f\u0001\rA\u0010\u0005\u0007\t\u0006=\u0001\u0019A#\t\r9\u000by\u0001q\u0001Q\u0011\u0019Q\u0017q\u0002a\u0002Y\"1q/a\u0004A\u0002eDqa`A\b\u0001\u0004\t\u0019\u0001C\u0004\u0002,\u0001!\t%!\f\u0002\rM,\u0017M]2i)1\ty#!\u000f\u0002N\u0005]\u00131LA3!\u0011\t\t$!\u000e\u000e\u0005\u0005M\"bAA\u0016\t%!\u0011qGA\u001a\u0005M\u0011V\r\\3bg\u0016\u001cV-\u0019:dQJ+7/\u001e7u\u0011!\tY$!\u000bA\u0002\u0005u\u0012a\u0004:fY\u0016\f7/Z:GS2$XM]:\u0011\t\u0005}\u0012\u0011J\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u0005)am\u001c:ng*\u0019\u0011qI%\u0002\u0005Y\f\u0014\u0002BA&\u0003\u0003\u0012qBU3mK\u0006\u001cXm\u001d$jYR,'o\u001d\u0005\t\u0003\u001f\nI\u00031\u0001\u0002R\u0005!\u0001/Y4f!\ri\u00111K\u0005\u0004\u0003+r!\u0001\u0002'p]\u001eD\u0001\"!\u0017\u0002*\u0001\u0007\u0011\u0011K\u0001\r]Vl'-\u001a:CsB\u000bw-\u001a\u0005\t\u0003;\nI\u00031\u0001\u0002`\u0005)A-\u001a9uQB\u0019Q\"!\u0019\n\u0007\u0005\rdBA\u0002J]RD\u0001\"a\u001a\u0002*\u0001\u0007\u0011\u0011N\u0001\u0014M&dG/\u001a:P]B+'/\\5tg&|gn\u001d\t\u0004\u001b\u0005-\u0014bAA7\u001d\t9!i\\8mK\u0006t\u0007\u0006BA\u0015\u0003c\u0002B!a\u001d\u0002\u00026\u0011\u0011Q\u000f\u0006\u0005\u0003o\nI(\u0001\u0006b]:|G/\u0019;j_:TA!a\u001f\u0002~\u00059Q.\u001a;sS\u000e\u001c(bAA@\u0011\u0005A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002\u0004\u0006U$!\u0002+j[\u0016$\u0007bBAD\u0001\u0011\u0005\u0013\u0011R\u0001\u0010g\u0016\f'o\u00195UK6\u0004H.\u0019;fgRQ\u0011qFAF\u00037\u000bi*a(\t\u0011\u00055\u0015Q\u0011a\u0001\u0003\u001f\u000bq\u0002^3na2\fG/\u001a$jYR,'o\u001d\t\u0005\u0003#\u000b9*\u0004\u0002\u0002\u0014*\u0019\u0011Q\u0013\u0003\u0002\u000bYLWm^:\n\t\u0005e\u00151\u0013\u0002\u0010)\u0016l\u0007\u000f\\1uK\u001aKG\u000e^3sg\"A\u0011qJAC\u0001\u0004\t\t\u0006\u0003\u0005\u0002Z\u0005\u0015\u0005\u0019AA)\u0011!\ti&!\"A\u0002\u0005}\u0003\u0006BAC\u0003cBq!!*\u0001\t\u0003\n9+A\u000btK\u0006\u00148\r\u001b*fY\u0016\f7/Z:CsRKG\u000f\\3\u0015\u0015\u0005%\u0016QYAm\u00037\fi\u000e\u0005\u0004\u0002,\u0006U\u0016\u0011X\u0007\u0003\u0003[SA!a,\u00022\u0006!Q\u000f^5m\u0015\t\t\u0019,\u0001\u0003kCZ\f\u0017\u0002BA\\\u0003[\u0013A\u0001T5tiB!\u00111XAa\u001b\t\tiLC\u0002\u0002@\u0012\ta\u0001Z8nC&t\u0017\u0002BAb\u0003{\u0013qAU3mK\u0006\u001cX\r\u0003\u0005\u0002H\u0006\r\u0006\u0019AAe\u00031\u0011X\r\\3bg\u0016$\u0016\u000e\u001e7f!\u0011\tY-a5\u000f\t\u00055\u0017q\u001a\t\u0003/:I1!!5\u000f\u0003\u0019\u0001&/\u001a3fM&!\u0011Q[Al\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u001b\b\t\u0011\u0005=\u00131\u0015a\u0001\u0003#B\u0001\"!\u0017\u0002$\u0002\u0007\u0011\u0011\u000b\u0005\t\u0003;\n\u0019\u000b1\u0001\u0002`!\"\u00111UA9\u0011\u001d\t\u0019\u000f\u0001C!\u0003K\f!EZ5oI\u0006cGNU3mK\u0006\u001cX-\u00133t\u0003:$G+\u001b;mKN\u0014\u0015p\u0015;biV\u001cH\u0003BAt\u0003[\u0004\u0002\"a3\u0002j\u0006%\u0017\u0011Z\u0005\u0005\u0003W\f9NA\u0002NCBD\u0001\"a<\u0002b\u0002\u0007\u0011\u0011_\u0001\tgR\fG/^:fgB)Q\"a=\u0002x&\u0019\u0011Q\u001f\b\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0003\u0002z\u0006}XBAA~\u0015\u0011\ti0!0\u0002\rM$\u0018\r^;t\u0013\u0011\u0011\t!a?\u0003\u001bI+G.Z1tKN#\u0018\r^;tQ\u0011\t\t/!\u001d\t\u000f\t\u001d\u0001\u0001\"\u0011\u0003\n\u0005Yb-\u001b8e\u00032dG+Z7qY\u0006$X-\u00133t\u0003:$G+\u001b;mKN$bAa\u0003\u0003\u0012\tM\u0001\u0003BA\u0019\u0005\u001bIAAa\u0004\u00024\t!\u0002\u000b\\1o\u0013R,WnU3be\u000eD'+Z:vYRD\u0001\"a\u0014\u0003\u0006\u0001\u0007\u0011\u0011\u000b\u0005\t\u00033\u0012)\u00011\u0001\u0002R!\"!QAA9\u0011\u001d\u0011I\u0002\u0001C!\u00057\t!CZ5oI\u0006cG\u000eV3na2\fG/Z%egV\u0011!Q\u0004\t\u0007\u0003W\u000b),!3)\t\t]\u0011\u0011\u000f\u0005\b\u0005G\u0001A\u0011\tB\u000e\u0003]1\u0017N\u001c3BY2\f5\r^5wKJ+G.Z1tK&#7\u000f\u000b\u0003\u0003\"\u0005E\u0004b\u0002B\u0015\u0001\u0011\u0005#1D\u0001\u0019M&tG-\u00117m!\u0016tG-\u001b8h%\u0016dW-Y:f\u0013\u0012\u001c\b\u0006\u0002B\u0014\u0003cBqAa\f\u0001\t\u0013\u0011\t$A\u0007rk\u0016\u0014\u0018PU3mK\u0006\u001cXm\u001d\u000b\u000b\u0005g\u0011)Ea\u0016\u0003Z\tm\u0003C\u0002B\u001b\u0005\u007f\tIL\u0004\u0003\u00038\tmbbA,\u0003:%\tq\"C\u0002\u0003>9\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003B\t\r#aA*fc*\u0019!Q\b\b\t\u0011\t\u001d#Q\u0006a\u0001\u0005\u0013\n\u0011b]3be\u000eD\u0017\nZ:\u0011\u000f5\u0011YEa\u0014\u0003V%\u0019!Q\n\b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA\u0003\u0005#J1Aa\u0015#\u0005\u0011\u0001\u0016mZ3\u0011\r\tU\"qHAe\u0011!\tyE!\fA\u0002\u0005E\u0003\u0002CA-\u0005[\u0001\r!!\u0015\t\u0011\tu#Q\u0006a\u0001\u0005?\n!\u0002]3s[&\u001c8/[8o!\u0011\u0011\tG!\u001a\u000e\u0005\t\r$b\u0001B/]&!!q\rB2\u0005)\u0001VM]7jgNLwN\u001c\u0005\b\u0005W\u0002A\u0011\u0002B7\u0003a1\u0017N\u001c3SK2,\u0017m]3t\u0005fLEm]%o\u001fJ$WM\u001d\u000b\u0005\u0005g\u0011y\u0007\u0003\u0005\u0003r\t%\u0004\u0019\u0001B+\u0003)\u0011X\r\\3bg\u0016LEm\u001d\u0005\b\u0005k\u0002A\u0011\u0002B<\u00039!xnU3be\u000eD'+Z:vYR$b!a\f\u0003z\tm\u0004\u0002CA(\u0005g\u0002\r!!\u0015\t\u0011\tu$1\u000fa\u0001\u0005g\t\u0001B]3mK\u0006\u001cXm\u001d\u0005\b\u0005\u000f\u0002A\u0011\u0002BA)\u0011\u0011\u0019Ia\"\u0015\t\tU#Q\u0011\u0005\t\u0003\u001f\u0012y\b1\u0001\u0003P!A\u00111\bB@\u0001\u0004\ti\u0004C\u0004\u0003\f\u0002!IA!$\u0002/M,\u0017M]2i\u0007>l\u0007\u000f\\3uK\u0012\u0014V\r\\3bg\u0016\u001cH\u0003\u0002BH\u00053#\u0002Ba\r\u0003\u0012\nU%q\u0013\u0005\t\u0005'\u0013I\t1\u0001\u0003J\u00051q-\u001a;JIND\u0001\"a\u0014\u0003\n\u0002\u0007\u0011\u0011\u000b\u0005\t\u00033\u0012I\t1\u0001\u0002R!A\u00111\bBE\u0001\u0004\ti\u0004C\u0004\u0003\u001e\u0002!IAa(\u0002\u001fM,\u0017M]2i\u0013:\f%o\u00195jm\u0016$\u0002\"!+\u0003\"\n\r&Q\u0015\u0005\t\u0003w\u0011Y\n1\u0001\u0002>!A\u0011\u0011\fBN\u0001\u0004\t\t\u0006\u0003\u0005\u0003(\nm\u0005\u0019AA)\u0003\u0019ygMZ:fi\"9!1\u0016\u0001\u0005B\t5\u0016\u0001D3ySN$8OQ=OC6,G\u0003BA5\u0005_C\u0001B!-\u0003*\u0002\u0007\u0011\u0011Z\u0001\u000eG\u0006tG-\u001b3bi\u0016t\u0015-\\3)\t\t%\u0016\u0011\u000f\u0005\b\u0005o\u0003A\u0011\u0002B]\u0003E\u0019WO\u001d:f]R\u0004&/\u001b8dSB\fGn]\u000b\u0003\u0005w\u0003bA!\u000e\u0003>\u0006%\u0017\u0002\u0002B`\u0005\u0007\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\b\u0005\u0007\u0004A\u0011\u0002Bc\u00039\u0019WO\u001d:f]R\u0014v\u000e\\3JIN,\"Aa2\u0011\r\t%'1\u001bBl\u001b\t\u0011YM\u0003\u0003\u0003N\n=\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0005#t\u0011AC2pY2,7\r^5p]&!!Q\u001bBf\u0005\u0019\u0011UO\u001a4feB!!\u0011\u001cBp\u001b\t\u0011YN\u0003\u0003\u0003^\u0006E\u0016\u0001\u00027b]\u001eLA!!6\u0003\\\u0002")
public class SqlReleaseSearchService
implements ReleaseSearchService,
Logging,
DeserializationSupport {
    private final ReleasePersistence releasePersistence;
    private final ArchivingService archivingService;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final TeamService teamService;
    private final InternalMetadataDecoratorService decoratorService;
    private final SqlBuilder.Dialect sqlDialect;
    private final PermissionEnforcer permissionEnforcer;
    private final RoleService roleService;
    private final SecuredCis securedCis;
    private Logger grizzled$slf4j$Logging$$_logger;
    private final long DEFAULT_NUMBER_OF_RELEASES_PER_PAGE;
    private final int DEFAULT_RELEASE_LOAD_DEPTH;
    private volatile boolean bitmap$0;

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public ReleaseSearchResult search(ReleasesFilters releasesFilters, long page, long numberByPage) {
        return ReleaseSearchService.search$((ReleaseSearchService)this, (ReleasesFilters)releasesFilters, (long)page, (long)numberByPage);
    }

    public ReleaseSearchResult search(ReleasesFilters releasesFilters, long page, long numberByPage, int depth) {
        return ReleaseSearchService.search$((ReleaseSearchService)this, (ReleasesFilters)releasesFilters, (long)page, (long)numberByPage, (int)depth);
    }

    public scala.collection.immutable.Map<String, String> findAllReleaseIdsAndTitlesByStatus(ReleaseStatus ... statuses) {
        return ReleaseSearchService.findAllReleaseIdsAndTitlesByStatus$((ReleaseSearchService)this, (ReleaseStatus[])statuses);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseSearchService sqlReleaseSearchService = this;
        synchronized (sqlReleaseSearchService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public long DEFAULT_NUMBER_OF_RELEASES_PER_PAGE() {
        return this.DEFAULT_NUMBER_OF_RELEASES_PER_PAGE;
    }

    public int DEFAULT_RELEASE_LOAD_DEPTH() {
        return this.DEFAULT_RELEASE_LOAD_DEPTH;
    }

    public void com$xebialabs$xlrelease$service$ReleaseSearchService$_setter_$DEFAULT_NUMBER_OF_RELEASES_PER_PAGE_$eq(long x$1) {
        this.DEFAULT_NUMBER_OF_RELEASES_PER_PAGE = x$1;
    }

    public void com$xebialabs$xlrelease$service$ReleaseSearchService$_setter_$DEFAULT_RELEASE_LOAD_DEPTH_$eq(int x$1) {
        this.DEFAULT_RELEASE_LOAD_DEPTH = x$1;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public TeamService teamService() {
        return this.teamService;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public RoleService roleService() {
        return this.roleService;
    }

    public SecuredCis securedCis() {
        return this.securedCis;
    }

    @Timed
    public ReleaseSearchResult search(ReleasesFilters releasesFilters, long page2, long numberByPage, int depth, boolean filterOnPermissions) {
        Seq<Release> seq;
        releasesFilters.checkConsistency();
        if (releasesFilters.hasASelectedFilter()) {
            Function1 & Serializable & scala.Serializable getIds = (Function1 & Serializable & scala.Serializable)page -> this.searchIds(releasesFilters, (Page)page);
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for releases by filters"})).s((Seq)Nil$.MODULE$));
            seq = releasesFilters.withOnlyArchived() ? (Seq<Release>)JavaConverters$.MODULE$.asScalaBufferConverter(this.searchInArchive(releasesFilters, numberByPage, numberByPage * page2)).asScala() : (releasesFilters.withInactive() || releasesFilters.withAborted() || releasesFilters.withCompleted() ? this.searchCompletedReleases(releasesFilters, (Function1<Page, Seq<String>>)getIds, page2, numberByPage) : this.queryReleases((Function1<Page, Seq<String>>)getIds, page2, numberByPage, XLReleasePermissions.VIEW_RELEASE));
        } else {
            seq = List$.MODULE$.empty();
        }
        Seq<Release> results = seq;
        return this.toSearchResult(page2, results);
    }

    @Timed
    public ReleaseSearchResult searchTemplates(TemplateFilters templateFilters, long page2, long numberByPage, int depth) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for templates by filters"})).s((Seq)Nil$.MODULE$));
        Seq<Release> templates = this.queryReleases((Function1<Page, Seq<String>>)(Function1 & Serializable & scala.Serializable)page -> this.searchIds$1((Page)page, templateFilters), page2, numberByPage, XLReleasePermissions.VIEW_TEMPLATE);
        return this.toSearchResult(page2, templates);
    }

    @Timed
    public List<Release> searchReleasesByTitle(String releaseTitle, long page2, long numberByPage, int depth) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for releases by title ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseTitle})));
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.queryReleases((Function1<Page, Seq<String>>)(Function1 & Serializable & scala.Serializable)page -> this.getIds$1((Page)page, releaseTitle), page2, numberByPage, XLReleasePermissions.VIEW_RELEASE)).asJava();
    }

    @Timed
    public scala.collection.immutable.Map<String, String> findAllReleaseIdsAndTitlesByStatus(Seq<ReleaseStatus> statuses) {
        ReleasesSqlBuilder sqlBuilder = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseIdAndTitle().withOneOfStatuses(statuses);
        Object object = !this.permissionEnforcer().isCurrentUserAdmin() ? sqlBuilder.withPermission(XLReleasePermissions.VIEW_RELEASE, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds()) : BoxedUnit.UNIT;
        Tuple2 sqlWithParams = sqlBuilder.build();
        return this.releasePersistence.findReleaseIdsAndTitlesByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).toMap(Predef$.MODULE$.$conforms());
    }

    @Timed
    public PlanItemSearchResult findAllTemplateIdsAndTitles(long page, long numberByPage) {
        ReleasesSqlBuilder sqlBuilder = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseIdAndTitle().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.TEMPLATE})))).orderBy(ReleaseOrderMode.title).withPage(new Page((long)((int)page), (long)((int)numberByPage), Predef$.MODULE$.int2Integer(0)));
        Object object = !this.permissionEnforcer().isCurrentUserAdmin() ? sqlBuilder.withPermission(XLReleasePermissions.VIEW_RELEASE, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds()) : BoxedUnit.UNIT;
        scala.collection.immutable.Map idToTitle = this.releasePersistence.findReleaseIdsAndTitlesByQuery((Tuple2<String, Seq<Object>>)sqlBuilder.build()).toMap(Predef$.MODULE$.$conforms());
        PlanItemSearchResult searchResult = new PlanItemSearchResult();
        searchResult.setPage(page + 1L);
        searchResult.setItems(JavaConverters$.MODULE$.mapAsJavaMap((Map)idToTitle));
        return searchResult;
    }

    @Timed
    public List<String> findAllTemplateIds() {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.TEMPLATE})))).build();
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams)).asJava();
    }

    @Timed
    public List<String> findAllActiveReleaseIds() {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])ReleaseStatus.ACTIVE_STATUSES)).build();
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams)).asJava();
    }

    @Timed
    public List<String> findAllPendingReleaseIds() {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for all pending releases"})).s((Seq)Nil$.MODULE$));
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.PLANNED})))).withAutoStart().build();
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams)).asJava();
    }

    private Seq<Release> queryReleases(Function1<Page, Seq<String>> searchIds, long page, long numberByPage, Permission permission) {
        Seq releaseIds = (Seq)searchIds.apply((Object)new Page((long)((int)page), (long)((int)numberByPage), Predef$.MODULE$.int2Integer(0)));
        Seq releases = releaseIds.nonEmpty() ? this.findReleasesByIdsInOrder((Seq<String>)releaseIds) : (Seq)Seq$.MODULE$.empty();
        releases.foreach((Function1 & Serializable & scala.Serializable)release -> {
            SqlReleaseSearchService.$anonfun$queryReleases$1(this, release);
            return BoxedUnit.UNIT;
        });
        this.decoratorService.decorate((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(releases).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ReleaseGlobalVariablesDecorator$.MODULE$.GLOBAL_VARIABLES(), EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))).asJava());
        return releases;
    }

    private Seq<Release> findReleasesByIdsInOrder(Seq<String> releaseIds) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withReleaseIds(releaseIds).build();
        Seq releasesUnordered = (Seq)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).map((Function1 & Serializable & scala.Serializable)releaseData -> this.deserializeRelease((ReleaseRow)releaseData), Seq$.MODULE$.canBuildFrom());
        return (Seq)releasesUnordered.sortBy((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToInteger((int)releaseIds.indexOf((Object)r.getId())), (Ordering)Ordering.Int$.MODULE$);
    }

    private ReleaseSearchResult toSearchResult(long page, Seq<Release> releases) {
        ReleaseSearchResult searchResult = new ReleaseSearchResult();
        searchResult.setPage(page + 1L);
        searchResult.addReleases((List)JavaConverters$.MODULE$.seqAsJavaListConverter(releases).asJava());
        return searchResult;
    }

    private Seq<String> searchIds(ReleasesFilters releasesFilters, Page page) {
        Tuple2 sqlWithParams = SqlReleasesFilterSupport$.MODULE$.sqlBuilderByFilters(releasesFilters, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds(), this.permissionEnforcer(), this.sqlDialect()).selectReleaseId().withPage(page).build();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for a batch of releases by SQL query: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlWithParams._1()})));
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    private Seq<Release> searchCompletedReleases(ReleasesFilters releasesFilters, Function1<Page, Seq<String>> getIds, long page, long numberByPage) {
        Seq seq;
        Seq releases = this.queryReleases(getIds, page, numberByPage, XLReleasePermissions.VIEW_RELEASE);
        if (releases.nonEmpty()) {
            if ((long)releases.length() >= numberByPage) {
                seq = releases;
            } else {
                List<Release> archivedReleases = this.searchInArchive(releasesFilters, numberByPage - (long)releases.length(), 0L);
                seq = (Seq)releases.$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(archivedReleases).asScala(), Seq$.MODULE$.canBuildFrom());
            }
        } else {
            int numOfNonArchivedReleases = ((SeqLike)getIds.apply((Object)new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(0)))).length();
            long offset = numberByPage * page - (long)numOfNonArchivedReleases;
            seq = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.searchInArchive(releasesFilters, numberByPage, offset)).asScala();
        }
        return seq;
    }

    private List<Release> searchInArchive(ReleasesFilters releasesFilters, long numberByPage, long offset) {
        List releases = this.archivingService.searchReleases(releasesFilters, numberByPage, offset);
        this.decoratorService.decorate((Collection)releases, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ReleaseGlobalVariablesDecorator$.MODULE$.GLOBAL_VARIABLES(), EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))).asJava());
        return releases;
    }

    @Timed
    public boolean existsByName(String candidateName) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withReleaseName(candidateName).withPage(new Page(0L, 1L, Predef$.MODULE$.int2Integer(0))).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).nonEmpty();
    }

    private Iterable<String> currentPrincipals() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Buffer<String> currentRoleIds() {
        return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService().getRolesFor(Permissions.getAuthentication())).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), Buffer$.MODULE$.canBuildFrom());
    }

    private final Seq searchIds$1(Page page, TemplateFilters templateFilters$1) {
        Tuple2 sqlWithParams = SqlTemplatesFilterSupport$.MODULE$.sqlBuilderByFilters(templateFilters$1, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds(), this.permissionEnforcer(), this.sqlDialect()).selectReleaseId().withPage(page).build();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for a batch of templates by SQL query: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlWithParams._1()})));
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    private final Seq getIds$1(Page page, String releaseTitle$1) {
        ReleasesSqlBuilder sqlWithParams = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withTitle(releaseTitle$1).withPage(page);
        Object object = !this.permissionEnforcer().isCurrentUserAdmin() ? sqlWithParams.withPermission(XLReleasePermissions.VIEW_RELEASE, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds()) : BoxedUnit.UNIT;
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams.build());
    }

    public static final /* synthetic */ void $anonfun$queryReleases$1(SqlReleaseSearchService $this, Release release) {
        $this.teamService().decorateWithEffectiveTeams(release);
    }

    public SqlReleaseSearchService(ReleasePersistence releasePersistence, ArchivingService archivingService, SqlRepositoryAdapter repositoryAdapter, TeamService teamService, InternalMetadataDecoratorService decoratorService, SqlBuilder.Dialect sqlDialect, PermissionEnforcer permissionEnforcer, RoleService roleService, SecuredCis securedCis) {
        this.releasePersistence = releasePersistence;
        this.archivingService = archivingService;
        this.repositoryAdapter = repositoryAdapter;
        this.teamService = teamService;
        this.decoratorService = decoratorService;
        this.sqlDialect = sqlDialect;
        this.permissionEnforcer = permissionEnforcer;
        this.roleService = roleService;
        this.securedCis = securedCis;
        ReleaseSearchService.$init$((ReleaseSearchService)this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
    }
}

