/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.AttachmentRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0001\u001b\t92+\u001d7BiR\f7\r[7f]R\u0014V\r]8tSR|'/\u001f\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!\u0001\u0006sKB|7/\u001b;pefT!a\u0002\u0005\u0002\u0013ad'/\u001a7fCN,'BA\u0005\u000b\u0003%AXMY5bY\u0006\u00147OC\u0001\f\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001a\u0002\u0006\r\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0005\u0013\t9BA\u0001\u000bBiR\f7\r[7f]R\u0014V\r]8tSR|'/\u001f\t\u00033yi\u0011A\u0007\u0006\u00037q\tQa\u001d7gi)T\u0011!H\u0001\tOJL'P\u001f7fI&\u0011qD\u0007\u0002\b\u0019><w-\u001b8h\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013A\u0005:fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016\u0004\"a\t\u0014\u000e\u0003\u0011R!!\n\u0002\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0003O\u0011\u0012!CU3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dK\")\u0011\u0006\u0001C\u0001U\u00051A(\u001b8jiz\"\"aK\u0017\u0011\u00051\u0002Q\"\u0001\u0002\t\u000b\u0005B\u0003\u0019\u0001\u0012\t\u000b=\u0002A\u0011\t\u0019\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012$\"!M\u001c\u0011\u0005I*T\"A\u001a\u000b\u0005Q2\u0011A\u00023p[\u0006Lg.\u0003\u00027g\tQ\u0011\t\u001e;bG\"lWM\u001c;\t\u000bar\u0003\u0019A\u001d\u0002\u0019\u0005$H/Y2i[\u0016tG/\u00133\u0011\u0005i\neBA\u001e@!\ta\u0004#D\u0001>\u0015\tqD\"\u0001\u0004=e>|GOP\u0005\u0003\u0001B\ta\u0001\u0015:fI\u00164\u0017B\u0001\"D\u0005\u0019\u0019FO]5oO*\u0011\u0001\t\u0005\u0015\u0003]\u0015\u0003\"AR'\u000e\u0003\u001dS!\u0001S%\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002K\u0017\u00069Q.\u001a;sS\u000e\u001c(B\u0001'\u000b\u0003!\u0019w\u000eZ1iC2,\u0017B\u0001(H\u0005\u0015!\u0016.\\3e\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0003\u0019\u0019'/Z1uKR!\u0011GU,]\u0011\u0015\u0019v\n1\u0001U\u0003\u001d\u0011X\r\\3bg\u0016\u0004\"AM+\n\u0005Y\u001b$a\u0002*fY\u0016\f7/\u001a\u0005\u00061>\u0003\r!W\u0001\u0005i\u0006\u001c8\u000e\u0005\u000235&\u00111l\r\u0002\u0005)\u0006\u001c8\u000eC\u0003^\u001f\u0002\u0007\u0011'\u0001\u0006biR\f7\r[7f]RD#aT#\t\u000bA\u0003A\u0011\t1\u0015\u0007E\n'\rC\u0003T?\u0002\u0007A\u000bC\u0003^?\u0002\u0007\u0011\u0007\u000b\u0002`\u000b\")Q\r\u0001C!M\u00061A-\u001a7fi\u0016$2a\u001a6l!\ty\u0001.\u0003\u0002j!\t!QK\\5u\u0011\u0015\u0019F\r1\u0001U\u0011\u0015iF\r1\u00012Q\t!W\tC\u0003f\u0001\u0011\u0005c\u000eF\u0002h_BDQ\u0001W7A\u0002eCQ!X7A\u0002EB#!\\#)\u0005\u0001\u0019\bC\u0001;{\u001b\u0005)(B\u0001<x\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005\rA(BA=\u0007\u0003\t!'-\u0003\u0002|k\ny\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000e")
public class SqlAttachmentRepository
implements AttachmentRepository,
Logging {
    private final ReleasePersistence releasePersistence;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlAttachmentRepository sqlAttachmentRepository = this;
        synchronized (sqlAttachmentRepository) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public Attachment findById(String attachmentId) {
        return (Attachment)this.releasePersistence.findAttachmentById(attachmentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Repository entity [%s] not found", new Object[]{attachmentId});
        });
    }

    @Timed
    public Attachment create(Release release, Task task, Attachment attachment) {
        Task releaseTask = release.getTask(task.getId());
        Set taskAttachments = (Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(releaseTask.getAttachments()).asScala()).toSet().$plus((Object)attachment);
        releaseTask.setAttachments((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)taskAttachments.toList()).asJava());
        return this.create(release, attachment);
    }

    @Timed
    public Attachment create(Release release, Attachment attachment) {
        this.releasePersistence.update((Option<Release>)None$.MODULE$, release);
        this.releasePersistence.insertAttachments(release.getId(), (Seq<SourceArtifact>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attachment[]{attachment})));
        return attachment;
    }

    @Timed
    public void delete(Release release, Attachment attachment) {
        block0: {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting attachment reference '", "' from release '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attachment.getId(), release.getId()})));
            release.deleteAttachment(attachment.getId());
            this.releasePersistence.update(release);
            if (release.isTemplate()) break block0;
            this.releasePersistence.deleteAttachmentById(attachment.getId());
        }
    }

    @Timed
    public void delete(Task task, Attachment attachment) {
        task.deleteAttachment(attachment.getId());
        Release release = task.getRelease();
        if (release.getTasksUsingAttachment(attachment.getId()).isEmpty()) {
            this.delete(release, attachment);
        } else {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting attachment reference ", " from task ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attachment.getId(), task.getId()})));
            this.releasePersistence.update(release);
        }
    }

    public SqlAttachmentRepository(ReleasePersistence releasePersistence) {
        this.releasePersistence = releasePersistence;
        Logging.$init$((Logging)this);
    }
}

