/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.Diff;
import com.xebialabs.xlrelease.domain.utils.Diff$;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.ConfigurationPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TriggerPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.security.SecuredCi;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\r\ra\u0001B\u0001\u0003\u00015\u0011AcU9m%\u0016dW-Y:f%\u0016\u0004xn]5u_JL(BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\t!B]3q_NLGo\u001c:z\u0015\t9\u0001\"A\u0005yYJ,G.Z1tK*\u0011\u0011BC\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aC\u0001\u0004G>l7\u0001A\n\u0007\u00019!\u0002\u0004\t\u0013\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0005\u0013\t9BAA\tSK2,\u0017m]3SKB|7/\u001b;pef\u0004\"!\u0007\u0010\u000e\u0003iQ!a\u0007\u000f\u0002\u000bMdg\r\u000e6\u000b\u0003u\t\u0001b\u001a:jujdW\rZ\u0005\u0003?i\u0011q\u0001T8hO&tw\r\u0005\u0002\"E5\t!!\u0003\u0002$\u0005\t1B)Z:fe&\fG.\u001b>bi&|gnU;qa>\u0014H\u000f\u0005\u0002\"K%\u0011aE\u0001\u0002\u001f\u0007>tg-[4ve\u0006$\u0018n\u001c8SK\u001a,'/\u001a8dKN\u001cV\u000f\u001d9peRD\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!K\u0001\u0013e\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW\r\u0005\u0002+[5\t1F\u0003\u0002-\u0005\u0005Y\u0001/\u001a:tSN$XM\\2f\u0013\tq3F\u0001\nSK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u001fQ\f7o\u001b)feNL7\u000f^3oG\u0016\u0004\"A\u000b\u001a\n\u0005MZ#a\u0004+bg.\u0004VM]:jgR,gnY3\t\u0011U\u0002!\u0011!Q\u0001\nY\nQ\u0003Z3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW\r\u0005\u0002+o%\u0011\u0001h\u000b\u0002\u0016\t\u0016\u0004XM\u001c3f]\u000eL\b+\u001a:tSN$XM\\2f\u0011!Q\u0004A!A!\u0002\u0013Y\u0014A\u0004;fC6\u0014V\r]8tSR|'/\u001f\t\u0003+qJ!!\u0010\u0003\u0003\u001dQ+\u0017-\u001c*fa>\u001c\u0018\u000e^8ss\"Aq\b\u0001BC\u0002\u0013\u0005\u0001)\u0001\rd_:4\u0017nZ;sCRLwN\u001c)feNL7\u000f^3oG\u0016,\u0012!\u0011\t\u0003U\tK!aQ\u0016\u00031\r{gNZ5hkJ\fG/[8o!\u0016\u00148/[:uK:\u001cW\r\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003B\u0003e\u0019wN\u001c4jOV\u0014\u0018\r^5p]B+'o]5ti\u0016t7-\u001a\u0011\t\u0011\u001d\u0003!Q1A\u0005\u0002!\u000b\u0011C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s+\u0005I\u0005CA\u0011K\u0013\tY%A\u0001\u000bTc2\u0014V\r]8tSR|'/_!eCB$XM\u001d\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u0013\u0006\u0011\"/\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:!\u0011!y\u0005A!A!\u0002\u0013\u0001\u0016A\u0005;sS\u001e<WM\u001d)feNL7\u000f^3oG\u0016\u0004\"AK)\n\u0005I[#A\u0005+sS\u001e<WM\u001d)feNL7\u000f^3oG\u0016D\u0001\u0002\u0016\u0001\u0003\u0006\u0004%\u0019!V\u0001\u000bgFdG)[1mK\u000e$X#\u0001,\u0011\u0005]SgB\u0001-h\u001d\tIVM\u0004\u0002[G:\u00111L\u0019\b\u00039\u0006t!!\u00181\u000e\u0003yS!a\u0018\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002e\r\u0005\u0011AMY\u0005\u0003\u0007\u0019T!\u0001\u001a\u0004\n\u0005!L\u0017AC*rY\n+\u0018\u000e\u001c3fe*\u00111AZ\u0005\u0003W2\u0014q\u0001R5bY\u0016\u001cGO\u0003\u0002iS\"Aa\u000e\u0001B\u0001B\u0003%a+A\u0006tc2$\u0015.\u00197fGR\u0004\u0003\"\u00029\u0001\t\u0003\t\u0018A\u0002\u001fj]&$h\b\u0006\u0005skZ<\b0\u001f>|)\t\u0019H\u000f\u0005\u0002\"\u0001!)Ak\u001ca\u0002-\")\u0001f\u001ca\u0001S!)\u0001g\u001ca\u0001c!)Qg\u001ca\u0001m!)!h\u001ca\u0001w!)qh\u001ca\u0001\u0003\")qi\u001ca\u0001\u0013\")qj\u001ca\u0001!\"9Q\u0010\u0001a\u0001\n\u0013q\u0018a\u00069feNL7\u000f^3oG\u0016Le\u000e^3sG\u0016\u0004Ho\u001c:t+\u0005y\bCBA\u0001\u0003\u0017\t\tB\u0004\u0003\u0002\u0004\u0005\u001dabA/\u0002\u0006%\t\u0011#C\u0002\u0002\nA\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u000e\u0005=!aA*fc*\u0019\u0011\u0011\u0002\t\u0011\u000bU\t\u0019\"a\u0006\n\u0007\u0005UAA\u0001\fQKJ\u001c\u0018n\u001d;f]\u000e,\u0017J\u001c;fe\u000e,\u0007\u000f^8s!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f\r\u00051Am\\7bS:LA!!\t\u0002\u001c\t9!+\u001a7fCN,\u0007\"CA\u0013\u0001\u0001\u0007I\u0011BA\u0014\u0003m\u0001XM]:jgR,gnY3J]R,'oY3qi>\u00148o\u0018\u0013fcR!\u0011\u0011FA\u0018!\ry\u00111F\u0005\u0004\u0003[\u0001\"\u0001B+oSRD\u0011\"!\r\u0002$\u0005\u0005\t\u0019A@\u0002\u0007a$\u0013\u0007C\u0004\u00026\u0001\u0001\u000b\u0015B@\u00021A,'o]5ti\u0016t7-Z%oi\u0016\u00148-\u001a9u_J\u001c\b\u0005C\u0004\u0002:\u0001!\t%a\u000f\u0002\r\u0015D\u0018n\u001d;t)\u0011\ti$a\u0011\u0011\u0007=\ty$C\u0002\u0002BA\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002F\u0005]\u0002\u0019AA$\u0003\tIG\r\u0005\u0003\u0002J\u0005Ec\u0002BA&\u0003\u001b\u0002\"!\u0018\t\n\u0007\u0005=\u0003#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003'\n)F\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001f\u0002\u0002\u0006BA\u001c\u00033\u0002B!a\u0017\u0002b5\u0011\u0011Q\f\u0006\u0004\u0003?J\u0017a\u0003;sC:\u001c\u0018m\u0019;j_:LA!a\u0019\u0002^\tQ\u0011j\u001d*fC\u0012|e\u000e\\=)\t\u0005]\u0012q\r\t\u0005\u0003S\n9(\u0004\u0002\u0002l)!\u0011QNA8\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003c\n\u0019(A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005U$\"\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\tI(a\u001b\u0003\u000bQKW.\u001a3\t\u000f\u0005u\u0004\u0001\"\u0011\u0002\u0000\u000511M]3bi\u0016$b!a\u0006\u0002\u0002\u0006\u0015\u0005\u0002CAB\u0003w\u0002\r!a\u0006\u0002\u000fI,G.Z1tK\"A\u0011qQA>\u0001\u0004\tI)A\u000bsK2,\u0017m]3De\u0016\fG/[8o'>,(oY3\u0011\t\u0005-\u0015\u0011S\u0007\u0003\u0003\u001bSA!a$\u0002\u001c\u00051QM^3oiNLA!a%\u0002\u000e\n)\"+\u001a7fCN,7I]3bi&|gnU8ve\u000e,\u0007\u0006BA>\u0003OBq!!'\u0001\t\u0003\nY*\u0001\u0005gS:$')_%e)\u0019\t9\"!(\u0002 \"A\u0011QIAL\u0001\u0004\t9\u0005\u0003\u0005\u0002\"\u0006]\u0005\u0019AAR\u0003\u001d9xN]6ESJ\u0004B!!*\u0002.6\u0011\u0011q\u0015\u0006\u0004\u000b\u0005%&bAAV\u0011\u0005AA-\u001a9m_fLG/\u0003\u0003\u00020\u0006\u001d&aB,pe.$\u0015N\u001d\u0015\u0005\u0003/\u000b9\u0007C\u0004\u00026\u0002!\t%a.\u0002\u001f\u0019Lg\u000eZ%eg\nK8\u000b^1ukN$B!!/\u0002<B1\u0011\u0011AA\u0006\u0003\u000fB\u0001\"!0\u00024\u0002\u0007\u0011qX\u0001\tgR\fG/^:fgB)q\"!1\u0002F&\u0019\u00111\u0019\t\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0003\u0002H\u00065WBAAe\u0015\u0011\tY-a\u0007\u0002\rM$\u0018\r^;t\u0013\u0011\ty-!3\u0003\u001bI+G.Z1tKN#\u0018\r^;tQ\u0011\t\u0019,a\u001a)\t\u0005M\u0016Q\u001b\t\u0005\u0003/\fY.\u0004\u0002\u0002Z*\u0019\u0011Q\u000e\t\n\t\u0005u\u0017\u0011\u001c\u0002\bm\u0006\u0014\u0018M]4t\u0011\u001d\t\t\u000f\u0001C!\u0003G\f1CZ5oI\nK8)\u00197f]\u0012\f'\u000fV8lK:$B!a\u0006\u0002f\"A\u0011q]Ap\u0001\u0004\t9%A\u0007dC2,g\u000eZ1s)>\\WM\u001c\u0015\u0005\u0003?\f9\u0007C\u0004\u0002n\u0002!\t!a<\u00021\u0019Lg\u000eZ!sG\"Lg/\u00192mKJ+G.Z1tK&#7\u000f\u0006\u0004\u0002:\u0006E(Q\u0001\u0005\t\u0003g\fY\u000f1\u0001\u0002v\u0006!A-\u0019;f!\u0011\t9P!\u0001\u000e\u0005\u0005e(\u0002BA~\u0003{\fA!\u001e;jY*\u0011\u0011q`\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\u0004\u0005e(\u0001\u0002#bi\u0016D\u0001Ba\u0002\u0002l\u0002\u0007!\u0011B\u0001\ta\u0006<WmU5{KB\u0019qBa\u0003\n\u0007\t5\u0001CA\u0002J]RDC!a;\u0002Z!\"\u00111^A4\u0011\u001d\u0011)\u0002\u0001C!\u0005/\taa]3be\u000eDG\u0003\u0002B\r\u0005?\u0001b!a>\u0003\u001c\u0005]\u0011\u0002\u0002B\u000f\u0003s\u0014A\u0001T5ti\"A!\u0011\u0005B\n\u0001\u0004\u0011\u0019#\u0001\u0007tK\u0006\u00148\r\u001b)be\u0006l7\u000fE\u0002\u0016\u0005KI1Aa\n\u0005\u0005U\u0011V\r\\3bg\u0016\u001cV-\u0019:dQ\nK\b+\u0019:b[NDCAa\u0005\u0002h!9!Q\u0006\u0001\u0005B\t=\u0012A\u00023fY\u0016$X\r\u0006\u0003\u0002*\tE\u0002\u0002CA#\u0005W\u0001\r!a\u0012)\t\t-\u0012q\r\u0005\b\u0005o\u0001A\u0011\u0002B\u001d\u0003]!W\r\\3uKJ+G.Z1tKJ+g-\u001a:f]\u000e,7\u000f\u0006\u0004\u0002*\tm\"Q\b\u0005\t\u0003\u000b\u0012)\u00041\u0001\u0002H!A!q\bB\u001b\u0001\u0004\u0011I!\u0001\u0006sK2,\u0017m]3VS\u0012DqAa\u0011\u0001\t\u0003\u0012)%A\u0007eK2,G/Z,ji\",\u0016\u000e\u001a\u000b\u0007\u0003S\u00119E!\u0013\t\u0011\u0005\u0015#\u0011\ta\u0001\u0003\u000fB\u0001Ba\u0010\u0003B\u0001\u0007!\u0011\u0002\u0015\u0005\u0005\u0003\n9\u0007C\u0004\u0003P\u0001!\tE!\u0015\u0002\t5|g/\u001a\u000b\u0007\u0003S\u0011\u0019Fa\u0016\t\u0011\tU#Q\na\u0001\u0003\u000f\n!b\u001c:jO&t\u0017\r\\%e\u0011!\u0011IF!\u0014A\u0002\u0005\u001d\u0013!\u00028fo&#\u0007\u0006\u0002B'\u0003OBqAa\u0018\u0001\t\u0003\u0012\t'A\u0005hKR\u001cF/\u0019;vgR!\u0011Q\u0019B2\u0011!\t)E!\u0018A\u0002\u0005\u001d\u0003\u0006\u0002B/\u0003OBqA!\u001b\u0001\t\u0003\u0012Y'\u0001\u0006jgR+W\u000e\u001d7bi\u0016$B!!\u0010\u0003n!A!q\u000eB4\u0001\u0004\t9%A\u0005sK2,\u0017m]3JI\"\"!qMA-Q\u0011\u00119'a\u001a\t\u000f\t]\u0004\u0001\"\u0011\u0003z\u0005Aq-\u001a;USRdW\r\u0006\u0003\u0002H\tm\u0004\u0002CA#\u0005k\u0002\r!a\u0012)\t\tU\u0014\u0011\f\u0015\u0005\u0005k\n9\u0007C\u0004\u0003\u0004\u0002!\tE!\"\u0002\rU\u0004H-\u0019;f)\u0011\t9Ba\"\t\u0011\u0005\r%\u0011\u0011a\u0001\u0003/ACA!!\u0002h!9!1\u0011\u0001\u0005B\t5ECBA\f\u0005\u001f\u0013\u0019\n\u0003\u0005\u0003\u0012\n-\u0005\u0019AA\f\u0003!y'/[4j]\u0006d\u0007\u0002\u0003BK\u0005\u0017\u0003\r!a\u0006\u0002\u000fU\u0004H-\u0019;fI\"\"!1RA4\u0011\u001d\u0011Y\n\u0001C!\u0005;\u000b!bZ3u\u00032dG+Y4t)\u0011\u0011yJ!*\u0011\r\u0005](\u0011UA$\u0013\u0011\u0011\u0019+!?\u0003\u0007M+G\u000f\u0003\u0005\u0003(\ne\u0005\u0019\u0001B\u0005\u0003-a\u0017.\\5u\u001dVl'-\u001a:)\t\te\u0015\u0011\f\u0015\u0005\u00053\u000b9\u0007C\u0004\u00030\u0002!IA!-\u0002!%t7/\u001a:u\t\u0016\u0004XM\u001c3f]\u000eLH\u0003\u0002BZ\u0005\u007f#B!!\u000b\u00036\"A!q\u0017BW\u0001\u0004\u0011I,\u0001\u0006eKB,g\u000eZ3oGf\u0004B!!\u0007\u0003<&!!QXA\u000e\u0005)!U\r]3oI\u0016t7-\u001f\u0005\t\u0003\u0007\u0013i\u000b1\u0001\u0002\u0018!9!1\u0019\u0001\u0005\n\t\u0015\u0017AC4fiJ+G.Z1tKR1\u0011q\u0003Bd\u0005GD\u0001Ba\u001c\u0003B\u0002\u0007!\u0011\u001a\t\u0005\u0005\u0017\u0014iN\u0004\u0003\u0003N\neg\u0002\u0002Bh\u0005/tAA!5\u0003V:\u0019!La5\n\u0005\u00151\u0011BA\u0002\u0005\u0013\ta#!C\u0002\u0003\\.\nAaQ5JI&!!q\u001cBq\u0005\u0011\u0019\u0015.\u00133\u000b\u0007\tm7\u0006\u0003\u0005\u0003f\n\u0005\u0007\u0019\u0001Be\u0003!)g\u000e^5us&#\u0007b\u0002Bu\u0001\u0011%!1^\u0001#G\",7m[%t\u001d>$(+\u001a4fe\u0016t7-\u001a3Cs\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:\u0015\t\u0005%\"Q\u001e\u0005\t\u0005_\u00149\u000f1\u0001\u0003J\u00069\u0002\u000f\\1o\u0013R,W.\u00133Pe&#8o\u00115jY\u0012\u0014XM\u001c\u0005\b\u0005g\u0004A\u0011\tB{\u0003y\u0011XmZ5ti\u0016\u0014\b+\u001a:tSN$XM\\2f\u0013:$XM]2faR|'\u000f\u0006\u0003\u0002*\t]\b\u0002\u0003B}\u0005c\u0004\r!!\u0005\u0002-A,'o]5ti\u0016t7-Z%oi\u0016\u00148-\u001a9u_JD3\u0001\u0001B\u007f!\u0011\tYFa@\n\t\r\u0005\u0011Q\f\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0002")
public class SqlReleaseRepository
implements ReleaseRepository,
Logging,
DeserializationSupport,
ConfigurationReferencesSupport {
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final DependencyPersistence dependencyPersistence;
    private final TeamRepository teamRepository;
    private final ConfigurationPersistence configurationPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final TriggerPersistence triggerPersistence;
    private final SqlBuilder.Dialect sqlDialect;
    private Seq<PersistenceInterceptor<Release>> persistenceInterceptors;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    @Override
    public void updateConfigurationRefs(Release release) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, release);
    }

    @Override
    public void deleteConfigurationRefs(Integer releaseUid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, releaseUid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public Release findById(String id) {
        return ReleaseRepository.findById$((ReleaseRepository)this, (String)id);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseRepository sqlReleaseRepository = this;
        synchronized (sqlReleaseRepository) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public Seq<String> findIdsByStatus(ReleaseStatus ... statuses) {
        return this.findIdsByStatus((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])statuses));
    }

    @Override
    public ConfigurationPersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    private Seq<PersistenceInterceptor<Release>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    private void persistenceInterceptors_$eq(Seq<PersistenceInterceptor<Release>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String id) {
        return this.releasePersistence.existsRelease(CiId$.MODULE$.RichCiId(id).normalized());
    }

    @Timed
    public Release create(Release release, ReleaseCreationSource releaseCreationSource) {
        if (this.releasePersistence.existsRelease(release.getId())) {
            throw new ItemAlreadyExistsException("A release with ID [%s] already exists", new Object[]{release.getId()});
        }
        this.persistenceInterceptors().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.onCreate((ConfigurationItem)release);
            return BoxedUnit.UNIT;
        });
        this.releasePersistence.insert(release);
        release.getReleaseTriggers().forEach(trigger -> $this.triggerPersistence.insert((ReleaseTrigger)trigger));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            this.taskPersistence.insert(task, Predef$.MODULE$.Integer2int(release.getCiUid()));
            return BoxedUnit.UNIT;
        });
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllGates()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$2.getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            this.insertDependency(release, dependency);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs(release);
        return release;
    }

    @Timed
    public Release findById(String id, WorkDir workDir) {
        return this.getRelease(id, id);
    }

    @Timed
    public Seq<String> findIdsByStatus(Seq<ReleaseStatus> statuses) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses(statuses).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    @Timed
    public Release findByCalendarToken(String calendarToken) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withCalendarToken(calendarToken).build();
        Seq<ReleaseRow> releases = this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
        return (Release)releases.headOption().map((Function1 & Serializable & scala.Serializable)releaseData -> this.deserializeRelease((ReleaseRow)releaseData)).orNull(Predef$.MODULE$.$conforms());
    }

    @Timed
    @IsReadOnly
    public Seq<String> findArchivableReleaseIds(Date date, int pageSize) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED})))).withEndDateBefore(date).withPage(new Page(0L, (long)pageSize, Predef$.MODULE$.int2Integer(0))).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    @Timed
    public List<Release> search(ReleaseSearchByParams searchParams) {
        ReleaseSearchByParams releaseSearchByParams = searchParams;
        if (releaseSearchByParams == null) {
            throw new MatchError((Object)releaseSearchByParams);
        }
        Page page = releaseSearchByParams.page();
        Either folderId2 = releaseSearchByParams.folderId();
        ReleaseStatus[] statuses = releaseSearchByParams.statuses();
        String title = releaseSearchByParams.title();
        String rootReleaseId = releaseSearchByParams.rootReleaseId();
        boolean autoStart = releaseSearchByParams.autoStart();
        ReleasesSqlBuilder base = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withTitle(title).withRootReleaseId(rootReleaseId).withPage(page);
        ReleasesSqlBuilder sqlBuilder = folderId2 == null ? base : (ReleasesSqlBuilder)((Object)folderId2.fold((Function1 & Serializable & scala.Serializable)folderId -> base.withFolder((String)folderId), (Function1 & Serializable & scala.Serializable)ancestorId -> base.withAncestor((String)ancestorId)));
        Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).nonEmpty() ? sqlBuilder.withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])statuses)) : BoxedUnit.UNIT;
        Object object2 = autoStart ? sqlBuilder.withAutoStart() : BoxedUnit.UNIT;
        List list = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlBuilder.build()).map((Function1 & Serializable & scala.Serializable)releaseData -> this.deserializeRelease((ReleaseRow)releaseData), Seq$.MODULE$.canBuildFrom())).asJava();
        return list;
    }

    @Timed
    public void delete(String id) {
        this.checkIsNotReferencedByDependencies(id);
        this.releasePersistence.findUidByReleaseId(id).foreach((Function1 & Serializable & scala.Serializable)uid -> {
            this.deleteReleaseReferences(id, uid);
            return BoxedUnit.UNIT;
        });
        this.releasePersistence.deleteById(id);
    }

    private void deleteReleaseReferences(String id, int releaseUid) {
        this.dependencyPersistence.deleteByReleaseUid(Predef$.MODULE$.int2Integer(releaseUid));
        this.triggerPersistence.deleteByTemplateId(id);
        this.taskPersistence.deleteTasksByReleaseUid(releaseUid);
        this.teamRepository.deleteTeamsFromPlatform(new SecuredCi(id, releaseUid));
        this.deleteConfigurationRefs(Predef$.MODULE$.int2Integer(releaseUid));
        this.persistenceInterceptors().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.onDelete(id);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void deleteWithUid(String id, int releaseUid) {
        this.deleteReleaseReferences(id, releaseUid);
        this.releasePersistence.deleteById(id);
    }

    @Timed
    public void move(String originalId, String newId) {
        this.releasePersistence.move(originalId, newId);
    }

    @Timed
    public ReleaseStatus getStatus(String id) {
        String status = (String)this.releasePersistence.findReleaseStatus(CiId$.MODULE$.RichCiId(id).normalized()).orNull(Predef$.MODULE$.$conforms());
        return status == null ? null : ReleaseStatus.valueOf((String)status.toUpperCase());
    }

    @Timed
    @IsReadOnly
    public boolean isTemplate(String releaseId) {
        return ReleaseStatus.TEMPLATE.equals(this.getStatus(releaseId));
    }

    @Timed
    @IsReadOnly
    public String getTitle(String id) {
        return (String)this.releasePersistence.findReleaseTitle(CiId$.MODULE$.RichCiId(id).normalized()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Release [%s] not found", new Object[]{id});
        });
    }

    @Timed
    public Release update(Release release) {
        return this.update(null, release);
    }

    @Timed
    public Release update(Release original, Release updated) {
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        if (original != null) {
            Diff$.MODULE$.apply((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(original.getAllTasks()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(updated.getAllTasks()).asScala()).newValues().foreach((Function1 & Serializable & scala.Serializable)task -> {
                this.taskPersistence.insert(task, Predef$.MODULE$.Integer2int(updated.getCiUid()));
                return BoxedUnit.UNIT;
            });
            Buffer originalTriggers = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(original.getReleaseTriggers()).asScala();
            Buffer updatedTriggers = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(updated.getReleaseTriggers()).asScala();
            Diff triggerDiff = Diff$.MODULE$.apply((Iterable)originalTriggers, (Iterable)updatedTriggers);
            triggerDiff.newValues().foreach((Function1 & Serializable & scala.Serializable)trigger -> {
                this.triggerPersistence.insert(trigger);
                return BoxedUnit.UNIT;
            });
            ((IterableLike)triggerDiff.updatedValues().filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$update$3(originalTriggers, t)))).foreach((Function1 & Serializable & scala.Serializable)trigger -> {
                this.triggerPersistence.update(trigger);
                return BoxedUnit.UNIT;
            });
            Diff$.MODULE$.apply((Iterable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(original.getAllGates()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$6.getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom()), (Iterable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(updated.getAllGates()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$7.getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).newValues().foreach((Function1 & Serializable & scala.Serializable)dependency -> {
                this.insertDependency(updated, dependency);
                return BoxedUnit.UNIT;
            });
        }
        this.updateConfigurationRefs(updated);
        return updated;
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.releasePersistence.findAllTags(limitNumber)).asJava();
    }

    private void insertDependency(Release release, Dependency dependency) {
        this.dependencyPersistence.insertDependency(release, dependency);
    }

    /*
     * WARNING - void declaration
     */
    private Release getRelease(String releaseId, String entityId) {
        void var3_3;
        Release release = (Release)this.repositoryAdapter().read(releaseId);
        if (release == null) {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Repository entity [", "] not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityId})), new Object[0]);
        }
        return var3_3;
    }

    private void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        Seq externalIncomingDependencies = (Seq)DependencyRow$.MODULE$.DependencyDataSeqOps(this.dependencyPersistence.findByPartialTargetIds((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{planItemIdOrItsChildren}))), (Option<scala.collection.immutable.Set<String>>)None$.MODULE$)).asDependencies().filterNot((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$checkIsNotReferencedByDependencies$1(planItemIdOrItsChildren, x$8)));
        if (externalIncomingDependencies.nonEmpty()) {
            throw new ItemInUseException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot delete [", "] because it or one of its children is referenced by "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{planItemIdOrItsChildren})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"one or more dependencies: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)externalIncomingDependencies.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.getId(), Seq$.MODULE$.canBuildFrom())).mkString(", ")})), new Object[0]);
        }
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Release> persistenceInterceptor) {
        PersistenceInterceptor<Release> persistenceInterceptor2 = persistenceInterceptor;
        this.persistenceInterceptors_$eq((Seq<PersistenceInterceptor<Release>>)((Seq)this.persistenceInterceptors().$plus$colon(persistenceInterceptor2, Seq$.MODULE$.canBuildFrom())));
    }

    public static final /* synthetic */ boolean $anonfun$update$6(ReleaseTrigger t$1, ReleaseTrigger x$5) {
        return x$5.isEnabled() != t$1.isEnabled();
    }

    public static final /* synthetic */ boolean $anonfun$update$3(Buffer originalTriggers$1, ReleaseTrigger t) {
        return BoxesRunTime.unboxToBoolean((Object)originalTriggers$1.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.equals((Object)t.getId()))).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$update$6(t, x$5))));
    }

    public static final /* synthetic */ boolean $anonfun$checkIsNotReferencedByDependencies$1(String planItemIdOrItsChildren$1, Dependency x$8) {
        return x$8.getId().startsWith(CiId$.MODULE$.RichCiId(planItemIdOrItsChildren$1).normalized());
    }

    public SqlReleaseRepository(ReleasePersistence releasePersistence, TaskPersistence taskPersistence, DependencyPersistence dependencyPersistence, TeamRepository teamRepository, ConfigurationPersistence configurationPersistence, SqlRepositoryAdapter repositoryAdapter, TriggerPersistence triggerPersistence, SqlBuilder.Dialect sqlDialect) {
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.teamRepository = teamRepository;
        this.configurationPersistence = configurationPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.triggerPersistence = triggerPersistence;
        this.sqlDialect = sqlDialect;
        ReleaseRepository.$init$((ReleaseRepository)this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        this.persistenceInterceptors = (Seq)Seq$.MODULE$.empty();
    }
}

