/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.xlrelease.repository.FolderPersistence;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleasesSqlRepository;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.data.FolderData;
import com.xebialabs.xlrelease.security.SecuredCi;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u001b\ti1+\u001d7TK\u000e,(/\u001a3DSNT!a\u0001\u0003\u0002\u0007M\fHN\u0003\u0002\u0006\r\u0005Q!/\u001a9pg&$xN]=\u000b\u0005\u001dA\u0011!\u0003=me\u0016dW-Y:f\u0015\tI!\"A\u0005yK\nL\u0017\r\\1cg*\t1\"A\u0002d_6\u001c\u0001aE\u0002\u0001\u001dY\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/ai\u0011\u0001B\u0005\u00033\u0011\u0011!bU3dkJ,GmQ5t\u0011!Y\u0002A!A!\u0002\u0013a\u0012!\u00054pY\u0012,'\u000fU3sg&\u001cH/\u001a8dKB\u0011q#H\u0005\u0003=\u0011\u0011\u0011CR8mI\u0016\u0014\b+\u001a:tSN$XM\\2f\u0011!\u0001\u0003A!A!\u0002\u0013\t\u0013A\u0005:fY\u0016\f7/Z:SKB|7/\u001b;pef\u0004\"a\u0006\u0012\n\u0005\r\"!!\u0006*fY\u0016\f7/Z:Tc2\u0014V\r]8tSR|'/\u001f\u0005\u0006K\u0001!\tAJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u001dJ#\u0006\u0005\u0002)\u00015\t!\u0001C\u0003\u001cI\u0001\u0007A\u0004C\u0003!I\u0001\u0007\u0011\u0005C\u0003-\u0001\u0011\u0005S&A\u000bhKR,eMZ3di&4XmU3dkJ,GmQ5\u0015\u00059\"\u0004CA\u00183\u001b\u0005\u0001$BA\u0019\u0007\u0003!\u0019XmY;sSRL\u0018BA\u001a1\u0005%\u0019VmY;sK\u0012\u001c\u0015\u000eC\u00036W\u0001\u0007a'A\u0006d_:$\u0018-\u001b8fe&#\u0007CA\u001cA\u001d\tAd\b\u0005\u0002:y5\t!H\u0003\u0002<\u0019\u00051AH]8pizR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\na\u0001\u0015:fI\u00164\u0017BA!C\u0005\u0019\u0019FO]5oO*\u0011q\b\u0010\u0005\u0006\t\u0002!\t%R\u0001\rO\u0016$8+Z2ve\u0016$7)\u001b\u000b\u0003]\u0019CQ!N\"A\u0002YBQ\u0001\u0013\u0001\u0005\n%\u000b1\"Y:TK\u000e,(/\u001a3DSR\u0019aFS&\t\u000bU:\u0005\u0019\u0001\u001c\t\u000b1;\u0005\u0019A'\u0002\u0007ULG\rE\u0002O\u001fFk\u0011\u0001P\u0005\u0003!r\u0012aa\u00149uS>t\u0007CA\bS\u0013\t\u0019\u0006CA\u0004J]R,w-\u001a:\t\u000bU\u0003A\u0011\t,\u0002/M,G/Q:FM\u001a,7\r^5wKN+7-\u001e:fI\u000eKGcA,[7B\u0011a\nW\u0005\u00033r\u0012A!\u00168ji\")Q\u0007\u0016a\u0001m!)A\f\u0016a\u0001;\u0006Y\u0011n]#gM\u0016\u001cG/\u001b<f!\tqe,\u0003\u0002`y\t9!i\\8mK\u0006t\u0007")
public class SqlSecuredCis
implements SecuredCis {
    private final FolderPersistence folderPersistence;
    private final ReleasesSqlRepository releasesRepository;

    public SecuredCi getEffectiveSecuredCi(String containerId) {
        String string = containerId;
        SecuredCi securedCi = Ids.isFolderId((String)string) ? this.folderPersistence.getEffectiveSecuredCi(string) : (Ids.isReleaseId((String)string) ? this.releasesRepository.getEffectiveSecuredCi(string) : this.getSecuredCi(string));
        return securedCi;
    }

    public SecuredCi getSecuredCi(String containerId) {
        SecuredCi securedCi;
        String string = containerId;
        if (Ids.isFolderId((String)string)) {
            securedCi = this.folderPersistence.getSecuredCi(containerId);
        } else if (Ids.isReleaseId((String)string)) {
            securedCi = this.asSecuredCi(string, this.releasesRepository.findUidByReleaseId(string));
        } else {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to get UID for unsupported ID format [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{containerId})));
        }
        return securedCi;
    }

    private SecuredCi asSecuredCi(String containerId, Option<Integer> uid) {
        return new SecuredCi(containerId, ((Integer)uid.getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find release by ID [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{containerId})));
        })).toString());
    }

    public void setAsEffectiveSecuredCi(String containerId, boolean isEffective) {
        if (Ids.isFolderId((String)containerId)) {
            int oldSecurityUid = new StringOps(Predef$.MODULE$.augmentString(this.folderPersistence.getEffectiveSecuredCi(containerId).getSecurityUid())).toInt();
            FolderData newFolderData = isEffective ? this.folderPersistence.setAsEffectiveSecuredCi(containerId) : this.folderPersistence.inheritEffectiveSecuredCi(containerId);
            this.releasesRepository.replaceSecurityUid(newFolderData.uid(), Predef$.MODULE$.int2Integer(oldSecurityUid), newFolderData.securityUid());
        } else if (isEffective) {
            this.releasesRepository.setAsEffectiveSecuredCi(containerId);
        } else {
            SecuredCi effectiveFolder = this.folderPersistence.getEffectiveSecuredCi(Ids.getParentId((String)containerId));
            this.releasesRepository.inheritSecurityFromFolder(containerId, Predef$.MODULE$.int2Integer(new StringOps(Predef$.MODULE$.augmentString(effectiveFolder.getSecurityUid())).toInt()));
        }
    }

    public SqlSecuredCis(FolderPersistence folderPersistence, ReleasesSqlRepository releasesRepository) {
        this.folderPersistence = folderPersistence;
        this.releasesRepository = releasesRepository;
    }
}

