package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.xlrelease.domain.distributed.events.{EvictAllConfigurationCacheEvent, EvictConfigurationCacheEvent}
import com.xebialabs.xlrelease.events.{AsyncSubscribe, EventListener}

@EventListener
class ConfigurationCacheEventHandler(cachingSqlConfigurationRepository: CachingSqlConfigurationRepository) {

  @AsyncSubscribe
  def onEvictConfigurationCacheEvent(event: EvictConfigurationCacheEvent): Unit = {
    cachingSqlConfigurationRepository.invalidate(event.configurationId)
  }

  @AsyncSubscribe
  def onEvictAllConfigurationCacheEvent(event: EvictAllConfigurationCacheEvent): Unit = {
    cachingSqlConfigurationRepository.invalidateAll()
  }
}
