/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.LicenseVersion4;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.exception.LicenseLimitReachedException;
import com.xebialabs.xlrelease.limits.LimitEnforcer;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.sql.ReleasePersistenceInterceptor$;
import com.xebialabs.xlrelease.repository.sql.ReleasePhaseTaskLimitValidator;
import com.xebialabs.xlrelease.repository.sql.ReleaseVariableLimitValidator;
import com.xebialabs.xlrelease.repository.sql.VariableSizeLimitValidator;
import com.xebialabs.xlrelease.repository.sql.WorkflowInterceptorLogic;
import com.xebialabs.xlrelease.repository.sql.WorkflowTaskValidator;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005uh\u0001\u0002\u0011\"\u00011B\u0001b\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\t7\u0002\u0011)\u0019!C\u00019\"A1\r\u0001B\u0001B\u0003%Q\f\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003f\u0011!A\u0007A!A!\u0002\u0013I\u0007\u0002C9\u0001\u0005\u000b\u0007I\u0011\u0001:\t\u0011e\u0004!\u0011!Q\u0001\nMDQA\u001f\u0001\u0005\u0002mDq!!\u0002\u0001\t\u0003\n9\u0001C\u0004\u0002\u001a\u0001!\t%a\u0007\t\u000f\u0005}\u0001\u0001\"\u0003\u0002\"!9\u0011q\b\u0001\u0005\n\u0005\u0005\u0003bBA+\u0001\u0011%\u0011q\u000b\u0005\b\u0003;\u0002A\u0011BA0\u0011\u001d\t9\u0007\u0001C\u0005\u0003SBq!!\u001c\u0001\t\u0013\ty\u0007C\u0004\u0002t\u0001!I!!\u001e\t\u000f\u0005e\u0004\u0001\"\u0003\u0002|!9\u0011q\u0010\u0001\u0005\n\u0005\u0005\u0005bBAC\u0001\u0011%\u0011q\u0011\u0005\b\u0003\u0017\u0003A\u0011BAG\u0011\u001d\t\t\n\u0001C\u0005\u0003'Cq!a&\u0001\t\u0013\tI\nC\u0004\u0002\u001e\u0002!I!a(\b\u000f\u0005-\u0017\u0005#\u0001\u0002N\u001a1\u0001%\tE\u0001\u0003\u001fDaA\u001f\u000e\u0005\u0002\u0005]\u0007\"CAm5\t\u0007I\u0011BAn\u0011!\t\u0019O\u0007Q\u0001\n\u0005u\u0007\"CAs5\t\u0007I\u0011BAt\u0011!\tYP\u0007Q\u0001\n\u0005%(!\b*fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016Le\u000e^3sG\u0016\u0004Ho\u001c:\u000b\u0005\t\u001a\u0013aA:rY*\u0011A%J\u0001\u000be\u0016\u0004xn]5u_JL(B\u0001\u0014(\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002)S\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002U\u0005\u00191m\\7\u0004\u0001MI\u0001!L\u001b@\u0007\u001aKEj\u0014\t\u0003]Mj\u0011a\f\u0006\u0003aE\nA\u0001\\1oO*\t!'\u0001\u0003kCZ\f\u0017B\u0001\u001b0\u0005\u0019y%M[3diB\u0019agN\u001d\u000e\u0003\rJ!\u0001O\u0012\u0003-A+'o]5ti\u0016t7-Z%oi\u0016\u00148-\u001a9u_J\u0004\"AO\u001f\u000e\u0003mR!\u0001P\u0013\u0002\r\u0011|W.Y5o\u0013\tq4HA\u0004SK2,\u0017m]3\u0011\u0005\u0001\u000bU\"A\u0011\n\u0005\t\u000b#A\b*fY\u0016\f7/\u001a)iCN,G+Y:l\u0019&l\u0017\u000e\u001e,bY&$\u0017\r^8s!\t\u0001E)\u0003\u0002FC\ti\"+\u001a7fCN,g+\u0019:jC\ndW\rT5nSR4\u0016\r\\5eCR|'\u000f\u0005\u0002A\u000f&\u0011\u0001*\t\u0002\u001b-\u0006\u0014\u0018.\u00192mKNK'0\u001a'j[&$h+\u00197jI\u0006$xN\u001d\t\u0003\u0001*K!aS\u0011\u0003+]{'o\u001b4m_^$\u0016m]6WC2LG-\u0019;peB\u0011\u0001)T\u0005\u0003\u001d\u0006\u0012\u0001dV8sW\u001adwn^%oi\u0016\u00148-\u001a9u_JdunZ5d!\t\u0001V+D\u0001R\u0015\t\u00116+A\u0003tY\u001a$$NC\u0001U\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001,R\u0005\u001daunZ4j]\u001e\f\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z!\t1\u0014,\u0003\u0002[G\t\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\u0002\u001fQ\f7o\u001b)feNL7\u000f^3oG\u0016,\u0012!\u0018\t\u0003=\u0006l\u0011a\u0018\u0006\u0003A\u0006\n1\u0002]3sg&\u001cH/\u001a8dK&\u0011!m\u0018\u0002\u0010)\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dK\u0006\u0001B/Y:l!\u0016\u00148/[:uK:\u001cW\rI\u0001\u0011M>dG-\u001a:SKB|7/\u001b;pef\u0004\"A\u000e4\n\u0005\u001d\u001c#\u0001\u0005$pY\u0012,'OU3q_NLGo\u001c:z\u00039a\u0017nY3og\u0016\u001cVM\u001d<jG\u0016\u0004\"A[8\u000e\u0003-T!\u0001\\7\u0002\u000fM,'O^5dK*\u0011anJ\u0001\bY&\u001cWM\\:f\u0013\t\u00018N\u0001\bMS\u000e,gn]3TKJ4\u0018nY3\u0002\u001b1LW.\u001b;F]\u001a|'oY3s+\u0005\u0019\bC\u0001;x\u001b\u0005)(B\u0001<&\u0003\u0019a\u0017.\\5ug&\u0011\u00010\u001e\u0002\u000e\u0019&l\u0017\u000e^#oM>\u00148-\u001a:\u0002\u001d1LW.\u001b;F]\u001a|'oY3sA\u00051A(\u001b8jiz\"\u0002\u0002`?\u007f\u007f\u0006\u0005\u00111\u0001\t\u0003\u0001\u0002AQa\u0016\u0005A\u0002aCQa\u0017\u0005A\u0002uCQ\u0001\u001a\u0005A\u0002\u0015DQ\u0001\u001b\u0005A\u0002%DQ!\u001d\u0005A\u0002M\f\u0001b\u001c8De\u0016\fG/\u001a\u000b\u0005\u0003\u0013\t)\u0002\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\t\ty!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\u0014\u00055!\u0001B+oSRDa!a\u0006\n\u0001\u0004I\u0014AA2j\u0003!yg.\u00169eCR,G\u0003BA\u0005\u0003;Aa!a\u0006\u000b\u0001\u0004I\u0014aE3oM>\u00148-\u001a+f]\u0006tG\u000fT5nSR\u001cHCBA\u0005\u0003G\t)\u0003\u0003\u0004\u0002\u0018-\u0001\r!\u000f\u0005\b\u0003OY\u0001\u0019AA\u0015\u0003!!XM\\1oi&#\u0007\u0003BA\u0016\u0003sqA!!\f\u00026A!\u0011qFA\u0007\u001b\t\t\tDC\u0002\u00024-\na\u0001\u0010:p_Rt\u0014\u0002BA\u001c\u0003\u001b\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u001e\u0003{\u0011aa\u0015;sS:<'\u0002BA\u001c\u0003\u001b\t1\u0003^3oC:$H+Z7qY\u0006$XmQ8v]R$b!a\u0011\u0002J\u0005-\u0003c\u0001\u0018\u0002F%\u0019\u0011qI\u0018\u0003\u000f%sG/Z4fe\"9\u0011q\u0005\u0007A\u0002\u0005%\u0002bBA'\u0019\u0001\u0007\u0011qJ\u0001\fe\u0016dW-Y:f\u0017&tG\rE\u0002;\u0003#J1!a\u0015<\u0005-\u0011V\r\\3bg\u0016\\\u0015N\u001c3\u0002%Q,g.\u00198u%\u0016dW-Y:f\u0007>,h\u000e\u001e\u000b\u0007\u0003\u0007\nI&a\u0017\t\u000f\u0005\u001dR\u00021\u0001\u0002*!9\u0011QJ\u0007A\u0002\u0005=\u0013\u0001E8o\u0007J,\u0017\r^3PeV\u0003H-\u0019;f)\u0019\tI!!\u0019\u0002f!1\u00111\r\bA\u0002e\nqA]3mK\u0006\u001cX\rC\u0004\u0002(9\u0001\r!!\u000b\u00027Y\fG.\u001b3bi\u0016$UMZ1vYR$\u0016M]4fi\u001a{G\u000eZ3s)\u0011\tI!a\u001b\t\r\u0005\rt\u00021\u0001:\u0003i1\u0018\r\\5eCR,wk\u001c:lM2|w\u000f\u0015:pa\u0016\u0014H/[3t)\u0011\tI!!\u001d\t\r\u0005\r\u0004\u00031\u0001:\u0003a1\u0018\r\\5eCR,gj\u001c;B%>|GoV8sW\u001adwn\u001e\u000b\u0005\u0003\u0013\t9\b\u0003\u0004\u0002dE\u0001\r!O\u0001\u001fm\u0006d\u0017\u000eZ1uK:{G)Y:iE>\f'\u000f\u001a$pe^{'o\u001b4m_^$B!!\u0003\u0002~!1\u00111\r\nA\u0002e\nAE^1mS\u0012\fG/\u001a(p\u0019>\u001c7\u000eV1tWB\u0013Xm]3oi\u001a{'oV8sW\u001adwn\u001e\u000b\u0005\u0003\u0013\t\u0019\t\u0003\u0004\u0002dM\u0001\r!O\u0001!m\u0006d\u0017\u000eZ1uK:{'+[:l!J|g-\u001b7f\r>\u0014xk\u001c:lM2|w\u000f\u0006\u0003\u0002\n\u0005%\u0005BBA2)\u0001\u0007\u0011(A\u0016wC2LG-\u0019;f\u001d>,fn];qa>\u0014H/\u001a3UCN\\\u0007K]3tK:$hi\u001c:X_J\\g\r\\8x)\u0011\tI!a$\t\r\u0005\rT\u00031\u0001:\u0003)2\u0018\r\\5eCR,gj\\'vYRLG*\u001a<fY:+7\u000f^3e)\u0006\u001c8n\u001d$pe^{'o\u001b4m_^$B!!\u0003\u0002\u0016\"1\u00111\r\fA\u0002e\n!E^1mS\u0012\fG/\u001a+pi\u0006dgj\\(g/>\u00148N\u001a7poR+W\u000e\u001d7bi\u0016\u001cH\u0003BA\u0005\u00037Ca!a\u0019\u0018\u0001\u0004I\u0014!E4fi2K7-\u001a8tK\u0016#\u0017\u000e^5p]R\u0011\u0011\u0011\u0006\u0015\u0004\u0001\u0005\r\u0006\u0003BAS\u0003gk!!a*\u000b\t\u0005%\u00161V\u0001\u000bgR,'/Z8usB,'\u0002BAW\u0003_\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003c\u000b1a\u001c:h\u0013\u0011\t),a*\u0003\u0013\r{W\u000e]8oK:$\bf\u0001\u0001\u0002:B!\u00111XAd\u001b\t\tiL\u0003\u0003\u0002@\u0006\u0005\u0017a\u0003;sC:\u001c\u0018m\u0019;j_:T1AIAb\u0015\r\t)-J\u0001\u0003I\nLA!!3\u0002>\ny\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG.A\u000fSK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0017J\u001c;fe\u000e,\u0007\u000f^8s!\t\u0001%dE\u0002\u001b\u0003#\u0004B!a\u0003\u0002T&!\u0011Q[A\u0007\u0005\u0019\te.\u001f*fMR\u0011\u0011QZ\u0001\"\u001b\u0006CvLT(`/>\u00136J\u0012'P/~#V)\u0014)M\u0003R+5kX!M\u0019>;V\tR\u000b\u0003\u0003;\u0004B!a\u0003\u0002`&!\u0011\u0011]A\u0007\u0005\rIe\u000e^\u0001#\u001b\u0006CvLT(`/>\u00136J\u0012'P/~#V)\u0014)M\u0003R+5kX!M\u0019>;V\t\u0012\u0011\u0002;Us%+R*U%&\u001bE+\u0012#`\u0019&\u001bUIT*F?\u0016#\u0015\nV%P\u001dN+\"!!;\u0011\r\u0005-\u0018Q_A\u0015\u001d\u0011\ti/!=\u000f\t\u0005=\u0012q^\u0005\u0003\u0003\u001fIA!a=\u0002\u000e\u00059\u0001/Y2lC\u001e,\u0017\u0002BA|\u0003s\u00141aU3r\u0015\u0011\t\u00190!\u0004\u0002=Us%+R*U%&\u001bE+\u0012#`\u0019&\u001bUIT*F?\u0016#\u0015\nV%P\u001dN\u0003\u0003")
public class ReleasePersistenceInterceptor
implements PersistenceInterceptor<Release>,
ReleasePhaseTaskLimitValidator,
ReleaseVariableLimitValidator,
VariableSizeLimitValidator,
WorkflowTaskValidator,
WorkflowInterceptorLogic,
Logging {
    private final ReleaseRepository releaseRepository;
    private final TaskPersistence taskPersistence;
    private final FolderRepository folderRepository;
    private final LicenseService licenseService;
    private final LimitEnforcer limitEnforcer;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void updateWorkflowProperties(Release release) {
        WorkflowInterceptorLogic.updateWorkflowProperties$((WorkflowInterceptorLogic)this, release);
    }

    @Override
    public void updateWorkflowProperties(Task task) {
        WorkflowInterceptorLogic.updateWorkflowProperties$((WorkflowInterceptorLogic)this, task);
    }

    @Override
    public void validateNoLockTaskPresent(Task task) {
        WorkflowTaskValidator.validateNoLockTaskPresent$((WorkflowTaskValidator)this, task);
    }

    @Override
    public void validateNoLockTaskPresent(Seq<Task> tasks) {
        WorkflowTaskValidator.validateNoLockTaskPresent$((WorkflowTaskValidator)this, tasks);
    }

    @Override
    public void validateNoUnsupportedTaskPresent(Task task) {
        WorkflowTaskValidator.validateNoUnsupportedTaskPresent$((WorkflowTaskValidator)this, task);
    }

    @Override
    public void validateNoUnsupportedTaskPresent(Seq<Task> tasks) {
        WorkflowTaskValidator.validateNoUnsupportedTaskPresent$((WorkflowTaskValidator)this, tasks);
    }

    @Override
    public void validateNoMultiLevelNestedTasks(Task task) {
        WorkflowTaskValidator.validateNoMultiLevelNestedTasks$((WorkflowTaskValidator)this, task);
    }

    @Override
    public void validateNoMultiLevelNestedTasks(Seq<Task> tasks) {
        WorkflowTaskValidator.validateNoMultiLevelNestedTasks$((WorkflowTaskValidator)this, tasks);
    }

    @Override
    public void enforceVariableSizeLimits(Release ci, String tenantId) {
        VariableSizeLimitValidator.enforceVariableSizeLimits$((VariableSizeLimitValidator)this, ci, tenantId);
    }

    @Override
    public void enforceVariableSizeLimits(Variable ci, String tenantId) {
        VariableSizeLimitValidator.enforceVariableSizeLimits$((VariableSizeLimitValidator)this, ci, tenantId);
    }

    @Override
    public void enforceReleaseVariableLimits(Release ci, String tenantId) {
        ReleaseVariableLimitValidator.enforceReleaseVariableLimits$(this, ci, tenantId);
    }

    @Override
    public String ensureTenantId(Release ci) {
        return ReleasePhaseTaskLimitValidator.ensureTenantId$(this, ci);
    }

    @Override
    public void enforcePhaseAndTaskLimits(Release ci, String tenantId) {
        ReleasePhaseTaskLimitValidator.enforcePhaseAndTaskLimits$(this, ci, tenantId);
    }

    public void onDelete(String ciId) {
        super.onDelete(ciId);
    }

    public void afterCreate(ConfigurationItem ci) {
        super.afterCreate(ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        super.afterUpdate(ci);
    }

    public void afterDelete(String ciId) {
        super.afterDelete(ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleasePersistenceInterceptor releasePersistenceInterceptor = this;
        synchronized (releasePersistenceInterceptor) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    @Override
    public LimitEnforcer limitEnforcer() {
        return this.limitEnforcer;
    }

    public void onCreate(Release ci) {
        String tenantId = this.ensureTenantId(ci);
        this.enforceTenantLimits(ci, tenantId);
        this.onCreateOrUpdate(ci, tenantId);
    }

    public void onUpdate(Release ci) {
        String tenantId = this.ensureTenantId(ci);
        this.onCreateOrUpdate(ci, tenantId);
    }

    private void enforceTenantLimits(Release ci, String tenantId) {
        Tuple3 tuple3;
        Tuple3 tuple32 = tuple3 = ci.isWorkflow() ? new Tuple3((Object)LimitEnforcer.LimitType.WORKFLOW_TEMPLATES, (Object)LimitEnforcer.LimitType.WORKFLOW_EXECUTIONS, (Object)ReleaseKind.WORKFLOW) : new Tuple3((Object)LimitEnforcer.LimitType.TEMPLATES, (Object)LimitEnforcer.LimitType.RELEASES, (Object)ReleaseKind.RELEASE);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        LimitEnforcer.LimitType templateLimitType = (LimitEnforcer.LimitType)tuple3._1();
        LimitEnforcer.LimitType releaseLimitType = (LimitEnforcer.LimitType)tuple3._2();
        ReleaseKind releaseKind = (ReleaseKind)tuple3._3();
        Tuple3 tuple33 = new Tuple3((Object)templateLimitType, (Object)releaseLimitType, (Object)releaseKind);
        LimitEnforcer.LimitType templateLimitType2 = (LimitEnforcer.LimitType)tuple33._1();
        LimitEnforcer.LimitType releaseLimitType2 = (LimitEnforcer.LimitType)tuple33._2();
        ReleaseKind releaseKind2 = (ReleaseKind)tuple33._3();
        ReleaseStatus releaseStatus = ci.getStatus();
        if (ReleaseStatus.TEMPLATE.equals(releaseStatus)) {
            this.limitEnforcer().enforceLimit(tenantId, templateLimitType2, 1, () -> Predef$.MODULE$.Integer2int(this.tenantTemplateCount(tenantId, releaseKind2)));
            return;
        }
        if (ReleaseStatus.PLANNED.equals(releaseStatus) ? true : (ReleaseStatus.IN_PROGRESS.equals(releaseStatus) ? true : (ReleaseStatus.PAUSED.equals(releaseStatus) ? true : (ReleaseStatus.FAILED.equals(releaseStatus) ? true : ReleaseStatus.FAILING.equals(releaseStatus))))) {
            this.limitEnforcer().enforceLimit(tenantId, releaseLimitType2, 1, () -> Predef$.MODULE$.Integer2int(this.tenantReleaseCount(tenantId, releaseKind2)));
            return;
        }
    }

    private Integer tenantTemplateCount(String tenantId, ReleaseKind releaseKind) {
        return this.releaseRepository.tenantTemplateCountByKind(tenantId, releaseKind);
    }

    private Integer tenantReleaseCount(String tenantId, ReleaseKind releaseKind) {
        return this.releaseRepository.tenantReleaseCountByKind(tenantId, releaseKind);
    }

    private void onCreateOrUpdate(Release release, String tenantId) {
        this.enforcePhaseAndTaskLimits(release, tenantId);
        this.enforceReleaseVariableLimits(release, tenantId);
        this.enforceVariableSizeLimits(release, tenantId);
        this.validateTotalNoOfWorkflowTemplates(release);
        this.updateWorkflowProperties(release);
        this.validateDefaultTargetFolder(release);
        this.validateWorkflowProperties(release);
    }

    private void validateDefaultTargetFolder(Release release) {
        boolean defaultTargetFolderIdIsEmpty;
        boolean doesNotAllowTargetFolderOverride = !release.getAllowTargetFolderOverride();
        String defaultTargetFolderId = release.getDefaultTargetFolderId();
        boolean bl = defaultTargetFolderIdIsEmpty = !StringUtils.hasText((String)defaultTargetFolderId);
        if (release.isTemplate() && doesNotAllowTargetFolderOverride && defaultTargetFolderIdIsEmpty) {
            String msg = "Override of the target folder is not allowed, but default target folder is not provided for release with ID [" + release.getId() + "]";
            throw new Checks.IncorrectArgumentException(msg, new Object[0]);
        }
        if (!defaultTargetFolderIdIsEmpty) {
            Option optionalFolder = this.folderRepository.findById(defaultTargetFolderId, 1);
            if (optionalFolder.isEmpty()) {
                throw new Checks.IncorrectArgumentException("Cannot find folder with id [" + defaultTargetFolderId + "]", new Object[0]);
            }
            return;
        }
    }

    private void validateWorkflowProperties(Release release) {
        this.validateNotARootWorkflow(release);
        this.validateNoDashboardForWorkflow(release);
        this.validateNoRiskProfileForWorkflow(release);
        this.validateNoLockTaskPresentForWorkflow(release);
        this.validateNoUnsupportedTaskPresentForWorkflow(release);
        this.validateNoMultiLevelNestedTasksForWorkflow(release);
    }

    private void validateNotARootWorkflow(Release release) {
        String parentFolder = Ids.getParentId((String)release.getId());
        if (release.isWorkflow()) {
            String string = parentFolder;
            String string2 = Ids.ROOT_FOLDER_ID;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new Checks.IncorrectArgumentException("Workflows can be created only inside a folder", new Object[0]);
            }
        }
    }

    private void validateNoDashboardForWorkflow(Release release) {
        if (release.isWorkflow()) {
            boolean hasDashboards = CollectionConverters$.MODULE$.ListHasAsScala(release.getExtensions()).asScala().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReleasePersistenceInterceptor.$anonfun$validateNoDashboardForWorkflow$1(x$2)));
            if (hasDashboards) {
                throw new Checks.IncorrectArgumentException("Dashboards are not supported for workflows", new Object[0]);
            }
            return;
        }
    }

    private void validateNoLockTaskPresentForWorkflow(Release release) {
        if (release.isWorkflow()) {
            this.validateNoLockTaskPresent((Seq<Task>)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().toSeq());
            return;
        }
    }

    private void validateNoRiskProfileForWorkflow(Release release) {
        if (release.isWorkflow() && release.getRiskProfile() != null) {
            throw new Checks.IncorrectArgumentException("Risk profile is not supported for workflows", new Object[0]);
        }
    }

    private void validateNoUnsupportedTaskPresentForWorkflow(Release release) {
        if (release.isWorkflow()) {
            this.validateNoUnsupportedTaskPresent((Seq<Task>)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().toSeq());
            return;
        }
    }

    private void validateNoMultiLevelNestedTasksForWorkflow(Release release) {
        if (release.isWorkflow()) {
            this.validateNoMultiLevelNestedTasks((Seq<Task>)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().toSeq());
            return;
        }
    }

    private void validateTotalNoOfWorkflowTemplates(Release release) {
        if (release.isTemplate() && release.isWorkflow()) {
            String licenseEdition = this.getLicenseEdition();
            if (!ReleasePersistenceInterceptor$.MODULE$.com$xebialabs$xlrelease$repository$sql$ReleasePersistenceInterceptor$$UNRESTRICTED_LICENSE_EDITIONS().contains((Object)licenseEdition)) {
                int totalWorkflowTemplates = this.releaseRepository.countTemplatesByKind(ReleaseKind.WORKFLOW);
                if (totalWorkflowTemplates >= ReleasePersistenceInterceptor$.MODULE$.com$xebialabs$xlrelease$repository$sql$ReleasePersistenceInterceptor$$MAX_NO_WORKFLOW_TEMPLATES_ALLOWED()) {
                    throw new LicenseLimitReachedException("License limit reached. You have exceeded the limit on the number of workflow templates supported with your license.");
                }
                return;
            }
            return;
        }
    }

    private String getLicenseEdition() {
        License license = this.licenseService.getLicense();
        if (license.isDummyLicense()) {
            return LicenseVersion4.Edition4.Unregistered.name();
        }
        return this.licenseService.getLicense().getStringValue(LicenseProperty.EDITION);
    }

    public static final /* synthetic */ boolean $anonfun$validateNoDashboardForWorkflow$1(ReleaseExtension x$2) {
        return x$2 instanceof Dashboard;
    }

    public ReleasePersistenceInterceptor(ReleaseRepository releaseRepository, TaskPersistence taskPersistence, FolderRepository folderRepository, LicenseService licenseService, LimitEnforcer limitEnforcer) {
        this.releaseRepository = releaseRepository;
        this.taskPersistence = taskPersistence;
        this.folderRepository = folderRepository;
        this.licenseService = licenseService;
        this.limitEnforcer = limitEnforcer;
        ReleasePhaseTaskLimitValidator.$init$(this);
        ReleaseVariableLimitValidator.$init$(this);
        VariableSizeLimitValidator.$init$(this);
        WorkflowTaskValidator.$init$(this);
        WorkflowInterceptorLogic.$init$(this);
        Logging.$init$((Logging)this);
        releaseRepository.registerPersistenceInterceptor((PersistenceInterceptor)this);
    }
}

