package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.security.PermissionEditor
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.domain.Team.FOLDER_OWNER_TEAMNAME
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence
import com.xebialabs.xlrelease.security.XLReleasePermissions.GENERATE_FOLDER_CONFIGURATION
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Component

@Component
class XLRelease220GenerateConfigurationPermissionUpgrader @Autowired()(val folderPersistence: FolderPersistence,
                                                                       val permissionEditor: PermissionEditor,
                                                                       @Qualifier("xlrRepositoryJdbcTemplate") val jdbcTemplate: JdbcTemplate,
                                                                       @Qualifier("xlrRepositorySqlDialect") implicit val dialect: Dialect)
  extends BasePermissionUpgrade {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "22.0.0#2")

  override def doUpgrade(): Boolean = grantPermissionToRoleWithName(FOLDER_OWNER_TEAMNAME, GENERATE_FOLDER_CONFIGURATION)

}
