/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.package$;
import com.xebialabs.xlrelease.repository.sql.security.FolderTeamLimitEnforcer;
import com.xebialabs.xlrelease.repository.sql.security.TeamMemberLimitEnforcer;
import com.xebialabs.xlrelease.security.SecuredCi;
import com.xebialabs.xlrelease.security.sql.SqlRoleService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.HashSet;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tMe\u0001\u0002\u0015*\u0001QB\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t+\u0002\u0011\t\u0011)A\u0005\u0013\"Aa\u000b\u0001BC\u0002\u0013\u0005q\u000b\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003Y\u0011!\t\u0007A!b\u0001\n\u0003\u0011\u0007\u0002C5\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u0011)\u0004!Q1A\u0005\u0002-D\u0001b\u001c\u0001\u0003\u0002\u0003\u0006I\u0001\u001c\u0005\u0006a\u0002!\t!\u001d\u0005\bq\u0002\u0011\r\u0011\"\u0003z\u0011\u0019y\b\u0001)A\u0005u\"I\u0011q\u0003\u0001C\u0002\u0013%\u0011\u0011\u0004\u0005\t\u0003C\u0001\u0001\u0015!\u0003\u0002\u001c!I\u0011Q\u0005\u0001C\u0002\u0013%\u0011q\u0005\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u0002*!9\u0011q\u0007\u0001\u0005B\u0005e\u0002bBA>\u0001\u0011\u0005\u0013Q\u0010\u0005\b\u0003\u0007\u0003A\u0011IAC\u0011\u001d\t\u0019\t\u0001C!\u00037C\u0011\"a+\u0001\u0005\u0004%I!!,\t\u0011\u0005=\u0006\u0001)A\u0005\u0003\u0017Bq!!-\u0001\t\u0003\n\u0019\fC\u0005\u0002j\u0002\u0011\r\u0011\"\u0003\u0002.\"A\u00111\u001e\u0001!\u0002\u0013\tY\u0005C\u0005\u0002n\u0002\u0011\r\u0011\"\u0003\u0002.\"A\u0011q\u001e\u0001!\u0002\u0013\tY\u0005C\u0004\u0002r\u0002!\t%a=\t\u000f\u0005}\b\u0001\"\u0011\u0003\u0002!9!q\u0002\u0001\u0005B\tE\u0001b\u0002B\b\u0001\u0011\u0005#q\u0003\u0005\b\u0005;\u0001A\u0011\tB\u0010\u0011\u001d\u0011i\u0002\u0001C\u0005\u0005SAqA!\r\u0001\t\u0013\u0011\u0019\u0004C\u0004\u0003R\u0001!IAa\u0015\t\u000f\te\u0003\u0001\"\u0003\u0003\\!9!\u0011\r\u0001\u0005\n\t\r\u0004b\u0002B?\u0001\u0011%!q\u0010\u0005\b\u0005\u0007\u0003A\u0011\u0002BC\u0011\u001d\u0011Y\t\u0001C\u0005\u0005\u001b\u0013\u0011cU9m)\u0016\fWNU3q_NLGo\u001c:z\u0015\tQ3&A\u0002tc2T!\u0001L\u0017\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002/_\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003aE\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003I\n1aY8n\u0007\u0001\u0019B\u0001A\u001b<\u007fA\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t1\u0011I\\=SK\u001a\u0004\"\u0001P\u001f\u000e\u0003-J!AP\u0016\u0003\u001dQ+\u0017-\u001c*fa>\u001c\u0018\u000e^8ssB\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\u0006g24GG\u001b\u0006\u0002\t\u0006AqM]5{u2,G-\u0003\u0002G\u0003\n9Aj\\4hS:<\u0017\u0001\u00046eE\u000e$V-\u001c9mCR,W#A%\u0011\u0005)\u001bV\"A&\u000b\u00051k\u0015\u0001B2pe\u0016T!AT(\u0002\t)$'m\u0019\u0006\u0003!F\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002%\u0006\u0019qN]4\n\u0005Q[%\u0001\u0004&eE\u000e$V-\u001c9mCR,\u0017!\u00046eE\u000e$V-\u001c9mCR,\u0007%\u0001\tqKJl\u0017n]:j_:,E-\u001b;peV\t\u0001\f\u0005\u0002Z=6\t!L\u0003\u0002\\9\u0006A1/Z2ve&$\u0018P\u0003\u0002^_\u0005AA-\u001a9m_fLG/\u0003\u0002`5\n\u0001\u0002+\u001a:nSN\u001c\u0018n\u001c8FI&$xN]\u0001\u0012a\u0016\u0014X.[:tS>tW\tZ5u_J\u0004\u0013a\u0003:pY\u0016\u001cVM\u001d<jG\u0016,\u0012a\u0019\t\u0003I\u001el\u0011!\u001a\u0006\u0003U\u0019T!aW\u0017\n\u0005!,'AD*rYJ{G.Z*feZL7-Z\u0001\re>dWmU3sm&\u001cW\rI\u0001\u000bg\u0016\u001cWO]3e\u0007&\u001cX#\u00017\u0011\u0005qj\u0017B\u00018,\u0005)\u0019VmY;sK\u0012\u001c\u0015n]\u0001\fg\u0016\u001cWO]3e\u0007&\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0006eR,ho\u001e\t\u0003g\u0002i\u0011!\u000b\u0005\u0006\u000f&\u0001\r!\u0013\u0005\u0006-&\u0001\r\u0001\u0017\u0005\u0006C&\u0001\ra\u0019\u0005\u0006U&\u0001\r\u0001\\\u0001\u0018i\u0016\fW.T3nE\u0016\u0014H*[7ji\u0016sgm\u001c:dKJ,\u0012A\u001f\t\u0003wvl\u0011\u0001 \u0006\u00037&J!A ?\u0003/Q+\u0017-\\'f[\n,'\u000fT5nSR,eNZ8sG\u0016\u0014\u0018\u0001\u0007;fC6lU-\u001c2fe2KW.\u001b;F]\u001a|'oY3sA!\u001a1\"a\u0001\u0011\t\u0005\u0015\u00111C\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u00055\u0011qB\u0001\bM\u0006\u001cGo\u001c:z\u0015\r\t\tbT\u0001\u0006E\u0016\fgn]\u0005\u0005\u0003+\t9AA\u0005BkR|w/\u001b:fI\u00069bm\u001c7eKJ$V-Y7MS6LG/\u00128g_J\u001cWM]\u000b\u0003\u00037\u00012a_A\u000f\u0013\r\ty\u0002 \u0002\u0018\r>dG-\u001a:UK\u0006lG*[7ji\u0016sgm\u001c:dKJ\f\u0001DZ8mI\u0016\u0014H+Z1n\u0019&l\u0017\u000e^#oM>\u00148-\u001a:!Q\ri\u00111A\u0001\u001b]\u0006lW\r\u001a)be\u0006lW\r^3s\u0015\u0012\u00147\rV3na2\fG/Z\u000b\u0003\u0003S\u0001B!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0004\u0003_Y\u0015A\u00038b[\u0016$\u0007/\u0019:b[&!\u00111GA\u0017\u0005iq\u0015-\\3e!\u0006\u0014\u0018-\\3uKJTEMY2UK6\u0004H.\u0019;f\u0003mq\u0017-\\3e!\u0006\u0014\u0018-\\3uKJTEMY2UK6\u0004H.\u0019;fA\u000511M]3bi\u0016$b!a\u000f\u0002H\u0005\u0005\u0004\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\u0007\u0005\u0005S&\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003\u000b\nyD\u0001\u0003UK\u0006l\u0007bBA%!\u0001\u0007\u00111J\u0001\fG>tG/Y5oKJLE\r\u0005\u0003\u0002N\u0005mc\u0002BA(\u0003/\u00022!!\u00158\u001b\t\t\u0019FC\u0002\u0002VM\na\u0001\u0010:p_Rt\u0014bAA-o\u00051\u0001K]3eK\u001aLA!!\u0018\u0002`\t11\u000b\u001e:j]\u001eT1!!\u00178\u0011\u001d\t\u0019\u0007\u0005a\u0001\u0003w\tA\u0001^3b[\"\u001a\u0001#a\u001a\u0011\t\u0005%\u0014qO\u0007\u0003\u0003WRA!!\u0003\u0002n)\u0019A*a\u001c\u000b\t\u0005E\u00141O\u0001\u000b[&\u001c'o\\7fi\u0016\u0014(BAA;\u0003\tIw.\u0003\u0003\u0002z\u0005-$!\u0002+j[\u0016$\u0017AB;qI\u0006$X\r\u0006\u0003\u0002<\u0005}\u0004bBA2#\u0001\u0007\u00111\b\u0015\u0004#\u0005\u001d\u0014\u0001C4fiR+\u0017-\\:\u0015\t\u0005\u001d\u0015q\u0013\t\u0007\u0003\u0013\u000b\u0019*a\u000f\u000e\u0005\u0005-%\u0002BAG\u0003\u001f\u000bA!\u001e;jY*\u0011\u0011\u0011S\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0016\u0006-%\u0001\u0002'jgRDq!!\u0013\u0013\u0001\u0004\tY\u0005K\u0002\u0013\u0003O\"B!a\"\u0002\u001e\"9\u0011qT\nA\u0002\u0005\u0005\u0016AA2j!\u0011\t\u0019+!*\u000e\u0003\u0019L1!a*g\u0005%\u0019VmY;sK\u0012\u001c\u0015\u000eK\u0002\u0014\u0003O\nQd\u0015+N)~;U\tV0U\u000b\u0006ku\fU#S\u001b&\u001b6+S(O?J{ukU\u000b\u0003\u0003\u0017\nad\u0015+N)~;U\tV0U\u000b\u0006ku\fU#S\u001b&\u001b6+S(O?J{uk\u0015\u0011\u0002+\u001d,G\u000fV3b[B+'/\\5tg&|gNU8xgR!\u0011QWAs!\u0019\t9,!1\u0002H:!\u0011\u0011XA_\u001d\u0011\t\t&a/\n\u0003aJ1!a08\u0003\u001d\u0001\u0018mY6bO\u0016LA!a1\u0002F\n\u00191+Z9\u000b\u0007\u0005}v\u0007\u0005\u0003\u0002J\u0006}g\u0002BAf\u00037tA!!4\u0002Z:!\u0011qZAl\u001d\u0011\t\t.!6\u000f\t\u0005E\u00131[\u0005\u0002e%\u0011\u0001'M\u0005\u0003]=J!\u0001L\u0017\n\u0007\u0005u7&\u0001\bUK\u0006l'+\u001a9pg&$xN]=\n\t\u0005\u0005\u00181\u001d\u0002\u0012)\u0016\fW\u000eU3s[&\u001c8/[8o%><(bAAoW!9\u0011q\u001d\fA\u0002\u0005\u0005\u0016!C2p]R\f\u0017N\\3s\u0003!\u001aF+\u0014+`\u000f\u0016#v\f\u0015*J\u001d\u000eK\u0005+\u0011'`)\u0016\u000bUjX'F\u001b\n+%k\u0018,J\u000b^{&kT,T\u0003%\u001aF+\u0014+`\u000f\u0016#v\f\u0015*J\u001d\u000eK\u0005+\u0011'`)\u0016\u000bUjX'F\u001b\n+%k\u0018,J\u000b^{&kT,TA\u0005\u00193\u000bV'U?\u001e+Ek\u0018*P\u0019\u0016{F+R!N?6+UJQ#S?ZKUiV0S\u001f^\u001b\u0016\u0001J*U\u001bR{v)\u0012+`%>cUi\u0018+F\u00036{V*R'C\u000bJ{f+S#X?J{uk\u0015\u0011\u0002#\u001d,G/T3nE\u0016\u00148\u000fU3s)\u0016\fW\u000e\u0006\u0003\u0002v\u0006u\bCBA\\\u0003\u0003\f9\u0010\u0005\u0003\u0002J\u0006e\u0018\u0002BA~\u0003G\u0014Q\u0002V3b[6+WNY3s%><\bbBAt7\u0001\u0007\u0011\u0011U\u0001\u0007I\u0016dW\r^3\u0015\t\t\r!\u0011\u0002\t\u0004m\t\u0015\u0011b\u0001B\u0004o\t!QK\\5u\u0011\u001d\u0011Y\u0001\ba\u0001\u0003\u0017\na\u0001^3b[&#\u0007f\u0001\u000f\u0002h\u00059B-\u001a7fi\u0016$V-Y7t\rJ|W\u000e\u00157bi\u001a|'/\u001c\u000b\u0005\u0005\u0007\u0011\u0019\u0002C\u0004\u0002Ju\u0001\r!a\u0013)\u0007u\t9\u0007\u0006\u0003\u0003\u0004\te\u0001bBAt=\u0001\u0007\u0011\u0011\u0015\u0015\u0004=\u0005\u001d\u0014aE:bm\u0016$V-Y7t)>\u0004F.\u0019;g_JlGCBAD\u0005C\u0011\u0019\u0003C\u0004\u0002J}\u0001\r!a\u0013\t\u000f\t\u0015r\u00041\u0001\u0002\b\u0006)A/Z1ng\"\u001aq$a\u001a\u0015\r\t-\"Q\u0006B\u0018!\u0019\t9,!1\u0002<!9\u0011\u0011\n\u0011A\u0002\u0005-\u0003b\u0002B\u0013A\u0001\u0007!1F\u0001\u0012kB$\u0017\r^3QKJl\u0017n]:j_:\u001cHC\u0002B\u0002\u0005k\u0011I\u0004C\u0004\u00038\u0005\u0002\r!a\u0013\u0002\u0017M,7-\u001e:jif,\u0016\u000e\u001a\u0005\b\u0005w\t\u0003\u0019\u0001B\u001f\u0003Q\u0011x\u000e\\3t/&$\b\u000eU3s[&\u001c8/[8ogB)aGa\u0010\u0003D%\u0019!\u0011I\u001c\u0003\u0015q\u0012X\r]3bi\u0016$g\bE\u00047\u0005\u000b\u0012IEa\u0014\n\u0007\t\u001dsG\u0001\u0004UkBdWM\r\t\u00043\n-\u0013b\u0001B'5\n!!k\u001c7f!\u0019\tI)a%\u0002L\u0005)R\u000f\u001d3bi\u0016Le\u000e[3sSR\fgnY3GY\u0006<GC\u0002B\u0002\u0005+\u00129\u0006C\u0004\u0002J\t\u0002\r!a\u0013\t\u000f\t\u0015\"\u00051\u0001\u0003,\u0005\u0011\"/Z7pm\u0016l\u0015n]:j]\u001e\u0014v\u000e\\3t)\u0011\u0011\u0019A!\u0018\t\u000f\t\u00152\u00051\u0001\u0003`A)aGa\u0010\u0002<\u0005\u0001bM]8n!2\fGOZ8s[J{G.\u001a\u000b\t\u0003w\u0011)Ga\u001a\u0003l!9\u0011\u0011\n\u0013A\u0002\u0005-\u0003b\u0002B5I\u0001\u0007!\u0011J\u0001\u0005e>dW\rC\u0004\u0003n\u0011\u0002\rAa\u001c\u0002\u0017A,'/\\5tg&|gn\u001d\t\u0007\u0003o\u000b\tM!\u001d\u0011\t\tM$\u0011P\u0007\u0003\u0005kR1Aa\u001e[\u0003)\u0001XM]7jgNLwN\\\u0005\u0005\u0005w\u0012)H\u0001\u0006QKJl\u0017n]:j_:\fa\u0002^8QY\u0006$hm\u001c:n%>dW\r\u0006\u0003\u0003J\t\u0005\u0005bBA2K\u0001\u0007\u00111H\u0001\ri>\u0004F.\u0019;g_Jl\u0017\n\u001a\u000b\u0005\u0003\u0017\u00129\tC\u0004\u0003\n\u001a\u0002\r!a\u0013\u0002\u0005%$\u0017A\u00044s_6\u0004F.\u0019;g_Jl\u0017\n\u001a\u000b\u0007\u0003\u0017\u0012yI!%\t\u000f\u0005%s\u00051\u0001\u0002L!9!\u0011R\u0014A\u0002\u0005-\u0003")
public class SqlTeamRepository
implements TeamRepository,
Logging {
    private final JdbcTemplate jdbcTemplate;
    private final PermissionEditor permissionEditor;
    private final SqlRoleService roleService;
    private final SecuredCis securedCis;
    @Autowired
    private final TeamMemberLimitEnforcer teamMemberLimitEnforcer;
    @Autowired
    private final FolderTeamLimitEnforcer folderTeamLimitEnforcer;
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private final String STMT_GET_TEAM_PERMISSION_ROWS;
    private final String STMT_GET_PRINCIPAL_TEAM_MEMBER_VIEW_ROWS;
    private final String STMT_GET_ROLE_TEAM_MEMBER_VIEW_ROWS;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTeamRepository sqlTeamRepository = this;
        synchronized (sqlTeamRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public PermissionEditor permissionEditor() {
        return this.permissionEditor;
    }

    public SqlRoleService roleService() {
        return this.roleService;
    }

    public SecuredCis securedCis() {
        return this.securedCis;
    }

    private TeamMemberLimitEnforcer teamMemberLimitEnforcer() {
        return this.teamMemberLimitEnforcer;
    }

    private FolderTeamLimitEnforcer folderTeamLimitEnforcer() {
        return this.folderTeamLimitEnforcer;
    }

    private NamedParameterJdbcTemplate namedParameterJdbcTemplate() {
        return this.namedParameterJdbcTemplate;
    }

    @Timed
    public Team create(String containerId, Team team) {
        this.removeMissingRoles((scala.collection.immutable.Seq<Team>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Team[]{team}));
        this.folderTeamLimitEnforcer().enforceLimitForTeamCreation(containerId, team.getTeamName());
        Role role = this.toPlatformRole(team);
        String securityUid = this.securedCis().getSecuredCi(containerId).getSecurityUid();
        this.roleService().create(securityUid, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Role[]{role}));
        this.updatePermissions(securityUid, (scala.collection.immutable.Seq<Tuple2<Role, java.util.List<String>>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)role), (Object)team.getPermissions())}));
        this.updateInheritanceFlag(containerId, (scala.collection.immutable.Seq<Team>)new .colon.colon((Object)team, (List)Nil$.MODULE$));
        return team;
    }

    @Timed
    public Team update(Team team) {
        String containerId = Ids.getParentId((String)team.getId());
        this.removeMissingRoles((scala.collection.immutable.Seq<Team>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Team[]{team}));
        Role role = this.toPlatformRole(team);
        String securityUid = this.securedCis().getSecuredCi(containerId).getSecurityUid();
        this.roleService().update(securityUid, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Role[]{role}));
        this.updatePermissions(securityUid, (scala.collection.immutable.Seq<Tuple2<Role, java.util.List<String>>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)role), (Object)team.getPermissions())}));
        return team;
    }

    @Timed
    public java.util.List<Team> getTeams(String containerId) {
        return this.getTeams(this.securedCis().getSecuredCi(containerId));
    }

    @Timed
    public java.util.List<Team> getTeams(SecuredCi ci) {
        scala.collection.immutable.Seq seq;
        List roles = CollectionConverters$.MODULE$.ListHasAsScala(this.roleService().readRoleAssignments(ci.getSecurityUid())).asScala().toList();
        List list = roles;
        if (Nil$.MODULE$.equals(list)) {
            seq = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty();
        } else {
            java.util.Map permissionsByRole = this.permissionEditor().readPermissions(ci.getSecurityUid());
            seq = roles.map((Function1 & Serializable)role -> this.fromPlatformRole(ci.getId(), (Role)role, (scala.collection.immutable.Seq<Permission>)CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)permissionsByRole.getOrDefault(role, new HashSet())).asScala().toSeq()));
        }
        return package$.MODULE$.ListExtensions(seq).asJavaMutable();
    }

    private String STMT_GET_TEAM_PERMISSION_ROWS() {
        return this.STMT_GET_TEAM_PERMISSION_ROWS;
    }

    public scala.collection.immutable.Seq<TeamRepository.TeamPermissionRow> getTeamPermissionRows(SecuredCi container) {
        java.util.Map params = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.FOLDERS$.MODULE$.CI_UID()), (Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(container.getSecurityUid()))))}))).asJava();
        RowMapper mapper = (rs, x$1) -> {
            String teamId = rs.getString("teamId");
            String teamName = rs.getString("teamName");
            String permissionName = rs.getString("permissionName");
            return new TeamRepository.TeamPermissionRow(new TeamRepository.TeamRow(teamId, teamName), permissionName);
        };
        scala.collection.immutable.Seq rows = CollectionConverters$.MODULE$.ListHasAsScala(this.namedParameterJdbcTemplate().query(this.STMT_GET_TEAM_PERMISSION_ROWS(), params, mapper)).asScala().toSeq();
        return rows;
    }

    private String STMT_GET_PRINCIPAL_TEAM_MEMBER_VIEW_ROWS() {
        return this.STMT_GET_PRINCIPAL_TEAM_MEMBER_VIEW_ROWS;
    }

    private String STMT_GET_ROLE_TEAM_MEMBER_VIEW_ROWS() {
        return this.STMT_GET_ROLE_TEAM_MEMBER_VIEW_ROWS;
    }

    public scala.collection.immutable.Seq<TeamRepository.TeamMemberRow> getMembersPerTeam(SecuredCi container) {
        java.util.Map params = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.FOLDERS$.MODULE$.CI_UID()), (Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(container.getSecurityUid()))))}))).asJava();
        RowMapper principalMapper = (rs, x$2) -> {
            String teamId = rs.getString("teamId");
            String teamName = rs.getString("teamName");
            String memberName = rs.getString("memberName");
            String fullName = rs.getString("fullName");
            None$ memberRow = memberName != null ? new Some((Object)new TeamRepository.MemberRow(memberName, fullName, null)) : None$.MODULE$;
            return new TeamRepository.TeamMemberRow(new TeamRepository.TeamRow(teamId, teamName), (Option)memberRow);
        };
        scala.collection.immutable.Seq principalRows = CollectionConverters$.MODULE$.ListHasAsScala(this.namedParameterJdbcTemplate().query(this.STMT_GET_PRINCIPAL_TEAM_MEMBER_VIEW_ROWS(), params, principalMapper)).asScala().toSeq();
        RowMapper roleMapper = (rs, x$3) -> {
            String teamId = rs.getString("teamId");
            String teamName = rs.getString("teamName");
            String memberName = rs.getString("memberName");
            String roleId = rs.getString("roleId");
            None$ memberRow = roleId != null && memberName != null ? new Some((Object)new TeamRepository.MemberRow(memberName, null, roleId)) : None$.MODULE$;
            return new TeamRepository.TeamMemberRow(new TeamRepository.TeamRow(teamId, teamName), (Option)memberRow);
        };
        scala.collection.immutable.Seq roleRows = CollectionConverters$.MODULE$.ListHasAsScala(this.namedParameterJdbcTemplate().query(this.STMT_GET_ROLE_TEAM_MEMBER_VIEW_ROWS(), params, roleMapper)).asScala().toSeq();
        return (scala.collection.immutable.Seq)principalRows.$plus$plus((IterableOnce)roleRows);
    }

    @Timed
    public void delete(String teamId) {
        String containerId = Ids.getParentId((String)teamId);
        String securityUid = this.securedCis().getSecuredCi(containerId).getSecurityUid();
        this.roleService().deleteRoles(securityUid, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.toPlatformId(teamId)}));
        this.updateInheritanceFlag(containerId, (scala.collection.immutable.Seq<Team>)CollectionConverters$.MODULE$.ListHasAsScala(this.getTeams(containerId)).asScala().toSeq());
    }

    @Timed
    public void deleteTeamsFromPlatform(String containerId) {
        this.deleteTeamsFromPlatform(this.securedCis().getSecuredCi(containerId));
    }

    @Timed
    public void deleteTeamsFromPlatform(SecuredCi container) {
        scala.collection.immutable.Seq roles = CollectionConverters$.MODULE$.ListHasAsScala(this.roleService().getRoles(container.getSecurityUid())).asScala().toSeq();
        this.roleService().deleteRoles(container.getSecurityUid(), (scala.collection.immutable.Seq)roles.map((Function1 & Serializable)x$4 -> x$4.getId()));
        if (Ids.isFolderId((String)container.getId())) {
            this.securedCis().setAsEffectiveSecuredCi(container.getId(), false);
            return;
        }
    }

    @Timed
    public java.util.List<Team> saveTeamsToPlatform(String containerId, java.util.List<Team> teams) {
        return package$.MODULE$.ListExtensions(this.saveTeamsToPlatform(containerId, (scala.collection.immutable.Seq<Team>)CollectionConverters$.MODULE$.ListHasAsScala(teams).asScala().toSeq())).asJavaMutable();
    }

    private scala.collection.immutable.Seq<Team> saveTeamsToPlatform(String containerId, scala.collection.immutable.Seq<Team> teams) {
        this.removeMissingRoles(teams);
        this.folderTeamLimitEnforcer().enforceLimitForBulkTeamCreation(containerId, teams);
        this.teamMemberLimitEnforcer().enforceLimitForBulkTeamMemberCreation(containerId, teams);
        String securityUid = this.securedCis().getSecuredCi(containerId).getSecurityUid();
        scala.collection.immutable.Seq roles = (scala.collection.immutable.Seq)teams.map((Function1 & Serializable)team -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.toPlatformRole((Team)team)), (Object)team.getPermissions()));
        this.roleService().writeRoleAssignments(securityUid, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)roles.map((Function1 & Serializable)x$5 -> (Role)x$5._1())).asJava());
        this.updatePermissions(securityUid, (scala.collection.immutable.Seq<Tuple2<Role, java.util.List<String>>>)roles);
        this.updateInheritanceFlag(containerId, teams);
        return teams;
    }

    private void updatePermissions(String securityUid, scala.collection.immutable.Seq<Tuple2<Role, java.util.List<String>>> rolesWithPermissions) {
        java.util.Map permissions = this.permissionEditor().readPermissions(securityUid);
        rolesWithPermissions.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Role role = (Role)tuple2._1();
                java.util.List rolePermissions = (java.util.List)tuple2._2();
                return permissions.put(role, CollectionConverters$.MODULE$.SetHasAsJava((Set)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(rolePermissions).asScala().map((Function1 & Serializable)x$1 -> Permission.find((String)x$1))).toSet()).asJava());
            }
            throw new MatchError((Object)tuple2);
        });
        this.permissionEditor().editPermissions(securityUid, permissions);
    }

    private void updateInheritanceFlag(String containerId, scala.collection.immutable.Seq<Team> teams) {
        this.securedCis().setAsEffectiveSecuredCi(containerId, teams.nonEmpty());
    }

    private void removeMissingRoles(scala.collection.immutable.Seq<Team> teams) {
        LazyRef availableRoles$lzy = new LazyRef();
        teams.foreach((Function1 & Serializable)team -> {
            Buffer nonExistingRoles = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(team.getRoles()).asScala().filter((Function1 & Serializable)roleName -> BoxesRunTime.boxToBoolean((boolean)SqlTeamRepository.$anonfun$removeMissingRoles$2(this, availableRoles$lzy, roleName)));
            if (nonExistingRoles.nonEmpty()) {
                this.logger().warn((Function0 & Serializable)() -> "The following role(s) do not exist: " + nonExistingRoles + ". They were removed from the team " + team.getTeamName() + " [" + team.getId() + "].");
                return BoxesRunTime.boxToBoolean((boolean)team.getRoles().removeAll(CollectionConverters$.MODULE$.BufferHasAsJava(nonExistingRoles).asJava()));
            }
            return BoxedUnit.UNIT;
        });
    }

    private Team fromPlatformRole(String containerId, Role role, scala.collection.immutable.Seq<Permission> permissions) {
        Team team = (Team)Type.valueOf(Team.class).getDescriptor().newInstance(this.fromPlatformId(containerId, role.getId()));
        team.setRoles(role.getRoles());
        team.setMembers(role.getPrincipals());
        team.setTeamName(role.getName());
        scala.collection.immutable.Seq permissionNames = (scala.collection.immutable.Seq)permissions.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Permission, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    return (B1)A12.getPermissionName();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Permission x1) {
                Permission permission = x1;
                return permission != null;
            }
        });
        team.setPermissions(package$.MODULE$.ListExtensions(permissionNames).asJavaMutable());
        return team;
    }

    private Role toPlatformRole(Team team) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)team.getTeamName()), (String)("Team name is missing in team " + team.getId()), (Object[])new Object[0]);
        Role role = new Role(this.toPlatformId(team.getId()), team.getTeamName());
        role.setRoles(team.getRoles());
        role.setPrincipals(team.getMembers());
        return role;
    }

    private String toPlatformId(String id) {
        return Ids.getName((String)id);
    }

    private String fromPlatformId(String containerId, String id) {
        return containerId + "/" + id;
    }

    private final /* synthetic */ Buffer availableRoles$lzycompute$1(LazyRef availableRoles$lzy$1) {
        Buffer buffer;
        LazyRef lazyRef = availableRoles$lzy$1;
        synchronized (lazyRef) {
            buffer = availableRoles$lzy$1.initialized() ? (Buffer)availableRoles$lzy$1.value() : (Buffer)availableRoles$lzy$1.initialize((Object)CollectionConverters$.MODULE$.ListHasAsScala(this.roleService().getRoles()).asScala());
        }
        return buffer;
    }

    private final Buffer availableRoles$1(LazyRef availableRoles$lzy$1) {
        if (availableRoles$lzy$1.initialized()) {
            return (Buffer)availableRoles$lzy$1.value();
        }
        return this.availableRoles$lzycompute$1(availableRoles$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$removeMissingRoles$3(String roleName$1, Role x$6) {
        String string = x$6.getName();
        String string2 = roleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$removeMissingRoles$2(SqlTeamRepository $this, LazyRef availableRoles$lzy$1, String roleName) {
        return !$this.availableRoles$1(availableRoles$lzy$1).exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SqlTeamRepository.$anonfun$removeMissingRoles$3(roleName, x$6)));
    }

    public SqlTeamRepository(JdbcTemplate jdbcTemplate, PermissionEditor permissionEditor, SqlRoleService roleService, SecuredCis securedCis) {
        this.jdbcTemplate = jdbcTemplate;
        this.permissionEditor = permissionEditor;
        this.roleService = roleService;
        this.securedCis = securedCis;
        Logging.$init$((Logging)this);
        this.teamMemberLimitEnforcer = null;
        this.folderTeamLimitEnforcer = null;
        this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate);
        this.STMT_GET_TEAM_PERMISSION_ROWS = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |SELECT\n       |    teams.ID        teamId,\n       |    teams.NAME      teamName,\n       |    team_permissions.PERMISSION_NAME permissionName\n       |FROM\n       |    XL_ROLES teams\n       |    JOIN XL_ROLE_PERMISSIONS team_permissions on teams.ID = team_permissions.ROLE_ID\n       |WHERE teams.CI_ID = :" + Schema.FOLDERS$.MODULE$.CI_UID() + "\n       |ORDER BY teamName, teamId\n       |"));
        this.STMT_GET_PRINCIPAL_TEAM_MEMBER_VIEW_ROWS = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |SELECT teams.ID                              teamId,\n       |       teams.NAME                            teamName,\n       |       team_principal_members.PRINCIPAL_NAME memberName,\n       |       team_principal_profile.FULL_NAME      fullName\n       |FROM XL_ROLES teams\n       |         LEFT JOIN XL_ROLE_PRINCIPALS team_principal_members on teams.ID = team_principal_members.ROLE_ID\n       |         LEFT JOIN XLR_USER_PROFILES team_principal_profile on team_principal_profile.USERNAME = team_principal_members.PRINCIPAL_NAME\n       |WHERE teams.CI_ID = :" + Schema.FOLDERS$.MODULE$.CI_UID() + "\n       |ORDER BY teamName, teamId\n       |"));
        this.STMT_GET_ROLE_TEAM_MEMBER_VIEW_ROWS = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |SELECT teams.ID        teamId,\n       |       teams.NAME      teamName,\n       |       team_roles.NAME memberName,\n       |       team_roles.ID   roleId\n       |FROM XL_ROLES teams\n       |         LEFT JOIN XL_ROLE_ROLES team_role_members on teams.ID = team_role_members.ROLE_ID\n       |         LEFT JOIN XL_ROLES team_roles on team_role_members.MEMBER_ROLE_ID = team_roles.ID\n       |WHERE teams.CI_ID = :" + Schema.FOLDERS$.MODULE$.CI_UID() + "\n       |ORDER BY teamName, teamId\n       |"));
    }
}

