package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.configuration.ThemeSettings
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.BaseInitializingUpgrade
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

/**
 * Creates the ThemeSettings by default
 * If an instance is new it will create it
 * If an instance is being upgraded and never created the settings, it will create
 */
@Component
class XLRelease2410ThemeSettingsUpgrade(configurationRepository: ConfigurationRepository) extends BaseInitializingUpgrade with Logging {

  override def doUpgrade(): Boolean = {
    if (!configurationRepository.exists(ThemeSettings.THEME_SETTINGS_ID)) {
      val themeSettings: ThemeSettings = Type.valueOf(classOf[ThemeSettings]).getDescriptor.newInstance(ThemeSettings.THEME_SETTINGS_ID)
      configurationRepository.create(themeSettings)
    }
    true
  }

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "24.1.0#1")
}
