package com.xebialabs.xlrelease.security.entities;

import jakarta.persistence.*;

@Entity
@Table(name = "XL_ROLE_ROLES")
public class XlRoleRole {
    @EmbeddedId
    private XlRoleRoleId id;

    @MapsId("roleId")
    @ManyToOne(fetch = FetchType.LAZY, optional = false)
    @JoinColumn(name = "ROLE_ID", nullable = false)
    private XlRole role;

    @MapsId("memberRoleId")
    @ManyToOne(fetch = FetchType.LAZY, optional = false)
    @JoinColumn(name = "MEMBER_ROLE_ID", nullable = false)
    private XlRole memberRole;

    public XlRoleRole(XlRole team, XlRole memberRole) {
        this.id = new XlRoleRoleId(team.getId(), memberRole.getId());
        this.role = team;
        this.memberRole = memberRole;
    }

    public XlRoleRole() {
    }

    public XlRoleRoleId getId() {
        return id;
    }

    public void setId(XlRoleRoleId id) {
        this.id = id;
    }

    public XlRole getRole() {
        return role;
    }

    public void setRole(XlRole role) {
        this.role = role;
    }

    public XlRole getMemberRole() {
        return memberRole;
    }

    public void setMemberRole(XlRole memberRole) {
        this.memberRole = memberRole;
    }
}