/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Tenant;
import com.xebialabs.xlrelease.domain.status.TenantStatus;
import com.xebialabs.xlrelease.repository.TenantRepository;
import com.xebialabs.xlrelease.repository.sql.jpa.JpaTenantRepository;
import com.xebialabs.xlrelease.repository.sql.jpa.entities.XlTenant;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import jakarta.persistence.OptimisticLockException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f\u0001\u0002\n\u0014\u0001yA\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t}\u0001\u0011)\u0019!C\u0002\u007f!Aq\u000b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005Y\u0001\t\u0015\r\u0011b\u0001Z\u0011!1\u0007A!A!\u0002\u0013Q\u0006\"B4\u0001\t\u0003A\u0007b\u00028\u0001\u0005\u0004%Ia\u001c\u0005\u0007g\u0002\u0001\u000b\u0011\u00029\t\u000bQ\u0004A\u0011I;\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002$!9\u00111\u0006\u0001\u0005B\u00055\u0002bBA\"\u0001\u0011\u0005\u0013Q\t\u0005\b\u00037\u0002A\u0011IA/\u0011\u001d\tI\u0007\u0001C!\u0003WBq!a\u001c\u0001\t\u0003\n\t\bC\u0004\u0002\u0000\u0001!\t%!!\t\u000f\u0005%\u0005\u0001\"\u0003\u0002\f\n\u00192+\u001d7UK:\fg\u000e\u001e*fa>\u001c\u0018\u000e^8ss*\u0011A#F\u0001\u0004gFd'B\u0001\f\u0018\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u00031e\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005iY\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005a\u0012aA2p[\u000e\u00011#\u0002\u0001 K%z\u0003C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g\r\u0005\u0002'O5\tQ#\u0003\u0002)+\t\u0001B+\u001a8b]R\u0014V\r]8tSR|'/\u001f\t\u0003U5j\u0011a\u000b\u0006\u0003YM\t1\u0002]3sg&\u001cH/\u001a8dK&\u0011af\u000b\u0002\u0013!\u0016\u00148/[:uK:\u001cWmU;qa>\u0014H\u000f\u0005\u00021k5\t\u0011G\u0003\u00023g\u0005)1\u000f\u001c45U*\tA'\u0001\u0005he&T(\u0010\\3e\u0013\t1\u0014GA\u0004M_\u001e<\u0017N\\4\u0002')\u0004\u0018\rV3oC:$(+\u001a9pg&$xN]=\u0011\u0005ebT\"\u0001\u001e\u000b\u0005m\u001a\u0012a\u00016qC&\u0011QH\u000f\u0002\u0014\u0015B\fG+\u001a8b]R\u0014V\r]8tSR|'/_\u0001\bI&\fG.Z2u+\u0005\u0001\u0005CA!U\u001d\t\u0011\u0015K\u0004\u0002D\u001f:\u0011A)\u0014\b\u0003\u000b2s!AR&\u000f\u0005\u001dSU\"\u0001%\u000b\u0005%k\u0012A\u0002\u001fs_>$h(C\u0001\u001d\u0013\tQ2$\u0003\u0002\u00193%\u0011ajF\u0001\u0003I\nL!\u0001\u0006)\u000b\u00059;\u0012B\u0001*T\u0003)\u0019\u0016\u000f\u001c\"vS2$WM\u001d\u0006\u0003)AK!!\u0016,\u0003\u000f\u0011K\u0017\r\\3di*\u0011!kU\u0001\tI&\fG.Z2uA\u0005a!\u000e\u001a2d)\u0016l\u0007\u000f\\1uKV\t!\f\u0005\u0002\\I6\tAL\u0003\u0002^=\u0006!1m\u001c:f\u0015\ty\u0006-\u0001\u0003kI\n\u001c'BA1c\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A2\u0002\u0007=\u0014x-\u0003\u0002f9\na!\n\u001a2d)\u0016l\u0007\u000f\\1uK\u0006i!\u000e\u001a2d)\u0016l\u0007\u000f\\1uK\u0002\na\u0001P5oSRtD\u0003B5lY6\u0004\"A\u001b\u0001\u000e\u0003MAQa\u000e\u0004A\u0002aBQA\u0010\u0004A\u0004\u0001CQ\u0001\u0017\u0004A\u0004i\u000b!BQ!U\u0007\"{6+\u0013.F+\u0005\u0001\bC\u0001\u0011r\u0013\t\u0011\u0018EA\u0002J]R\f1BQ!U\u0007\"{6+\u0013.FA\u0005Aa-\u001b8e\u0005fLE\r\u0006\u0002w\u007fB\u0019\u0001e^=\n\u0005a\f#AB(qi&|g\u000e\u0005\u0002{{6\t1P\u0003\u0002}/\u00051Am\\7bS:L!A`>\u0003\rQ+g.\u00198u\u0011\u001d\t\t!\u0003a\u0001\u0003\u0007\t\u0001\u0002^3oC:$\u0018\n\u001a\t\u0005\u0003\u000b\tiA\u0004\u0003\u0002\b\u0005%\u0001CA$\"\u0013\r\tY!I\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0011\u0011\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005-\u0011\u0005K\u0002\n\u0003+\u0001B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037\u0019\u0016a\u0003;sC:\u001c\u0018m\u0019;j_:LA!a\b\u0002\u001a\tQ\u0011j\u001d*fC\u0012|e\u000e\\=\u0002\u0015\u0019Lg\u000e\u001a\"z\u001d\u0006lW\rF\u0002w\u0003KAq!a\n\u000b\u0001\u0004\t\u0019!\u0001\u0003oC6,\u0007f\u0001\u0006\u0002\u0016\u00059a-\u001b8e\u00032dGCAA\u0018!\u0015\t\t$a\u000fz\u001d\u0011\t\u0019$a\u000e\u000f\u0007\u001d\u000b)$C\u0001#\u0013\r\tI$I\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti$a\u0010\u0003\u0007M+\u0017OC\u0002\u0002:\u0005B3aCA\u000b\u0003\u0019\u0019'/Z1uKR)\u00110a\u0012\u0002L!9\u0011\u0011\n\u0007A\u0002\u0005\r\u0011A\u0003;f]\u0006tGOT1nK\"9\u0011Q\n\u0007A\u0002\u0005=\u0013\u0001\u0004;f]\u0006tGo\u0015;biV\u001c\b\u0003BA)\u0003/j!!a\u0015\u000b\u0007\u0005U30\u0001\u0004ti\u0006$Xo]\u0005\u0005\u00033\n\u0019F\u0001\u0007UK:\fg\u000e^*uCR,8/\u0001\u0004va\u0012\fG/\u001a\u000b\u0005\u0003?\n)\u0007E\u0002!\u0003CJ1!a\u0019\"\u0005\u0011)f.\u001b;\t\r\u0005\u001dT\u00021\u0001z\u0003\u0019!XM\\1oi\u00061A-\u001a7fi\u0016$B!a\u0018\u0002n!9\u0011\u0011\u0001\bA\u0002\u0005\r\u0011a\u00057j].4u\u000e\u001c3feN$v\u000eV3oC:$HCBA0\u0003g\n)\bC\u0004\u0002\u0002=\u0001\r!a\u0001\t\u000f\u0005]t\u00021\u0001\u0002z\u0005Iam\u001c7eKJLEm\u001d\t\u0007\u0003c\tY(a\u0001\n\t\u0005u\u0014q\b\u0002\u0005\u0019&\u001cH/\u0001\rmS:\\Wk]3s!J|g-\u001b7fgR{G+\u001a8b]R$b!a\u0018\u0002\u0004\u0006\u0015\u0005bBA\u0001!\u0001\u0007\u00111\u0001\u0005\b\u0003\u000f\u0003\u0002\u0019AA=\u00039)8/\u001a:Qe>4\u0017\u000e\\3JIN\fqA\u001a:p[J{w\u000fF\u0002z\u0003\u001bCq!a$\u0012\u0001\u0004\t\t*A\u0002s_^\u0004B!a%\u0002\u001a6\u0011\u0011Q\u0013\u0006\u0004\u0003/S\u0014\u0001C3oi&$\u0018.Z:\n\t\u0005m\u0015Q\u0013\u0002\t12$VM\\1oi\"\u001a\u0001!a(\u0011\t\u0005]\u0011\u0011U\u0005\u0005\u0003G\u000bIBA\bJgR\u0013\u0018M\\:bGRLwN\\1m\u0001")
public class SqlTenantRepository
implements TenantRepository,
PersistenceSupport,
Logging {
    private final JpaTenantRepository jpaTenantRepository;
    private final SqlBuilder.Dialect dialect;
    private final JdbcTemplate jdbcTemplate;
    private final int BATCH_SIZE;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public MapSqlParameterSource paramMap2MapSqlParameterSource(Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$(this, params);
    }

    @Override
    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$(this, pkColumn, sqlStatement, params);
    }

    @Override
    public Long sqlInsertTask(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsertTask$(this, pkColumn, sqlStatement, params);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlInsertTask(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Long, R> mapper) {
        return (R)PersistenceSupport.sqlInsertTask$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlInsertTask(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Long, R> mapper) {
        return (R)PersistenceSupport.sqlInsertTask$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$(this, sqlStatement, params);
    }

    @Override
    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$(this, sqlStatement, params, callback);
    }

    @Override
    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$(this, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$(this, pkColumn, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$(this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$(this, sqlStatement, setup, callback);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$(this, entityId);
    }

    @Override
    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$(this, uid, token, freshToken);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$(this, uid);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, extractor);
    }

    @Override
    public Seq<Object> sqlBatch(String sqlStatement, Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$(this, sqlStatement, parameters);
    }

    @Override
    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$(this, sqlStatement, params);
    }

    @Override
    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$(this, pkColumn);
    }

    @Override
    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$(this, pairs);
    }

    @Override
    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, text);
    }

    @Override
    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, inputStream);
    }

    @Override
    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, byteArray);
    }

    @Override
    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, byteArray);
    }

    @Override
    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$(this, body, jdbcTemplate);
    }

    @Override
    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$(this, body);
    }

    @Override
    public <A> Seq<A> findMany(Function0<Buffer<A>> body) {
        return Utils.findMany$(this, body);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTenantRepository sqlTenantRepository = this;
        synchronized (sqlTenantRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        SqlTenantRepository sqlTenantRepository = this;
        synchronized (sqlTenantRepository) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$(this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    @Override
    public NamedParameterJdbcTemplate namedTemplate() {
        if (!this.bitmap$0) {
            return this.namedTemplate$lzycompute();
        }
        return this.namedTemplate;
    }

    @Override
    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    private int BATCH_SIZE() {
        return this.BATCH_SIZE;
    }

    @IsReadOnly
    public Option<Tenant> findById(String tenantId) {
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.jpaTenantRepository.findById(tenantId).map(row -> this.fromRow((XlTenant)row))));
    }

    @IsReadOnly
    public Option<Tenant> findByName(String name) {
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.jpaTenantRepository.findByNameIgnoreCase(name).map(row -> this.fromRow((XlTenant)row))));
    }

    @IsReadOnly
    public Seq<Tenant> findAll() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.jpaTenantRepository.findAll()).asScala().map((Function1 & Serializable)row -> this.fromRow((XlTenant)row))).toSeq();
    }

    public Tenant create(String tenantName, TenantStatus tenantStatus) {
        XlTenant newTenantRow = new XlTenant();
        newTenantRow.setTenantId(UUID.randomUUID().toString());
        newTenantRow.setName(tenantName.toLowerCase().trim());
        newTenantRow.setStatus(tenantStatus.value());
        this.jpaTenantRepository.save(newTenantRow);
        return this.fromRow(newTenantRow);
    }

    public void update(Tenant tenant) {
        Optional maybeTenantRow = this.jpaTenantRepository.findById(tenant.tenantId());
        if (maybeTenantRow.isPresent()) {
            XlTenant existingTenant = (XlTenant)maybeTenantRow.get();
            existingTenant.setName(tenant.tenantName().toLowerCase().trim());
            existingTenant.setStatus(tenant.tenantStatus().value());
            try {
                this.jpaTenantRepository.save(existingTenant);
            }
            catch (OptimisticLockException e) {
                throw new RuntimeException("Failed to update tenant with ID " + tenant.tenantId(), e);
            }
            return;
        }
        throw new IllegalArgumentException("Tenant with ID '" + tenant.tenantId() + "' does not exist");
    }

    public void delete(String tenantId) {
        this.jpaTenantRepository.deleteById(tenantId);
    }

    public void linkFoldersToTenant(String tenantId, List<String> folderIds) {
        if (folderIds.nonEmpty()) {
            String updateFolderSql = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |UPDATE " + Schema.FOLDERS$.MODULE$.TABLE() + "\n           |  SET " + Schema.FOLDERS$.MODULE$.TENANT_ID() + " = :" + Schema.FOLDERS$.MODULE$.TENANT_ID() + "\n           |WHERE " + Schema.FOLDERS$.MODULE$.FOLDER_ID() + " = :" + Schema.FOLDERS$.MODULE$.FOLDER_ID()));
            folderIds.grouped(this.BATCH_SIZE()).foreach((Function1 & Serializable)batch -> {
                Set parameters = batch.map((Function1 & Serializable)folderId -> Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.FOLDERS$.MODULE$.TENANT_ID()), (Object)tenantId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.FOLDERS$.MODULE$.FOLDER_ID()), folderId)}))).toSet();
                return this.sqlBatch(updateFolderSql, (Set<Map<String, Object>>)parameters);
            });
            return;
        }
    }

    public void linkUserProfilesToTenant(String tenantId, List<String> userProfileIds) {
        if (userProfileIds.nonEmpty()) {
            String updateUserProfileSql = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |UPDATE " + Schema.USER_PROFILE$.MODULE$.TABLE() + "\n           |  SET " + Schema.USER_PROFILE$.MODULE$.TENANT_ID() + " = :" + Schema.USER_PROFILE$.MODULE$.TENANT_ID() + "\n           |WHERE " + Schema.USER_PROFILE$.MODULE$.USERNAME() + " = :" + Schema.USER_PROFILE$.MODULE$.USERNAME()));
            userProfileIds.grouped(this.BATCH_SIZE()).foreach((Function1 & Serializable)batch -> {
                Set parameters = batch.map((Function1 & Serializable)userProfileId -> Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.USER_PROFILE$.MODULE$.TENANT_ID()), (Object)tenantId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.USER_PROFILE$.MODULE$.USERNAME()), (Object)userProfileId.toLowerCase())}))).toSet();
                return this.sqlBatch(updateUserProfileSql, (Set<Map<String, Object>>)parameters);
            });
            return;
        }
    }

    private Tenant fromRow(XlTenant row) {
        return new Tenant(row.getTenantId(), row.getName(), TenantStatus.fromString((String)row.getStatus()));
    }

    public SqlTenantRepository(JpaTenantRepository jpaTenantRepository, SqlBuilder.Dialect dialect, JdbcTemplate jdbcTemplate) {
        this.jpaTenantRepository = jpaTenantRepository;
        this.dialect = dialect;
        this.jdbcTemplate = jdbcTemplate;
        Utils.$init$(this);
        CompressionSupport.$init$(this);
        PersistenceSupport.$init$(this);
        Logging.$init$((Logging)this);
        this.BATCH_SIZE = 512;
    }
}

