package com.xebialabs.xlrelease.repository.sql.proxy

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.environments.{Application, Environment, EnvironmentLabel, EnvironmentStage}
import com.xebialabs.xlrelease.domain.{Attachment, Phase, Release}
import com.xebialabs.xlrelease.repository.IdMatchers._
import com.xebialabs.xltype.serialization.CiReference
import grizzled.slf4j.Logging
import org.springframework.dao.EmptyResultDataAccessException

// based on referencedId decide if we have to go via database/type system or we know exact targetClass type
class DefaultCiReferenceTargetTypeResolver(referenceTypeRepository: ReferenceTypeRepository) extends CiReferenceTargetTypeResolver with Logging {

  //noinspection ScalaStyle
  override def typeOf(referencedId: String, ref: CiReference): Option[Type] = {
    try {
      referencedId match {
        case AttachmentId(_) => Some(Type.valueOf(classOf[Attachment]))
        case ReleaseId(_) => Some(Type.valueOf(classOf[Release]))
        case PhaseId(_) => Some(Type.valueOf(classOf[Phase]))
        case TaskId(_) => referenceTypeRepository.findTaskType(referencedId)
        case ConfigurationId(_) => referenceTypeRepository.findConfigurationType(referencedId)
        case VariableId(_) => referenceTypeRepository.findVariableType(referencedId)
        case TriggerId(_) => referenceTypeRepository.findTriggerType(referencedId)
        case EnvironmentStageId(_) => Some(Type.valueOf(classOf[EnvironmentStage]))
        case EnvironmentLabelId(_) => Some(Type.valueOf(classOf[EnvironmentLabel]))
        case EnvironmentId(_) => Some(Type.valueOf(classOf[Environment]))
        case ApplicationId(_) => Some(Type.valueOf(classOf[Application]))
        case _ =>
          // release extensions (dashboards, risk, etc.), facets, release groups, deliveries, everything else should not end up here
          None
      }
    } catch {
      case ex: EmptyResultDataAccessException =>
        logger.error(s"Unable to resolve $referencedId of $ref")
        None
    }
  }
}

