package com.xebialabs.xlrelease.repository.sql.persistence

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.db.sql.SqlBuilder.{CommonDialect, Dialect, MSSQLDialect}
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional
import com.xebialabs.xlrelease.repository.sql.SqlRepository
import com.xebialabs.xlrelease.repository.sql.persistence.Schema.SECURABLES
import com.xebialabs.xlrelease.repository.sql.persistence.Utils.params
import grizzled.slf4j.Logging
import org.springframework.jdbc.core.JdbcTemplate

@IsTransactional
class SecurablePersistence()(implicit val jdbcTemplate: JdbcTemplate,
                             implicit val dialect: Dialect)
  extends SqlRepository with PersistenceSupport with Logging {

  private val STMT_INSERT_SECURABLE: String = dialect match {
    case CommonDialect(dbName) if dbName.contains("mysql") =>
      s"INSERT INTO ${SECURABLES.TABLE} VALUES ()"
    case MSSQLDialect(_) =>
      s"INSERT INTO ${SECURABLES.TABLE} DEFAULT VALUES"
    case _ =>
      s"INSERT INTO ${SECURABLES.TABLE} VALUES (DEFAULT)"
  }

  def insert(): CiUid = {
    try {
      sqlInsert(SECURABLES.CI_UID, STMT_INSERT_SECURABLE, params())
    } catch {
      case e: Throwable => throw new SecurableStoreException(s"Cannot insert new row to SECURABLES table", e)
    }
  }

  private val STMT_DELETE_SECURABLE =
    s"""DELETE FROM ${SECURABLES.TABLE} WHERE ${SECURABLES.CI_UID} = :ciUid""".stripMargin

  def deleteCi(ciUid: CiUid): Unit = {
    sqlUpdate(STMT_DELETE_SECURABLE, params("ciUid" -> ciUid), () => _)
  }
}

object SecurablePersistence {

  implicit class RichCI(val ci: ConfigurationItem) extends AnyVal {
    def getOptProperty[T](propName: String, defaultVal: T): T = {
      if (ci.hasProperty(propName) && ci.getProperty[T](propName) != null) {
        ci.getProperty[T](propName)
      } else {
        defaultVal
      }
    }
  }

}

class SecurableStoreException(msg: String, e: Throwable = null) extends RuntimeException(msg, e)
