package com.xebialabs.xlrelease.repository.sql.persistence.data

import com.xebialabs.xlrelease.utils.FolderId

case class TargetRow(releaseId: Option[String],
                     targetId: Option[String])

object TargetRow {
  def apply(folderPath: String, folderId: String, releaseId: String, targetId: String): TargetRow = new TargetRow(
    releaseId = Option(releaseId).map(id => (FolderId(folderPath) / folderId / id).absolute),
    targetId = Option(targetId).filter(_.nonEmpty)
  )

  def apply(releaseId: String, targetId: String): TargetRow = new TargetRow(Option(releaseId), Option(targetId).filter(_.nonEmpty))

  implicit class TargetRowOps(val row: TargetRow) extends AnyVal {
    def getTargetId: Option[String] =
      row.releaseId
        .map(_ ++ row.targetId.map("/" ++ _).getOrElse(""))
        .orElse(row.targetId)
  }

}
