package com.xebialabs.xlrelease.repository.sql.jpa.entities;

import java.time.Instant;
import jakarta.persistence.*;

@Entity
@Table(name = "CLUSTER_DATACENTERS")
public class ClusterDatacenter {

    @Id
    @Column(name = "DATACENTER", nullable = false, unique = true)
    private String datacenter;

    @Column(name = "TARGET_STATE", nullable = false)
    private String targetState;

    @Column(name = "UPDATED_BY")
    private String updatedBy;

    @Column(name = "UPDATED_DATE", nullable = false)
    private Instant updatedDate;

    @Version
    @Column(name = "VERSION", nullable = false)
    private Integer version;

    @PrePersist
    @PreUpdate
    private void normalizeDatacenter() {
        if (datacenter != null) {
            datacenter = datacenter.toLowerCase();
        }
    }

    public String getDatacenter() {
        return datacenter;
    }

    public void setDatacenter(final String datacenter) {
        this.datacenter = datacenter;
    }

    public String getTargetState() {
        return targetState;
    }

    public void setTargetState(final String targetState) {
        this.targetState = targetState;
    }

    public String getUpdatedBy() {
        return updatedBy;
    }

    public void setUpdatedBy(final String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Instant getUpdatedDate() {
        return updatedDate;
    }

    public void setUpdatedDate(final Instant updatedDate) {
        this.updatedDate = updatedDate;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(final Integer version) {
        this.version = version;
    }
}
