/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow$;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\r5e\u0001\u0002\u00180\u0001iB\u0001\u0002\u0019\u0001\u0003\u0006\u0004%\t!\u0019\u0005\tQ\u0002\u0011\t\u0011)A\u0005E\"A\u0011\u000e\u0001BC\u0002\u0013\u0005!\u000e\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003l\u0011!y\u0007A!b\u0001\n\u0003\u0001\b\u0002\u0003;\u0001\u0005\u0003\u0005\u000b\u0011B9\t\u0011U\u0004!Q1A\u0005\u0002YD\u0001B\u001f\u0001\u0003\u0002\u0003\u0006Ia\u001e\u0005\tw\u0002\u0011)\u0019!C\u0001y\"I\u0011\u0011\u0001\u0001\u0003\u0002\u0003\u0006I! \u0005\u000b\u0003\u0007\u0001!Q1A\u0005\u0002\u0005\u0015\u0001BCA\n\u0001\t\u0005\t\u0015!\u0003\u0002\b!Q\u0011Q\u0003\u0001\u0003\u0006\u0004%\t!a\u0006\t\u0015\u0005}\u0001A!A!\u0002\u0013\tI\u0002\u0003\u0006\u0002\"\u0001\u0011)\u0019!C\u0002\u0003GA!\"a\u0015\u0001\u0005\u0003\u0005\u000b\u0011BA\u0013\u0011\u001d\t)\u0006\u0001C\u0001\u0003/Bq!a\u001b\u0001\t\u0003\ni\u0007C\u0004\u0002l\u0001!\t%a,\t\u000f\u0005E\u0007\u0001\"\u0011\u0002T\"9!q\u0001\u0001\u0005B\t%\u0001b\u0002B\f\u0001\u0011\u0005#\u0011\u0004\u0005\b\u0005C\u0001A\u0011\tB\u0012\u0011\u001d\u0011\u0019\u0005\u0001C!\u0005\u000bBqAa\u0013\u0001\t\u0013\u0011i\u0005C\u0004\u0003R\u0001!\tEa\u0015\t\u000f\t}\u0003\u0001\"\u0011\u0003b!9!q\r\u0001\u0005\n\t%\u0004b\u0002B7\u0001\u0011\u0005#q\u000e\u0005\b\u0005\u007f\u0002A\u0011\tBA\u0011\u001d\u00119\t\u0001C!\u0005\u0013CqAa$\u0001\t\u0013\u0011\t\nC\u0004\u0003\u0018\u0002!\tE!'\t\u000f\t}\u0005\u0001\"\u0011\u0003\"\"9!1\u0018\u0001\u0005B\tu\u0006b\u0002Bi\u0001\u0011\u0005#1\u001b\u0005\b\u0005/\u0004A\u0011\tBm\u0011\u001d\u0011\t\u000f\u0001C!\u0005GDqAa;\u0001\t\u0003\u0012i\u000fC\u0004\u0004\u0002\u0001!\tea\u0001\t\u000f\rm\u0001\u0001\"\u0011\u0004\u0004!91\u0011\u0005\u0001\u0005B\r\r\u0002bBB\u001c\u0001\u0011\u00053\u0011\b\u0005\b\u0007\u0013\u0002A\u0011IB&\u0011\u001d\u0019Y\b\u0001C!\u0007{\u0012\u0011cU9m)\u0006\u001c8NU3q_NLGo\u001c:z\u0015\t\u0001\u0014'A\u0002tc2T!AM\u001a\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u00025k\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003m]\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003a\n1aY8n\u0007\u0001\u0019\u0002\u0002A\u001eB\u000b>\u0013V\u000b\u0017\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\t\u001bU\"A\u0019\n\u0005\u0011\u000b$A\u0004+bg.\u0014V\r]8tSR|'/\u001f\t\u0004\r\u001eKU\"A\u0018\n\u0005!{#!F%oi\u0016\u00148-\u001a9uK\u0012\u0014V\r]8tSR|'/\u001f\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019N\na\u0001Z8nC&t\u0017B\u0001(L\u0005\u0011!\u0016m]6\u0011\u0005\u0019\u0003\u0016BA)0\u0005e\u0011\u0015m]3SK2,\u0017m]3Ji\u0016l'+\u001a9pg&$xN]=\u0011\u0005\u0019\u001b\u0016B\u0001+0\u0005Y!Um]3sS\u0006d\u0017N_1uS>t7+\u001e9q_J$\bC\u0001$W\u0013\t9vF\u0001\u0010D_:4\u0017nZ;sCRLwN\u001c*fM\u0016\u0014XM\\2fgN+\b\u000f]8siB\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\u0006g24GG\u001b\u0006\u0002;\u0006AqM]5{u2,G-\u0003\u0002`5\n9Aj\\4hS:<\u0017A\u0005:fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016,\u0012A\u0019\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K>\n1\u0002]3sg&\u001cH/\u001a8dK&\u0011q\r\u001a\u0002\u0013%\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW-A\nsK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\u000beKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3\u0016\u0003-\u0004\"a\u00197\n\u00055$'!\u0006#fa\u0016tG-\u001a8dsB+'o]5ti\u0016t7-Z\u0001\u0017I\u0016\u0004XM\u001c3f]\u000eL\b+\u001a:tSN$XM\\2fA\u0005yA/Y:l!\u0016\u00148/[:uK:\u001cW-F\u0001r!\t\u0019'/\u0003\u0002tI\nyA+Y:l!\u0016\u00148/[:uK:\u001cW-\u0001\tuCN\\\u0007+\u001a:tSN$XM\\2fA\u0005\t2m\\7nK:$(+\u001a9pg&$xN]=\u0016\u0003]\u0004\"A\u0011=\n\u0005e\f$!E\"p[6,g\u000e\u001e*fa>\u001c\u0018\u000e^8ss\u0006\u00112m\\7nK:$(+\u001a9pg&$xN]=!\u0003E\u0011X\r]8tSR|'/_!eCB$XM]\u000b\u0002{B\u0011aI`\u0005\u0003\u007f>\u0012AcU9m%\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\u0018A\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u0002\n\u0001dY8oM&<WO]1uS>t\u0007+\u001a:tSN$XM\\2f+\t\t9\u0001\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\ti\u0001Z\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\t\u0005E\u00111\u0002\u0002\"\u0007>tg-[4ve\u0006$\u0018n\u001c8SK\u001a,'/\u001a8dKB+'o]5ti\u0016t7-Z\u0001\u001aG>tg-[4ve\u0006$\u0018n\u001c8QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\rgC\u000e,GOU3q_NLGo\u001c:z\t&\u001c\b/\u0019;dQ\u0016\u0014XCAA\r!\r\u0011\u00151D\u0005\u0004\u0003;\t$!\u0007$bG\u0016$(+\u001a9pg&$xN]=ESN\u0004\u0018\r^2iKJ\f!DZ1dKR\u0014V\r]8tSR|'/\u001f#jgB\fGo\u00195fe\u0002\nq\u0001Z5bY\u0016\u001cG/\u0006\u0002\u0002&A!\u0011qEA'\u001d\u0011\tI#a\u0012\u000f\t\u0005-\u00121\t\b\u0005\u0003[\tyD\u0004\u0003\u00020\u0005ub\u0002BA\u0019\u0003wqA!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003oI\u0014A\u0002\u001fs_>$h(C\u00019\u0013\t1t'\u0003\u00025k%\u0019\u0011\u0011I\u001a\u0002\u0005\u0011\u0014\u0017b\u0001\u0019\u0002F)\u0019\u0011\u0011I\u001a\n\t\u0005%\u00131J\u0001\u000b'Fd')^5mI\u0016\u0014(b\u0001\u0019\u0002F%!\u0011qJA)\u0005\u001d!\u0015.\u00197fGRTA!!\u0013\u0002L\u0005AA-[1mK\u000e$\b%\u0001\u0004=S:LGO\u0010\u000b\u0013\u00033\nY&!\u0018\u0002`\u0005\u0005\u00141MA3\u0003O\nI\u0007\u0005\u0002G\u0001!)\u0001-\u0005a\u0001E\")\u0011.\u0005a\u0001W\")q.\u0005a\u0001c\")Q/\u0005a\u0001o\")10\u0005a\u0001{\"9\u00111A\tA\u0002\u0005\u001d\u0001bBA\u000b#\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003C\t\u00029AA\u0013\u0003!1\u0017N\u001c3Cs&#W\u0003BA8\u0003k\"B!!\u001d\u0002\u0002B!\u00111OA;\u0019\u0001!q!a\u001e\u0013\u0005\u0004\tIHA\u0001U#\r\tY(\u0013\t\u0004y\u0005u\u0014bAA@{\t9aj\u001c;iS:<\u0007bBAB%\u0001\u0007\u0011QQ\u0001\u0007i\u0006\u001c8.\u00133\u0011\t\u0005\u001d\u0015q\u0012\b\u0005\u0003\u0013\u000bY\tE\u0002\u00024uJ1!!$>\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011SAJ\u0005\u0019\u0019FO]5oO*\u0019\u0011QR\u001f)\u0007I\t9\n\u0005\u0003\u0002\u001a\u0006-VBAAN\u0015\u0011\ti*a(\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002\"\u0006\r\u0016\u0001B2pe\u0016TA!!*\u0002(\u0006QQ.[2s_6,G/\u001a:\u000b\u0005\u0005%\u0016AA5p\u0013\u0011\ti+a'\u0003\u000bQKW.\u001a3\u0016\t\u0005E\u0016Q\u0017\u000b\u0007\u0003g\u000b9,!/\u0011\t\u0005M\u0014Q\u0017\u0003\b\u0003o\u001a\"\u0019AA=\u0011\u001d\t\u0019i\u0005a\u0001\u0003\u000bCq!a/\u0014\u0001\u0004\ti,\u0001\bsKN|GN^3PaRLwN\\:\u0011\t\u0005}\u00161Z\u0007\u0003\u0003\u0003T1AMAb\u0015\u0011\t)-a2\u0002\t)\u001cxN\u001c\u0006\u0004\u0003\u0013\u001c\u0014!D:fe&\fG.\u001b>bi&|g.\u0003\u0003\u0002N\u0006\u0005'A\u0004*fg>dg/Z(qi&|gn\u001d\u0015\u0004'\u0005]\u0015A\u00054j]\u0012$\u0016m]6t\u0005\u0006\u001c\u0018n\u0019#bi\u0006$B!!6\u0002rB1\u0011q[Aq\u0003Kl!!!7\u000b\t\u0005m\u0017Q\\\u0001\u0005kRLGN\u0003\u0002\u0002`\u0006!!.\u0019<b\u0013\u0011\t\u0019/!7\u0003\t1K7\u000f\u001e\t\u0005\u0003O\fi/\u0004\u0002\u0002j*\u0019\u00111^\u0019\u0002\u000bE,XM]=\n\t\u0005=\u0018\u0011\u001e\u0002\u000e)\u0006\u001c8NQ1tS\u000e$\u0015\r^1\t\u000f\u0005MH\u00031\u0001\u0002v\u00069A/Y:l\u0013\u0012\u001c\bCBAl\u0003C\f)\tK\u0002\u0015\u0003/C3\u0001FA~!\u0011\tiPa\u0001\u000e\u0005\u0005}(\u0002\u0002B\u0001\u0003\u0017\n1\u0002\u001e:b]N\f7\r^5p]&!!QAA\u0000\u0005)I5OU3bI>sG._\u0001\u0007KbL7\u000f^:\u0015\t\t-!\u0011\u0003\t\u0004y\t5\u0011b\u0001B\b{\t9!i\\8mK\u0006t\u0007bBAB+\u0001\u0007\u0011Q\u0011\u0015\u0004+\u0005]\u0005fA\u000b\u0002|\u00061Q\u000f\u001d3bi\u0016$2!\u0013B\u000e\u0011\u0019\u0011iB\u0006a\u0001\u0013\u0006!A/Y:lQ\r1\u0012qS\u0001\fkB$\u0017\r^3UCN\\7\u000f\u0006\u0003\u0003&\t-\u0002c\u0001\u001f\u0003(%\u0019!\u0011F\u001f\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005[9\u0002\u0019\u0001B\u0018\u0003\u0015!\u0018m]6t!\u0011a$\u0011G%\n\u0007\tMRH\u0001\u0006=e\u0016\u0004X-\u0019;fIzB3aFALQ\r9\"\u0011\b\t\u0005\u0005w\u0011y$\u0004\u0002\u0003>)\u0019\u0011QT\u001f\n\t\t\u0005#Q\b\u0002\bm\u0006\u0014\u0018M]4t\u0003Q)\b\u000fZ1uKR\u000b7o\u001b)s_B,'\u000f^5fgR!!Q\u0005B$\u0011\u0019\u0011i\u0002\u0007a\u0001\u0013\"\u001a\u0001$a&\u00029U\u0004H-\u0019;f)\u0006\u001c8\u000e\u0015:pa\u0016\u0014H/[3t\u0013:$XM\u001d8bYR!!Q\u0005B(\u0011\u0019\u0011i\"\u0007a\u0001\u0013\u0006I\"-\u0019;dQV\u0003H-\u0019;f)\u0006\u001c8\u000e\u0015:pa\u0016\u0014H/[3t)\u0011\u0011)C!\u0016\t\u000f\t5\"\u00041\u0001\u0003XA)\u0011q\u0011B-\u0013&!!1LAJ\u0005\r\u0019V\r\u001e\u0015\u00045\u0005]\u0015A\n2bi\u000eDW\u000b\u001d3bi\u0016$\u0016m]6Qe>\u0004XM\u001d;jKN<\u0016\u000e\u001e5JI\u0006sG\rS1tQR!!Q\u0005B2\u0011\u001d\u0011ic\u0007a\u0001\u0005/B3aGAL\u0003]\u0011\u0017\r^2i+B$\u0017\r^3EKB,g\u000eZ3oG&,7\u000f\u0006\u0003\u0003&\t-\u0004b\u0002B\u00179\u0001\u0007!qK\u0001\u001fkB$\u0017\r^3UCN\\\u0017I\u001c3SK2,\u0017m]3GY\u0006<7\u000b^1ukN$R!\u0013B9\u0005gBaA!\b\u001e\u0001\u0004I\u0005b\u0002B;;\u0001\u0007!qO\u0001\be\u0016dW-Y:f!\rQ%\u0011P\u0005\u0004\u0005wZ%a\u0002*fY\u0016\f7/\u001a\u0015\u0004;\u0005]\u0015AC;qI\u0006$X\rV=qKR\u0019\u0011Ja!\t\r\tua\u00041\u0001JQ\rq\u0012qS\u0001\u0007I\u0016dW\r^3\u0015\t\t\u0015\"1\u0012\u0005\u0007\u0005;y\u0002\u0019A%)\u0007}\t9*\u0001\u0006de\u0016\fG/\u001a+bg.$2!\u0013BJ\u0011\u0019\u0011)\n\ta\u0001\u0013\u00069a.Z<UCN\\\u0017AB2sK\u0006$X\rF\u0002J\u00057CaA!&\"\u0001\u0004I\u0005fA\u0011\u0002\u0018\u0006AQn\u001c<f)\u0006\u001c8\u000eF\u0005J\u0005G\u00139Ka+\u00036\"1!Q\u0015\u0012A\u0002%\u000b!\u0002^1tWR{Wj\u001c<f\u0011\u0019\u0011IK\ta\u0001\u0013\u0006IQn\u001c<fIR\u000b7o\u001b\u0005\b\u0005[\u0013\u0003\u0019\u0001BX\u0003Y)\b\u000fZ1uK\u0012|%/[4j]\u000e{g\u000e^1j]\u0016\u0014\bc\u0001&\u00032&\u0019!1W&\u0003\u001bQ\u000b7o[\"p]R\f\u0017N\\3s\u0011\u001d\u00119L\ta\u0001\u0005_\u000ba#\u001e9eCR,G\rV1sO\u0016$8i\u001c8uC&tWM\u001d\u0015\u0004E\u0005]\u0015A\u00064j]\u0012\feMZ3di\u0016$')\u001f\"mC\u000e\\w.\u001e;\u0015\t\u0005U(q\u0018\u0005\b\u0005\u0003\u001c\u0003\u0019\u0001Bb\u0003!\u0011G.Y2l_V$\b\u0003\u0002Bc\u0005\u0017l!Aa2\u000b\u0007\t%7*\u0001\u0005dC2,g\u000eZ1s\u0013\u0011\u0011iMa2\u0003\u0011\tc\u0017mY6pkRD3aIAL\u0003i1\u0017N\u001c3QK:$\u0017N\\4UCN\\7oV5uQ\u001a\u000b7-\u001a;t)\t\t)\u0010K\u0002%\u0003/\u000b\u0001bZ3u)&$H.\u001a\u000b\u0005\u0003\u000b\u0013Y\u000eC\u0004\u0002\u0004\u0016\u0002\r!!\")\u0007\u0015\n9\nK\u0002&\u0003w\fqaZ3u)f\u0004X\r\u0006\u0003\u0002\u0006\n\u0015\bbBABM\u0001\u0007\u0011Q\u0011\u0015\u0004M\u0005]\u0005f\u0001\u0014\u0002|\u0006Qq-\u001a;BY2$\u0016mZ:\u0015\t\t=(1\u001f\t\u0007\u0003/\u0014\t0!\"\n\t\tm\u0013\u0011\u001c\u0005\b\u0005k<\u0003\u0019\u0001B|\u0003-a\u0017.\\5u\u001dVl'-\u001a:\u0011\u0007q\u0012I0C\u0002\u0003|v\u00121!\u00138uQ\r9\u0013q\u0013\u0015\u0004O\u0005m\u0018A\u00054j]\u0012|e/\u001a:ek\u0016$\u0016m]6JIN$\"a!\u0002\u0011\r\r\u001d1\u0011CAC\u001d\u0011\u0019Ia!\u0004\u000f\t\u0005M21B\u0005\u0002}%\u00191qB\u001f\u0002\u000fA\f7m[1hK&!11CB\u000b\u0005\r\u0019V-\u001d\u0006\u0004\u0007\u001fi\u0004f\u0001\u0015\u0002\u0018\"\u001a\u0001&a?\u0002%\u0019Lg\u000e\u001a#vKN{wN\u001c+bg.LEm\u001d\u0015\u0004S\u0005]\u0005fA\u0015\u0002|\u0006Iq-\u001a;Ti\u0006$Xo\u001d\u000b\u0005\u0007K\u0019\t\u0004\u0005\u0003\u0004(\r5RBAB\u0015\u0015\r\u0019YcS\u0001\u0007gR\fG/^:\n\t\r=2\u0011\u0006\u0002\u000b)\u0006\u001c8n\u0015;biV\u001c\bbBABU\u0001\u0007\u0011Q\u0011\u0015\u0004U\u0005]\u0005f\u0001\u0016\u0002|\u0006yq-\u001a;UCN\\7\u000b^1ukN,7\u000f\u0006\u0003\u0004<\r\u0005\u0003\u0003CAl\u0007{\t)i!\n\n\t\r}\u0012\u0011\u001c\u0002\u0004\u001b\u0006\u0004\bbBB\"W\u0001\u0007\u0011QQ\u0001\ne\u0016dW-Y:f\u0013\u0012D3aKALQ\rY\u00131`\u0001(M&tG\rV1tW&#7OQ=UCN\\G+\u001f9f'R\fG/^:B]\u0012\u001cF/\u0019:u\t\u0006$X\r\u0006\u0005\u0004\u0006\r53\u0011NB7\u0011\u001d\u0019y\u0005\fa\u0001\u0007#\n\u0001\u0002^1tWRK\b/\u001a\t\u0005\u0007'\u001a)'\u0004\u0002\u0004V)!1qKB-\u0003\u001d\u0011XM\u001a7fGRTAaa\u0017\u0004^\u0005\u0019\u0011\r]5\u000b\t\r}3\u0011M\u0001\u0007a2,x-\u001b8\u000b\u0007\r\rT'\u0001\u0005eKBdw._5u\u0013\u0011\u00199g!\u0016\u0003\tQK\b/\u001a\u0005\b\u0007Wb\u0003\u0019AB\u0013\u0003)!\u0018m]6Ti\u0006$Xo\u001d\u0005\b\u0007_b\u0003\u0019AB9\u00035\u0019H/\u0019:uK\u0012\u0014UMZ8sKB!\u0011q[B:\u0013\u0011\u0019)(!7\u0003\t\u0011\u000bG/\u001a\u0015\u0004Y\u0005]\u0005f\u0001\u0017\u0002|\u0006!R\u000f\u001d3bi\u0016$\u0016m]6Ti\u0006$Xo\u001d'j]\u0016$bA!\n\u0004\u0000\r\u0005\u0005bBAB[\u0001\u0007\u0011Q\u0011\u0005\b\u0007\u0007k\u0003\u0019AAC\u0003)\u0019H/\u0019;vg2Kg.\u001a\u0015\u0004\u0001\r\u001d\u0005\u0003BA\u007f\u0007\u0013KAaa#\u0002\u0000\ny\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000e")
public class SqlTaskRepository
implements TaskRepository,
InterceptedRepository<Task>,
BaseReleaseItemRepository,
DeserializationSupport,
ConfigurationReferencesSupport,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final TaskPersistence taskPersistence;
    private final CommentRepository commentRepository;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect dialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Task>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(String uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public Release getRelease(String releaseId, String entityId, ResolveOptions resolveOptions) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId, resolveOptions);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(String gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Task> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    public TaskBasicData findTaskBasicData(String taskId) throws NotFoundException {
        return TaskRepository.findTaskBasicData$((TaskRepository)this, (String)taskId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskRepository sqlTaskRepository = this;
        synchronized (sqlTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Task>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Task>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public void updateTasks(Task ... tasks) {
        this.updateTasks((scala.collection.immutable.Seq<Task>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])tasks));
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public CommentRepository commentRepository() {
        return this.commentRepository;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    public FacetRepositoryDispatcher facetRepositoryDispatcher() {
        return this.facetRepositoryDispatcher;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        return this.findById(taskId, ResolveOptions$.MODULE$.WITH_DECORATORS());
    }

    @Timed
    public <T extends Task> T findById(String taskId, ResolveOptions resolveOptions) {
        if (!this.exists(taskId)) {
            throw new NotFoundException("Repository entity [" + taskId + "] not found", new Object[0]);
        }
        Release release = this.getRelease(Ids.releaseIdFrom((String)taskId), taskId, resolveOptions);
        return (T)((Task)Option$.MODULE$.apply((Object)release.getTask(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(taskId)))).fold((Function0 & Serializable)() -> {
            throw new NotFoundException("Repository entity [" + taskId + "] not found in release", new Object[0]);
        }, (Function1 & Serializable)task -> {
            task.getAllTasks().forEach(t -> this.commentRepository().decorate(t));
            return task;
        }));
    }

    @Timed
    @IsReadOnly
    public java.util.List<TaskBasicData> findTasksBasicData(java.util.List<String> taskIds) {
        if (taskIds.isEmpty()) {
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava();
        }
        scala.collection.immutable.Seq<TaskRow> tasksData = this.taskPersistence().findByIds((Iterable<String>)CollectionConverters$.MODULE$.ListHasAsScala(taskIds).asScala());
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(taskIds).asScala().map((Function1 & Serializable)taskId -> new Tuple2(taskId, (Object)tasksData.find((Function1 & Serializable)data -> BoxesRunTime.boxToBoolean((boolean)taskId.endsWith(data.taskId())))))).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String id = (String)tuple2._1();
                Option option = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TaskRow data = (TaskRow)some.value();
                    return new Some((Object)TaskRow$.MODULE$.TaskDataOps(data).asTaskData(id));
                }
            }
            return None$.MODULE$;
        })).asJava();
    }

    @Timed
    @IsReadOnly
    public boolean exists(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> "Checking if exists task [" + taskId + "]");
        return this.taskPersistence().exists(taskId);
    }

    @Timed
    public Task update(Task task) {
        Release release = task.getRelease();
        this.interceptUpdate((ConfigurationItem)task);
        this.releasePersistence().update(release);
        this.updateTaskPropertiesInternal(task);
        this.updateConfigurationRefs((CiWithUid)release);
        this.afterUpdate((ConfigurationItem)task);
        return task;
    }

    @Timed
    public void updateTasks(scala.collection.immutable.Seq<Task> tasks) {
        tasks.groupBy((Function1 & Serializable)x$1 -> x$1.getRelease()).foreach((Function1 & Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTasks$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void updateTaskProperties(Task task) {
        this.interceptUpdate((ConfigurationItem)task);
        this.updateTaskPropertiesInternal(task);
        this.afterUpdate((ConfigurationItem)task);
    }

    private void updateTaskPropertiesInternal(Task task) {
        this.taskPersistence().updateProperties(task);
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTaskPropertiesInternal$1(this, task, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void batchUpdateTaskProperties(scala.collection.immutable.Set<Task> tasks) {
        tasks.foreach((Function1 & Serializable)ci -> {
            this.interceptUpdate((ConfigurationItem)ci);
            return BoxedUnit.UNIT;
        });
        this.taskPersistence().batchUpdateTaskProperties(tasks);
        this.batchUpdateDependencies(tasks);
    }

    @Timed
    public void batchUpdateTaskPropertiesWithIdAndHash(scala.collection.immutable.Set<Task> tasks) {
        tasks.foreach((Function1 & Serializable)ci -> {
            this.interceptUpdate((ConfigurationItem)ci);
            return BoxedUnit.UNIT;
        });
        this.taskPersistence().batchUpdateTaskPropertiesWithIdAndHash(tasks);
        this.batchUpdateDependencies(tasks);
    }

    private void batchUpdateDependencies(scala.collection.immutable.Set<Task> tasks) {
        Tuple2 tuple2 = ((IterableOps)tasks.flatMap((Function1 & Serializable)x$2 -> syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(x$2)))).partition((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isArchived()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Set archivedDeps = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set otherDeps = (scala.collection.immutable.Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)archivedDeps, (Object)otherDeps);
        scala.collection.immutable.Set archivedDeps2 = (scala.collection.immutable.Set)tuple22._1();
        scala.collection.immutable.Set otherDeps2 = (scala.collection.immutable.Set)tuple22._2();
        this.dependencyPersistence().batchDeleteDependencies((scala.collection.immutable.Set<Dependency>)archivedDeps2);
        this.dependencyPersistence().batchUpdateDependencies((scala.collection.immutable.Set<Dependency>)otherDeps2);
        tasks.foreach((Function1 & Serializable)ci -> {
            this.afterUpdate((ConfigurationItem)ci);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Task updateTaskAndReleaseFlagStatus(Task task, Release release) {
        return this.update(task);
    }

    @Timed
    public Task updateType(Task task) {
        Task updated = this.update(task);
        this.taskPersistence().updateType(task);
        return updated;
    }

    @Timed
    public void delete(Task task) {
        String taskId = task.getId();
        this.checkIsNotReferencedByDependencies(taskId);
        this.interceptDelete(taskId);
        this.releasePersistence().update(task.getRelease());
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)dependency -> {
            SqlTaskRepository.$anonfun$delete$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        task.getAllTasks().forEach(t -> {
            this.commentRepository().deleteByTask(t);
            this.taskPersistence().delete((Task)t);
        });
        this.updateConfigurationRefs((CiWithUid)task.getRelease());
        this.afterDelete(taskId);
    }

    private Task createTask(Task newTask2) {
        this.taskPersistence().insert(newTask2, newTask2.getRelease().getCiUid());
        Object object = newTask2 instanceof TaskGroup ? ((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(newTask2.getAllTasks()).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$createTask$1(newTask2, x$5)))).map((Function1 & Serializable)newTask -> this.createTask((Task)newTask)) : BoxedUnit.UNIT;
        return newTask2;
    }

    @Timed
    public Task create(Task newTask) {
        this.interceptCreate((ConfigurationItem)newTask);
        this.releasePersistence().update(newTask.getRelease());
        Task createdTask = this.createTask(newTask);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(createdTask)).foreach((Function1 & Serializable)dependency -> {
            this.insertDependency(dependency);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)createdTask.getRelease());
        this.facetRepositoryDispatcher().liveRepository().createFromTasks(CollectionConverters$.MODULE$.ListHasAsScala(newTask.getAllTasks()).asScala().toSeq(), this.facetRepositoryDispatcher().liveRepository().createFromTasks$default$2());
        this.afterCreate((ConfigurationItem)createdTask);
        return createdTask;
    }

    @Timed
    public Task moveTask(Task taskToMove, Task movedTask, TaskContainer updatedOriginContainer, TaskContainer updatedTargetContainer) {
        this.interceptUpdate((ConfigurationItem)movedTask);
        TaskContainer taskContainer = updatedOriginContainer;
        TaskContainer taskContainer2 = updatedTargetContainer;
        if (taskContainer == null ? taskContainer2 != null : !taskContainer.equals(taskContainer2)) {
            this.checkIsNotReferencedByDependencies(taskToMove.getId());
            CollectionConverters$.MODULE$.ListHasAsScala(taskToMove.getAllTasks()).asScala().foreach((Function1 & Serializable)taskWithOldId -> {
                SqlTaskRepository.$anonfun$moveTask$1(this, taskToMove, movedTask, taskWithOldId);
                return BoxedUnit.UNIT;
            });
        }
        this.releasePersistence().update(movedTask.getRelease());
        return movedTask;
    }

    @Timed
    public java.util.List<String> findAffectedByBlackout(Blackout blackout) {
        Date endDate = BlackoutMetadata$.MODULE$.toStartOfNextMinute(blackout.getEndDate());
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.dialect()).selectReleaseData().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)ReleaseStatus.ACTIVE_STATUSES)).build();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)((IterableOps)((IterableOps)this.releasePersistence().findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable)releaseData -> this.tryDeserializeRelease((ReleaseRow)releaseData))).flatMap((Function1 & Serializable)rel -> CollectionConverters$.MODULE$.ListHasAsScala(rel.getAllTasks()).asScala())).filter((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$findAffectedByBlackout$3(endDate, task)))).map((Function1 & Serializable)x$6 -> x$6.getId())).asJava();
    }

    @Timed
    public java.util.List<String> findPendingTasksWithFacets() {
        Tuple2 sqlWithParams = new TasksSqlBuilder(this.dialect()).selectTaskId().withOneOfTaskStatuses((scala.collection.immutable.Seq<TaskStatus>)new .colon.colon((Object)TaskStatus.PENDING, (List)Nil$.MODULE$)).withAnyFacets().build();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.taskPersistence().findTaskIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSet().toList()).asJava();
    }

    @Timed
    @IsReadOnly
    public String getTitle(String taskId) {
        return (String)this.taskPersistence().getTitle(taskId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Task [%s] not found", new Object[]{taskId});
        });
    }

    @Timed
    @IsReadOnly
    public String getType(String taskId) {
        return (String)this.taskPersistence().getType(taskId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Task [%s] not found", new Object[]{taskId});
        });
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.taskPersistence().findAllTags(limitNumber)).asJava();
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findOverdueTaskIds() {
        return this.taskPersistence().findOverdueTaskIds();
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findDueSoonTaskIds() {
        return this.taskPersistence().findDueSoonTaskIds();
    }

    @Timed
    @IsReadOnly
    public TaskStatus getStatus(String taskId) {
        return (TaskStatus)this.taskPersistence().getStatus(taskId).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("getStatus: could not find task '" + taskId + "'", new Object[0]);
        });
    }

    @Timed
    @IsReadOnly
    public Map<String, TaskStatus> getTaskStatuses(String releaseId) {
        return this.taskPersistence().getTaskStatuses(releaseId);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findTaskIdsByTaskTypeStatusAndStartDate(Type taskType, TaskStatus taskStatus, Date startedBefore) {
        return this.taskPersistence().findTaskIdsByTaskTypeStatusAndStartDate(taskType, taskStatus, startedBefore);
    }

    public void updateTaskStatusLine(String taskId, String statusLine) {
        this.taskPersistence().updateStatusLine(taskId, statusLine);
    }

    public static final /* synthetic */ void $anonfun$updateTasks$2(SqlTaskRepository $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Release release = (Release)tuple2._1();
            scala.collection.immutable.Seq tasks = (scala.collection.immutable.Seq)tuple2._2();
            tasks.foreach((Function1 & Serializable)ci -> {
                $this.interceptUpdate((ConfigurationItem)ci);
                return BoxedUnit.UNIT;
            });
            $this.releasePersistence().update(release);
            tasks.foreach((Function1 & Serializable)task -> {
                $this.updateTaskPropertiesInternal(task);
                return BoxedUnit.UNIT;
            });
            tasks.foreach((Function1 & Serializable)ci -> {
                $this.afterUpdate((ConfigurationItem)ci);
                return BoxedUnit.UNIT;
            });
            $this.updateConfigurationRefs((CiWithUid)release);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$updateTaskPropertiesInternal$1(SqlTaskRepository $this, Task task$1, Dependency x0$1) {
        BoxedUnit boxedUnit;
        Dependency dependency = x0$1;
        if (dependency.isArchived()) {
            $this.dependencyPersistence().deleteDependency(dependency);
            return;
        }
        try {
            $this.dependencyPersistence().updateDependency(dependency);
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (NotFoundException e) {
            $this.logger().error((Function0 & Serializable)() -> "Dependency " + dependency + " not found when updating task " + task$1, (Function0 & Serializable)() -> e);
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlTaskRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    public static final /* synthetic */ boolean $anonfun$createTask$1(Task newTask$1, Task x$5) {
        String string = x$5.getContainer().getId();
        String string2 = newTask$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$moveTask$1(SqlTaskRepository $this, Task taskToMove$1, Task movedTask$1, Task taskWithOldId) {
        String oldId = taskWithOldId.getId();
        String newId = oldId.replace(taskToMove$1.getId(), movedTask$1.getId());
        $this.taskPersistence().move(oldId, newId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findAffectedByBlackout$3(Date endDate$1, Task task) {
        TaskStatus taskStatus = task.getStatus();
        TaskStatus taskStatus2 = TaskStatus.PENDING;
        if (taskStatus == null) {
            if (taskStatus2 != null) {
                return false;
            }
        } else if (!taskStatus.equals(taskStatus2)) return false;
        if (!task.isPostponedDueToBlackout()) return false;
        Date date = task.getScheduledStartDate();
        Date date2 = endDate$1;
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public SqlTaskRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, TaskPersistence taskPersistence, CommentRepository commentRepository, SqlRepositoryAdapter repositoryAdapter, ConfigurationReferencePersistence configurationPersistence, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect dialect) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.taskPersistence = taskPersistence;
        this.commentRepository = commentRepository;
        this.repositoryAdapter = repositoryAdapter;
        this.configurationPersistence = configurationPersistence;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.dialect = dialect;
        TaskRepository.$init$((TaskRepository)this);
        InterceptedRepository.$init$((InterceptedRepository)this);
        BaseReleaseItemRepository.$init$(this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

