/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005\u001de\u0001B\t\u0013\u0001uA\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005m!AQ\b\u0001BC\u0002\u0013\u0005a\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003@\u0011!\u0019\u0005A!b\u0001\n\u0003!\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u000b%\u0003A\u0011\u0001&\t\u000b=\u0003A\u0011\t)\t\u000bE\u0004A\u0011\t:\t\u000bm\u0004A\u0011\t?\t\rm\u0004A\u0011IA\u0001\u0011\u001d\t\u0019\u0003\u0001C!\u0003KAq!a\u000b\u0001\t\u0013\ti\u0003C\u0004\u00024\u0001!\t%!\u000e\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B!I\u0011Q\f\u0001\u0012\u0002\u0013\u0005\u0011q\f\u0002\u0018'FdG)\u001a9f]\u0012,gnY=SKB|7/\u001b;pefT!a\u0005\u000b\u0002\u0007M\fHN\u0003\u0002\u0016-\u0005Q!/\u001a9pg&$xN]=\u000b\u0005]A\u0012!\u0003=me\u0016dW-Y:f\u0015\tI\"$A\u0005yK\nL\u0017\r\\1cg*\t1$A\u0002d_6\u001c\u0001aE\u0003\u0001=\u0011BC\u0006\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VM\u001a\t\u0003K\u0019j\u0011\u0001F\u0005\u0003OQ\u0011A\u0003R3qK:$WM\\2z%\u0016\u0004xn]5u_JL\bCA\u0015+\u001b\u0005\u0011\u0012BA\u0016\u0013\u0005e\u0011\u0015m]3SK2,\u0017m]3Ji\u0016l'+\u001a9pg&$xN]=\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014!B:mMRR'\"A\u0019\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\r\u0018\u0003\u000f1{wmZ5oO\u0006\u0011\"/\u001a7fCN,\u0007+\u001a:tSN$XM\\2f+\u00051\u0004CA\u001c;\u001b\u0005A$BA\u001d\u0013\u0003-\u0001XM]:jgR,gnY3\n\u0005mB$A\u0005*fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016\f1C]3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dK\u0002\nQ\u0003Z3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW-F\u0001@!\t9\u0004)\u0003\u0002Bq\t)B)\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,\u0017A\u00063fa\u0016tG-\u001a8dsB+'o]5ti\u0016t7-\u001a\u0011\u0002#I,\u0007o\\:ji>\u0014\u00180\u00113baR,'/F\u0001F!\tIc)\u0003\u0002H%\t!2+\u001d7SKB|7/\u001b;pef\fE-\u00199uKJ\f!C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3sA\u00051A(\u001b8jiz\"Ba\u0013'N\u001dB\u0011\u0011\u0006\u0001\u0005\u0006i\u001d\u0001\rA\u000e\u0005\u0006{\u001d\u0001\ra\u0010\u0005\u0006\u0007\u001e\u0001\r!R\u0001\tM&tGMQ=JIR\u0011\u0011k\u0016\t\u0003%Vk\u0011a\u0015\u0006\u0003)Z\ta\u0001Z8nC&t\u0017B\u0001,T\u0005)!U\r]3oI\u0016t7-\u001f\u0005\u00061\"\u0001\r!W\u0001\u0003S\u0012\u0004\"AW1\u000f\u0005m{\u0006C\u0001/!\u001b\u0005i&B\u00010\u001d\u0003\u0019a$o\\8u}%\u0011\u0001\rI\u0001\u0007!J,G-\u001a4\n\u0005\t\u001c'AB*ue&twM\u0003\u0002aA!\u0012\u0001\"\u001a\t\u0003M>l\u0011a\u001a\u0006\u0003Q&\f!\"\u00198o_R\fG/[8o\u0015\tQ7.\u0001\u0003d_J,'B\u00017n\u0003)i\u0017n\u0019:p[\u0016$XM\u001d\u0006\u0002]\u0006\u0011\u0011n\\\u0005\u0003a\u001e\u0014Q\u0001V5nK\u0012\faa\u0019:fCR,GcA)tq\")A/\u0003a\u0001k\u00069!/\u001a7fCN,\u0007C\u0001*w\u0013\t98KA\u0004SK2,\u0017m]3\t\u000beL\u0001\u0019A)\u0002\u0015\u0011,\u0007/\u001a8eK:\u001c\u0017\u0010\u000b\u0002\nK\u00061Q\u000f\u001d3bi\u0016$2!U?\u007f\u0011\u0015!(\u00021\u0001v\u0011\u0015I(\u00021\u0001RQ\tQQ\r\u0006\u0004\u0002\u0004\u0005%\u00111\u0002\t\u0004?\u0005\u0015\u0011bAA\u0004A\t!QK\\5u\u0011\u0015!8\u00021\u0001v\u0011\u001d\tia\u0003a\u0001\u0003\u001f\tA\u0002Z3qK:$WM\\2jKN\u0004R!!\u0005\u0002\u001cEsA!a\u0005\u0002\u00189\u0019A,!\u0006\n\u0003\u0005J1!!\u0007!\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\b\u0002 \t\u00191+Z9\u000b\u0007\u0005e\u0001\u0005\u000b\u0002\fK\u00061A-\u001a7fi\u0016$B!a\u0001\u0002(!)\u0011\u0010\u0004a\u0001#\"\u0012A\"Z\u0001\u0012I\u0016dW\r^3Ge>l'+\u001a7fCN,GCBA\u0002\u0003_\t\t\u0004C\u0003u\u001b\u0001\u0007Q\u000fC\u0003z\u001b\u0001\u0007\u0011+A\u0004be\u000eD\u0017N^3\u0015\r\u0005\r\u0011qGA\u001d\u0011\u0015!h\u00021\u0001v\u0011\u001d\tYD\u0004a\u0001\u0003\u001f\tA#\u0019:dQ&4X\r\u001a#fa\u0016tG-\u001a8dS\u0016\u001c\bF\u0001\bf\u0003m1\u0017N\u001c3BY2LenY8nS:<G)\u001a9f]\u0012,gnY5fgRQ\u0011qBA\"\u0003\u0013\ni%a\u0016\t\u000f\u0005\u0015s\u00021\u0001\u0002H\u0005IA/\u0019:hKRLEm\u001d\t\u0006\u0003#\tY\"\u0017\u0005\b\u0003\u0017z\u0001\u0019AA$\u0003!\u0019H/\u0019;vg\u0016\u001c\bbBA(\u001f\u0001\u0007\u0011\u0011K\u0001\u0014e\u00164WM]3oG&twm\u00115jY\u0012\u0014XM\u001c\t\u0004?\u0005M\u0013bAA+A\t9!i\\8mK\u0006t\u0007\"CA-\u001fA\u0005\t\u0019AA)\u0003AIgn\u00197vI\u0016$V-\u001c9mCR,7\u000f\u000b\u0002\u0010K\u0006)c-\u001b8e\u00032d\u0017J\\2p[&tw\rR3qK:$WM\\2jKN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003CRC!!\u0015\u0002d-\u0012\u0011Q\r\t\u0005\u0003O\ny'\u0004\u0002\u0002j)!\u00111NA7\u0003%)hn\u00195fG.,GM\u0003\u0002iA%!\u0011\u0011OA5\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0015\u0004\u0001\u0005U\u0004\u0003BA<\u0003\u0007k!!!\u001f\u000b\t\u0005m\u0014QP\u0001\fiJ\fgn]1di&|gNC\u0002\u0014\u0003\u007fR1!!!\u0017\u0003\t!'-\u0003\u0003\u0002\u0006\u0006e$aD%t)J\fgn]1di&|g.\u00197")
public class SqlDependencyRepository
implements DependencyRepository,
BaseReleaseItemRepository,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public Release getRelease(String releaseId, String entityId, ResolveOptions resolveOptions) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId, resolveOptions);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(String gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlDependencyRepository sqlDependencyRepository = this;
        synchronized (sqlDependencyRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Timed
    public Dependency findById(String id) {
        String releaseId = Ids.releaseIdFrom((String)id);
        Release release = this.getRelease(releaseId, id);
        Option maybeDependency = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllGates()).asScala().flatMap((Function1 & Serializable)x$1 -> CollectionConverters$.MODULE$.ListHasAsScala(x$1.getDependencies()).asScala())).find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$findById$2(id, x$2)));
        return (Dependency)maybeDependency.getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Repository entity [" + id + "] not found", new Object[0]);
        });
    }

    @Timed
    public Dependency create(Release release, Dependency dependency) {
        this.insertDependency(dependency);
        this.releasePersistence().update(release);
        return dependency;
    }

    @Timed
    public Dependency update(Release release, Dependency dependency) {
        if (!dependency.isArchived()) {
            this.dependencyPersistence().updateDependency(dependency);
        } else {
            this.dependencyPersistence().deleteDependency(dependency);
        }
        this.releasePersistence().update(release);
        return dependency;
    }

    @Timed
    public void update(Release release, Seq<Dependency> dependencies) {
        dependencies.foreach((Function1 & Serializable)dependency -> {
            SqlDependencyRepository.$anonfun$update$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        this.releasePersistence().update(release);
    }

    @Timed
    public void delete(Dependency dependency) {
        Release release = dependency.getGateTask().getRelease();
        this.deleteFromRelease(release, dependency);
    }

    private void deleteFromRelease(Release release, Dependency dependency) {
        Option maybeGateTask = CollectionConverters$.MODULE$.ListHasAsScala(release.getAllGates()).asScala().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$deleteFromRelease$1(dependency, x$3)));
        maybeGateTask.map((Function1 & Serializable)gateTask -> {
            gateTask.setDependencies(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(gateTask.getDependencies()).asScala().filterNot((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$deleteFromRelease$3(dependency, x$4)))).asJava());
            this.releasePersistence().update(release);
            this.dependencyPersistence().deleteDependency(dependency);
            return dependency;
        }).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("GateTask " + dependency.getGateTask().getId() + " not found while deleting dependency " + dependency.getId() + ".", new Object[0]);
        });
    }

    @Timed
    public void archive(Release release, Seq<Dependency> archivedDependencies) {
        if (archivedDependencies.nonEmpty()) {
            archivedDependencies.foreach((Function1 & Serializable)dependency -> {
                SqlDependencyRepository.$anonfun$archive$1(this, dependency);
                return BoxedUnit.UNIT;
            });
            this.releasePersistence().update(release);
            return;
        }
    }

    @Timed
    public Seq<Dependency> findAllIncomingDependencies(Seq<String> targetIds, Seq<String> statuses, boolean referencingChildren, boolean includeTemplates) {
        Seq<DependencyRow> dependencies = referencingChildren ? this.dependencyPersistence().findByPartialTargetIds((Set<String>)targetIds.toSet(), (Option<Set<String>>)SqlDependencyRepository.status$1(statuses)) : this.dependencyPersistence().findByTargetIds((Set<String>)targetIds.toSet(), (Option<Set<String>>)SqlDependencyRepository.status$1(statuses));
        return DependencyRow$.MODULE$.DependencyDataSeqOps((Seq<DependencyRow>)((Seq)dependencies.filter((Function1 & Serializable)dep -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$findAllIncomingDependencies$1(includeTemplates, dep))))).asDependencies();
    }

    public boolean findAllIncomingDependencies$default$4() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$findById$2(String id$1, Dependency x$2) {
        String string = x$2.getId();
        String string2 = CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id$1));
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$update$1(SqlDependencyRepository $this, Dependency dependency) {
        if (!dependency.isArchived()) {
            $this.dependencyPersistence().updateDependency(dependency);
            return;
        }
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    public static final /* synthetic */ boolean $anonfun$deleteFromRelease$1(Dependency dependency$1, GateTask x$3) {
        String string = x$3.getId();
        String string2 = CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(dependency$1.getGateTask().getId()));
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$deleteFromRelease$3(Dependency dependency$1, Dependency x$4) {
        String string = x$4.getId();
        String string2 = CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(dependency$1.getId()));
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$archive$1(SqlDependencyRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    private static final Option status$1(Seq statuses$1) {
        if (statuses$1.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)statuses$1.toSet());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findAllIncomingDependencies$1(boolean includeTemplates$1, DependencyRow dep) {
        if (includeTemplates$1) return true;
        String string = dep.gateReleaseStatus();
        String string2 = ReleaseStatus.TEMPLATE.value();
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    public SqlDependencyRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, SqlRepositoryAdapter repositoryAdapter) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.repositoryAdapter = repositoryAdapter;
        BaseReleaseItemRepository.$init$(this);
        Logging.$init$((Logging)this);
    }
}

