/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.AttachmentRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import org.slf4j.Marker;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005ed\u0001B\u0006\r\u0001]A\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006c\u0001!\tA\r\u0005\u0006m\u0001!\te\u000e\u0005\u00061\u0002!\t%\u0017\u0005\u00061\u0002!\t\u0005\u001a\u0005\u0006Q\u0002!\t%\u001b\u0005\u0006c\u0002!\tE\u001d\u0005\u0006c\u0002!\t%\u001f\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011\u001d\ty\u0002\u0001C\u0001\u0003C\u0011qcU9m\u0003R$\u0018m\u00195nK:$(+\u001a9pg&$xN]=\u000b\u00055q\u0011aA:rY*\u0011q\u0002E\u0001\u000be\u0016\u0004xn]5u_JL(BA\t\u0013\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0014)\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002+\u0005\u00191m\\7\u0004\u0001M!\u0001\u0001\u0007\u0010#!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fMB\u0011q\u0004I\u0007\u0002\u001d%\u0011\u0011E\u0004\u0002\u0015\u0003R$\u0018m\u00195nK:$(+\u001a9pg&$xN]=\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013!B:mMRR'\"A\u0014\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\u000b\u0013\u0003\u000f1{wmZ5oO\u0006\u0011\"/\u001a7fCN,\u0007+\u001a:tSN$XM\\2f!\tas&D\u0001.\u0015\tqC\"A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,\u0017B\u0001\u0019.\u0005I\u0011V\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0002\rqJg.\u001b;?)\t\u0019T\u0007\u0005\u00025\u00015\tA\u0002C\u0003+\u0005\u0001\u00071&\u0001\u0005gS:$')_%e)\tAd\b\u0005\u0002:y5\t!H\u0003\u0002<!\u00051Am\\7bS:L!!\u0010\u001e\u0003\u0015\u0005#H/Y2i[\u0016tG\u000fC\u0003@\u0007\u0001\u0007\u0001)\u0001\u0007biR\f7\r[7f]RLE\r\u0005\u0002B\u0011:\u0011!I\u0012\t\u0003\u0007ji\u0011\u0001\u0012\u0006\u0003\u000bZ\ta\u0001\u0010:p_Rt\u0014BA$\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011J\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001dS\u0002FA\u0002M!\tie+D\u0001O\u0015\ty\u0005+\u0001\u0006b]:|G/\u0019;j_:T!!\u0015*\u0002\t\r|'/\u001a\u0006\u0003'R\u000b!\"\\5de>lW\r^3s\u0015\u0005)\u0016AA5p\u0013\t9fJA\u0003US6,G-\u0001\u0004de\u0016\fG/\u001a\u000b\u0005qi{\u0016\rC\u0003\\\t\u0001\u0007A,A\u0004sK2,\u0017m]3\u0011\u0005ej\u0016B\u00010;\u0005\u001d\u0011V\r\\3bg\u0016DQ\u0001\u0019\u0003A\u0002\u0001\u000ba\u0001^1tW&#\u0007\"\u00022\u0005\u0001\u0004A\u0014AC1ui\u0006\u001c\u0007.\\3oi\"\u0012A\u0001\u0014\u000b\u0004q\u00154\u0007\"B.\u0006\u0001\u0004a\u0006\"\u00022\u0006\u0001\u0004A\u0004FA\u0003M\u0003AIgn]3si\u0006#H/Y2i[\u0016tG\u000fF\u0002k[>\u0004\"!G6\n\u00051T\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006]\u001a\u0001\r\u0001Q\u0001\ne\u0016dW-Y:f\u0013\u0012DQA\u0019\u0004A\u0002aB#A\u0002'\u0002\r\u0011,G.\u001a;f)\r\u0019ho\u001e\t\u00033QL!!\u001e\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u00067\u001e\u0001\r\u0001\u0018\u0005\u0006E\u001e\u0001\r\u0001\u000f\u0015\u0003\u000f1#2a\u001d>\u0000\u0011\u0015Y\b\u00021\u0001}\u0003\u0011!\u0018m]6\u0011\u0005ej\u0018B\u0001@;\u0005\u0011!\u0016m]6\t\u000b\tD\u0001\u0019\u0001\u001d)\u0005!a\u0015a\u00032bi\u000eD\u0017J\\:feR$RA[A\u0004\u0003\u0013AQaW\u0005A\u0002qCq!a\u0003\n\u0001\u0004\ti!A\u0006biR\f7\r[7f]R\u001c\b#BA\b\u00033Ad\u0002BA\t\u0003+q1aQA\n\u0013\u0005Y\u0012bAA\f5\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u000e\u0003;\u00111aU3r\u0015\r\t9BG\u0001\u0007S:\u001cXM\u001d;\u0015\u0013)\f\u0019#a\u0013\u0002P\u0005M\u0003bBA\u0013\u0015\u0001\u0007\u0011qE\u0001\u000be\u0016dW-Y:f+&$\u0007\u0003BA\u0015\u0003\u000brA!a\u000b\u0002B9!\u0011QFA\u001f\u001d\u0011\ty#a\u000f\u000f\t\u0005E\u0012\u0011\b\b\u0005\u0003g\t9DD\u0002D\u0003kI\u0011!F\u0005\u0003'QI!!\u0005\n\n\u0005m\u0002\u0012bAA u\u0005\u0011\u0011\u000eZ\u0005\u0005\u0003/\t\u0019EC\u0002\u0002@iJA!a\u0012\u0002J\t)1)[+jI*!\u0011qCA\"\u0011\u0019\tiE\u0003a\u0001\u0001\u0006Q\u0011M\u001d;jM\u0006\u001cG/\u00133\t\r\u0005E#\u00021\u0001A\u00031\t'\u000f^5gC\u000e$h*Y7f\u0011\u001d\t)F\u0003a\u0001\u0003/\nqaY8oi\u0016tG\u000f\u0005\u0003\u0002Z\u0005\u0005TBAA.\u0015\r)\u0016Q\f\u0006\u0003\u0003?\nAA[1wC&!\u00111MA.\u0005-Ie\u000e];u'R\u0014X-Y7)\u0007\u0001\t9\u0007\u0005\u0003\u0002j\u0005UTBAA6\u0015\u0011\ti'a\u001c\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0004\u001b\u0005E$bAA:!\u0005\u0011AMY\u0005\u0005\u0003o\nYGA\bJgR\u0013\u0018M\\:bGRLwN\\1m\u0001")
public class SqlAttachmentRepository
implements AttachmentRepository,
Logging {
    private final ReleasePersistence releasePersistence;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlAttachmentRepository sqlAttachmentRepository = this;
        synchronized (sqlAttachmentRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public Attachment findById(String attachmentId) {
        this.logger().debug((Function0 & Serializable)() -> "Searching for attachment [" + attachmentId + "]");
        return (Attachment)this.releasePersistence.findAttachmentById(attachmentId).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("Repository entity [%s] not found", new Object[]{attachmentId});
        });
    }

    @Timed
    public Attachment create(Release release, String taskId, Attachment attachment) {
        this.logger().debug((Function0 & Serializable)() -> "Adding attachment to task [" + taskId + "]");
        Task releaseTask = release.getTask(taskId);
        HashSet<Attachment> taskAttachments = new HashSet<Attachment>(releaseTask.getAttachments());
        taskAttachments.add(attachment);
        releaseTask.setAttachments(new ArrayList(taskAttachments));
        return this.create(release, attachment);
    }

    @Timed
    public Attachment create(Release release, Attachment attachment) {
        this.logger().debug((Function0 & Serializable)() -> "Adding attachment to release [" + release.getId() + "]");
        release.getAttachments().add(attachment);
        this.releasePersistence.update((Option<Release>)None$.MODULE$, release);
        return attachment;
    }

    @Timed
    public boolean insertAttachment(String releaseId, Attachment attachment) {
        return this.releasePersistence.insertAttachments(releaseId, (Seq<SourceArtifact>)new .colon.colon((Object)attachment, (List)Nil$.MODULE$));
    }

    @Timed
    public void delete(Release release, Attachment attachment) {
        this.logger().info((Function0 & Serializable)() -> "Deleting attachment reference '" + attachment.getId() + "' from release '" + release.getId() + "'");
        release.deleteAttachment(attachment.getId());
        this.releasePersistence.update(release);
        if (!release.isTemplate()) {
            this.releasePersistence.deleteAttachmentById(attachment.getId(), release.getCiUid());
            return;
        }
    }

    @Timed
    public void delete(Task task, Attachment attachment) {
        task.deleteAttachment(attachment.getId());
        Release release = task.getRelease();
        if (release.getTasksUsingAttachment(attachment.getId()).isEmpty()) {
            this.delete(release, attachment);
            return;
        }
        this.logger().info((Function0 & Serializable)() -> "Deleting attachment reference " + attachment.getId() + " from task " + task.getId());
        this.releasePersistence.update(release);
    }

    public boolean batchInsert(Release release, Seq<Attachment> attachments) {
        boolean bl;
        try {
            bl = this.releasePersistence.insertAttachments(release.getId(), attachments);
        }
        catch (RuntimeException e) {
            this.logger().error((Function0 & Serializable)() -> e.getMessage(), (Function0 & Serializable)() -> e);
            bl = false;
        }
        return bl;
    }

    public boolean insert(String releaseUid, String artifactId, String artifactName, InputStream content) {
        boolean bl;
        try {
            bl = this.releasePersistence.insertArtifact(releaseUid, artifactId, artifactName, content);
        }
        catch (RuntimeException e) {
            this.logger().error((Function0 & Serializable)() -> e.getMessage(), (Function0 & Serializable)() -> e);
            bl = false;
        }
        return bl;
    }

    public SqlAttachmentRepository(ReleasePersistence releasePersistence) {
        this.releasePersistence = releasePersistence;
        Logging.$init$((Logging)this);
    }
}

