package com.xebialabs.xlrelease.security.entities;

import java.io.Serializable;
import java.util.Objects;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Nationalized;

@Embeddable
public class XlRolePermissionId implements Serializable {
    private static final long serialVersionUID = -4525813517185428131L;
    @Size(max = 255)
    @NotNull
    @Nationalized
    @Column(name = "ROLE_ID", nullable = false)
    private String roleId;

    @Size(max = 255)
    @NotNull
    @Nationalized
    @Column(name = "PERMISSION_NAME", nullable = false)
    private String permissionName;

    @NotNull
    @Column(name = "CI_ID", nullable = false)
    private String ciId;

    public XlRolePermissionId() {
    }

    public XlRolePermissionId(final String roleId, final String permissionName, final String ciId) {
        this.roleId = roleId;
        this.permissionName = permissionName;
        this.ciId = ciId;
    }

    public XlRolePermissionId(final XlRole role, final String permissionName) {
        this(role.getId(), permissionName, role.getCiId());
    }

    public String getRoleId() {
        return roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getPermissionName() {
        return permissionName;
    }

    public void setPermissionName(String permissionName) {
        this.permissionName = permissionName;
    }

    public String getCiId() {
        return ciId;
    }

    public void setCiId(String ciId) {
        this.ciId = ciId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || Hibernate.getClass(this) != Hibernate.getClass(o)) return false;
        XlRolePermissionId entity = (XlRolePermissionId) o;
        return Objects.equals(this.roleId, entity.roleId) &&
                Objects.equals(this.permissionName, entity.permissionName) &&
                Objects.equals(this.ciId, entity.ciId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(roleId, permissionName, ciId);
    }

}