package com.xebialabs.xlrelease.repository.sql.persistence.data

import com.xebialabs.xlrelease.domain.id.CiUid

import java.util.Date

case class ReleaseRow(json: String,
                      releaseId: String,
                      ciUid: CiUid,
                      folderId: String,
                      securityUid: CiUid,
                      status: String,
                      realFlagStatus: Int,
                      title: String,
                      startDate: Date,
                      endDate: Date,
                      riskScore: Int,
                      totalRiskScore: Int,
                      scmDataUid: CiUid,
                      plannedDuration: Integer,
                      isOverdueNotified: Boolean,
                      kind: String
                     )


case class BasicReleaseRow(releaseId: String,
                           ciUid: CiUid,
                           folderId: String,
                           securityUid: CiUid,
                           status: String,
                           realFlagStatus: Int,
                           title: String,
                           startDate: Date,
                           endDate: Date,
                           riskScore: Int,
                           totalRiskScore: Int,
                           scmDataUid: CiUid,
                           plannedDuration: Integer,
                           isOverdueNotified: Boolean,
                           kind: String,
                           owner: String
                          )

case class OriginTemplateDataRow(originTemplateId: String,
                                 originTemplateTitle: String
                                )

case class ReleaseOverviewDataRow(releaseId: String,
                                  ciUid: CiUid,
                                  folderId: String,
                                  securityUid: CiUid,
                                  status: String,
                                  realFlagStatus: Int,
                                  title: String,
                                  startDate: Date,
                                  endDate: Date,
                                  riskScore: Int,
                                  totalRiskScore: Int,
                                  scmDataUid: CiUid,
                                  plannedDuration: Integer,
                                  kind: String,
                                  currentPhaseTitle: String,
                                  owner: String
                                 )
