/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.security;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.utils.IdUtils$;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.SecurityRepository;
import com.xebialabs.xlrelease.repository.TeamArrayPropertyChange;
import com.xebialabs.xlrelease.security.XlRolePermissionRepository;
import com.xebialabs.xlrelease.security.XlRolePrincipalRepository;
import com.xebialabs.xlrelease.security.XlRoleRepository;
import com.xebialabs.xlrelease.security.XlRoleRoleRepository;
import com.xebialabs.xlrelease.security.entities.XlRole;
import com.xebialabs.xlrelease.security.entities.XlRolePermission;
import com.xebialabs.xlrelease.security.entities.XlRolePermissionId;
import com.xebialabs.xlrelease.security.entities.XlRolePrincipal;
import com.xebialabs.xlrelease.security.entities.XlRolePrincipalId;
import com.xebialabs.xlrelease.security.entities.XlRoleRole;
import com.xebialabs.xlrelease.security.entities.XlRoleRoleId;
import com.xebialabs.xlrelease.security.sql.db.Ids$;
import java.io.Serializable;
import java.util.List;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\teb\u0001B\u0012%\u0001EB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!q\u0005A!A!\u0002\u0013y\u0005\"\u0002*\u0001\t\u0003\u0019\u0006\"B.\u0001\t\u0003b\u0006\"B<\u0001\t\u0003B\b\"CA\u000f\u0001E\u0005I\u0011AA\u0010\u0011%\t)\u0004AI\u0001\n\u0003\ty\u0002C\u0005\u00028\u0001\t\n\u0011\"\u0001\u0002 !9\u0011\u0011\b\u0001\u0005B\u0005m\u0002bBA&\u0001\u0011\u0005\u0013Q\n\u0005\b\u00033\u0002A\u0011IA.\u0011\u001d\t\u0019\u0007\u0001C!\u0003KBq!a\u001b\u0001\t\u0003\ni\u0007C\u0004\u0002x\u0001!\t%!\u001f\t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\"9\u0011\u0011\u0012\u0001\u0005B\u0005-\u0005bBAJ\u0001\u0011\u0005\u0013Q\u0013\u0005\b\u00037\u0003A\u0011IAO\u0011\u001d\t\u0019\u000b\u0001C!\u0003KCq!a+\u0001\t\u0013\ti\u000bC\u0004\u0002L\u0002!I!!4\t\u000f\u0005\r\b\u0001\"\u0003\u0002f\"9\u0011\u0011\u001e\u0001\u0005\n\u0005-\bbBAx\u0001\u0011%\u0011\u0011\u001f\u0005\b\u0003o\u0002A\u0011BA|\u0011\u001d\t\t\t\u0001C\u0005\u0003\u007fDq!!#\u0001\t\u0013\u0011)\u0001C\u0004\u0002\u0014\u0002!IAa\u0003\t\u000f\u0005m\u0005\u0001\"\u0003\u0003\u0012!9\u00111\u0015\u0001\u0005\n\t]\u0001b\u0002B\u000f\u0001\u0011%!q\u0004\u0002\u0016'Fd7+Z2ve&$\u0018PU3q_NLGo\u001c:z\u0015\t)c%\u0001\u0005tK\u000e,(/\u001b;z\u0015\t9\u0003&A\u0002tc2T!!\u000b\u0016\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002,Y\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003[9\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003=\n1aY8n\u0007\u0001\u00192\u0001\u0001\u001a9!\t\u0019d'D\u00015\u0015\u0005)\u0014!B:dC2\f\u0017BA\u001c5\u0005\u0019\te.\u001f*fMB\u0011\u0011HO\u0007\u0002Q%\u00111\b\u000b\u0002\u0013'\u0016\u001cWO]5usJ+\u0007o\\:ji>\u0014\u00180\u0001\bs_2,'+\u001a9pg&$xN]=\u0011\u0005y\u0002U\"A \u000b\u0005\u0015R\u0013BA!@\u0005AAFNU8mKJ+\u0007o\\:ji>\u0014\u00180A\ns_2,'k\u001c7fgJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002?\t&\u0011Qi\u0010\u0002\u001512\u0014v\u000e\\3S_2,'+\u001a9pg&$xN]=\u00021I|G.\u001a)sS:\u001c\u0017\u000e]1mgJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002?\u0011&\u0011\u0011j\u0010\u0002\u001a12\u0014v\u000e\\3Qe&t7-\u001b9bYJ+\u0007o\\:ji>\u0014\u00180A\rs_2,\u0007+\u001a:nSN\u001c\u0018n\u001c8t%\u0016\u0004xn]5u_JL\bC\u0001 M\u0013\tiuH\u0001\u000eYYJ{G.\u001a)fe6L7o]5p]J+\u0007o\\:ji>\u0014\u00180\u0001\u0006tK\u000e,(/\u001a3DSN\u0004\"!\u000f)\n\u0005EC#AC*fGV\u0014X\rZ\"jg\u00061A(\u001b8jiz\"b\u0001\u0016,X1fS\u0006CA+\u0001\u001b\u0005!\u0003\"\u0002\u001f\u0007\u0001\u0004i\u0004\"\u0002\"\u0007\u0001\u0004\u0019\u0005\"\u0002$\u0007\u0001\u00049\u0005\"\u0002&\u0007\u0001\u0004Y\u0005\"\u0002(\u0007\u0001\u0004y\u0015aB4fiR+\u0017-\u001c\u000b\u0003;\u000e\u0004\"AX1\u000e\u0003}S!\u0001\u0019\u0016\u0002\r\u0011|W.Y5o\u0013\t\u0011wL\u0001\u0003UK\u0006l\u0007\"\u00023\b\u0001\u0004)\u0017A\u0002;fC6LE\r\u0005\u0002gi:\u0011qM\u001d\b\u0003QFt!!\u001b9\u000f\u0005)|gBA6o\u001b\u0005a'BA71\u0003\u0019a$o\\8u}%\tq&\u0003\u0002.]%\u00111\u0006L\u0005\u0003S)J!a\u001d\u0015\u0002%M+7-\u001e:jif\u0014V\r]8tSR|'/_\u0005\u0003kZ\u0014a\u0001V3b[&#'BA:)\u0003)\u0019'/Z1uKR+\u0017-\u001c\u000b\tKf\\X0!\u0006\u0002\u001a!)!\u0010\u0003a\u0001K\u0006Y1m\u001c8uC&tWM]%e\u0011\u0015a\b\u00021\u0001f\u0003!!X-Y7OC6,\u0007b\u0002@\t!\u0003\u0005\ra`\u0001\u0006e>dWm\u001d\t\u0007\u0003\u0003\tI!a\u0004\u000f\t\u0005\r\u0011Q\u0001\t\u0003WRJ1!a\u00025\u0003\u0019\u0001&/\u001a3fM&!\u00111BA\u0007\u0005\r\u0019V\r\u001e\u0006\u0004\u0003\u000f!\u0004\u0003BA\u0001\u0003#IA!a\u0005\u0002\u000e\t11\u000b\u001e:j]\u001eD\u0001\"a\u0006\t!\u0003\u0005\ra`\u0001\u000baJLgnY5qC2\u001c\b\u0002CA\u000e\u0011A\u0005\t\u0019A@\u0002\u0017A,'/\\5tg&|gn]\u0001\u0015GJ,\u0017\r^3UK\u0006lG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0005\"fA@\u0002$-\u0012\u0011Q\u0005\t\u0005\u0003O\t\t$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003%)hn\u00195fG.,GMC\u0002\u00020Q\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019$!\u000b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000bde\u0016\fG/\u001a+fC6$C-\u001a4bk2$H\u0005N\u0001\u0015GJ,\u0017\r^3UK\u0006lG\u0005Z3gCVdG\u000fJ\u001b\u0002\u0015U\u0004H-\u0019;f)\u0016\fW\u000eF\u0005f\u0003{\ty$a\u0012\u0002J!)A\r\u0004a\u0001K\"1a\u0010\u0004a\u0001\u0003\u0003\u00022!OA\"\u0013\r\t)\u0005\u000b\u0002\u0018)\u0016\fW.\u0011:sCf\u0004&o\u001c9feRL8\t[1oO\u0016Dq!a\u0006\r\u0001\u0004\t\t\u0005C\u0004\u0002\u001c1\u0001\r!!\u0011\u0002\u0015\u0019Lg\u000e\u001a+fC6LE\r\u0006\u0004\u0002P\u0005U\u0013q\u000b\t\u0005g\u0005ES-C\u0002\u0002TQ\u0012aa\u00149uS>t\u0007B\u0002>\u000e\u0001\u0004\ty\u0001\u0003\u0004}\u001b\u0001\u0007\u0011qB\u0001\rM&tG\rV3b[\nK\u0018\n\u001a\u000b\u0007\u0003;\ny&!\u0019\u0011\tM\n\t&\u0018\u0005\u0006u:\u0001\r!\u001a\u0005\u0006I:\u0001\r!Z\u0001\u000fM&tG\rV3b[\nKh*Y7f)\u0019\ti&a\u001a\u0002j!1!p\u0004a\u0001\u0003\u001fAa\u0001`\bA\u0002\u0005=\u0011A\u00033fY\u0016$X\rV3b[R!\u0011qNA;!\r\u0019\u0014\u0011O\u0005\u0004\u0003g\"$\u0001B+oSRDQ\u0001\u001a\tA\u0002\u0015\f1#\u00193e!JLgnY5qC2\u001cHk\u001c+fC6$b!a\u001c\u0002|\u0005u\u0004\"\u00023\u0012\u0001\u0004)\u0007bBA\f#\u0001\u0007\u0011q\u0010\t\u0006\u0003\u0003\tI!Z\u0001\u0019e\u0016lwN^3Qe&t7-\u001b9bYN4%o\\7UK\u0006lGCBA8\u0003\u000b\u000b9\tC\u0003e%\u0001\u0007Q\rC\u0004\u0002\u0018I\u0001\r!a \u0002)\u0005$GMU8mKN\u0014\u0015PT1nKR{G+Z1n)\u0019\ty'!$\u0002\u0010\")Am\u0005a\u0001K\"1\u0011\u0011S\nA\u0002}\f\u0011B]8mK:\u000bW.Z:\u00023I,Wn\u001c<f%>dWm\u001d\"z\u001d\u0006lWM\u0012:p[R+\u0017-\u001c\u000b\u0007\u0003_\n9*!'\t\u000b\u0011$\u0002\u0019A3\t\r\u0005EE\u00031\u0001\u0000\u0003Q\tG\r\u001a)fe6L7o]5p]N$v\u000eV3b[R1\u0011qNAP\u0003CCQ\u0001Z\u000bA\u0002\u0015Da!a\u0007\u0016\u0001\u0004y\u0018!\u0007:f[>4X\rU3s[&\u001c8/[8og\u001a\u0013x.\u001c+fC6$b!a\u001c\u0002(\u0006%\u0006\"\u00023\u0017\u0001\u0004)\u0007BBA\u000e-\u0001\u0007q0\u0001\thKR\u001cuN\u001c;bS:,'oQ5JIR!\u0011qVAe!\u0011\t\t,a1\u000f\t\u0005M\u0016Q\u0018\b\u0005\u0003k\u000bILD\u0002i\u0003oK!\u0001\u0019\u0016\n\u0007\u0005mv,\u0001\u0002jI&!\u0011qXAa\u0003\u001d\u0001\u0018mY6bO\u0016T1!a/`\u0013\u0011\t)-a2\u0003\u000b\rKW+\u001b3\u000b\t\u0005}\u0016\u0011\u0019\u0005\u0007u^\u0001\r!a\u0004\u00021\u0019Lg\u000eZ(qi&|g.\u00197YYJ{G.\u001a\"z\u001d\u0006lW\r\u0006\u0004\u0002P\u0006u\u0017\u0011\u001d\t\u0006g\u0005E\u0013\u0011\u001b\t\u0005\u0003'\fI.\u0004\u0002\u0002V*\u0019\u0011q[ \u0002\u0011\u0015tG/\u001b;jKNLA!a7\u0002V\n1\u0001\f\u001c*pY\u0016Dq!a8\u0019\u0001\u0004\ty+A\u0007d_:$\u0018-\u001b8fe\u000eK\u0017\n\u001a\u0005\u0007yb\u0001\r!a\u0004\u0002!\u0019Lg\u000eZ(qi&|g.\u00197UK\u0006lG\u0003BAh\u0003ODQ\u0001Z\rA\u0002\u0015\f\u0001CZ5oIJ+\u0017/^5sK\u0012$V-Y7\u0015\t\u0005E\u0017Q\u001e\u0005\u0006Ij\u0001\r!Z\u0001\u0018M&tGm\u00127pE\u0006d'k\u001c7f\u0013\u0012\u001c()\u001f(b[\u0016$B!a=\u0002vB1\u0011\u0011AA\u0005\u0003#Da!!%\u001c\u0001\u0004yHCBA8\u0003s\fi\u0010C\u0004\u0002|r\u0001\r!!5\u0002\tQ,\u0017-\u001c\u0005\u0007\u0003/a\u0002\u0019A@\u0015\r\u0005=$\u0011\u0001B\u0002\u0011\u001d\tY0\ba\u0001\u0003#Dq!a\u0006\u001e\u0001\u0004\ty\b\u0006\u0004\u0002p\t\u001d!\u0011\u0002\u0005\b\u0003wt\u0002\u0019AAi\u0011\u0019\t\tJ\ba\u0001\u007fR1\u0011q\u000eB\u0007\u0005\u001fAq!a? \u0001\u0004\t\t\u000e\u0003\u0004\u0002\u0012~\u0001\ra \u000b\u0007\u0003_\u0012\u0019B!\u0006\t\u000f\u0005m\b\u00051\u0001\u0002R\"1\u00111\u0004\u0011A\u0002}$b!a\u001c\u0003\u001a\tm\u0001bBA~C\u0001\u0007\u0011\u0011\u001b\u0005\u0007\u00037\t\u0003\u0019A@\u0002#\u001d,G\u000fV3b[\u0006#HO]5ckR,7\u000fF\u0002^\u0005CAqAa\t#\u0001\u0004\t\t.\u0001\u0004yYJ{G.\u001a\u0015\u0004\u0001\t\u001d\u0002\u0003\u0002B\u0015\u0005ki!Aa\u000b\u000b\t\t5\"qF\u0001\fiJ\fgn]1di&|gNC\u0002(\u0005cQ1Aa\r+\u0003\t!'-\u0003\u0003\u00038\t-\"aD%t)J\fgn]1di&|g.\u00197")
public class SqlSecurityRepository
implements SecurityRepository {
    private final XlRoleRepository roleRepository;
    private final XlRoleRoleRepository roleRolesRepository;
    private final XlRolePrincipalRepository rolePrincipalsRepository;
    private final XlRolePermissionRepository rolePermissionsRepository;
    private final SecuredCis securedCis;

    public Team getTeam(String teamId) {
        XlRole xlRole = this.findRequiredTeam(teamId);
        Team team = this.getTeamAttributes(xlRole);
        return team;
    }

    public String createTeam(String containerId, String teamName, scala.collection.immutable.Set<String> roles, scala.collection.immutable.Set<String> principals, scala.collection.immutable.Set<String> permissions) {
        XlRole xlRole;
        Long containerCiId = this.getContainerCiId(containerId);
        Option<XlRole> option = this.findOptionalXlRoleByName(containerCiId, teamName);
        if (option instanceof Some) {
            XlRole xlRole2;
            Some some = (Some)option;
            xlRole = xlRole2 = (XlRole)some.value();
        } else if (None$.MODULE$.equals(option)) {
            String roleId = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(IdUtils$.MODULE$.getUniqueId("Team", "")), "/");
            XlRole xlRole3 = new XlRole(roleId, teamName, containerCiId);
            xlRole = (XlRole)this.roleRepository.save(xlRole3);
        } else {
            throw new MatchError(option);
        }
        XlRole team = xlRole;
        this.addRolesByNameToTeam(team, roles);
        this.addPrincipalsToTeam(team, principals);
        this.addPermissionsToTeam(team, permissions);
        return team.getId();
    }

    public scala.collection.immutable.Set<String> createTeam$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    public scala.collection.immutable.Set<String> createTeam$default$4() {
        return Predef$.MODULE$.Set().empty();
    }

    public scala.collection.immutable.Set<String> createTeam$default$5() {
        return Predef$.MODULE$.Set().empty();
    }

    public String updateTeam(String teamId, TeamArrayPropertyChange roles, TeamArrayPropertyChange principals, TeamArrayPropertyChange permissions) {
        XlRole team = this.findRequiredTeam(teamId);
        this.addRolesByNameToTeam(team, (scala.collection.immutable.Set<String>)roles.add());
        this.addPrincipalsToTeam(team, (scala.collection.immutable.Set<String>)principals.add());
        this.addPermissionsToTeam(team, (scala.collection.immutable.Set<String>)permissions.add());
        this.removeRolesByNameFromTeam(team, (scala.collection.immutable.Set<String>)roles.remove());
        this.removePrincipalsFromTeam(team, (scala.collection.immutable.Set<String>)principals.remove());
        this.removePermissionsFromTeam(team, (scala.collection.immutable.Set<String>)permissions.remove());
        return team.getId();
    }

    public Option<String> findTeamId(String containerId, String teamName) {
        return this.findOptionalXlRoleByName(this.getContainerCiId(containerId), teamName).map((Function1 & Serializable)x$1 -> x$1.getId());
    }

    public Option<Team> findTeamById(String containerId, String teamId) {
        Some some;
        XlRole xlRole;
        Long ciId = this.getContainerCiId(containerId);
        Option<XlRole> option = this.roleRepository.findByCiIdAndId(ciId, teamId);
        if (option instanceof Some && (xlRole = (XlRole)(some = (Some)option).value()) != null) {
            XlRole xlRole2 = xlRole;
            Team team = this.getTeamAttributes(xlRole2);
            return Option$.MODULE$.apply((Object)team);
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    public Option<Team> findTeamByName(String containerId, String teamName) {
        Some some;
        XlRole xlRole;
        Long ciId = this.getContainerCiId(containerId);
        Option<XlRole> option = this.findOptionalXlRoleByName(ciId, teamName);
        if (option instanceof Some && (xlRole = (XlRole)(some = (Some)option).value()) != null) {
            XlRole xlRole2 = xlRole;
            Team team = this.getTeamAttributes(xlRole2);
            return Option$.MODULE$.apply((Object)team);
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    public void deleteTeam(String teamId) {
        this.roleRolesRepository.deleteByIdRoleId(teamId);
        this.rolePrincipalsRepository.deleteByIdRoleId(teamId);
        this.rolePermissionsRepository.deleteByIdRoleId(teamId);
        this.roleRepository.deleteById(teamId);
    }

    public void addPrincipalsToTeam(String teamId, scala.collection.immutable.Set<String> principals) {
        XlRole team = this.findRequiredTeam(teamId);
        this.addPrincipalsToTeam(team, principals);
    }

    public void removePrincipalsFromTeam(String teamId, scala.collection.immutable.Set<String> principals) {
        this.findOptionalTeam(teamId).foreach((Function1 & Serializable)x$2 -> {
            this.removePrincipalsFromTeam(x$2, (scala.collection.immutable.Set<String>)principals);
            return BoxedUnit.UNIT;
        });
    }

    public void addRolesByNameToTeam(String teamId, scala.collection.immutable.Set<String> roleNames) {
        XlRole team = this.findRequiredTeam(teamId);
        this.addRolesByNameToTeam(team, roleNames);
    }

    public void removeRolesByNameFromTeam(String teamId, scala.collection.immutable.Set<String> roleNames) {
        this.findOptionalTeam(teamId).foreach((Function1 & Serializable)x$3 -> {
            this.removeRolesByNameFromTeam(x$3, (scala.collection.immutable.Set<String>)roleNames);
            return BoxedUnit.UNIT;
        });
    }

    public void addPermissionsToTeam(String teamId, scala.collection.immutable.Set<String> permissions) {
        XlRole team = this.findRequiredTeam(teamId);
        this.addPermissionsToTeam(team, permissions);
    }

    public void removePermissionsFromTeam(String teamId, scala.collection.immutable.Set<String> permissions) {
        this.findOptionalTeam(teamId).foreach((Function1 & Serializable)x$4 -> {
            this.removePermissionsFromTeam(x$4, (scala.collection.immutable.Set<String>)permissions);
            return BoxedUnit.UNIT;
        });
    }

    private Long getContainerCiId(String containerId) {
        Option securityUid = Option$.MODULE$.apply((Object)this.securedCis.getEffectiveSecuredCi(containerId).getSecurityUid());
        return Ids$.MODULE$.toDbId(securityUid);
    }

    private Option<XlRole> findOptionalXlRoleByName(Long containerCiId, String teamName) {
        return this.roleRepository.findByCiIdAndNameIgnoreCase(containerCiId, teamName);
    }

    private Option<XlRole> findOptionalTeam(String teamId) {
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.roleRepository.findById(teamId)));
    }

    private XlRole findRequiredTeam(String teamId) {
        return (XlRole)this.roleRepository.findById(teamId).orElseThrow(() -> new NotFoundException("Team [" + teamId + "] not found", new Object[0]));
    }

    private scala.collection.immutable.Set<XlRole> findGlobalRoleIdsByName(scala.collection.immutable.Set<String> roleNames) {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.roleRepository.findByCiIdAndNameIgnoreCaseIn(Predef$.MODULE$.long2Long(-1L), CollectionConverters$.MODULE$.SetHasAsJava(roleNames).asJava())).asScala().toSet();
    }

    private void addPrincipalsToTeam(XlRole team, scala.collection.immutable.Set<String> principals) {
        scala.collection.immutable.Set teamPrincipals = (scala.collection.immutable.Set)principals.map((Function1 & Serializable)x$5 -> new XlRolePrincipal(team, (String)x$5));
        this.rolePrincipalsRepository.saveAll(CollectionConverters$.MODULE$.SetHasAsJava((Set)teamPrincipals).asJava());
    }

    private void removePrincipalsFromTeam(XlRole team, scala.collection.immutable.Set<String> principals) {
        java.util.Set ids = CollectionConverters$.MODULE$.SetHasAsJava((Set)principals.map((Function1 & Serializable)principal -> new XlRolePrincipalId(team.getId(), (String)principal))).asJava();
        this.rolePrincipalsRepository.deleteAllById(ids);
    }

    private void addRolesByNameToTeam(XlRole team, scala.collection.immutable.Set<String> roleNames) {
        scala.collection.immutable.Set<XlRole> globalRoleIds = this.findGlobalRoleIdsByName(roleNames);
        scala.collection.immutable.Set teamRoles = (scala.collection.immutable.Set)globalRoleIds.map((Function1 & Serializable)x$6 -> new XlRoleRole(team, (XlRole)x$6));
        this.roleRolesRepository.saveAll(CollectionConverters$.MODULE$.SetHasAsJava((Set)teamRoles).asJava());
    }

    private void removeRolesByNameFromTeam(XlRole team, scala.collection.immutable.Set<String> roleNames) {
        scala.collection.immutable.Set<XlRole> memberRoles = this.findGlobalRoleIdsByName(roleNames);
        java.util.Set ids = CollectionConverters$.MODULE$.SetHasAsJava((Set)memberRoles.map((Function1 & Serializable)memberRole -> new XlRoleRoleId(team.getId(), memberRole.getId()))).asJava();
        this.roleRolesRepository.deleteAllById(ids);
    }

    private void addPermissionsToTeam(XlRole team, scala.collection.immutable.Set<String> permissions) {
        scala.collection.immutable.Set teamPermissions = (scala.collection.immutable.Set)permissions.map((Function1 & Serializable)x$7 -> new XlRolePermission(team, (String)x$7));
        this.rolePermissionsRepository.saveAll(CollectionConverters$.MODULE$.SetHasAsJava((Set)teamPermissions).asJava());
    }

    private void removePermissionsFromTeam(XlRole team, scala.collection.immutable.Set<String> permissions) {
        java.util.Set ids = CollectionConverters$.MODULE$.SetHasAsJava((Set)permissions.map((Function1 & Serializable)permission -> new XlRolePermissionId(team, (String)permission))).asJava();
        this.rolePermissionsRepository.deleteAllById(ids);
    }

    private Team getTeamAttributes(XlRole xlRole) {
        String teamId = xlRole.getId();
        List memberRoleNames = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.roleRolesRepository.findByIdRoleId(teamId)).asScala().map((Function1 & Serializable)x$8 -> x$8.getMemberRole().getName())).asJava();
        List permissions = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.rolePermissionsRepository.findByIdRoleId(teamId)).asScala().map((Function1 & Serializable)x$9 -> x$9.getId().getPermissionName())).asJava();
        List principals = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.rolePrincipalsRepository.findByIdRoleId(teamId)).asScala().map((Function1 & Serializable)x$10 -> x$10.getId().getPrincipalName())).asJava();
        Team team = new Team();
        team.setId(teamId);
        team.setTeamName(xlRole.getName());
        team.setPermissions(permissions);
        team.setMembers(principals);
        team.setRoles(memberRoleNames);
        return team;
    }

    public SqlSecurityRepository(XlRoleRepository roleRepository, XlRoleRoleRepository roleRolesRepository, XlRolePrincipalRepository rolePrincipalsRepository, XlRolePermissionRepository rolePermissionsRepository, SecuredCis securedCis) {
        this.roleRepository = roleRepository;
        this.roleRolesRepository = roleRolesRepository;
        this.rolePrincipalsRepository = rolePrincipalsRepository;
        this.rolePermissionsRepository = rolePermissionsRepository;
        this.securedCis = securedCis;
    }
}

