/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.security.SecuredCi;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001\u0002\u0005\n\u0001QA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tM\u0001\u0011\t\u0011)A\u0005O!)!\u0006\u0001C\u0001W!)\u0001\u0007\u0001C!c!)!\u000b\u0001C!'\")a\u000b\u0001C\u0005/\")1\u000f\u0001C!i\ni1+\u001d7TK\u000e,(/\u001a3DSNT!AC\u0006\u0002\u0007M\fHN\u0003\u0002\r\u001b\u0005Q!/\u001a9pg&$xN]=\u000b\u00059y\u0011!\u0003=me\u0016dW-Y:f\u0015\t\u0001\u0012#A\u0005yK\nL\u0017\r\\1cg*\t!#A\u0002d_6\u001c\u0001aE\u0002\u0001+m\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0007C\u0001\u000f\u001e\u001b\u0005Y\u0011B\u0001\u0010\f\u0005)\u0019VmY;sK\u0012\u001c\u0015n]\u0001\u0012M>dG-\u001a:QKJ\u001c\u0018n\u001d;f]\u000e,\u0007CA\u0011%\u001b\u0005\u0011#BA\u0012\n\u0003-\u0001XM]:jgR,gnY3\n\u0005\u0015\u0012#!\u0005$pY\u0012,'\u000fU3sg&\u001cH/\u001a8dK\u0006\u0011\"/\u001a7fCN,\u0007+\u001a:tSN$XM\\2f!\t\t\u0003&\u0003\u0002*E\t\u0011\"+\u001a7fCN,\u0007+\u001a:tSN$XM\\2f\u0003\u0019a\u0014N\\5u}Q\u0019AFL\u0018\u0011\u00055\u0002Q\"A\u0005\t\u000b}\u0019\u0001\u0019\u0001\u0011\t\u000b\u0019\u001a\u0001\u0019A\u0014\u0002+\u001d,G/\u00124gK\u000e$\u0018N^3TK\u000e,(/\u001a3DSR\u0011!\u0007\u000f\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k5\t\u0001b]3dkJLG/_\u0005\u0003oQ\u0012\u0011bU3dkJ,GmQ5\t\u000be\"\u0001\u0019\u0001\u001e\u0002\u0017\r|g\u000e^1j]\u0016\u0014\u0018\n\u001a\t\u0003w\ts!\u0001\u0010!\u0011\u0005u:R\"\u0001 \u000b\u0005}\u001a\u0012A\u0002\u001fs_>$h(\u0003\u0002B/\u00051\u0001K]3eK\u001aL!a\u0011#\u0003\rM#(/\u001b8h\u0015\t\tu\u0003\u000b\u0002\u0005\rB\u0011q\tU\u0007\u0002\u0011*\u0011\u0011JS\u0001\u000bC:tw\u000e^1uS>t'BA&M\u0003\u0011\u0019wN]3\u000b\u00055s\u0015AC7jGJ|W.\u001a;fe*\tq*\u0001\u0002j_&\u0011\u0011\u000b\u0013\u0002\u0006)&lW\rZ\u0001\rO\u0016$8+Z2ve\u0016$7)\u001b\u000b\u0003eQCQ!O\u0003A\u0002iB#!\u0002$\u0002\u0017\u0005\u001c8+Z2ve\u0016$7)\u001b\u000b\u0004eaK\u0006\"B\u001d\u0007\u0001\u0004Q\u0004\"\u0002.\u0007\u0001\u0004Y\u0016aA;jIB\u0019a\u0003\u00180\n\u0005u;\"AB(qi&|g\u000e\u0005\u0002`a:\u0011\u0001-\u001c\b\u0003C*t!A\u00195\u000f\u0005\r<gB\u00013g\u001d\tiT-C\u0001\u0013\u0013\t\u0001\u0012#\u0003\u0002\u000f\u001f%\u0011\u0011.D\u0001\u0007I>l\u0017-\u001b8\n\u0005-d\u0017AA5e\u0015\tIW\"\u0003\u0002o_\u00069\u0001/Y2lC\u001e,'BA6m\u0013\t\t(OA\u0003DSVKGM\u0003\u0002o_\u000692/\u001a;Bg\u00163g-Z2uSZ,7+Z2ve\u0016$7)\u001b\u000b\u0004kbL\bC\u0001\fw\u0013\t9xC\u0001\u0003V]&$\b\"B\u001d\b\u0001\u0004Q\u0004\"\u0002>\b\u0001\u0004Y\u0018aC5t\u000b\u001a4Wm\u0019;jm\u0016\u0004\"A\u0006?\n\u0005u<\"a\u0002\"p_2,\u0017M\u001c\u0015\u0003\u000f\u0019C3\u0001AA\u0001!\u0011\t\u0019!a\u0004\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\t1\u0002\u001e:b]N\f7\r^5p]*\u0019!\"a\u0003\u000b\u0007\u00055Q\"\u0001\u0002eE&!\u0011\u0011CA\u0003\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007")
public class SqlSecuredCis
implements SecuredCis {
    private final FolderPersistence folderPersistence;
    private final ReleasePersistence releasePersistence;

    @Timed
    public SecuredCi getEffectiveSecuredCi(String containerId) {
        String string = containerId;
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        if (Ids.isFolderId((String)string)) {
            return this.folderPersistence.getEffectiveSecuredCi(string);
        }
        if (Ids.isReleaseId((String)string)) {
            return this.releasePersistence.getEffectiveSecuredCi(string);
        }
        return this.getSecuredCi(string);
    }

    @Timed
    public SecuredCi getSecuredCi(String containerId) {
        String string = containerId;
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        if (Ids.isFolderId((String)string)) {
            return this.folderPersistence.getSecuredCi(containerId);
        }
        if (Ids.isReleaseId((String)string)) {
            return this.asSecuredCi(string, this.releasePersistence.findUidByReleaseId(string));
        }
        throw new IllegalArgumentException("Unable to get UID for unsupported ID format [" + containerId + "]");
    }

    private SecuredCi asSecuredCi(String containerId, Option<Long> uid) {
        return new SecuredCi(containerId, ((Long)uid.getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Unable to find release by ID [" + containerId + "]");
        })).toString());
    }

    @Timed
    public void setAsEffectiveSecuredCi(String containerId, boolean isEffective) {
        if (Ids.isFolderId((String)containerId)) {
            long oldSecurityUid = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(this.folderPersistence.getEffectiveSecuredCi(containerId).getSecurityUid()));
            FolderRow newFolderData = isEffective ? this.folderPersistence.setAsEffectiveSecuredCi(containerId) : this.folderPersistence.inheritEffectiveSecuredCi(containerId);
            this.releasePersistence.replaceSecurityUid(newFolderData.uid(), Predef$.MODULE$.long2Long(oldSecurityUid), newFolderData.securityUid());
            return;
        }
        if (isEffective) {
            this.releasePersistence.setAsEffectiveSecuredCi(containerId);
            return;
        }
        SecuredCi effectiveFolder = this.folderPersistence.getEffectiveSecuredCi(Ids.getParentId((String)containerId));
        this.releasePersistence.inheritSecurityFromFolder(containerId, Predef$.MODULE$.long2Long(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(effectiveFolder.getSecurityUid()))));
    }

    public SqlSecuredCis(FolderPersistence folderPersistence, ReleasePersistence releasePersistence) {
        this.folderPersistence = folderPersistence;
        this.releasePersistence = releasePersistence;
    }
}

