package com.xebialabs.xlrelease.scheduler.sql

import com.xebialabs.xlrelease.repository.sql.persistence.Schema.TASK_JOBS
import com.xebialabs.xlrelease.scheduler._
import org.springframework.jdbc.core.RowMapper

trait JobRowMapper {

  def jobMapper: RowMapper[JobRow] = (rs, _) => {
    JobRow(
      id = rs.getLong(TASK_JOBS.ID),
      node = rs.getString(TASK_JOBS.NODE),
      jobType = JobType.valueOf(rs.getString(TASK_JOBS.JOB_TYPE)),
      status = JobStatus.valueOf(rs.getString(TASK_JOBS.STATUS)),
      version = rs.getLong(TASK_JOBS.VERSION),
      submitTime = Option(rs.getTimestamp(TASK_JOBS.SUBMIT_TIME)).map(_.toInstant).orNull,
      reservationTime = Option(rs.getTimestamp(TASK_JOBS.RESERVATION_TIME)).map(_.toInstant).orNull,
      startTime = Option(rs.getTimestamp(TASK_JOBS.START_TIME)).map(_.toInstant).orNull,
      scheduledStartTime = Option(rs.getTimestamp(TASK_JOBS.SCHEDULED_START_TIME)).map(_.toInstant).orNull,
      taskId = rs.getString(TASK_JOBS.TASK_ID),
      releaseUid = rs.getLong(TASK_JOBS.RELEASE_UID),
      executionId = rs.getString(TASK_JOBS.EXECUTION_ID),
      runnerId = rs.getString(TASK_JOBS.RUNNER_ID)
    )
  }

}
