package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.xlrelease.domain.id.CiUid
import com.xebialabs.xlrelease.domain.{BaseConfiguration, CiWithUid}
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence
import com.xebialabs.xlrelease.utils.{CiHelper, Diff}

import scala.jdk.CollectionConverters._

trait ConfigurationReferencesSupport {
  val configurationPersistence: ConfigurationReferencePersistence

  def updateConfigurationRefs(entity: CiWithUid): Unit = {
    val existingCiRefs = Option(configurationPersistence.getReferencesByUid(entity.getCiUid))

    val references: Set[BaseConfiguration] = CiHelper.getExternalReferences(entity).asScala
      .filter(_.isInstanceOf[BaseConfiguration])
      .filterNot(ci => Ids.isInRelease(ci.getId))
      .map(_.asInstanceOf[BaseConfiguration])
      .toSet

    val currentCiRefs = references.map(_.getId).toSeq
    val ciRefDiff = Diff(existingCiRefs.getOrElse(Seq.empty), currentCiRefs)

    configurationPersistence.deleteRefs(ciRefDiff.deletedValues.toSet, entity.getCiUid)
    configurationPersistence.insertRefs(ciRefDiff.newValues.toSet, entity.getCiUid)
  }

  def deleteConfigurationRefs(uid: CiUid): Unit = {
    configurationPersistence.deleteUsedByRef(uid)
  }

}
