package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData
import com.xebialabs.xlrelease.db.sql.transaction.{IsReadOnly, IsTransactional}
import com.xebialabs.xlrelease.domain.id.CiUid
import com.xebialabs.xlrelease.repository.SCMTraceabilityRepository
import com.xebialabs.xlrelease.repository.sql.persistence.SCMTraceabilityPersistence
import grizzled.slf4j.Logging
import io.micrometer.core.annotation.Timed
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Repository

@IsTransactional
@Repository
@Autowired
class SqlSCMTraceabilityRepository(
                                    scmTraceabilityPersistence: SCMTraceabilityPersistence
                                  ) extends SCMTraceabilityRepository with Logging {

  @Timed
  @IsReadOnly
  override def findById(id: CiUid): Option[SCMTraceabilityData] = {
    logger.debug(s"Getting scm traceability data with id [$id]")
    scmTraceabilityPersistence.findById(id)
  }

  @Timed
  override def createSCMEntity(scmEntity: SCMTraceabilityData): CiUid = {
    logger.debug(s"Inserting scm traceability data $scmEntity")
    scmTraceabilityPersistence.insert(scmEntity)
  }

  @Timed
  override def updateSCMEntity(id: CiUid, scmEntity: SCMTraceabilityData): Unit = {
    logger.debug(s"Update scm traceability data with id [$id] with [$scmEntity]")
    scmTraceabilityPersistence.update(id, scmEntity)
  }

  @Timed
  override def deleteData(id: CiUid): Unit = {
    logger.debug(s"Deleting scm traceability data with id [$id]")
    scmTraceabilityPersistence.delete(id)
  }
}
