package com.xebialabs.xlrelease.security.entities;

import jakarta.persistence.*;

@Entity
@Table(name = "XL_ROLE_PRINCIPALS")
public class XlRolePrincipal {
    @EmbeddedId
    private XlRolePrincipalId id;

    @MapsId("roleId")
    @ManyToOne(fetch = FetchType.LAZY, optional = false)
    @JoinColumn(name = "ROLE_ID", nullable = false)
    private XlRole role;

    public XlRolePrincipal() {
    }

    public XlRolePrincipal(final XlRolePrincipalId id, final XlRole role) {
        this.id = id;
        this.role = role;
    }

    public XlRolePrincipal(XlRole role, String principalName) {
        this.id = new XlRolePrincipalId(role.getId(), principalName);
        this.role = role;
    }


    public XlRolePrincipalId getId() {
        return id;
    }

    public void setId(XlRolePrincipalId id) {
        this.id = id;
    }

    public XlRole getRole() {
        return role;
    }

    public void setRole(XlRole role) {
        this.role = role;
    }

}