package com.xebialabs.xlrelease.repository.sql.persistence

import com.xebialabs.xlrelease.domain.UserProfile
import com.xebialabs.xlrelease.repository.sql.persistence.Schema.USER_PROFILE
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper
import org.springframework.jdbc.core.RowMapper

import java.sql.ResultSet

trait UserProfileMapper {
  self: CompressionSupport =>
  val userProfileRowMapper: RowMapper[UserProfile] = (rs: ResultSet, _: Int) => {
    val lastActive = rs.getTimestamp(USER_PROFILE.LAST_ACTIVE)
    val inputStream = rs.getBinaryStream(USER_PROFILE.CONTENT)
    try {
      val stream = decompress(inputStream)
      val profile = CiSerializerHelper.deserialize(stream, null).asInstanceOf[UserProfile]
      profile.setLastActive(lastActive)
      profile
    } finally {
      inputStream.close()
    }
  }

}
