package com.xebialabs.xlrelease.database

import com.p6spy.engine.logging.Category
import com.p6spy.engine.spy.appender.FormattedLogger
import com.xebialabs.xlrelease.features.DatabaseProxyFeature
import grizzled.slf4j.Logging

class SqlLogger extends FormattedLogger with Logging {
  private lazy val settings: DatabaseProxyFeature = DatabaseProxyFeature

  override def logSQL(connectionId: Int, now: String, elapsedMillis: Long, category: Category, prepared: String, sql: String, url: String): Unit = {
    val executionThreshold = settings.executionThreshold.toMillis

    if (elapsedMillis >= executionThreshold) {
      if (settings.shouldLogParameters) {
        logSQLInternal(connectionId, now, elapsedMillis, category, prepared, sql, url)
      } else {
        logSQLInternal(connectionId, now, elapsedMillis, category, prepared, "", url)
      }
    }
  }

  protected def logSQLInternal(connectionId: Int, now: String, elapsed: Long, category: Category, prepared: String, sql: String, url: String): Unit = {
    val msg = strategy.formatMessage(connectionId, now, elapsed, category.toString, prepared, sql, url)
    if (Category.ERROR == category) {
      logger.error(msg)
    } else if (Category.WARN == category) {
      logger.warn(msg)
    } else if (Category.DEBUG == category) {
      logger.debug(msg)
    } else {
      logger.info(msg)
    }
  }

  override def isCategoryEnabled(category: Category): Boolean = {
    if (Category.ERROR == category) {
      logger.isErrorEnabled
    } else if (Category.WARN == category) {
      logger.isWarnEnabled
    } else if (Category.DEBUG == category) {
      logger.isDebugEnabled
    } else {
      logger.isInfoEnabled
    }
  }

  override def logException(e: Exception): Unit = {
    logger.warn("", e)
  }

  override def logText(text: String): Unit = {
    logger.info(text)
  }
}
