package com.xebialabs.xlrelease.repository.sql.persistence

import com.xebialabs.xlrelease.domain.events.{ReleaseActorStarted, ReleaseActorStopped, ReleaseRiskScoreUpdated}
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}

@EventListener
class ReleaseCacheEventHandler(releaseCacheService: ReleaseCacheService) {

  @Subscribe
  def onActorStart(event: ReleaseActorStarted): Unit = {
    releaseCacheService.invalidate(event.releaseId)
    releaseCacheService.allow(event.releaseId)
  }

  @Subscribe
  def onActorStop(event: ReleaseActorStopped): Unit = {
    releaseCacheService.disallow(event.releaseId)
    releaseCacheService.invalidate(event.releaseId)
  }

  @Subscribe
  def onRiskUpdate(event: ReleaseRiskScoreUpdated): Unit = {
    event match {
      case ReleaseRiskScoreUpdated(releaseId, riskScore, totalRiskScore) =>
        releaseCacheService.get(event.releaseId).foreach { releaseRow =>
          val updatedRow = releaseRow.copy(riskScore = riskScore, totalRiskScore = totalRiskScore)
          releaseCacheService.put(releaseId, updatedRow)
        }
    }
  }
}
