package com.xebialabs.xlrelease.repository.sql.persistence.configuration

import com.xebialabs.xlrelease.repository.sql.persistence.CiId.CiId
import com.xebialabs.xlrelease.repository.sql.persistence.CiUid
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationPersistence._
import com.xebialabs.xlrelease.repository.sql.persistence.data.ConfigurationReferenceRow

import scala.util.Try

trait ConfigurationReferencePersistence extends ConfigurationPersistenceCommon {

  def insertRefs(configurationIds: Set[CiId], usedBy: CiUid): Unit

  def deleteRefs(configurationIds: Set[CiId], usedBy: CiUid): Unit

  def isReferenced(configurationId: String): Boolean

  def getReferencingEntities(configurationId: String): Seq[ConfigurationReferenceRow]

  def getReferencesByUid(usedByCiUid: CiUid): List[String]

  def deleteUsedByRef(usedByCiUid: CiUid): Unit

  def deleteRefsByConfigurationUid(configurationUid: CiUid): Unit

  def deleteRefsByConfigurationUids(configurationUids: Seq[CiUid]): Unit

  def findAllByUid(uid: CiUid): Seq[ConfigurationRow]

  def deleteRefsByTypes(ciTypes: Seq[String]): Try[Boolean]

  def findAllNonInheritedReferences(folderId: String, queryParameters: Seq[String]): Seq[String]
}
