/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ExtendedValidationContext;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext$;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.configuration.ThemeSettings;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.repository.CiProperty;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.query.ReleaseBasicData;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.ReferencedEntity;
import com.xebialabs.xlrelease.repository.sql.SqlConfigurationRepository$;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ReleaseConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.TriggerConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ConfigurationReferenceRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ConfigurationReferenceRow$;
import com.xebialabs.xlrelease.scheduler.filters.JobFilters;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import com.xebialabs.xlrelease.service.ConfigurationVariableService$;
import com.xebialabs.xlrelease.utils.FolderId;
import com.xebialabs.xlrelease.utils.TypeHelper$;
import com.xebialabs.xlrelease.validation.ExtendedValidationContextImpl;
import com.xebialabs.xlrelease.validation.XlrValidationsFailedException;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0011-b\u0001B A\u0001-C\u0001B\u0018\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\tO\u0002\u0011\t\u0011)A\u0005Q\"A1\u000e\u0001B\u0001B\u0003%A\u000e\u0003\u0005p\u0001\t\u0005\t\u0015!\u0003q\u0011!!\bA!A!\u0002\u0013)\b\u0002C=\u0001\u0005\u0003\u0005\u000b\u0011\u0002>\t\u0011u\u0004!\u0011!Q\u0001\nyDq!a\u0003\u0001\t\u0003\ti\u0001C\u0005\u0002 \u0001\u0011\r\u0011\"\u0003\u0002\"!A\u0011\u0011\b\u0001!\u0002\u0013\t\u0019\u0003C\u0005\u0002<\u0001\u0011\r\u0011\"\u0003\u0002\"!A\u0011Q\b\u0001!\u0002\u0013\t\u0019\u0003C\u0005\u0002@\u0001\u0011\r\u0011\"\u0003\u0002\"!A\u0011\u0011\t\u0001!\u0002\u0013\t\u0019\u0003C\u0005\u0002D\u0001\u0011\r\u0011\"\u0003\u0002\"!A\u0011Q\t\u0001!\u0002\u0013\t\u0019\u0003C\u0005\u0002H\u0001\u0011\r\u0011\"\u0003\u0002J!A\u0011q\f\u0001!\u0002\u0013\tY\u0005C\u0004\u0002b\u0001!\t%a\u0019\t\u000f\u0005\u0005\u0004\u0001\"\u0011\u0002 \"9\u0011Q\u001b\u0001\u0005\n\u0005]\u0007bBAo\u0001\u0011%\u0011q\u001c\u0005\b\u0003_\u0004A\u0011IAy\u0011\u001d\ty\u0010\u0001C!\u0005\u0003Aq!a@\u0001\t\u0003\u0012i\u0001C\u0004\u0003\u001c\u0001!\tE!\b\t\u000f\t-\u0003\u0001\"\u0011\u0003N!9!Q\u000f\u0001\u0005B\t]\u0004b\u0002B;\u0001\u0011\u0005#\u0011\u0012\u0005\n\u0005K\u0003\u0011\u0013!C\u0001\u0005OCqAa0\u0001\t\u0013\u0011\t\rC\u0004\u0003f\u0002!\tAa:\t\u000f\t=\b\u0001\"\u0001\u0003r\"I1\u0011\u0003\u0001\u0012\u0002\u0013\u000511\u0003\u0005\b\u0007/\u0001A\u0011IB\r\u0011\u001d\u00199\u0002\u0001C!\u0007WAqa!\u0014\u0001\t\u0003\u001ay\u0005C\u0004\u0004X\u0001!Ia!\u0017\t\u000f\rU\u0004\u0001\"\u0011\u0004x!91Q\u0010\u0001\u0005\u0002\r}\u0004bBBF\u0001\u0011\u00053Q\u0012\u0005\b\u0007C\u0003A\u0011BBR\u0011\u001d\u0019\u0019\r\u0001C!\u0007\u000bDqa!3\u0001\t\u0003\u001aY\rC\u0004\u0004T\u0002!Ia!6\b\u000f\r\u0005\b\t#\u0001\u0004d\u001a1q\b\u0011E\u0001\u0007KDq!a\u00030\t\u0003\u00199O\u0002\u0004\u0004j>*11\u001e\u0005\u000b\u0007[\f$\u0011!Q\u0001\n\tm\u0003bBA\u0006c\u0011\u00051q\u001e\u0005\b\u0007o\fD\u0011AB}\u0011\u001d\u0019Y0\rC\u0001\u0007{D\u0011\u0002b\u00010\u0003\u0003%Y\u0001\"\u0002\u0007\r\u0011%q&\u0002C\u0006\u0011)!ia\u000eB\u0001B\u0003%\u0011q\u000f\u0005\b\u0003\u00179D\u0011\u0001C\b\u0011%\u0011If\u000eb\u0001\n\u0013!)\u0002\u0003\u0005\u0005\u0018]\u0002\u000b\u0011\u0002B.\u0011\u001d\u00199p\u000eC\u0001\u0007sDq\u0001\"\u00078\t\u0003!Y\u0002C\u0005\u0005&=\n\t\u0011b\u0003\u0005(\tQ2+\u001d7D_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ss*\u0011\u0011IQ\u0001\u0004gFd'BA\"E\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003\u000b\u001a\u000b\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005\u001dC\u0015!\u0003=fE&\fG.\u00192t\u0015\u0005I\u0015aA2p[\u000e\u00011\u0003\u0002\u0001M%Z\u0003\"!\u0014)\u000e\u00039S\u0011aT\u0001\u0006g\u000e\fG.Y\u0005\u0003#:\u0013a!\u00118z%\u00164\u0007CA*U\u001b\u0005\u0011\u0015BA+C\u0005]\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002X96\t\u0001L\u0003\u0002Z5\u0006)1\u000f\u001c45U*\t1,\u0001\u0005he&T(\u0010\\3e\u0013\ti\u0006LA\u0004M_\u001e<\u0017N\\4\u00021\r|gNZ5hkJ\fG/[8o!\u0016\u00148/[:uK:\u001cW\r\u0005\u0002aK6\t\u0011M\u0003\u0002cG\u0006i1m\u001c8gS\u001e,(/\u0019;j_:T!\u0001\u001a!\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0003M\u0006\u0014\u0001dQ8oM&<WO]1uS>t\u0007+\u001a:tSN$XM\\2f\u0003!\u0012X\r\\3bg\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]J+g-\u001a:f]\u000e,\u0007+\u001a:tSN$XM\\2f!\t\u0001\u0017.\u0003\u0002kC\nA#+\u001a7fCN,7i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cW\rU3sg&\u001cH/\u001a8dK\u0006ACO]5hO\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cW\rU3sg&\u001cH/\u001a8dKB\u0011\u0001-\\\u0005\u0003]\u0006\u0014\u0001\u0006\u0016:jO\u001e,'oQ8oM&<WO]1uS>t'+\u001a4fe\u0016t7-\u001a)feNL7\u000f^3oG\u0016\fAc]9m%\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\bCA9s\u001b\u0005\u0001\u0015BA:A\u0005Q\u0019\u0016\u000f\u001c*fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u0006\tbm\u001c7eKJ\u0004VM]:jgR,gnY3\u0011\u0005Y<X\"A2\n\u0005a\u001c'!\u0005$pY\u0012,'\u000fU3sg&\u001cH/\u001a8dK\u0006\u0011\"/\u001a7fCN,\u0007+\u001a:tSN$XM\\2f!\t180\u0003\u0002}G\n\u0011\"+\u001a7fCN,\u0007+\u001a:tSN$XM\\2f\u00035QwN\u0019*fa>\u001c\u0018\u000e^8ssB\u0019q0a\u0002\u000e\u0005\u0005\u0005!bA\"\u0002\u0004)\u0019\u0011Q\u0001#\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018\u0002BA\u0005\u0003\u0003\u0011QBS8c%\u0016\u0004xn]5u_JL\u0018A\u0002\u001fj]&$h\b\u0006\t\u0002\u0010\u0005E\u00111CA\u000b\u0003/\tI\"a\u0007\u0002\u001eA\u0011\u0011\u000f\u0001\u0005\u0006=\"\u0001\ra\u0018\u0005\u0006O\"\u0001\r\u0001\u001b\u0005\u0006W\"\u0001\r\u0001\u001c\u0005\u0006_\"\u0001\r\u0001\u001d\u0005\u0006i\"\u0001\r!\u001e\u0005\u0006s\"\u0001\rA\u001f\u0005\u0006{\"\u0001\rA`\u0001\u0017%\u0016cU)Q*F?J+e)\u0012*F\u001d\u000e+u\fV-Q\u000bV\u0011\u00111\u0005\t\u0005\u0003K\t\u0019D\u0004\u0003\u0002(\u0005=\u0002cAA\u0015\u001d6\u0011\u00111\u0006\u0006\u0004\u0003[Q\u0015A\u0002\u001fs_>$h(C\u0002\u000229\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u001b\u0003o\u0011aa\u0015;sS:<'bAA\u0019\u001d\u00069\"+\u0012'F\u0003N+uLU#G\u000bJ+ejQ#`)f\u0003V\tI\u0001\u0018)\u0016k\u0005\u000bT!U\u000b~\u0013VIR#S\u000b:\u001bUi\u0018+Z!\u0016\u000b\u0001\u0004V#N!2\u000bE+R0S\u000b\u001a+%+\u0012(D\u000b~#\u0016\fU#!\u0003Y!&+S$H\u000bJ{&+\u0012$F%\u0016s5)R0U3B+\u0015a\u0006+S\u0013\u001e;UIU0S\u000b\u001a+%+\u0012(D\u000b~#\u0016\fU#!\u0003M!\u0016iU&`%\u00163UIU#O\u0007\u0016{F+\u0017)F\u0003Q!\u0016iU&`%\u00163UIU#O\u0007\u0016{F+\u0017)FA\u00051Q.\u00199qKJ,\"!a\u0013\u0011\t\u00055\u00131L\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u0005AA-\u0019;bE&tGM\u0003\u0003\u0002V\u0005]\u0013a\u00026bG.\u001cxN\u001c\u0006\u0004\u00033B\u0015!\u00034bgR,'\u000f_7m\u0013\u0011\ti&a\u0014\u0003\u0019=\u0013'.Z2u\u001b\u0006\u0004\b/\u001a:\u0002\u000f5\f\u0007\u000f]3sA\u000511M]3bi\u0016,B!!\u001a\u0002lQ!\u0011qMAB!\u0011\tI'a\u001b\r\u0001\u00119\u0011QN\nC\u0002\u0005=$!\u0001+\u0012\t\u0005E\u0014q\u000f\t\u0004\u001b\u0006M\u0014bAA;\u001d\n9aj\u001c;iS:<\u0007\u0003BA=\u0003\u007fj!!a\u001f\u000b\u0007\u0005uD)\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003\u0003\u000bYHA\tCCN,7i\u001c8gS\u001e,(/\u0019;j_:DaAY\nA\u0002\u0005\u001d\u0004fA\n\u0002\bB!\u0011\u0011RAN\u001b\t\tYI\u0003\u0003\u0002\u000e\u0006=\u0015AC1o]>$\u0018\r^5p]*!\u0011\u0011SAJ\u0003\u0011\u0019wN]3\u000b\t\u0005U\u0015qS\u0001\u000b[&\u001c'o\\7fi\u0016\u0014(BAAM\u0003\tIw.\u0003\u0003\u0002\u001e\u0006-%!\u0002+j[\u0016$W\u0003BAQ\u0003K#b!a)\u0002(\u0006%\u0006\u0003BA5\u0003K#q!!\u001c\u0015\u0005\u0004\ty\u0007\u0003\u0004c)\u0001\u0007\u00111\u0015\u0005\b\u0003W#\u0002\u0019AAW\u0003-1w\u000e\u001c3fe\u000eKW+\u001b3\u0011\t\u0005=\u0016Q\u001a\b\u0005\u0003c\u000bIM\u0004\u0003\u00024\u0006\u001dg\u0002BA[\u0003\u000btA!a.\u0002D:!\u0011\u0011XAa\u001d\u0011\tY,a0\u000f\t\u0005%\u0012QX\u0005\u0002\u0013&\u0011q\tS\u0005\u0003\u000b\u001aK!a\u0011#\n\u0005\u0005\u0013\u0015B\u00013A\u0013\r\tYmY\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty-!5\u0003\u000b\rKW+\u001b3\u000b\u0007\u0005-7\rK\u0002\u0015\u0003\u000f\u000babZ3u\r>dG-\u001a:DSVKG\r\u0006\u0003\u0002.\u0006e\u0007bBAn+\u0001\u0007\u00111E\u0001\tM>dG-\u001a:JI\u0006\u00012\r[3dW\u000e\u000b'\u000fZ5oC2LG/_\u000b\u0005\u0003C\fi\u000f\u0006\u0003\u0002d\u0006%\bcA'\u0002f&\u0019\u0011q\u001d(\u0003\tUs\u0017\u000e\u001e\u0005\u0007EZ\u0001\r!a;\u0011\t\u0005%\u0014Q\u001e\u0003\b\u0003[2\"\u0019AA8\u0003\u0011\u0011X-\u00193\u0016\t\u0005M\u0018q\u001f\u000b\u0005\u0003k\fI\u0010\u0005\u0003\u0002j\u0005]HaBA7/\t\u0007\u0011q\u000e\u0005\b\u0003w<\u0002\u0019AA\u0012\u0003=\u0019wN\u001c4jOV\u0014\u0018\r^5p]&#\u0007fA\f\u0002\b\u00061Q\u000f\u001d3bi\u0016,BAa\u0001\u0003\bQ!!Q\u0001B\u0005!\u0011\tIGa\u0002\u0005\u000f\u00055\u0004D1\u0001\u0002p!1!\r\u0007a\u0001\u0005\u000bA3\u0001GAD+\u0011\u0011yAa\u0005\u0015\r\tE!Q\u0003B\f!\u0011\tIGa\u0005\u0005\u000f\u00055\u0014D1\u0001\u0002p!1!-\u0007a\u0001\u0005#Aq!a+\u001a\u0001\u0004\ti\u000bK\u0002\u001a\u0003\u000f\u000b\u0011BZ5oI\nK\u0018\nZ:\u0016\t\t}!1\u0007\u000b\u0005\u0005C\u0011)\u0004\u0005\u0004\u0003$\t5\"\u0011G\u0007\u0003\u0005KQAAa\n\u0003*\u0005!Q\u000f^5m\u0015\t\u0011Y#\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0018\u0005K\u0011A\u0001T5tiB!\u0011\u0011\u000eB\u001a\t\u001d\tiG\u0007b\u0001\u0003_BqAa\u000e\u001b\u0001\u0004\u0011I$\u0001\td_:4\u0017nZ;sCRLwN\\%egB1!1\bB\"\u0003GqAA!\u0010\u0003B9!\u0011\u0011\u0006B \u0013\u0005y\u0015bAAf\u001d&!!Q\tB$\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u0017t\u0005f\u0001\u000e\u0002\b\u0006ia-\u001b8e\u00032d')\u001f+za\u0016,BAa\u0014\u0003VQ!!\u0011\u000bB,!\u0019\u0011\u0019C!\f\u0003TA!\u0011\u0011\u000eB+\t\u001d\tig\u0007b\u0001\u0003_BqA!\u0017\u001c\u0001\u0004\u0011Y&\u0001\u0004dSRK\b/\u001a\t\u0005\u0005;\u0012y'\u0004\u0002\u0003`)!!\u0011\rB2\u0003\u001d\u0011XM\u001a7fGRTAA!\u001a\u0003h\u0005\u0019\u0011\r]5\u000b\t\t%$1N\u0001\u0007a2,x-\u001b8\u000b\u0007\t5d)\u0001\u0005eKBdw._5u\u0013\u0011\u0011\tHa\u0018\u0003\tQK\b/\u001a\u0015\u00047\u0005\u001d\u0015!\u00064j]\u0012\fE\u000e\u001c\"z)f\u0004X-\u00118e)&$H.Z\u000b\u0005\u0005s\u0012y\b\u0006\u0004\u0003|\t\u0005%1\u0011\t\u0007\u0005G\u0011iC! \u0011\t\u0005%$q\u0010\u0003\b\u0003[b\"\u0019AA8\u0011\u001d\u0011I\u0006\ba\u0001\u00057BqA!\"\u001d\u0001\u0004\t\u0019#A\u0003uSRdW\rK\u0002\u001d\u0003\u000f+BAa#\u0003\u0012RQ!Q\u0012BJ\u0005+\u00139J!'\u0011\r\t\r\"Q\u0006BH!\u0011\tIG!%\u0005\u000f\u00055TD1\u0001\u0002p!9!\u0011L\u000fA\u0002\tm\u0003\"\u0003BC;A\u0005\t\u0019AA\u0012\u0011\u001d\tY.\ba\u0001\u0003GAqAa'\u001e\u0001\u0004\u0011i*\u0001\u0006g_2$WM](oYf\u00042!\u0014BP\u0013\r\u0011\tK\u0014\u0002\b\u0005>|G.Z1oQ\ri\u0012qQ\u0001 M&tG-\u00117m\u0005f$\u0016\u0010]3B]\u0012$\u0016\u000e\u001e7fI\u0011,g-Y;mi\u0012\u0012T\u0003\u0002BU\u0005{+\"Aa++\t\u0005\r\"QV\u0016\u0003\u0005_\u0003BA!-\u0003:6\u0011!1\u0017\u0006\u0005\u0005k\u00139,A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0012(\n\t\tm&1\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GaBA7=\t\u0007\u0011qN\u0001\u0012e\u0016\fGmQ8oM&<WO]1uS>tW\u0003\u0002Bb\u0005\u001b$BA!2\u0003PB)QJa2\u0003L&\u0019!\u0011\u001a(\u0003\r=\u0003H/[8o!\u0011\tIG!4\u0005\u000f\u00055tD1\u0001\u0002p!9!\u0011[\u0010A\u0002\tM\u0017a\u0001:poB!!Q\u001bBp\u001d\u0011\u00119Na7\u000f\t\u0005E&\u0011\\\u0005\u0003E\u000eL1A!8b\u0003a\u0019uN\u001c4jOV\u0014\u0018\r^5p]B+'o]5ti\u0016t7-Z\u0005\u0005\u0005C\u0014\u0019O\u0001\tD_:4\u0017nZ;sCRLwN\u001c*po*\u0019!Q\\1\u00025\u0019Lg\u000eZ\"p]\u001aLw-\u001e:bi&|g\u000eV5uY\u0016\u0014\u00150\u00133\u0015\t\u0005\r\"\u0011\u001e\u0005\b\u0005W\u0004\u0003\u0019AA\u0012\u0003!\u0019wN\u001c4jO&#\u0007f\u0001\u0011\u0002\b\u0006!R\r_5tiN\u0014\u0015\u0010V=qK\u0006sG\rV5uY\u0016,BAa=\u0003zR1!Q\u0014B{\u0005oDqA!\u0017\"\u0001\u0004\u0011Y\u0006C\u0005\u0003\u0006\u0006\u0002\n\u00111\u0001\u0002$\u00119\u0011QN\u0011C\u0002\u0005=\u0004fA\u0011\u0002\b\"\u001a\u0011Ea@\u0011\t\r\u00051QB\u0007\u0003\u0007\u0007QAa!\u0002\u0004\b\u0005YAO]1og\u0006\u001cG/[8o\u0015\r\t5\u0011\u0002\u0006\u0004\u0007\u0017!\u0015A\u00013c\u0013\u0011\u0019yaa\u0001\u0003\u0015%\u001b(+Z1e\u001f:d\u00170\u0001\u0010fq&\u001cHo\u001d\"z)f\u0004X-\u00118e)&$H.\u001a\u0013eK\u001a\fW\u000f\u001c;%eU!!\u0011VB\u000b\t\u001d\tiG\tb\u0001\u0003_\nqBZ5oI\u001aK'o\u001d;CsRK\b/Z\u000b\u0005\u00077\u0019)\u0003\u0006\u0003\u0004\u001e\r\u001d\u0002C\u0002B\u0012\u0007?\u0019\u0019#\u0003\u0003\u0004\"\t\u0015\"\u0001C(qi&|g.\u00197\u0011\t\u0005%4Q\u0005\u0003\b\u0003[\u001a#\u0019AA8\u0011\u001d\u0011If\ta\u0001\u00057B3aIAD+\u0011\u0019ica\r\u0015\r\r=2QGB\u001c!\u0019\u0011\u0019ca\b\u00042A!\u0011\u0011NB\u001a\t\u001d\ti\u0007\nb\u0001\u0003_BqA!\u0017%\u0001\u0004\u0011Y\u0006C\u0004\u0004:\u0011\u0002\raa\u000f\u0002\u000f\r|g\u000e^3yiB!1QHB$\u001b\t\u0019yD\u0003\u0003\u0004B\r\r\u0013!D:fe&\fG.\u001b>bi&|gN\u0003\u0003\u0004F\t-\u0014\u0001\u00039mk6\u0014\u0017N\\4\n\t\r%3q\b\u0002\u0012%\u0016\u001cx\u000e\\;uS>t7i\u001c8uKb$\bf\u0001\u0013\u0002\b\u00061Q\r_5tiN$BA!(\u0004R!9\u00111`\u0013A\u0002\u0005\r\u0002fA\u0013\u0002\b\"\u001aQEa@\u0002/\u001d,GoQ8oM&<'+\u001a4fe\u0016t7-\u001a3S_^\u001cHCBB.\u0007S\u001aY\u0007\u0005\u0004\u0003<\t\r3Q\f\t\u0005\u0007?\u001a)'\u0004\u0002\u0004b)\u001911M2\u0002\t\u0011\fG/Y\u0005\u0005\u0007O\u001a\tGA\rD_:4\u0017nZ;sCRLwN\u001c*fM\u0016\u0014XM\\2f%><\bbBA~M\u0001\u0007\u00111\u0005\u0005\b\u0007[2\u0003\u0019AB8\u0003\u0005\u001awN\u001c4jOV\u0014\u0018\r^5p]J+g-\u001a:f]\u000e,\u0007+\u001a:tSN$XM\\2f!\r\u00017\u0011O\u0005\u0004\u0007g\n'!I\"p]\u001aLw-\u001e:bi&|gNU3gKJ,gnY3QKJ\u001c\u0018n\u001d;f]\u000e,\u0017A\u00023fY\u0016$X\r\u0006\u0003\u0002d\u000ee\u0004bBA~O\u0001\u0007\u00111\u0005\u0015\u0004O\u0005\u001d\u0015AF4fi*{'MU;o]\u0016\u0014(+\u001a4fe\u0016t7-Z:\u0015\t\r\u00055\u0011\u0012\t\u0007\u0005w\u0011\u0019ea!\u0011\u0007E\u001c))C\u0002\u0004\b\u0002\u0013\u0001CU3gKJ,gnY3e\u000b:$\u0018\u000e^=\t\u000f\u0005m\b\u00061\u0001\u0002$\u0005!r-\u001a;SK\u001a,'/\u001a8dKJ+G.Z1tKN$Baa$\u0004\u001eB1!1\u0005B\u0017\u0007#\u0003Baa%\u0004\u001a6\u00111Q\u0013\u0006\u0004\u0007/\u0013\u0015!B9vKJL\u0018\u0002BBN\u0007+\u0013\u0001CU3mK\u0006\u001cXMQ1tS\u000e$\u0015\r^1\t\u000f\u0005m\u0018\u00061\u0001\u0002$!\u001a\u0011&a\"\u0002!\u001d,G/\u00117m'V\u0014G+\u001f9fg>3W\u0003BBS\u0007\u0003$Baa*\u0004@B11\u0011VBZ\u0007kk!aa+\u000b\t\r56qV\u0001\nS6lW\u000f^1cY\u0016T1a!-O\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u000b\u001aY\u000b\u0005\u0003\u00048\u000euVBAB]\u0015\u0011\u0019YL!\u000b\u0002\t1\fgnZ\u0005\u0005\u0003k\u0019I\fC\u0004\u0003Z)\u0002\rAa\u0017\u0005\u000f\u00055$F1\u0001\u0002p\u0005Yq-\u001a;BY2$\u0016\u0010]3t+\t\u0011I\u0004K\u0002,\u0003\u000f\u000bQ\u0002Z3mKR,')\u001f+za\u0016\u001cH\u0003BAr\u0007\u001bDqaa4-\u0001\u0004\u0011I$A\u0004dSRK\b/Z:)\u00071\n9)\u0001\u0005wC2LG-\u0019;f)\u0011\t\u0019oa6\t\r\tl\u0003\u0019AA<Q\r\u000111\u001c\t\u0005\u0007\u0003\u0019i.\u0003\u0003\u0004`\u000e\r!aD%t)J\fgn]1di&|g.\u00197\u00025M\u000bHnQ8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0011\u0005E|3CA\u0018M)\t\u0019\u0019OA\u0004UsB,w\n]:\u0014\u0005Eb\u0015A\u0002=m)f\u0004X\r\u0006\u0003\u0004r\u000eU\bcABzc5\tq\u0006C\u0004\u0004nN\u0002\rAa\u0017\u0002\u001d!\f7oQ1sI&t\u0017\r\\5usV\u0011!QT\u0001\fQ\u0006\u001c\bK]8qKJ$\u0018\u0010\u0006\u0003\u0003\u001e\u000e}\bb\u0002C\u0001k\u0001\u0007\u00111E\u0001\raJ|\u0007/\u001a:us:\u000bW.Z\u0001\b)f\u0004Xm\u00149t)\u0011\u0019\t\u0010b\u0002\t\u000f\r5h\u00071\u0001\u0003\\\t!\")Y:f\u0007>tg-[4ve\u0006$\u0018n\u001c8PaN\u001c\"a\u000e'\u0002\u0005\rLG\u0003\u0002C\t\t'\u00012aa=8\u0011\u001d!i!\u000fa\u0001\u0003o*\"Aa\u0017\u0002\u000f\rLG+\u001f9fA\u0005qq-\u001a;DCJ$\u0017N\\1mSRLXC\u0001C\u000f!\u0015i%q\u0019C\u0010!\riE\u0011E\u0005\u0004\tGq%aA%oi\u0006!\")Y:f\u0007>tg-[4ve\u0006$\u0018n\u001c8PaN$B\u0001\"\u0005\u0005*!9AQ\u0002 A\u0002\u0005]\u0004")
public class SqlConfigurationRepository
implements ConfigurationRepository,
Logging {
    private final ConfigurationPersistence configurationPersistence;
    private final ReleaseConfigurationReferencePersistence releaseConfigurationReferencePersistence;
    private final TriggerConfigurationReferencePersistence triggerConfigurationReferencePersistence;
    private final SqlRepositoryAdapter sqlRepositoryAdapter;
    private final FolderPersistence folderPersistence;
    private final JobRepository jobRepository;
    private final String RELEASE_REFERENCE_TYPE;
    private final String TEMPLATE_REFERENCE_TYPE;
    private final String TRIGGER_REFERENCE_TYPE;
    private final String TASK_REFERENCE_TYPE;
    private final ObjectMapper mapper;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private scala.collection.immutable.Seq<PersistenceInterceptor<BaseConfiguration>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public ThemeSettings getThemeSettings() {
        return ConfigurationRepository.getThemeSettings$((ConfigurationRepository)this);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<BaseConfiguration> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlConfigurationRepository sqlConfigurationRepository = this;
        synchronized (sqlConfigurationRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<BaseConfiguration>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<BaseConfiguration>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    private String RELEASE_REFERENCE_TYPE() {
        return this.RELEASE_REFERENCE_TYPE;
    }

    private String TEMPLATE_REFERENCE_TYPE() {
        return this.TEMPLATE_REFERENCE_TYPE;
    }

    private String TRIGGER_REFERENCE_TYPE() {
        return this.TRIGGER_REFERENCE_TYPE;
    }

    private String TASK_REFERENCE_TYPE() {
        return this.TASK_REFERENCE_TYPE;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    @Timed
    public <T extends BaseConfiguration> T create(T configuration) {
        return this.create(configuration, this.getFolderCiUid(configuration.getFolderId()));
    }

    @Timed
    public <T extends BaseConfiguration> T create(T configuration, Integer folderCiUid) {
        this.checkCardinality(configuration);
        this.validate(configuration);
        this.interceptCreate((ConfigurationItem)configuration);
        this.configurationPersistence.insert(configuration, folderCiUid);
        this.afterCreate((ConfigurationItem)configuration);
        return configuration;
    }

    private Integer getFolderCiUid(String folderId) {
        String string = folderId;
        switch (string == null ? 0 : string.hashCode()) {
            case 0: {
                if (string != null) break;
                return null;
            }
        }
        return this.folderPersistence.getUid(string);
    }

    private <T extends BaseConfiguration> void checkCardinality(T configuration) {
        Type configurationType = Type.valueOf(BaseConfiguration.class);
        if (SqlConfigurationRepository$.MODULE$.com$xebialabs$xlrelease$repository$sql$SqlConfigurationRepository$$BaseConfigurationOps(configuration).hasCardinality()) {
            Type configGroupType = (Type)SqlConfigurationRepository.groupType$1(configuration, configurationType).getOrElse((Function0 & Serializable)() -> configuration.getType());
            Buffer foundConfigs = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.findAllByTypeAndTitle(configGroupType, null, configuration.getFolderId(), false)).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SqlConfigurationRepository.$anonfun$checkCardinality$3(configuration, x$1)));
            Option<Object> cardinality = SqlConfigurationRepository$.MODULE$.com$xebialabs$xlrelease$repository$sql$SqlConfigurationRepository$$BaseConfigurationOps(configuration).getCardinality();
            if (cardinality.isDefined() && foundConfigs.size() >= BoxesRunTime.unboxToInt((Object)cardinality.get())) {
                String folderId = configuration.getFolderId() == null ? Ids.ROOT_FOLDER_ID : configuration.getFolderId();
                throw new ItemAlreadyExistsException("There are already " + foundConfigs.length() + " items of type '" + configGroupType + "' defined on the folder '" + folderId + "'", new Object[0]);
            }
            return;
        }
    }

    @Timed
    public <T extends BaseConfiguration> T read(String configurationId) {
        return (T)((BaseConfiguration)Option$.MODULE$.apply(this.sqlRepositoryAdapter.read(configurationId)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Configuration " + configurationId + " not found", new Object[0]);
        }));
    }

    @Timed
    public <T extends BaseConfiguration> T update(T configuration) {
        return this.update(configuration, this.getFolderCiUid(configuration.getFolderId()));
    }

    @Timed
    public <T extends BaseConfiguration> T update(T configuration, Integer folderCiUid) {
        this.validate(configuration);
        this.interceptUpdate((ConfigurationItem)configuration);
        this.configurationPersistence.update(configuration);
        this.afterUpdate((ConfigurationItem)configuration);
        return configuration;
    }

    @Timed
    public <T extends BaseConfiguration> java.util.List<T> findByIds(scala.collection.immutable.Seq<String> configurationIds) {
        return CollectionConverters$.MODULE$.BufferHasAsJava(((IterableOnceOps)this.configurationPersistence.findByIds(configurationIds).flatMap((Function1 & Serializable)row -> this.readConfiguration((Tuple2<Option<FolderId>, String>)row))).toBuffer()).asJava();
    }

    @Timed
    public <T extends BaseConfiguration> java.util.List<T> findAllByType(Type ciType) {
        return CollectionConverters$.MODULE$.BufferHasAsJava(((IterableOnceOps)this.configurationPersistence.findByTypes(this.getAllSubTypesOf(ciType)).flatMap((Function1 & Serializable)row -> this.readConfiguration((Tuple2<Option<FolderId>, String>)row))).toBuffer()).asJava();
    }

    @Timed
    public <T extends BaseConfiguration> java.util.List<T> findAllByTypeAndTitle(Type ciType, String title) {
        return this.findAllByTypeAndTitle(ciType, title, null, false);
    }

    @Timed
    public <T extends BaseConfiguration> java.util.List<T> findAllByTypeAndTitle(Type ciType, String title, String folderId, boolean folderOnly) {
        return CollectionConverters$.MODULE$.BufferHasAsJava(((IterableOnceOps)this.configurationPersistence.findByTypesTitleAndFolder(this.getAllSubTypesOf(ciType), (Option<String>)Option$.MODULE$.apply((Object)title).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2.trim())))), (Option<Either<String, String>>)Option$.MODULE$.apply((Object)folderId).map((Function1)(folderOnly ? (Function1 & Serializable)value -> new Right(value) : (Function1 & Serializable)value -> new Left(value)))).flatMap((Function1 & Serializable)row -> this.readConfiguration((Tuple2<Option<FolderId>, String>)row))).toBuffer()).asJava();
    }

    public <T extends BaseConfiguration> String findAllByTypeAndTitle$default$2() {
        return null;
    }

    private <T extends BaseConfiguration> Option<T> readConfiguration(Tuple2<Option<FolderId>, String> row) {
        Tuple2<Option<FolderId>, String> tuple2 = row;
        if (tuple2 != null) {
            Option folderIdOpt = (Option)tuple2._1();
            String rawConfiguration = (String)tuple2._2();
            return this.sqlRepositoryAdapter.deserialize(rawConfiguration).map((Function1 & Serializable)conf -> (BaseConfiguration)folderIdOpt.fold((Function0 & Serializable)() -> conf, (Function1 & Serializable)folderId -> {
                conf.setFolderId(folderId.absolute());
                return conf;
            }));
        }
        throw new MatchError(tuple2);
    }

    @Timed
    public String findConfigurationTitleById(String configId) {
        return this.configurationPersistence.findConfigurationTitleById(configId);
    }

    @Timed
    @IsReadOnly
    public <T extends BaseConfiguration> boolean existsByTypeAndTitle(Type ciType, String title) {
        return this.configurationPersistence.existsByTypeAndTitle(this.getAllSubTypesOf(ciType), title);
    }

    @Timed
    public <T extends BaseConfiguration> Optional<T> findFirstByType(Type ciType) {
        return this.findFirstByType(ciType, ResolutionContext$.MODULE$.GLOBAL());
    }

    @Timed
    public <T extends BaseConfiguration> Optional<T> findFirstByType(Type ciType, ResolutionContext context) {
        return OptionConverters.RichOption$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOption(this.configurationPersistence.findFirstByTypes(this.getAllSubTypesOf(ciType), (Option<String>)context.folderId()).flatMap((Function1 & Serializable)row -> this.readConfiguration((Tuple2<Option<FolderId>, String>)row))));
    }

    @Timed
    @IsReadOnly
    public boolean exists(String configurationId) {
        return this.configurationPersistence.exists(configurationId);
    }

    public <T extends BaseConfiguration> String existsByTypeAndTitle$default$2() {
        return null;
    }

    private scala.collection.immutable.Seq<ConfigurationReferenceRow> getConfigReferencedRows(String configurationId, ConfigurationReferencePersistence configurationReferencePersistence) {
        if (configurationReferencePersistence.isReferenced(configurationId)) {
            return configurationReferencePersistence.getReferencingEntities(configurationId);
        }
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    @Timed
    public void delete(String configurationId) {
        if (this.exists(configurationId)) {
            SeqOps seqOps;
            scala.collection.immutable.Seq allReferences;
            scala.collection.immutable.Seq seq;
            Object config = this.read(configurationId);
            if (config.getType().isSubTypeOf(Type.valueOf(JobRunner.class))) {
                seq = this.getJobRunnerReferences(configurationId);
            } else {
                scala.collection.immutable.Seq configReferencesInRelease = (scala.collection.immutable.Seq)this.getConfigReferencedRows(configurationId, this.releaseConfigurationReferencePersistence).map((Function1 & Serializable)configRef -> new ReferencedEntity(configRef.id(), configRef.title(), this.RELEASE_REFERENCE_TYPE()));
                scala.collection.immutable.Seq configReferencesInTrigger = (scala.collection.immutable.Seq)this.getConfigReferencedRows(configurationId, this.triggerConfigurationReferencePersistence).map((Function1 & Serializable)configRef -> new ReferencedEntity(configRef.id(), configRef.title(), this.TRIGGER_REFERENCE_TYPE()));
                seq = (scala.collection.immutable.Seq)configReferencesInRelease.$plus$plus((IterableOnce)configReferencesInTrigger);
            }
            scala.collection.immutable.Seq seq2 = allReferences = seq;
            if (seq2 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0) {
                this.interceptDelete(configurationId);
                this.configurationPersistence.delete(configurationId);
                this.afterDelete(configurationId);
                return;
            }
            this.mapper().registerModule((Module)DefaultScalaModule$.MODULE$);
            String json = this.mapper().writeValueAsString(allReferences);
            throw new ItemInUseException("%s", new Object[]{json});
        }
    }

    public scala.collection.immutable.Seq<ReferencedEntity> getJobRunnerReferences(String configurationId) {
        JobFilters jobFilters = new JobFilters();
        jobFilters.runnerId_$eq(configurationId);
        Page jobs = this.jobRepository.findAllJobOverview(jobFilters, Pageable.unpaged());
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(jobs.getContent()).asScala().map((Function1 & Serializable)overview -> new ReferencedEntity(overview.taskId(), overview.taskTitle(), this.TASK_REFERENCE_TYPE()))).toSeq();
    }

    @Timed
    public java.util.List<ReleaseBasicData> getReferenceReleases(String configurationId) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.releaseConfigurationReferencePersistence.getReferencingEntities(configurationId).map((Function1 & Serializable)x$3 -> ConfigurationReferenceRow$.MODULE$.ConfigurationReferenceDataOps((ConfigurationReferenceRow)x$3).asReleaseData())).asJava();
    }

    private <T extends BaseConfiguration> scala.collection.immutable.Seq<String> getAllSubTypesOf(Type ciType) {
        return (scala.collection.immutable.Seq)TypeHelper$.MODULE$.getAllSubtypesOf(ciType).map((Function1 & Serializable)x$4 -> x$4.toString());
    }

    @Timed
    public scala.collection.immutable.Seq<String> getAllTypes() {
        return this.configurationPersistence.findAllConfigurationTypes();
    }

    @Timed
    public void deleteByTypes(scala.collection.immutable.Seq<String> ciTypes) {
        scala.collection.immutable.Seq<Integer> configurationCiUids = this.configurationPersistence.findUidsByTypes(ciTypes);
        this.releaseConfigurationReferencePersistence.deleteRefsByConfigurationUids(configurationCiUids);
        this.triggerConfigurationReferencePersistence.deleteRefsByConfigurationUids(configurationCiUids);
        this.configurationPersistence.deleteByTypes(ciTypes);
    }

    private void validate(BaseConfiguration configuration) {
        ListBuffer passVarUsagePoints = ListBuffer$.MODULE$.empty();
        BaseConfiguration baseConfiguration = configuration;
        if (baseConfiguration instanceof Configuration) {
            Configuration configuration2 = (Configuration)baseConfiguration;
            ConfigurationVariableService$.MODULE$.getUsagePointsByVars((Iterable)new .colon.colon((Object)configuration2, (List)Nil$.MODULE$)).values().foreach((Function1 & Serializable)usagePoints -> {
                usagePoints.foreach((Function1 & Serializable)up -> {
                    CiProperty targetProperty = up.getTargetProperty();
                    PropertyDescriptor desc = targetProperty.getDescriptor();
                    PropertyKind propertyKind = desc.getKind();
                    PropertyKind propertyKind2 = PropertyKind.STRING;
                    Checks.checkArgument((!(propertyKind != null ? !propertyKind.equals(propertyKind2) : propertyKind2 != null) && desc.isPassword() ? 1 : 0) != 0, (String)"Non-password-type variables in configuration variableMapping are not supported", (Object[])new Object[0]);
                    targetProperty.setValue((Object)"<temporary_value>");
                    return (ListBuffer)passVarUsagePoints$1.$plus$eq(up);
                });
                return BoxedUnit.UNIT;
            });
        }
        Descriptor desc = configuration.getType().getDescriptor();
        ExtendedValidationContextImpl extendedValidationContext = new ExtendedValidationContextImpl((ConfigurationItem)configuration);
        desc.validate((ExtendedValidationContext)extendedValidationContext, (ConfigurationItem)configuration);
        java.util.List messages = extendedValidationContext.getMessages();
        Object object = !messages.isEmpty() ? BoxesRunTime.boxToBoolean((boolean)configuration.get$validationMessages().addAll(messages)) : BoxedUnit.UNIT;
        if (!configuration.get$validationMessages().isEmpty()) {
            throw new XlrValidationsFailedException((ConfigurationItem)configuration);
        }
        passVarUsagePoints.toList().foreach((Function1 & Serializable)up -> {
            SqlConfigurationRepository.$anonfun$validate$3(up);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$checkCardinality$1(Type configurationType$1, BaseConfiguration configuration$1, Type superType) {
        if (!superType.isSubTypeOf(configurationType$1)) return false;
        if (!SqlConfigurationRepository$.MODULE$.com$xebialabs$xlrelease$repository$sql$SqlConfigurationRepository$$TypeOps(superType).hasCardinality()) return false;
        Integer n = BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)superType.getDescriptor().getPropertyDescriptor("cardinality").getDefaultValue()));
        Option<Object> option = SqlConfigurationRepository$.MODULE$.com$xebialabs$xlrelease$repository$sql$SqlConfigurationRepository$$BaseConfigurationOps(configuration$1).getCardinality();
        if (n != null) {
            if (!((Object)n).equals(option)) return false;
            return true;
        }
        if (option == null) return true;
        return false;
    }

    private static final Option groupType$1(BaseConfiguration configuration, Type configurationType$1) {
        java.util.List superClasses = configuration.getType().getDescriptor().getSuperClasses();
        return CollectionConverters$.MODULE$.ListHasAsScala(superClasses).asScala().find((Function1 & Serializable)superType -> BoxesRunTime.boxToBoolean((boolean)SqlConfigurationRepository.$anonfun$checkCardinality$1(configurationType$1, configuration, superType)));
    }

    public static final /* synthetic */ boolean $anonfun$checkCardinality$3(BaseConfiguration configuration$2, BaseConfiguration x$1) {
        String string = x$1.getFolderId();
        String string2 = configuration$2.getFolderId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$validate$3(UsagePoint up) {
        up.getTargetProperty().setValue(null);
    }

    public SqlConfigurationRepository(ConfigurationPersistence configurationPersistence, ReleaseConfigurationReferencePersistence releaseConfigurationReferencePersistence, TriggerConfigurationReferencePersistence triggerConfigurationReferencePersistence, SqlRepositoryAdapter sqlRepositoryAdapter, FolderPersistence folderPersistence, ReleasePersistence releasePersistence, JobRepository jobRepository) {
        this.configurationPersistence = configurationPersistence;
        this.releaseConfigurationReferencePersistence = releaseConfigurationReferencePersistence;
        this.triggerConfigurationReferencePersistence = triggerConfigurationReferencePersistence;
        this.sqlRepositoryAdapter = sqlRepositoryAdapter;
        this.folderPersistence = folderPersistence;
        this.jobRepository = jobRepository;
        InterceptedRepository.$init$((InterceptedRepository)this);
        ConfigurationRepository.$init$((ConfigurationRepository)this);
        Logging.$init$((Logging)this);
        this.RELEASE_REFERENCE_TYPE = "Release";
        this.TEMPLATE_REFERENCE_TYPE = "Template";
        this.TRIGGER_REFERENCE_TYPE = "Trigger";
        this.TASK_REFERENCE_TYPE = "Task";
        this.mapper = new ObjectMapper();
    }

    private static class BaseConfigurationOps {
        private final BaseConfiguration ci;
        private final Type ciType;

        private Type ciType() {
            return this.ciType;
        }

        public boolean hasCardinality() {
            return this.ci.hasProperty("cardinality");
        }

        public Option<Object> getCardinality() {
            if (this.hasCardinality()) {
                return new Some((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)this.ciType().getDescriptor().getPropertyDescriptor("cardinality").getDefaultValue())));
            }
            return None$.MODULE$;
        }

        public BaseConfigurationOps(BaseConfiguration ci) {
            this.ci = ci;
            this.ciType = ci.getType();
        }
    }

    private static class TypeOps {
        private final Type xlType;

        public boolean hasCardinality() {
            return this.hasProperty("cardinality");
        }

        public boolean hasProperty(String propertyName) {
            return this.xlType.getDescriptor().getPropertyDescriptor(propertyName) != null;
        }

        public TypeOps(Type xlType) {
            this.xlType = xlType;
        }
    }
}

