package com.xebialabs.xlrelease.spring.config

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.security.sql.SecurityCacheConfigurationCondition
import com.xebialabs.xlrelease.support.cache.caffeine.spring.XlrCaffeineCacheManager
import org.springframework.cache.CacheManager
import org.springframework.context.annotation.{Bean, Conditional, Configuration}

@Configuration
@Conditional(value = Array(classOf[SecurityCacheConfigurationCondition]))
class SecurityCacheConfiguration {

  @Bean
  def securityCacheManager(xlrConfig: XlrConfig): CacheManager = {
    new XlrCaffeineCacheManager("securityCacheManager", "security", xlrConfig.cache)
  }

}

