package com.xebialabs.xlrelease.repository.sql.persistence

import com.xebialabs.xlrelease.domain.events.{ReleaseActorStarted, ReleaseActorStopped, ReleaseRiskScoreUpdated}
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}


@EventListener
class ReleaseCacheEventHandler {

  @Subscribe
  def onActorStart(event: ReleaseActorStarted): Unit = {
    ReleaseCacheService.invalidate(event.releaseId)
    ReleaseCacheService.allow(event.releaseId)
  }

  @Subscribe
  def onActorStop(event: ReleaseActorStopped): Unit = {
    ReleaseCacheService.disallow(event.releaseId)
    ReleaseCacheService.invalidate(event.releaseId)
  }

  @Subscribe
  def onRiskUpdate(event: ReleaseRiskScoreUpdated): Unit = {
    event match {
      case ReleaseRiskScoreUpdated(releaseId, riskScore, totalRiskScore) =>
        ReleaseCacheService.get(event.releaseId).foreach { releaseRow =>
          val updatedRow = releaseRow.copy(riskScore = riskScore, totalRiskScore = totalRiskScore)
          ReleaseCacheService.put(releaseId, updatedRow)
        }
    }
  }
}
