/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security;

import com.xebialabs.xlrelease.domain.distributed.events.DistributedGroupDeleted;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedUserGroupMembershipUpdated;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedXLReleaseEvent;
import com.xebialabs.xlrelease.security.UserGroupRepository;
import com.xebialabs.xlrelease.service.BroadcastService;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@CacheConfig(cacheManager="securityUserGroupCacheManager")
@ScalaSignature(bytes="\u0006\u0005\u0005\ra\u0001B\u0007\u000f\u0001]A\u0001B\t\u0001\u0003\u0002\u0003\u0006IA\b\u0005\tG\u0001\u0011\t\u0011)A\u0005I!)!\u0006\u0001C\u0001W!)q\u0006\u0001C!a!)\u0001\f\u0001C!3\")A\f\u0001C!;\")\u0001\r\u0001C!C\")a\r\u0001C!O\")!\u000e\u0001C!W\")a\u000e\u0001C!_\")!\u000f\u0001C!g\")a\u000f\u0001C!o\nY2+\u001d7Vg\u0016\u0014xI]8vaJ+\u0007o\\:ji>\u0014\u0018pQ1dQ\u0016T!a\u0004\t\u0002\u0011M,7-\u001e:jifT!!\u0005\n\u0002\u0013ad'/\u001a7fCN,'BA\n\u0015\u0003%AXMY5bY\u0006\u00147OC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0001D\b\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}\u0001S\"\u0001\b\n\u0005\u0005r!aE+tKJ<%o\\;q%\u0016\u0004xn]5u_JL\u0018aE;tKJ<%o\\;q%\u0016\u0004xn]5u_JL\u0018\u0001\u00052s_\u0006$7-Y:u'\u0016\u0014h/[2f!\t)\u0003&D\u0001'\u0015\t9\u0003#A\u0004tKJ4\u0018nY3\n\u0005%2#\u0001\u0005\"s_\u0006$7-Y:u'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}Q\u0019A&\f\u0018\u0011\u0005}\u0001\u0001\"\u0002\u0012\u0004\u0001\u0004q\u0002\"B\u0012\u0004\u0001\u0004!\u0013!\u00054j]\u0012<%o\\;qg\u001a{'/V:feR\u0011\u0011g\u0010\t\u0004eebdBA\u001a8!\t!$$D\u00016\u0015\t1d#\u0001\u0004=e>|GOP\u0005\u0003qi\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001e<\u0005\r\u0019V\r\u001e\u0006\u0003qi\u0001\"AM\u001f\n\u0005yZ$AB*ue&tw\rC\u0003A\t\u0001\u0007A(\u0001\u0005vg\u0016\u0014h.Y7fQ!!!IT(S'V3\u0006CA\"M\u001b\u0005!%BA#G\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u000f\"\u000bQaY1dQ\u0016T!!\u0013&\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011aS\u0001\u0004_J<\u0017BA'E\u0005%\u0019\u0015m\u00195fC\ndW-\u0001\u0006dC\u000eDWMT1nKNd\u0013\u0001U\u0011\u0002#\u0006YQo]3s[\u001d\u0014x.\u001e9t\u0003\rYW-_\u0011\u0002)\u0006I1%^:fe:\fW.Z\u0001\u0007k:dWm]:\"\u0003]\u000bqb\t:fgVdGOL5t\u000b6\u0004H/_\u0001\fGJ,\u0017\r^3He>,\b\u000f\u0006\u0002=5\")1,\u0002a\u0001y\u0005IqM]8va:\u000bW.Z\u0001\rGJ,\u0017\r^3He>,\bo\u001d\u000b\u0003cyCQa\u0018\u0004A\u0002E\n!b\u001a:pkBt\u0015-\\3t\u0003-!W\r\\3uK\u001e\u0013x.\u001e9\u0015\u0005\t,\u0007CA\rd\u0013\t!'D\u0001\u0003V]&$\b\"B.\b\u0001\u0004a\u0014AD1eIV\u001bXM\u001d+p\u000fJ|W\u000f\u001d\u000b\u0004E\"L\u0007\"\u0002!\t\u0001\u0004a\u0004\"B.\t\u0001\u0004a\u0014a\u0005:f[>4X-V:fe\u001a\u0013x.\\$s_V\u0004Hc\u00012m[\")\u0001)\u0003a\u0001y!)1,\u0003a\u0001y\u0005iR\u000f\u001d3bi\u0016<%o\\;qg6+WNY3sg\"L\u0007OR8s+N,'\u000fF\u0002caFDQ\u0001\u0011\u0006A\u0002qBQa\u0018\u0006A\u0002E\nq\"\u00193e+N,'\u000fV8He>,\bo\u001d\u000b\u0004ER,\b\"\u0002!\f\u0001\u0004a\u0004\"B0\f\u0001\u0004\t\u0014\u0001\u0006:f[>4X-V:fe\u001a\u0013x.\\$s_V\u00048\u000fF\u0002cqfDQ\u0001\u0011\u0007A\u0002qBQa\u0018\u0007A\u0002EBC\u0001A>\u007f\u007fB\u00111\t`\u0005\u0003{\u0012\u00131bQ1dQ\u0016\u001cuN\u001c4jO\u0006a1-Y2iK6\u000bg.Y4fe\u0006\u0012\u0011\u0011A\u0001\u001eg\u0016\u001cWO]5usV\u001bXM]$s_V\u00048)Y2iK6\u000bg.Y4fe\u0002")
public class SqlUserGroupRepositoryCache
implements UserGroupRepository {
    private final UserGroupRepository userGroupRepository;
    private final BroadcastService broadcastService;

    @Cacheable(cacheNames={"user-groups"}, key="#username", unless="#result.isEmpty")
    public Set<String> findGroupsForUser(String username) {
        return this.userGroupRepository.findGroupsForUser(username);
    }

    public String createGroup(String groupName) {
        return this.userGroupRepository.createGroup(groupName);
    }

    public Set<String> createGroups(Set<String> groupNames) {
        return this.userGroupRepository.createGroups(groupNames);
    }

    public void deleteGroup(String groupName) {
        this.userGroupRepository.deleteGroup(groupName);
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedGroupDeleted(groupName), true);
    }

    public void addUserToGroup(String username, String groupName) {
        this.userGroupRepository.addUserToGroup(username, groupName);
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedUserGroupMembershipUpdated(username), true);
    }

    public void removeUserFromGroup(String username, String groupName) {
        this.userGroupRepository.removeUserFromGroup(username, groupName);
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedUserGroupMembershipUpdated(username), true);
    }

    public void updateGroupsMembershipForUser(String username, Set<String> groupNames) {
        this.userGroupRepository.updateGroupsMembershipForUser(username, groupNames);
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedUserGroupMembershipUpdated(username), true);
    }

    public void addUserToGroups(String username, Set<String> groupNames) {
        this.userGroupRepository.addUserToGroups(username, groupNames);
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedUserGroupMembershipUpdated(username), true);
    }

    public void removeUserFromGroups(String username, Set<String> groupNames) {
        this.userGroupRepository.removeUserFromGroups(username, groupNames);
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedUserGroupMembershipUpdated(username), true);
    }

    public SqlUserGroupRepositoryCache(UserGroupRepository userGroupRepository, BroadcastService broadcastService) {
        this.userGroupRepository = userGroupRepository;
        this.broadcastService = broadcastService;
    }
}

