package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional
import com.xebialabs.xlrelease.domain.Phase
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence
import com.xebialabs.xlrelease.repository.{PersistenceInterceptor, PhaseRepository}
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._


@Component
@IsTransactional
class PhasePersistenceInterceptor(phaseRepository: PhaseRepository,
                                  val taskPersistence: TaskPersistence)
  extends PersistenceInterceptor[Phase]
    with WorkflowTaskValidator
    with WorkflowInterceptorLogic {

  phaseRepository.registerPersistenceInterceptor(this)

  override def onCreate(ci: Phase): Unit = {
    onCreateOrUpdate(ci)
  }

  override def onUpdate(ci: Phase): Unit = {
    onCreateOrUpdate(ci)
  }

  private def onCreateOrUpdate(phase: Phase): Unit = {
    if (null != phase.getRelease() && phase.getRelease().isWorkflow()) {
      validateNoLockTaskPresent(phase.getAllTasks().asScala.toSeq)
      validateNoUnsupportedTaskPresent(phase.getAllTasks().asScala.toSeq)
      validateWorkflowTaskCount(phase.getRelease())
    }
  }

}
