/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.SecuritySchema;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.security.SqlUserGroupRepository$;
import com.xebialabs.xlrelease.security.UserGroupRepository;
import com.xebialabs.xlrelease.security.sql.Diff;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\rEa\u0001B!C\u0001-C\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\t_\u0002\u0011)\u0019!C\u0001a\"AQ\u0010\u0001B\u0001B\u0003%\u0011\u000f\u0003\u0005\u007f\u0001\t\u0015\r\u0011\"\u0001\u0000\u0011)\ty\u0003\u0001B\u0001B\u0003%\u0011\u0011\u0001\u0005\b\u0003c\u0001A\u0011AA\u001a\u0011\u001d\ti\u0004\u0001C!\u0003\u007fAq!a \u0001\t\u0003\n\t\tC\u0004\u0002\n\u0002!\t%a#\t\u000f\u0005M\u0005\u0001\"\u0011\u0002\u0016\"9\u0011\u0011\u0015\u0001\u0005B\u0005\r\u0006bBAV\u0001\u0011\u0005\u0013Q\u0016\u0005\b\u0003k\u0003A\u0011IA\\\u0011\u001d\ty\f\u0001C!\u0003\u0003Dq!!3\u0001\t\u0003\nY\rC\u0004\u0002T\u0002!I!!6\t\u000f\u0005}\u0007\u0001\"\u0003\u0002b\"91Q\u0001\u0001\u0005\n\r\u001dqaBAw\u0005\"\u0005\u0011q\u001e\u0004\u0007\u0003\nC\t!!=\t\u000f\u0005EB\u0003\"\u0001\u0002t\"I\u0011Q\u001f\u000bC\u0002\u0013%\u0011q\u001f\u0005\t\u0003s$\u0002\u0015!\u0003\u0002R!I\u00111 \u000bC\u0002\u0013%\u0011q\u001f\u0005\t\u0003{$\u0002\u0015!\u0003\u0002R!I\u0011q \u000bC\u0002\u0013%\u0011q\u001f\u0005\t\u0005\u0003!\u0002\u0015!\u0003\u0002R!I!1\u0001\u000bC\u0002\u0013%\u0011q\u001f\u0005\t\u0005\u000b!\u0002\u0015!\u0003\u0002R!I!q\u0001\u000bC\u0002\u0013%\u0011q\u001f\u0005\t\u0005\u0013!\u0002\u0015!\u0003\u0002R!I!1\u0002\u000bC\u0002\u0013%\u0011q\u001f\u0005\t\u0005\u001b!\u0002\u0015!\u0003\u0002R!I!q\u0002\u000bC\u0002\u0013%\u0011q\u001f\u0005\t\u0005#!\u0002\u0015!\u0003\u0002R!I!1\u0003\u000bC\u0002\u0013%\u0011q\u001f\u0005\t\u0005+!\u0002\u0015!\u0003\u0002R!I!q\u0003\u000bC\u0002\u0013%\u0011q\u001f\u0005\t\u00053!\u0002\u0015!\u0003\u0002R\u00191!1\u0004\u000bE\u0005;A!Ba\u000e)\u0005+\u0007I\u0011AA|\u0011)\u0011I\u0004\u000bB\tB\u0003%\u0011\u0011\u000b\u0005\u000b\u0005wA#Q3A\u0005\u0002\u0005]\bB\u0003B\u001fQ\tE\t\u0015!\u0003\u0002R!9\u0011\u0011\u0007\u0015\u0005\u0002\t}\u0002\"\u0003B%Q\u0005\u0005I\u0011\u0001B&\u0011%\u0011\t\u0006KI\u0001\n\u0003\u0011\u0019\u0006C\u0005\u0003h!\n\n\u0011\"\u0001\u0003T!I!\u0011\u000e\u0015\u0002\u0002\u0013\u0005#1\u000e\u0005\n\u0005wB\u0013\u0011!C\u0001\u0005{B\u0011B!\")\u0003\u0003%\tAa\"\t\u0013\tM\u0005&!A\u0005B\tU\u0005\"\u0003BRQ\u0005\u0005I\u0011\u0001BS\u0011%\u0011y\u000bKA\u0001\n\u0003\u0012\t\fC\u0005\u00036\"\n\t\u0011\"\u0011\u00038\"I!\u0011\u0018\u0015\u0002\u0002\u0013\u0005#1\u0018\u0005\n\u0005{C\u0013\u0011!C!\u0005\u007f;\u0011Ba1\u0015\u0003\u0003EIA!2\u0007\u0013\tmA#!A\t\n\t\u001d\u0007bBA\u0019w\u0011\u0005!q\u001c\u0005\n\u0005s[\u0014\u0011!C#\u0005wC\u0011B!9<\u0003\u0003%\tIa9\t\u0013\t%8(!A\u0005\u0002\n-\b\"\u0003B}w\u0005\u0005I\u0011\u0002B~\u0005Y\u0019\u0016\u000f\\+tKJ<%o\\;q%\u0016\u0004xn]5u_JL(BA\"E\u0003!\u0019XmY;sSRL(BA#G\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002H\u0011\u0006I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u0013\u0006\u00191m\\7\u0004\u0001M)\u0001\u0001\u0014*WAB\u0011Q\nU\u0007\u0002\u001d*\tq*A\u0003tG\u0006d\u0017-\u0003\u0002R\u001d\n1\u0011I\\=SK\u001a\u0004\"a\u0015+\u000e\u0003\tK!!\u0016\"\u0003'U\u001bXM]$s_V\u0004(+\u001a9pg&$xN]=\u0011\u0005]sV\"\u0001-\u000b\u0005eS\u0016a\u00039feNL7\u000f^3oG\u0016T!a\u0017/\u0002\u0007M\fHN\u0003\u0002^\t\u0006Q!/\u001a9pg&$xN]=\n\u0005}C&A\u0005)feNL7\u000f^3oG\u0016\u001cV\u000f\u001d9peR\u0004\"!\u00194\u000e\u0003\tT!a\u00193\u0002\u000bMdg\r\u000e6\u000b\u0003\u0015\f\u0001b\u001a:jujdW\rZ\u0005\u0003O\n\u0014q\u0001T8hO&tw-A\u0006dS&#7+\u001a:wS\u000e,\u0007C\u00016n\u001b\u0005Y'B\u00017E\u0003\u001d\u0019XM\u001d<jG\u0016L!A\\6\u0003\u0017\rK\u0017\nZ*feZL7-Z\u0001\rU\u0012\u00147\rV3na2\fG/Z\u000b\u0002cB\u0011!o_\u0007\u0002g*\u0011A/^\u0001\u0005G>\u0014XM\u0003\u0002wo\u0006!!\u000e\u001a2d\u0015\tA\u00180A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005Q\u0018aA8sO&\u0011Ap\u001d\u0002\r\u0015\u0012\u00147\rV3na2\fG/Z\u0001\u000eU\u0012\u00147\rV3na2\fG/\u001a\u0011\u0002\u000f\u0011L\u0017\r\\3diV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\tIC\u0004\u0003\u0002\u0006\u0005\rb\u0002BA\u0004\u0003?qA!!\u0003\u0002\u001c9!\u00111BA\r\u001d\u0011\ti!a\u0006\u000f\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005K\u0003\u0019a$o\\8u}%\t\u0011*\u0003\u0002H\u0011&\u0011QIR\u0005\u0004\u0003;!\u0015A\u00013c\u0013\rY\u0016\u0011\u0005\u0006\u0004\u0003;!\u0015\u0002BA\u0013\u0003O\t!bU9m\u0005VLG\u000eZ3s\u0015\rY\u0016\u0011E\u0005\u0005\u0003W\tiCA\u0004ES\u0006dWm\u0019;\u000b\t\u0005\u0015\u0012qE\u0001\tI&\fG.Z2uA\u00051A(\u001b8jiz\"\u0002\"!\u000e\u00028\u0005e\u00121\b\t\u0003'\u0002AQ\u0001\u001b\u0004A\u0002%DQa\u001c\u0004A\u0002EDaA \u0004A\u0002\u0005\u0005\u0011!\u00054j]\u0012<%o\\;qg\u001a{'/V:feR!\u0011\u0011IA,!\u0019\t\u0019%a\u0013\u0002R9!\u0011QIA$!\r\tyAT\u0005\u0004\u0003\u0013r\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002N\u0005=#aA*fi*\u0019\u0011\u0011\n(\u0011\t\u0005\r\u00131K\u0005\u0005\u0003+\nyE\u0001\u0004TiJLgn\u001a\u0005\b\u00033:\u0001\u0019AA)\u0003!)8/\u001a:oC6,\u0007fA\u0004\u0002^A!\u0011qLA7\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u0015\u0014AC1o]>$\u0018\r^5p]*!\u0011qMA5\u0003\u001diW\r\u001e:jGNT1!a\u001bI\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA8\u0003C\u0012Q\u0001V5nK\u0012D3aBA:!\u0011\t)(a\u001f\u000e\u0005\u0005]$\u0002BA=\u0003O\t1\u0002\u001e:b]N\f7\r^5p]&!\u0011QPA<\u0005)I5OU3bI>sG._\u0001\fGJ,\u0017\r^3He>,\b\u000f\u0006\u0003\u0002R\u0005\r\u0005bBAC\u0011\u0001\u0007\u0011\u0011K\u0001\nOJ|W\u000f\u001d(b[\u0016D3\u0001CA/\u00031\u0019'/Z1uK\u001e\u0013x.\u001e9t)\u0011\t\t%!$\t\u000f\u0005=\u0015\u00021\u0001\u0002B\u0005QqM]8va:\u000bW.Z:)\u0007%\ti&A\u0006eK2,G/Z$s_V\u0004H\u0003BAL\u0003;\u00032!TAM\u0013\r\tYJ\u0014\u0002\u0005+:LG\u000fC\u0004\u0002\u0006*\u0001\r!!\u0015)\u0007)\ti&\u0001\bbI\u0012,6/\u001a:U_\u001e\u0013x.\u001e9\u0015\r\u0005]\u0015QUAT\u0011\u001d\tIf\u0003a\u0001\u0003#Bq!!\"\f\u0001\u0004\t\t\u0006K\u0002\f\u0003;\nq\"\u00193e+N,'\u000fV8He>,\bo\u001d\u000b\u0007\u0003/\u000by+!-\t\u000f\u0005eC\u00021\u0001\u0002R!9\u0011q\u0012\u0007A\u0002\u0005\u0005\u0003f\u0001\u0007\u0002^\u0005\u0019\"/Z7pm\u0016,6/\u001a:Ge>lwI]8vaR1\u0011qSA]\u0003wCq!!\u0017\u000e\u0001\u0004\t\t\u0006C\u0004\u0002\u00066\u0001\r!!\u0015)\u00075\ti&\u0001\u000bsK6|g/Z+tKJ4%o\\7He>,\bo\u001d\u000b\u0007\u0003/\u000b\u0019-!2\t\u000f\u0005ec\u00021\u0001\u0002R!9\u0011q\u0012\bA\u0002\u0005\u0005\u0003f\u0001\b\u0002^\u0005iR\u000f\u001d3bi\u0016<%o\\;qg6+WNY3sg\"L\u0007OR8s+N,'\u000f\u0006\u0004\u0002\u0018\u00065\u0017q\u001a\u0005\b\u00033z\u0001\u0019AA)\u0011\u001d\tyi\u0004a\u0001\u0003\u0003B3aDA/\u0003-1\u0017N\u001c3He>,\b/\u00133\u0015\t\u0005]\u0017Q\u001c\t\u0006\u001b\u0006e\u0017\u0011K\u0005\u0004\u00037t%AB(qi&|g\u000eC\u0004\u0002\u0006B\u0001\r!!\u0015\u0002\u0015\u0019Lg\u000eZ$s_V\u00048\u000f\u0006\u0003\u0002d\u000e\r\u0001CBA\"\u0003\u0017\n)\u000fE\u0002\u0002h\"r1!!;\u0014\u001d\u0011\tI!a;\n\u0005\r#\u0015AF*rYV\u001bXM]$s_V\u0004(+\u001a9pg&$xN]=\u0011\u0005M#2C\u0001\u000bM)\t\ty/A\rT)6#vLR%O\t~;%kT+Q'~3uJU0V'\u0016\u0013VCAA)\u0003i\u0019F+\u0014+`\r&sEiX$S\u001fV\u00036k\u0018$P%~+6+\u0012*!\u0003E\u0019F+\u0014+`\u0013:\u001bVI\u0015+`\u000fJ{U\u000bU\u0001\u0013'RkEkX%O'\u0016\u0013FkX$S\u001fV\u0003\u0006%A\tT)6#v\fR#M\u000bR+ul\u0012*P+B\u000b!c\u0015+N)~#U\tT#U\u000b~;%kT+QA\u0005Q3\u000bV'U?\u0012+E*\u0012+F?V\u001bVIU0H%>+\u0006kX'F\u001b\n+%k\u0015%J!~\u0013\u0015lX$S\u001fV\u0003\u0016aK*U\u001bR{F)\u0012'F)\u0016{VkU#S?\u001e\u0013v*\u0016)`\u001b\u0016k%)\u0012*T\u0011&\u0003vLQ-`\u000fJ{U\u000b\u0015\u0011\u0002CM#V\nV0J\u001dN+%\u000bV0V'\u0016\u0013vl\u0012*P+B{V*R'C\u000bJ\u001b\u0006*\u0013)\u0002EM#V\nV0J\u001dN+%\u000bV0V'\u0016\u0013vl\u0012*P+B{V*R'C\u000bJ\u001b\u0006*\u0013)!\u0003\u0005\u001aF+\u0014+`\t\u0016cU\tV#`+N+%kX$S\u001fV\u0003v,T#N\u0005\u0016\u00136\u000bS%Q\u0003\t\u001aF+\u0014+`\t\u0016cU\tV#`+N+%kX$S\u001fV\u0003v,T#N\u0005\u0016\u00136\u000bS%QA\u0005\u00113\u000bV'U?\u0012+E*\u0012+F?V\u001bVIU0H%>+\u0006kU0N\u000b6\u0013UIU*I\u0013B\u000b1e\u0015+N)~#U\tT#U\u000b~+6+\u0012*`\u000fJ{U\u000bU*`\u001b\u0016k%)\u0012*T\u0011&\u0003\u0006%\u0001\nT)6#vLR%O\t~;%kT+Q?&#\u0015aE*U\u001bR{f)\u0013(E?\u001e\u0013v*\u0016)`\u0013\u0012\u0003\u0013\u0001E*U\u001bR{f)\u0013(E?\u001e\u0013v*\u0016)T\u0003E\u0019F+\u0014+`\r&sEiX$S\u001fV\u00036\u000b\t\u0002\u0006\u000fJ|W\u000f]\n\u0007Q1\u0013yB!\n\u0011\u00075\u0013\t#C\u0002\u0003$9\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0003(\tEb\u0002\u0002B\u0015\u0005[qA!a\u0004\u0003,%\tq*C\u0002\u000309\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u00034\tU\"\u0001D*fe&\fG.\u001b>bE2,'b\u0001B\u0018\u001d\u0006\u0011\u0011\u000eZ\u0001\u0004S\u0012\u0004\u0013\u0001\u00028b[\u0016\fQA\\1nK\u0002\"bA!\u0011\u0003F\t\u001d\u0003c\u0001B\"Q5\tA\u0003C\u0004\u000385\u0002\r!!\u0015\t\u000f\tmR\u00061\u0001\u0002R\u0005!1m\u001c9z)\u0019\u0011\tE!\u0014\u0003P!I!q\u0007\u0018\u0011\u0002\u0003\u0007\u0011\u0011\u000b\u0005\n\u0005wq\u0003\u0013!a\u0001\u0003#\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003V)\"\u0011\u0011\u000bB,W\t\u0011I\u0006\u0005\u0003\u0003\\\t\rTB\u0001B/\u0015\u0011\u0011yF!\u0019\u0002\u0013Ut7\r[3dW\u0016$'bAA2\u001d&!!Q\rB/\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!Q\u000e\t\u0005\u0005_\u0012I(\u0004\u0002\u0003r)!!1\u000fB;\u0003\u0011a\u0017M\\4\u000b\u0005\t]\u0014\u0001\u00026bm\u0006LA!!\u0016\u0003r\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011!q\u0010\t\u0004\u001b\n\u0005\u0015b\u0001BB\u001d\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!\u0011\u0012BH!\ri%1R\u0005\u0004\u0005\u001bs%aA!os\"I!\u0011S\u001a\u0002\u0002\u0003\u0007!qP\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t]\u0005C\u0002BM\u0005?\u0013I)\u0004\u0002\u0003\u001c*\u0019!Q\u0014(\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\"\nm%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa*\u0003.B\u0019QJ!+\n\u0007\t-fJA\u0004C_>dW-\u00198\t\u0013\tEU'!AA\u0002\t%\u0015A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BA!\u001c\u00034\"I!\u0011\u0013\u001c\u0002\u0002\u0003\u0007!qP\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!qP\u0001\ti>\u001cFO]5oOR\u0011!QN\u0001\u0007KF,\u0018\r\\:\u0015\t\t\u001d&\u0011\u0019\u0005\n\u0005#K\u0014\u0011!a\u0001\u0005\u0013\u000bQa\u0012:pkB\u00042Aa\u0011<'\u0015Y$\u0011\u001aBk!)\u0011YM!5\u0002R\u0005E#\u0011I\u0007\u0003\u0005\u001bT1Aa4O\u0003\u001d\u0011XO\u001c;j[\u0016LAAa5\u0003N\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\t]'Q\\\u0007\u0003\u00053TAAa7\u0003v\u0005\u0011\u0011n\\\u0005\u0005\u0005g\u0011I\u000e\u0006\u0002\u0003F\u0006)\u0011\r\u001d9msR1!\u0011\tBs\u0005ODqAa\u000e?\u0001\u0004\t\t\u0006C\u0004\u0003<y\u0002\r!!\u0015\u0002\u000fUt\u0017\r\u001d9msR!!Q\u001eB{!\u0015i\u0015\u0011\u001cBx!\u001di%\u0011_A)\u0003#J1Aa=O\u0005\u0019!V\u000f\u001d7fe!I!q_ \u0002\u0002\u0003\u0007!\u0011I\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\u007f!\u0011\u0011yGa@\n\t\r\u0005!\u0011\u000f\u0002\u0007\u001f\nTWm\u0019;\t\u000f\u0005=\u0015\u00031\u0001\u0002B\u0005yq-\u001a8fe\u0006$Xm\u0012:pkBLE\r\u0006\u0002\u0002R!\u001a\u0001aa\u0003\u0011\t\u0005U4QB\u0005\u0005\u0007\u001f\t9HA\bJgR\u0013\u0018M\\:bGRLwN\\1m\u0001")
public class SqlUserGroupRepository
implements UserGroupRepository,
PersistenceSupport,
Logging {
    private final CiIdService ciIdService;
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public MapSqlParameterSource paramMap2MapSqlParameterSource(Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$(this, params);
    }

    @Override
    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$(this, pkColumn, sqlStatement, params);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$(this, sqlStatement, params);
    }

    @Override
    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$(this, sqlStatement, params, callback);
    }

    @Override
    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$(this, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$(this, pkColumn, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$(this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$(this, sqlStatement, setup, callback);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$(this, entityId);
    }

    @Override
    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$(this, uid, token, freshToken);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$(this, uid);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, extractor);
    }

    @Override
    public Seq<Object> sqlBatch(String sqlStatement, scala.collection.immutable.Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$(this, sqlStatement, parameters);
    }

    @Override
    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$(this, sqlStatement, params);
    }

    @Override
    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$(this, pkColumn);
    }

    @Override
    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$(this, pairs);
    }

    @Override
    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, text);
    }

    @Override
    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, inputStream);
    }

    @Override
    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, byteArray);
    }

    @Override
    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, byteArray);
    }

    @Override
    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$(this, body, jdbcTemplate);
    }

    @Override
    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$(this, body);
    }

    @Override
    public <A> Seq<A> findMany(Function0<Buffer<A>> body) {
        return Utils.findMany$(this, body);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlUserGroupRepository sqlUserGroupRepository = this;
        synchronized (sqlUserGroupRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        SqlUserGroupRepository sqlUserGroupRepository = this;
        synchronized (sqlUserGroupRepository) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$(this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    @Override
    public NamedParameterJdbcTemplate namedTemplate() {
        if (!this.bitmap$0) {
            return this.namedTemplate$lzycompute();
        }
        return this.namedTemplate;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Set<String> findGroupsForUser(String username) {
        Assert.hasText((String)username, (String)"username cannot be empty");
        this.logger().trace((Function0 & Serializable)() -> "Finding groups for user '" + username + "'");
        return this.findMany((Function0 & Serializable)() -> this.sqlQuery(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_FIND_GROUPS_FOR_USER(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUP_PRINCIPALS$.MODULE$.PRINCIPAL_NAME()), (Object)username.toLowerCase())})), (Function1 & Serializable)rs -> rs.getString(SecuritySchema.GROUPS$.MODULE$.NAME()))).toSet();
    }

    @Timed
    public String createGroup(String groupName) {
        Assert.hasText((String)groupName, (String)"groupName cannot be empty");
        this.logger().trace((Function0 & Serializable)() -> "Creating new group '" + groupName + "'");
        String groupId = this.generateGroupId();
        this.sqlInsert(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_INSERT_GROUP(), this.paramMap2MapSqlParameterSource(Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUPS$.MODULE$.ID()), (Object)groupId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUPS$.MODULE$.NAME()), (Object)groupName)}))));
        return groupId;
    }

    @Timed
    public scala.collection.immutable.Set<String> createGroups(scala.collection.immutable.Set<String> groupNames) {
        Assert.notEmpty((Collection)CollectionConverters$.MODULE$.SetHasAsJava(groupNames).asJava(), (String)"groupNames cannot be empty");
        scala.collection.immutable.Set nonEmptyGroupNames = (scala.collection.immutable.Set)groupNames.filter((Function1 & Serializable)str -> BoxesRunTime.boxToBoolean((boolean)SqlUserGroupRepository.$anonfun$createGroups$1(str)));
        return nonEmptyGroupNames.grouped(100).flatMap((Function1 & Serializable)chunkedGroupNames -> {
            scala.collection.immutable.Set groups = (scala.collection.immutable.Set)chunkedGroupNames.map((Function1 & Serializable)x$1 -> new Group(this.generateGroupId(), (String)x$1));
            this.sqlBatch(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_INSERT_GROUP(), (scala.collection.immutable.Set<Map<String, Object>>)((scala.collection.immutable.Set)groups.map((Function1 & Serializable)group -> Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUPS$.MODULE$.ID()), (Object)group.id()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUPS$.MODULE$.NAME()), (Object)group.name())})))));
            return (scala.collection.immutable.Set)groups.map((Function1 & Serializable)x$2 -> x$2.id());
        }).toSet();
    }

    @Timed
    public void deleteGroup(String groupName) {
        Assert.hasText((String)groupName, (String)"groupName cannot be empty");
        this.logger().trace((Function0 & Serializable)() -> "Deleting group '" + groupName + "'");
        Option<String> option = this.findGroupId(groupName);
        if (option instanceof Some) {
            Some some = (Some)option;
            String groupId = (String)some.value();
            this.sqlExec(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_DELETE_USER_GROUP_MEMBERSHIP_BY_GROUP(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUP_PRINCIPALS$.MODULE$.GROUP_ID()), (Object)groupId)})), x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.execute()));
            this.sqlExec(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_DELETE_GROUP(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUPS$.MODULE$.NAME()), (Object)groupName)})), x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.execute()));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().trace((Function0 & Serializable)() -> "Group '" + groupName + "' not found");
            return;
        }
        throw new MatchError(option);
    }

    @Timed
    public void addUserToGroup(String username, String groupName) {
        String string;
        Assert.hasText((String)username, (String)"username cannot be empty");
        Assert.hasText((String)groupName, (String)"groupName cannot be empty");
        this.logger().trace((Function0 & Serializable)() -> "Adding user '" + username + "' to group '" + groupName + "'");
        Option<String> option = this.findGroupId(groupName);
        if (option instanceof Some) {
            String id;
            Some some = (Some)option;
            string = id = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            string = this.createGroup(groupName);
        } else {
            throw new MatchError(option);
        }
        String groupId = string;
        this.sqlInsert(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_INSERT_USER_GROUP_MEMBERSHIP(), this.paramMap2MapSqlParameterSource(Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUP_PRINCIPALS$.MODULE$.GROUP_ID()), (Object)groupId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUP_PRINCIPALS$.MODULE$.PRINCIPAL_NAME()), (Object)username.toLowerCase())}))));
    }

    @Timed
    public void addUserToGroups(String username, scala.collection.immutable.Set<String> groupNames) {
        scala.collection.immutable.Set set;
        Assert.hasText((String)username, (String)"username cannot be empty");
        Assert.notEmpty((Collection)CollectionConverters$.MODULE$.SetHasAsJava(groupNames).asJava(), (String)"groupNames cannot be empty");
        this.logger().trace((Function0 & Serializable)() -> "Adding user '" + username + "' to groups '" + groupNames + "'");
        scala.collection.immutable.Set<Group> existingGroups = this.findGroups(groupNames);
        scala.collection.immutable.Set newGroups = (scala.collection.immutable.Set)groupNames.filterNot((Function1)existingGroups.map((Function1 & Serializable)x$5 -> x$5.name()));
        if (newGroups.nonEmpty()) {
            scala.collection.immutable.Set<String> newGroupIds = this.createGroups((scala.collection.immutable.Set<String>)newGroups);
            set = (scala.collection.immutable.Set)newGroupIds.$plus$plus((IterableOnce)existingGroups.map((Function1 & Serializable)x$6 -> x$6.id()));
        } else {
            set = (scala.collection.immutable.Set)existingGroups.map((Function1 & Serializable)x$7 -> x$7.id());
        }
        scala.collection.immutable.Set groupIds = set;
        groupIds.grouped(100).foreach((Function1 & Serializable)chunkedGroupIds -> this.sqlBatch(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_INSERT_USER_GROUP_MEMBERSHIP(), (scala.collection.immutable.Set<Map<String, Object>>)((scala.collection.immutable.Set)chunkedGroupIds.map((Function1 & Serializable)groupId -> Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUP_PRINCIPALS$.MODULE$.GROUP_ID()), groupId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUP_PRINCIPALS$.MODULE$.PRINCIPAL_NAME()), (Object)username.toLowerCase())}))))));
    }

    @Timed
    public void removeUserFromGroup(String username, String groupName) {
        Assert.hasText((String)username, (String)"username cannot be empty");
        Assert.hasText((String)groupName, (String)"groupName cannot be empty");
        this.logger().trace((Function0 & Serializable)() -> "Removing user '" + username + "' from group '" + groupName + "'");
        Option<String> option = this.findGroupId(groupName);
        if (option instanceof Some) {
            Some some = (Some)option;
            String groupId = (String)some.value();
            this.sqlExec(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_DELETE_USER_GROUP_MEMBERSHIP(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUP_PRINCIPALS$.MODULE$.GROUP_ID()), (Object)groupId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUP_PRINCIPALS$.MODULE$.PRINCIPAL_NAME()), (Object)username.toLowerCase())})), x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.execute()));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().trace((Function0 & Serializable)() -> "Group '" + groupName + "' not found");
            return;
        }
        throw new MatchError(option);
    }

    @Timed
    public void removeUserFromGroups(String username, scala.collection.immutable.Set<String> groupNames) {
        Assert.hasText((String)username, (String)"username cannot be empty");
        Assert.notEmpty((Collection)CollectionConverters$.MODULE$.SetHasAsJava(groupNames).asJava(), (String)"groupNames cannot be empty");
        this.logger().trace((Function0 & Serializable)() -> "Removing user '" + username + "' from groups '" + groupNames + "'");
        scala.collection.immutable.Set groupIds = (scala.collection.immutable.Set)this.findGroups(groupNames).map((Function1 & Serializable)x$9 -> x$9.id());
        groupIds.grouped(100).foreach((Function1 & Serializable)chunkedGroupIds -> BoxesRunTime.boxToBoolean((boolean)SqlUserGroupRepository.$anonfun$removeUserFromGroups$3(this, username, chunkedGroupIds)));
    }

    @Timed
    public void updateGroupsMembershipForUser(String username, scala.collection.immutable.Set<String> groupNames) {
        scala.collection.immutable.Set<String> existingGroupsMembership = this.findGroupsForUser(username);
        Diff diff = new Diff(existingGroupsMembership, groupNames);
        if (diff.newEntries().nonEmpty()) {
            if (diff.newEntries().size() == 1) {
                this.addUserToGroup(username, (String)diff.newEntries().head());
            } else {
                this.addUserToGroups(username, (scala.collection.immutable.Set<String>)diff.newEntries());
            }
        }
        if (diff.deletedEntries().nonEmpty()) {
            if (diff.deletedEntries().size() == 1) {
                this.removeUserFromGroup(username, (String)diff.deletedEntries().head());
                return;
            }
            this.removeUserFromGroups(username, (scala.collection.immutable.Set<String>)diff.deletedEntries());
            return;
        }
    }

    private Option<String> findGroupId(String groupName) {
        return this.findOne((Function0 & Serializable)() -> this.sqlQuery(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_FIND_GROUP_ID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUPS$.MODULE$.NAME()), (Object)groupName)})), (Function1 & Serializable)rs -> rs.getString(SecuritySchema.GROUPS$.MODULE$.ID())));
    }

    private scala.collection.immutable.Set<Group> findGroups(scala.collection.immutable.Set<String> groupNames) {
        return ((IterableOps)groupNames.filter((Function1 & Serializable)str -> BoxesRunTime.boxToBoolean((boolean)SqlUserGroupRepository.$anonfun$findGroups$1(str)))).grouped(100).flatMap((Function1 & Serializable)chunkedGroupNames -> this.sqlQuery(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_FIND_GROUPS(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUPS$.MODULE$.NAME()), (Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)chunkedGroupNames).asJava())})), (Function1 & Serializable)rs -> new Group(rs.getString(SecuritySchema.GROUPS$.MODULE$.ID()), rs.getString(SecuritySchema.GROUPS$.MODULE$.NAME())))).toSet();
    }

    private String generateGroupId() {
        return Ids.getName((String)this.ciIdService.getUniqueId("Group", ""));
    }

    public static final /* synthetic */ boolean $anonfun$createGroups$1(String str) {
        return StringUtils.hasText((String)str);
    }

    public static final /* synthetic */ boolean $anonfun$removeUserFromGroups$3(SqlUserGroupRepository $this, String username$5, scala.collection.immutable.Set chunkedGroupIds) {
        return BoxesRunTime.unboxToBoolean($this.sqlExec(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_DELETE_USER_GROUPS_MEMBERSHIP(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUP_PRINCIPALS$.MODULE$.PRINCIPAL_NAME()), (Object)username$5.toLowerCase()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUP_PRINCIPALS$.MODULE$.GROUP_ID()), (Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)chunkedGroupIds).asJava())})), x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.execute())));
    }

    public static final /* synthetic */ boolean $anonfun$findGroups$1(String str) {
        return StringUtils.hasText((String)str);
    }

    public SqlUserGroupRepository(CiIdService ciIdService, JdbcTemplate jdbcTemplate, SqlBuilder.Dialect dialect) {
        this.ciIdService = ciIdService;
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        Utils.$init$(this);
        CompressionSupport.$init$(this);
        PersistenceSupport.$init$(this);
        Logging.$init$((Logging)this);
    }

    private static class Group
    implements Product,
    Serializable {
        private final String id;
        private final String name;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public Group copy(String id, String name) {
            return new Group(id, name);
        }

        public String copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.name();
        }

        public String productPrefix() {
            return "Group";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.id();
                }
                case 1: {
                    return this.name();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Group;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "id";
                }
                case 1: {
                    return "name";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Group)) return false;
            boolean bl = true;
            if (!bl) return false;
            Group group = (Group)x$1;
            String string = this.id();
            String string2 = group.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.name();
            String string4 = group.name();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!group.canEqual(this)) return false;
            return true;
        }

        public Group(String id, String name) {
            this.id = id;
            this.name = name;
            Product.$init$((Product)this);
        }
    }
}

