/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.security;

import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.utils.IdUtils$;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.SecurityRepository;
import com.xebialabs.xlrelease.repository.TeamArrayPropertyChange;
import com.xebialabs.xlrelease.security.XlRolePermissionRepository;
import com.xebialabs.xlrelease.security.XlRolePrincipalRepository;
import com.xebialabs.xlrelease.security.XlRoleRepository;
import com.xebialabs.xlrelease.security.XlRoleRoleRepository;
import com.xebialabs.xlrelease.security.entities.XlRole;
import com.xebialabs.xlrelease.security.entities.XlRolePermission;
import com.xebialabs.xlrelease.security.entities.XlRolePermissionId;
import com.xebialabs.xlrelease.security.entities.XlRolePrincipal;
import com.xebialabs.xlrelease.security.entities.XlRolePrincipalId;
import com.xebialabs.xlrelease.security.entities.XlRoleRole;
import com.xebialabs.xlrelease.security.entities.XlRoleRoleId;
import com.xebialabs.xlrelease.security.sql.db.Ids$;
import java.io.Serializable;
import java.util.List;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\t\u0015a\u0001\u0002\u0011\"\u00019B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0011!Y\u0005A!A!\u0002\u0013a\u0005\"B(\u0001\t\u0003\u0001\u0006\"\u0002-\u0001\t\u0003J\u0006\"\u0002;\u0001\t\u0003*\b\"CA\f\u0001E\u0005I\u0011AA\r\u0011%\ty\u0003AI\u0001\n\u0003\tI\u0002C\u0005\u00022\u0001\t\n\u0011\"\u0001\u0002\u001a!9\u00111\u0007\u0001\u0005B\u0005U\u0002bBA#\u0001\u0011\u0005\u0013q\t\u0005\b\u0003'\u0002A\u0011IA+\u0011\u001d\ty\u0006\u0001C!\u0003CBq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002r\u0001!\t%a\u001d\t\u000f\u0005m\u0004\u0001\"\u0011\u0002~!9\u00111\u0011\u0001\u0005B\u0005\u0015\u0005bBAF\u0001\u0011\u0005\u0013Q\u0012\u0005\b\u0003'\u0003A\u0011BAK\u0011\u001d\ty\n\u0001C\u0005\u0003CCq!a.\u0001\t\u0013\tI\fC\u0004\u0002>\u0002!I!a0\t\u000f\u0005\r\u0007\u0001\"\u0003\u0002F\"9\u0011q\f\u0001\u0005\n\u0005-\u0007bBA5\u0001\u0011%\u00111\u001b\u0005\b\u0003c\u0002A\u0011BAm\u0011\u001d\tY\b\u0001C\u0005\u0003?Dq!a!\u0001\t\u0013\t)\u000fC\u0004\u0002\f\u0002!I!a;\u0003+M\u000bHnU3dkJLG/\u001f*fa>\u001c\u0018\u000e^8ss*\u0011!eI\u0001\tg\u0016\u001cWO]5us*\u0011A%J\u0001\u0004gFd'B\u0001\u0014(\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003Q%\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005)Z\u0013!\u0003=fE&\fG.\u00192t\u0015\u0005a\u0013aA2p[\u000e\u00011c\u0001\u00010kA\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\u0004\"AN\u001c\u000e\u0003\u0015J!\u0001O\u0013\u0003%M+7-\u001e:jif\u0014V\r]8tSR|'/_\u0001\u000fe>dWMU3q_NLGo\u001c:z!\tYT(D\u0001=\u0015\t\u0011s%\u0003\u0002?y\t\u0001\u0002\f\u001c*pY\u0016\u0014V\r]8tSR|'/_\u0001\u0014e>dWMU8mKN\u0014V\r]8tSR|'/\u001f\t\u0003w\u0005K!A\u0011\u001f\u0003)ac'k\u001c7f%>dWMU3q_NLGo\u001c:z\u0003a\u0011x\u000e\\3Qe&t7-\u001b9bYN\u0014V\r]8tSR|'/\u001f\t\u0003w\u0015K!A\u0012\u001f\u00033ac'k\u001c7f!JLgnY5qC2\u0014V\r]8tSR|'/_\u0001\u001ae>dW\rU3s[&\u001c8/[8ogJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002<\u0013&\u0011!\n\u0010\u0002\u001b12\u0014v\u000e\\3QKJl\u0017n]:j_:\u0014V\r]8tSR|'/_\u0001\u000bg\u0016\u001cWO]3e\u0007&\u001c\bC\u0001\u001cN\u0013\tqUE\u0001\u0006TK\u000e,(/\u001a3DSN\fa\u0001P5oSRtDCB)T)V3v\u000b\u0005\u0002S\u00015\t\u0011\u0005C\u0003:\r\u0001\u0007!\bC\u0003@\r\u0001\u0007\u0001\tC\u0003D\r\u0001\u0007A\tC\u0003H\r\u0001\u0007\u0001\nC\u0003L\r\u0001\u0007A*A\u0004hKR$V-Y7\u0015\u0005i\u0003\u0007CA._\u001b\u0005a&BA/(\u0003\u0019!w.\\1j]&\u0011q\f\u0018\u0002\u0005)\u0016\fW\u000eC\u0003b\u000f\u0001\u0007!-\u0001\u0004uK\u0006l\u0017\n\u001a\t\u0003GFt!\u0001Z8\u000f\u0005\u0015tgB\u00014n\u001d\t9GN\u0004\u0002iW6\t\u0011N\u0003\u0002k[\u00051AH]8pizJ\u0011\u0001L\u0005\u0003U-J!\u0001K\u0015\n\u0005\u0019:\u0013B\u00019&\u0003I\u0019VmY;sSRL(+\u001a9pg&$xN]=\n\u0005I\u001c(A\u0002+fC6LEM\u0003\u0002qK\u0005Q1M]3bi\u0016$V-Y7\u0015\u0011\t4\bP_A\b\u0003'AQa\u001e\u0005A\u0002\t\f1bY8oi\u0006Lg.\u001a:JI\")\u0011\u0010\u0003a\u0001E\u0006AA/Z1n\u001d\u0006lW\rC\u0004|\u0011A\u0005\t\u0019\u0001?\u0002\u000bI|G.Z:\u0011\u000bu\f\u0019!!\u0003\u000f\u0005y|\bC\u000152\u0013\r\t\t!M\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0011q\u0001\u0002\u0004'\u0016$(bAA\u0001cA\u0019Q0a\u0003\n\t\u00055\u0011q\u0001\u0002\u0007'R\u0014\u0018N\\4\t\u0011\u0005E\u0001\u0002%AA\u0002q\f!\u0002\u001d:j]\u000eL\u0007/\u00197t\u0011!\t)\u0002\u0003I\u0001\u0002\u0004a\u0018a\u00039fe6L7o]5p]N\fAc\u0019:fCR,G+Z1nI\u0011,g-Y;mi\u0012\u001aTCAA\u000eU\ra\u0018QD\u0016\u0003\u0003?\u0001B!!\t\u0002,5\u0011\u00111\u0005\u0006\u0005\u0003K\t9#A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011F\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002.\u0005\r\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006!2M]3bi\u0016$V-Y7%I\u00164\u0017-\u001e7uIQ\nAc\u0019:fCR,G+Z1nI\u0011,g-Y;mi\u0012*\u0014AC;qI\u0006$X\rV3b[RI!-a\u000e\u0002:\u0005\u0005\u00131\t\u0005\u0006C2\u0001\rA\u0019\u0005\u0007w2\u0001\r!a\u000f\u0011\u0007Y\ni$C\u0002\u0002@\u0015\u0012q\u0003V3b[\u0006\u0013(/Y=Qe>\u0004XM\u001d;z\u0007\"\fgnZ3\t\u000f\u0005EA\u00021\u0001\u0002<!9\u0011Q\u0003\u0007A\u0002\u0005m\u0012A\u00034j]\u0012$V-Y7JIR1\u0011\u0011JA(\u0003#\u0002B\u0001MA&E&\u0019\u0011QJ\u0019\u0003\r=\u0003H/[8o\u0011\u00199X\u00021\u0001\u0002\n!1\u00110\u0004a\u0001\u0003\u0013\t!\u0002Z3mKR,G+Z1n)\u0011\t9&!\u0018\u0011\u0007A\nI&C\u0002\u0002\\E\u0012A!\u00168ji\")\u0011M\u0004a\u0001E\u0006\u0019\u0012\r\u001a3Qe&t7-\u001b9bYN$v\u000eV3b[R1\u0011qKA2\u0003KBQ!Y\bA\u0002\tDq!!\u0005\u0010\u0001\u0004\t9\u0007\u0005\u0003~\u0003\u0007\u0011\u0017\u0001\u0007:f[>4X\r\u0015:j]\u000eL\u0007/\u00197t\rJ|W\u000eV3b[R1\u0011qKA7\u0003_BQ!\u0019\tA\u0002\tDq!!\u0005\u0011\u0001\u0004\t9'\u0001\u000bbI\u0012\u0014v\u000e\\3t\u0005ft\u0015-\\3U_R+\u0017-\u001c\u000b\u0007\u0003/\n)(a\u001e\t\u000b\u0005\f\u0002\u0019\u00012\t\r\u0005e\u0014\u00031\u0001}\u0003%\u0011x\u000e\\3OC6,7/A\rsK6|g/\u001a*pY\u0016\u001c()\u001f(b[\u00164%o\\7UK\u0006lGCBA,\u0003\u007f\n\t\tC\u0003b%\u0001\u0007!\r\u0003\u0004\u0002zI\u0001\r\u0001`\u0001\u0015C\u0012$\u0007+\u001a:nSN\u001c\u0018n\u001c8t)>$V-Y7\u0015\r\u0005]\u0013qQAE\u0011\u0015\t7\u00031\u0001c\u0011\u0019\t)b\u0005a\u0001y\u0006I\"/Z7pm\u0016\u0004VM]7jgNLwN\\:Ge>lG+Z1n)\u0019\t9&a$\u0002\u0012\")\u0011\r\u0006a\u0001E\"1\u0011Q\u0003\u000bA\u0002q\f\u0001cZ3u\u0007>tG/Y5oKJ\u001c\u0015.\u00133\u0015\t\u0005]\u0015Q\u0014\t\u0004a\u0005e\u0015bAANc\t\u0019\u0011J\u001c;\t\r],\u0002\u0019AA\u0005\u000391\u0017N\u001c3UK\u0006l')\u001f(b[\u0016$b!a)\u00022\u0006U\u0006#\u0002\u0019\u0002L\u0005\u0015\u0006\u0003BAT\u0003[k!!!+\u000b\u0007\u0005-F(\u0001\u0005f]RLG/[3t\u0013\u0011\ty+!+\u0003\rac'k\u001c7f\u0011\u001d\t\u0019L\u0006a\u0001\u0003/\u000bQbY8oi\u0006Lg.\u001a:DS&#\u0007BB=\u0017\u0001\u0004\tI!\u0001\tgS:$w\n\u001d;j_:\fG\u000eV3b[R!\u00111UA^\u0011\u0015\tw\u00031\u0001c\u0003A1\u0017N\u001c3SKF,\u0018N]3e)\u0016\fW\u000e\u0006\u0003\u0002&\u0006\u0005\u0007\"B1\u0019\u0001\u0004\u0011\u0017a\u00064j]\u0012<En\u001c2bYJ{G.Z%eg\nKh*Y7f)\u0011\t9-!3\u0011\u000bu\f\u0019!!*\t\r\u0005e\u0014\u00041\u0001})\u0019\t9&!4\u0002R\"9\u0011q\u001a\u000eA\u0002\u0005\u0015\u0016\u0001\u0002;fC6Da!!\u0005\u001b\u0001\u0004aHCBA,\u0003+\f9\u000eC\u0004\u0002Pn\u0001\r!!*\t\u000f\u0005E1\u00041\u0001\u0002hQ1\u0011qKAn\u0003;Dq!a4\u001d\u0001\u0004\t)\u000b\u0003\u0004\u0002zq\u0001\r\u0001 \u000b\u0007\u0003/\n\t/a9\t\u000f\u0005=W\u00041\u0001\u0002&\"1\u0011\u0011P\u000fA\u0002q$b!a\u0016\u0002h\u0006%\bbBAh=\u0001\u0007\u0011Q\u0015\u0005\u0007\u0003+q\u0002\u0019\u0001?\u0015\r\u0005]\u0013Q^Ax\u0011\u001d\tym\ba\u0001\u0003KCa!!\u0006 \u0001\u0004a\bf\u0001\u0001\u0002tB!\u0011Q\u001fB\u0001\u001b\t\t9P\u0003\u0003\u0002z\u0006m\u0018a\u0003;sC:\u001c\u0018m\u0019;j_:T1\u0001JA\u007f\u0015\r\typJ\u0001\u0003I\nLAAa\u0001\u0002x\ny\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000e")
public class SqlSecurityRepository
implements SecurityRepository {
    private final XlRoleRepository roleRepository;
    private final XlRoleRoleRepository roleRolesRepository;
    private final XlRolePrincipalRepository rolePrincipalsRepository;
    private final XlRolePermissionRepository rolePermissionsRepository;
    private final SecuredCis securedCis;

    public Team getTeam(String teamId) {
        XlRole xlRole = (XlRole)this.roleRepository.findById(teamId).get();
        List memberRoleNames = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.roleRolesRepository.findByIdRoleId(teamId)).asScala().map((Function1 & Serializable)x$1 -> x$1.getMemberRole().getName())).asJava();
        List permissions = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.rolePermissionsRepository.findByIdRoleId(teamId)).asScala().map((Function1 & Serializable)x$2 -> x$2.getId().getPermissionName())).asJava();
        List principals = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.rolePrincipalsRepository.findByIdRoleId(teamId)).asScala().map((Function1 & Serializable)x$3 -> x$3.getId().getPrincipalName())).asJava();
        Team team = new Team();
        team.setId(teamId);
        team.setTeamName(xlRole.getName());
        team.setPermissions(permissions);
        team.setMembers(principals);
        team.setRoles(memberRoleNames);
        return team;
    }

    public String createTeam(String containerId, String teamName, scala.collection.immutable.Set<String> roles, scala.collection.immutable.Set<String> principals, scala.collection.immutable.Set<String> permissions) {
        XlRole xlRole;
        int containerCiId = this.getContainerCiId(containerId);
        Option<XlRole> option = this.findTeamByName(containerCiId, teamName);
        if (option instanceof Some) {
            XlRole xlRole2;
            Some some = (Some)option;
            xlRole = xlRole2 = (XlRole)some.value();
        } else if (None$.MODULE$.equals(option)) {
            String roleId = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(IdUtils$.MODULE$.getUniqueId("Team", "")), "/");
            XlRole xlRole3 = new XlRole(roleId, teamName, Predef$.MODULE$.int2Integer(containerCiId));
            xlRole = (XlRole)this.roleRepository.save(xlRole3);
        } else {
            throw new MatchError(option);
        }
        XlRole team = xlRole;
        this.addRolesByNameToTeam(team, roles);
        this.addPrincipalsToTeam(team, principals);
        this.addPermissionsToTeam(team, permissions);
        return team.getId();
    }

    public scala.collection.immutable.Set<String> createTeam$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    public scala.collection.immutable.Set<String> createTeam$default$4() {
        return Predef$.MODULE$.Set().empty();
    }

    public scala.collection.immutable.Set<String> createTeam$default$5() {
        return Predef$.MODULE$.Set().empty();
    }

    public String updateTeam(String teamId, TeamArrayPropertyChange roles, TeamArrayPropertyChange principals, TeamArrayPropertyChange permissions) {
        XlRole team = this.findRequiredTeam(teamId);
        this.addRolesByNameToTeam(team, (scala.collection.immutable.Set<String>)roles.add());
        this.addPrincipalsToTeam(team, (scala.collection.immutable.Set<String>)principals.add());
        this.addPermissionsToTeam(team, (scala.collection.immutable.Set<String>)permissions.add());
        this.removeRolesByNameFromTeam(team, (scala.collection.immutable.Set<String>)roles.remove());
        this.removePrincipalsFromTeam(team, (scala.collection.immutable.Set<String>)principals.remove());
        this.removePermissionsFromTeam(team, (scala.collection.immutable.Set<String>)permissions.remove());
        return team.getId();
    }

    public Option<String> findTeamId(String containerId, String teamName) {
        return this.findTeamByName(this.getContainerCiId(containerId), teamName).map((Function1 & Serializable)x$4 -> x$4.getId());
    }

    public void deleteTeam(String teamId) {
        this.roleRolesRepository.deleteByIdRoleId(teamId);
        this.rolePrincipalsRepository.deleteByIdRoleId(teamId);
        this.rolePermissionsRepository.deleteByIdRoleId(teamId);
        this.roleRepository.deleteById(teamId);
    }

    public void addPrincipalsToTeam(String teamId, scala.collection.immutable.Set<String> principals) {
        XlRole team = this.findRequiredTeam(teamId);
        this.addPrincipalsToTeam(team, principals);
    }

    public void removePrincipalsFromTeam(String teamId, scala.collection.immutable.Set<String> principals) {
        this.findOptionalTeam(teamId).foreach((Function1 & Serializable)x$5 -> {
            this.removePrincipalsFromTeam(x$5, (scala.collection.immutable.Set<String>)principals);
            return BoxedUnit.UNIT;
        });
    }

    public void addRolesByNameToTeam(String teamId, scala.collection.immutable.Set<String> roleNames) {
        XlRole team = this.findRequiredTeam(teamId);
        this.addRolesByNameToTeam(team, roleNames);
    }

    public void removeRolesByNameFromTeam(String teamId, scala.collection.immutable.Set<String> roleNames) {
        this.findOptionalTeam(teamId).foreach((Function1 & Serializable)x$6 -> {
            this.removeRolesByNameFromTeam(x$6, (scala.collection.immutable.Set<String>)roleNames);
            return BoxedUnit.UNIT;
        });
    }

    public void addPermissionsToTeam(String teamId, scala.collection.immutable.Set<String> permissions) {
        XlRole team = this.findRequiredTeam(teamId);
        this.addPermissionsToTeam(team, permissions);
    }

    public void removePermissionsFromTeam(String teamId, scala.collection.immutable.Set<String> permissions) {
        this.findOptionalTeam(teamId).foreach((Function1 & Serializable)x$7 -> {
            this.removePermissionsFromTeam(x$7, (scala.collection.immutable.Set<String>)permissions);
            return BoxedUnit.UNIT;
        });
    }

    private int getContainerCiId(String containerId) {
        Option securityUid = Option$.MODULE$.apply((Object)this.securedCis.getEffectiveSecuredCi(containerId).getSecurityUid());
        return Ids$.MODULE$.toDbId(securityUid);
    }

    private Option<XlRole> findTeamByName(int containerCiId, String teamName) {
        return this.roleRepository.findByCiIdAndNameIgnoreCase(Predef$.MODULE$.int2Integer(containerCiId), teamName);
    }

    private Option<XlRole> findOptionalTeam(String teamId) {
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.roleRepository.findById(teamId)));
    }

    private XlRole findRequiredTeam(String teamId) {
        return (XlRole)this.roleRepository.findById(teamId).orElseThrow(() -> new IllegalStateException("No team with id: " + teamId));
    }

    private scala.collection.immutable.Set<XlRole> findGlobalRoleIdsByName(scala.collection.immutable.Set<String> roleNames) {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.roleRepository.findByCiIdAndNameIgnoreCaseIn(Predef$.MODULE$.int2Integer(-1), CollectionConverters$.MODULE$.SetHasAsJava(roleNames).asJava())).asScala().toSet();
    }

    private void addPrincipalsToTeam(XlRole team, scala.collection.immutable.Set<String> principals) {
        scala.collection.immutable.Set teamPrincipals = (scala.collection.immutable.Set)principals.map((Function1 & Serializable)x$8 -> new XlRolePrincipal(team, (String)x$8));
        this.rolePrincipalsRepository.saveAll(CollectionConverters$.MODULE$.SetHasAsJava((Set)teamPrincipals).asJava());
    }

    private void removePrincipalsFromTeam(XlRole team, scala.collection.immutable.Set<String> principals) {
        java.util.Set ids = CollectionConverters$.MODULE$.SetHasAsJava((Set)principals.map((Function1 & Serializable)principal -> new XlRolePrincipalId(team.getId(), (String)principal))).asJava();
        this.rolePrincipalsRepository.deleteAllById(ids);
    }

    private void addRolesByNameToTeam(XlRole team, scala.collection.immutable.Set<String> roleNames) {
        scala.collection.immutable.Set<XlRole> globalRoleIds = this.findGlobalRoleIdsByName(roleNames);
        scala.collection.immutable.Set teamRoles = (scala.collection.immutable.Set)globalRoleIds.map((Function1 & Serializable)x$9 -> new XlRoleRole(team, (XlRole)x$9));
        this.roleRolesRepository.saveAll(CollectionConverters$.MODULE$.SetHasAsJava((Set)teamRoles).asJava());
    }

    private void removeRolesByNameFromTeam(XlRole team, scala.collection.immutable.Set<String> roleNames) {
        scala.collection.immutable.Set<XlRole> memberRoles = this.findGlobalRoleIdsByName(roleNames);
        java.util.Set ids = CollectionConverters$.MODULE$.SetHasAsJava((Set)memberRoles.map((Function1 & Serializable)memberRole -> new XlRoleRoleId(team.getId(), memberRole.getId()))).asJava();
        this.roleRolesRepository.deleteAllById(ids);
    }

    private void addPermissionsToTeam(XlRole team, scala.collection.immutable.Set<String> permissions) {
        scala.collection.immutable.Set teamPermissions = (scala.collection.immutable.Set)permissions.map((Function1 & Serializable)x$10 -> new XlRolePermission(team, (String)x$10));
        this.rolePermissionsRepository.saveAll(CollectionConverters$.MODULE$.SetHasAsJava((Set)teamPermissions).asJava());
    }

    private void removePermissionsFromTeam(XlRole team, scala.collection.immutable.Set<String> permissions) {
        java.util.Set ids = CollectionConverters$.MODULE$.SetHasAsJava((Set)permissions.map((Function1 & Serializable)permission -> new XlRolePermissionId(team, (String)permission))).asJava();
        this.rolePermissionsRepository.deleteAllById(ids);
    }

    public SqlSecurityRepository(XlRoleRepository roleRepository, XlRoleRoleRepository roleRolesRepository, XlRolePrincipalRepository rolePrincipalsRepository, XlRolePermissionRepository rolePermissionsRepository, SecuredCis securedCis) {
        this.roleRepository = roleRepository;
        this.roleRolesRepository = roleRolesRepository;
        this.rolePrincipalsRepository = rolePrincipalsRepository;
        this.rolePermissionsRepository = rolePermissionsRepository;
        this.securedCis = securedCis;
    }
}

