/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.security;

import com.xebialabs.xlrelease.domain.distributed.events.DistributedXLReleaseEvent;
import com.xebialabs.xlrelease.domain.distributed.events.EvictRolesEvent;
import com.xebialabs.xlrelease.domain.events.TeamCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TeamDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TeamEvent;
import com.xebialabs.xlrelease.domain.events.TeamUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsMergedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsRemovedInTemplateEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.security.SecuredCi;
import com.xebialabs.xlrelease.security.sql.SecurityCacheConfigurationCondition;
import com.xebialabs.xlrelease.service.BroadcastService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@EventListener
@Conditional(value={SecurityCacheConfigurationCondition.class})
@ScalaSignature(bytes="\u0006\u0005)4A!\u0002\u0004\u0001'!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0011\u0015q\u0003\u0001\"\u00010\u0011\u0015!\u0004\u0001\"\u00016\u0005A!V-Y7Fm\u0016tG\u000fS1oI2,'O\u0003\u0002\b\u0011\u0005A1/Z2ve&$\u0018P\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011QBD\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0004\t\u0002\u0013a,'-[1mC\n\u001c(\"A\t\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001!\"\u0004\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VM\u001a\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\tQa\u001d7gi)T\u0011aH\u0001\tOJL'P\u001f7fI&\u0011\u0011\u0005\b\u0002\b\u0019><w-\u001b8h\u0003A\u0011'o\\1eG\u0006\u001cHoU3sm&\u001cW\r\u0005\u0002%O5\tQE\u0003\u0002'\u0019\u000591/\u001a:wS\u000e,\u0017B\u0001\u0015&\u0005A\u0011%o\\1eG\u0006\u001cHoU3sm&\u001cW-\u0001\u0006tK\u000e,(/\u001a3DSN\u0004\"a\u000b\u0017\u000e\u0003)I!!\f\u0006\u0003\u0015M+7-\u001e:fI\u000eK7/\u0001\u0004=S:LGO\u0010\u000b\u0004aI\u001a\u0004CA\u0019\u0001\u001b\u00051\u0001\"\u0002\u0012\u0004\u0001\u0004\u0019\u0003\"B\u0015\u0004\u0001\u0004Q\u0013aB8o\u000bZ,g\u000e\u001e\u000b\u0003me\u0002\"!F\u001c\n\u0005a2\"\u0001B+oSRDQA\u000f\u0003A\u0002m\nQ!\u001a<f]R\u0004\"\u0001P!\u000e\u0003uR!AP \u0002\r\u00154XM\u001c;t\u0015\t\u0001E\"\u0001\u0004e_6\f\u0017N\\\u0005\u0003\u0005v\u0012\u0011\u0002V3b[\u00163XM\u001c;)\u0005\u0011!\u0005CA#H\u001b\u00051%B\u0001 \r\u0013\tAeIA\u0005Tk\n\u001c8M]5cK\"\u0012\u0001A\u0013\t\u0003\u0017Jk\u0011\u0001\u0014\u0006\u0003\u001b:\u000b!b\u001d;fe\u0016|G/\u001f9f\u0015\ty\u0005+A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\t\u0016aA8sO&\u00111\u000b\u0014\u0002\n\u0007>l\u0007o\u001c8f]RD#\u0001A+\u0011\u0005\u00153\u0016BA,G\u00055)e/\u001a8u\u0019&\u001cH/\u001a8fe\"\"\u0001!W1c!\tQv,D\u0001\\\u0015\taV,\u0001\u0006b]:|G/\u0019;j_:T!A\u0018(\u0002\u000f\r|g\u000e^3yi&\u0011\u0001m\u0017\u0002\f\u0007>tG-\u001b;j_:\fG.A\u0003wC2,X\rL\u0001dG\u0005!\u0007CA3i\u001b\u00051'BA\u0005h\u0015\t9A\"\u0003\u0002jM\n\u00193+Z2ve&$\u0018pQ1dQ\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u000e{g\u000eZ5uS>t\u0007")
public class TeamEventHandler
implements Logging {
    private final BroadcastService broadcastService;
    private final SecuredCis securedCis;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TeamEventHandler teamEventHandler = this;
        synchronized (teamEventHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Subscribe
    public void onEvent(TeamEvent event) {
        String string;
        TeamEvent teamEvent = event;
        if (teamEvent instanceof TeamCreatedEvent) {
            String containerId;
            TeamCreatedEvent teamCreatedEvent = (TeamCreatedEvent)teamEvent;
            string = containerId = teamCreatedEvent.containerId();
        } else if (teamEvent instanceof TeamUpdatedEvent) {
            String containerId;
            TeamUpdatedEvent teamUpdatedEvent = (TeamUpdatedEvent)teamEvent;
            string = containerId = teamUpdatedEvent.containerId();
        } else if (teamEvent instanceof TeamDeletedEvent) {
            String containerId;
            TeamDeletedEvent teamDeletedEvent = (TeamDeletedEvent)teamEvent;
            string = containerId = teamDeletedEvent.containerId();
        } else if (teamEvent instanceof TeamsMergedEvent) {
            String templateId;
            TeamsMergedEvent teamsMergedEvent = (TeamsMergedEvent)teamEvent;
            string = templateId = teamsMergedEvent.templateId();
        } else if (teamEvent instanceof TeamsRemovedInTemplateEvent) {
            String templateId;
            TeamsRemovedInTemplateEvent teamsRemovedInTemplateEvent = (TeamsRemovedInTemplateEvent)teamEvent;
            string = templateId = teamsRemovedInTemplateEvent.templateId();
        } else {
            throw new MatchError((Object)teamEvent);
        }
        String ciId = string;
        this.logger().debug((Function0 & Serializable)() -> "Publishing event to evict cache for configurationItem [" + ciId + "]");
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.securedCis.getSecuredCi(ciId));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            SecuredCi securityId = (SecuredCi)success.value();
            this.broadcastService.broadcast((DistributedXLReleaseEvent)new EvictRolesEvent(securityId.getSecurityUid()), true);
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            this.logger().error((Function0 & Serializable)() -> ex);
            return;
        }
        throw new MatchError((Object)try_);
    }

    public TeamEventHandler(BroadcastService broadcastService, SecuredCis securedCis) {
        this.broadcastService = broadcastService;
        this.securedCis = securedCis;
        Logging.$init$((Logging)this);
    }
}

