/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.spring.config;

import com.xebialabs.deployit.security.PermissionChecker;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.security.DefaultUserGroupService;
import com.xebialabs.xlrelease.security.SqlUserGroupRepository;
import com.xebialabs.xlrelease.security.SqlUserGroupRepositoryCache;
import com.xebialabs.xlrelease.security.UserGroupRepository;
import com.xebialabs.xlrelease.security.UserGroupService;
import com.xebialabs.xlrelease.security.sql.CachingPermissionEditor;
import com.xebialabs.xlrelease.security.sql.CachingPermissionLister;
import com.xebialabs.xlrelease.security.sql.CachingSqlRoleService;
import com.xebialabs.xlrelease.security.sql.CachingSqlUserService;
import com.xebialabs.xlrelease.security.sql.SqlPermissionChecker;
import com.xebialabs.xlrelease.security.sql.SqlPermissionEditor;
import com.xebialabs.xlrelease.security.sql.SqlPermissionLister;
import com.xebialabs.xlrelease.security.sql.SqlRoleService;
import com.xebialabs.xlrelease.security.sql.SqlUserService;
import com.xebialabs.xlrelease.security.sql.UserCacheEvicter;
import com.xebialabs.xlrelease.service.BroadcastService;
import com.xebialabs.xlrelease.spring.config.SqlConfiguration;
import java.util.Optional;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import scala.reflect.ScalaSignature;

@Configuration
@ScalaSignature(bytes="\u0006\u0005\u0005}a\u0001B\u0007\u000f\u0001eA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\tK\u0001\u0011\t\u0011)A\u0005M!A1\u0006\u0001B\u0001B\u0003%A\u0006C\u00033\u0001\u0011\u00051\u0007\u0003\u00059\u0001!\u0015\r\u0011\"\u0001:\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015Y\u0007\u0001\"\u0001m\u0011\u0015\u0011\b\u0001\"\u0001t\u0011\u0015A\b\u0001\"\u0001z\u0011\u0015q\b\u0001\"\u0001\u0000\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017\u0011\u0001dU9m'\u0016\u001cWO]5us\u000e{gNZ5hkJ\fG/[8o\u0015\ty\u0001#\u0001\u0004d_:4\u0017n\u001a\u0006\u0003#I\taa\u001d9sS:<'BA\n\u0015\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0016-\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002/\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\u0007\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0002!M\fHnQ8oM&<WO]1uS>t\u0007C\u0001\u0012$\u001b\u0005q\u0011B\u0001\u0013\u000f\u0005A\u0019\u0016\u000f\\\"p]\u001aLw-\u001e:bi&|g.A\u0005yYJ\u001cuN\u001c4jOB\u0011q%K\u0007\u0002Q)\u0011qBE\u0005\u0003U!\u0012\u0011\u0002\u00177s\u0007>tg-[4\u0002!\t\u0014x.\u00193dCN$8+\u001a:wS\u000e,\u0007CA\u00171\u001b\u0005q#BA\u0018\u0013\u0003\u001d\u0019XM\u001d<jG\u0016L!!\r\u0018\u0003!\t\u0013x.\u00193dCN$8+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u00035kY:\u0004C\u0001\u0012\u0001\u0011\u0015\u0001C\u00011\u0001\"\u0011\u0015)C\u00011\u0001'\u0011\u0015YC\u00011\u0001-\u00039\u0019\u0017m\u00195j]\u001e,e.\u00192mK\u0012,\u0012A\u000f\t\u00037mJ!\u0001\u0010\u000f\u0003\u000f\t{w\u000e\\3b]\u0006Y!o\u001c7f'\u0016\u0014h/[2f)\u0005y\u0004C\u0001!F\u001b\u0005\t%B\u0001\"D\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\tJ\t\u0001b]3dkJLG/_\u0005\u0003\r\u0006\u0013abU9m%>dWmU3sm&\u001cW\r\u000b\u0002\u0007\u0011B\u0011\u0011JU\u0007\u0002\u0015*\u00111\nT\u0001\u000bC:tw\u000e^1uS>t'BA'O\u0003\u001d\u0019wN\u001c;fqRT!a\u0014)\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!U\u0001\u0004_J<\u0017BA*K\u0005\u0011\u0011U-\u00198\u0002\u0017U\u001cXM]*feZL7-\u001a\u000b\u0003-v\u0003\"aV.\u000e\u0003aS!\u0001R-\u000b\u0005i#\u0012\u0001\u00033fa2|\u00170\u001b;\n\u0005qC&aC+tKJ\u001cVM\u001d<jG\u0016DQAX\u0004A\u0002}\u000bq!\u001a<jGR,'\u000fE\u0002aK\u001el\u0011!\u0019\u0006\u0003E\u000e\fA!\u001e;jY*\tA-\u0001\u0003kCZ\f\u0017B\u00014b\u0005!y\u0005\u000f^5p]\u0006d\u0007C\u0001!i\u0013\tI\u0017I\u0001\tVg\u0016\u00148)Y2iK\u00163\u0018n\u0019;fe\"\u0012q\u0001S\u0001\u0011kN,'o\u0012:pkB\u001cVM\u001d<jG\u0016$\u0012!\u001c\t\u0003]>l\u0011aQ\u0005\u0003a\u000e\u0013\u0001#V:fe\u001e\u0013x.\u001e9TKJ4\u0018nY3)\u0005!A\u0015aE;tKJ<%o\\;q%\u0016\u0004xn]5u_JLH#\u0001;\u0011\u00059,\u0018B\u0001<D\u0005M)6/\u001a:He>,\bOU3q_NLGo\u001c:zQ\tI\u0001*\u0001\tqKJl\u0017n]:j_:d\u0015n\u001d;feR\t!\u0010\u0005\u0002Aw&\u0011A0\u0011\u0002\u0014'Fd\u0007+\u001a:nSN\u001c\u0018n\u001c8MSN$XM\u001d\u0015\u0003\u0015!\u000b\u0001\u0003]3s[&\u001c8/[8o\u000b\u0012LGo\u001c:\u0015\u0005\u0005\u0005\u0001cA,\u0002\u0004%\u0019\u0011Q\u0001-\u0003!A+'/\\5tg&|g.\u00123ji>\u0014\bFA\u0006I\u0003QAHN\u001d)fe6L7o]5p]\u000eCWmY6feR!\u0011QBA\n!\r9\u0016qB\u0005\u0004\u0003#A&!\u0005)fe6L7o]5p]\u000eCWmY6fe\")\u0001\u0010\u0004a\u0001u\"\u0012A\u0002\u0013\u0015\u0004\u0001\u0005e\u0001cA%\u0002\u001c%\u0019\u0011Q\u0004&\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0001")
public class SqlSecurityConfiguration {
    private boolean cachingEnabled;
    private final SqlConfiguration sqlConfiguration;
    private final XlrConfig xlrConfig;
    private final BroadcastService broadcastService;
    private volatile boolean bitmap$0;

    private boolean cachingEnabled$lzycompute() {
        SqlSecurityConfiguration sqlSecurityConfiguration = this;
        synchronized (sqlSecurityConfiguration) {
            if (!this.bitmap$0) {
                this.cachingEnabled = this.xlrConfig.isSecurityCacheEnabled();
                this.bitmap$0 = true;
            }
        }
        return this.cachingEnabled;
    }

    public boolean cachingEnabled() {
        if (!this.bitmap$0) {
            return this.cachingEnabled$lzycompute();
        }
        return this.cachingEnabled;
    }

    @Bean
    public SqlRoleService roleService() {
        if (this.cachingEnabled()) {
            return new CachingSqlRoleService(this.sqlConfiguration.xlrRepositoryDatabase(), this.broadcastService);
        }
        return new SqlRoleService(this.sqlConfiguration.xlrRepositoryDatabase());
    }

    @Bean
    public UserService userService(Optional<UserCacheEvicter> evicter) {
        if (this.xlrConfig.isSecurityUserCacheEnabled()) {
            return new CachingSqlUserService(this.sqlConfiguration.xlrRepositoryDatabase(), evicter.get());
        }
        return new SqlUserService(this.sqlConfiguration.xlrRepositoryDatabase());
    }

    @Bean
    public UserGroupService userGroupService() {
        return new DefaultUserGroupService(this.userGroupRepository());
    }

    @Bean
    public UserGroupRepository userGroupRepository() {
        SqlUserGroupRepository repository = new SqlUserGroupRepository(this.sqlConfiguration.ciIdService(), this.sqlConfiguration.xlrRepositoryJdbcTemplate(), this.sqlConfiguration.xlrRepositorySqlDialect());
        if (this.xlrConfig.isUserGroupCacheEnabled()) {
            return new SqlUserGroupRepositoryCache(repository, this.broadcastService);
        }
        return repository;
    }

    @Bean
    public SqlPermissionLister permissionLister() {
        if (this.cachingEnabled()) {
            return new CachingPermissionLister(this.sqlConfiguration.xlrRepositoryDatabase());
        }
        return new SqlPermissionLister(this.sqlConfiguration.xlrRepositoryDatabase());
    }

    @Bean
    public PermissionEditor permissionEditor() {
        if (this.cachingEnabled()) {
            return new CachingPermissionEditor(this.sqlConfiguration.xlrRepositoryDatabase(), this.broadcastService);
        }
        return new SqlPermissionEditor(this.sqlConfiguration.xlrRepositoryDatabase());
    }

    @Bean
    public PermissionChecker xlrPermissionChecker(SqlPermissionLister permissionLister) {
        return new SqlPermissionChecker(this.sqlConfiguration.xlrRepositoryDatabase(), permissionLister, this.cachingEnabled());
    }

    public SqlSecurityConfiguration(SqlConfiguration sqlConfiguration, XlrConfig xlrConfig, BroadcastService broadcastService) {
        this.sqlConfiguration = sqlConfiguration;
        this.xlrConfig = xlrConfig;
        this.broadcastService = broadcastService;
    }
}

