/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import java.io.Serializable;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import scala.Function1;
import scala.Option;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@IsTransactional
@ScalaSignature(bytes="\u0006\u000594A\u0001D\u0007\u00011!A1\u0006\u0001B\u0001B\u0003%A\u0006\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0011\u0015\u0019\u0004\u0001\"\u00015\u0011\u0015I\u0004\u0001\"\u0011;\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0011\u00151\u0005\u0001\"\u0003H\u0011\u0015Q\u0005\u0001\"\u0003L\u0011\u0015i\u0005\u0001\"\u0003O\u0011\u0015\u0001\u0006\u0001\"\u0003R\u0011\u0015\u0019\u0006\u0001\"\u0003U\u0011\u00151\u0006\u0001\"\u0003X\u0005u\u0011V\r\\3bg\u0016\u0004VM]:jgR,gnY3J]R,'oY3qi>\u0014(B\u0001\b\u0010\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003!E\t!B]3q_NLGo\u001c:z\u0015\t\u00112#A\u0005yYJ,G.Z1tK*\u0011A#F\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AF\u0001\u0004G>l7\u0001A\n\u0004\u0001e\t\u0003C\u0001\u000e \u001b\u0005Y\"B\u0001\u000f\u001e\u0003\u0011a\u0017M\\4\u000b\u0003y\tAA[1wC&\u0011\u0001e\u0007\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007\t\u001aS%D\u0001\u0010\u0013\t!sB\u0001\fQKJ\u001c\u0018n\u001d;f]\u000e,\u0017J\u001c;fe\u000e,\u0007\u000f^8s!\t1\u0013&D\u0001(\u0015\tA\u0013#\u0001\u0004e_6\f\u0017N\\\u0005\u0003U\u001d\u0012qAU3mK\u0006\u001cX-A\tsK2,\u0017m]3SKB|7/\u001b;pef\u0004\"AI\u0017\n\u00059z!!\u0005*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0006\u0001bm\u001c7eKJ\u0014V\r]8tSR|'/\u001f\t\u0003EEJ!AM\b\u0003!\u0019{G\u000eZ3s%\u0016\u0004xn]5u_JL\u0018A\u0002\u001fj]&$h\bF\u00026oa\u0002\"A\u000e\u0001\u000e\u00035AQaK\u0002A\u00021BQaL\u0002A\u0002A\n\u0001b\u001c8De\u0016\fG/\u001a\u000b\u0003w\u0005\u0003\"\u0001P \u000e\u0003uR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\u0012A!\u00168ji\")!\t\u0002a\u0001K\u0005\u00111-[\u0001\t_:,\u0006\u000fZ1uKR\u00111(\u0012\u0005\u0006\u0005\u0016\u0001\r!J\u0001\u0011_:\u001c%/Z1uK>\u0013X\u000b\u001d3bi\u0016$\"a\u000f%\t\u000b%3\u0001\u0019A\u0013\u0002\u000fI,G.Z1tK\u0006Yb/\u00197jI\u0006$X\rR3gCVdG\u000fV1sO\u0016$hi\u001c7eKJ$\"a\u000f'\t\u000b%;\u0001\u0019A\u0013\u00025Y\fG.\u001b3bi\u0016<vN]6gY><\bK]8qKJ$\u0018.Z:\u0015\u0005mz\u0005\"B%\t\u0001\u0004)\u0013\u0001\u0007<bY&$\u0017\r^3O_R\f%k\\8u/>\u00148N\u001a7poR\u00111H\u0015\u0005\u0006\u0013&\u0001\r!J\u0001\u001fm\u0006d\u0017\u000eZ1uK:{G)Y:iE>\f'\u000f\u001a$pe^{'o\u001b4m_^$\"aO+\t\u000b%S\u0001\u0019A\u0013\u0002IY\fG.\u001b3bi\u0016tu\u000eT8dWR\u000b7o\u001b)sKN,g\u000e\u001e$pe^{'o\u001b4m_^$\"a\u000f-\t\u000b%[\u0001\u0019A\u0013)\u0005\u0001Q\u0006CA.b\u001b\u0005a&BA/_\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u00059y&B\u00011\u0012\u0003\t!'-\u0003\u0002c9\ny\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000e\u000b\u0002\u0001IB\u0011Q\r\\\u0007\u0002M*\u0011q\r[\u0001\u000bgR,'/Z8usB,'BA5k\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A6\u0002\u0007=\u0014x-\u0003\u0002nM\nI1i\\7q_:,g\u000e\u001e")
public class ReleasePersistenceInterceptor
implements PersistenceInterceptor<Release> {
    private final FolderRepository folderRepository;

    public void onDelete(String x$1) {
        super.onDelete(x$1);
    }

    public void afterCreate(ConfigurationItem x$1) {
        super.afterCreate(x$1);
    }

    public void afterUpdate(ConfigurationItem x$1) {
        super.afterUpdate(x$1);
    }

    public void afterDelete(String x$1) {
        super.afterDelete(x$1);
    }

    public void onCreate(Release ci) {
        this.onCreateOrUpdate(ci);
    }

    public void onUpdate(Release ci) {
        this.onCreateOrUpdate(ci);
    }

    private void onCreateOrUpdate(Release release) {
        this.validateDefaultTargetFolder(release);
        this.validateWorkflowProperties(release);
    }

    private void validateDefaultTargetFolder(Release release) {
        boolean defaultTargetFolderIdIsEmpty;
        boolean doesNotAllowTargetFolderOverride = !release.getAllowTargetFolderOverride();
        String defaultTargetFolderId = release.getDefaultTargetFolderId();
        boolean bl = defaultTargetFolderIdIsEmpty = !StringUtils.hasText((String)defaultTargetFolderId);
        if (release.isTemplate() && doesNotAllowTargetFolderOverride && defaultTargetFolderIdIsEmpty) {
            String msg = "Override of the target folder is not allowed, but default target folder is not provided for release with ID [" + release.getId() + "]";
            throw new Checks.IncorrectArgumentException(msg, new Object[0]);
        }
        if (!defaultTargetFolderIdIsEmpty) {
            Option optionalFolder = this.folderRepository.findById(defaultTargetFolderId, 1);
            if (optionalFolder.isEmpty()) {
                throw new Checks.IncorrectArgumentException("Cannot find folder with id [" + defaultTargetFolderId + "]", new Object[0]);
            }
            return;
        }
    }

    private void validateWorkflowProperties(Release release) {
        this.validateNotARootWorkflow(release);
        this.validateNoDashboardForWorkflow(release);
        this.validateNoLockTaskPresentForWorkflow(release);
    }

    private void validateNotARootWorkflow(Release release) {
        String parentFolder = Ids.getParentId((String)release.getId());
        if (release.isWorkflow()) {
            String string = parentFolder;
            String string2 = Ids.ROOT_FOLDER_ID;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new Checks.IncorrectArgumentException("Workflows can be created only inside a folder", new Object[0]);
            }
        }
    }

    private void validateNoDashboardForWorkflow(Release release) {
        if (release.isWorkflow()) {
            boolean hasDashboards = CollectionConverters$.MODULE$.ListHasAsScala(release.getExtensions()).asScala().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReleasePersistenceInterceptor.$anonfun$validateNoDashboardForWorkflow$1(x$1)));
            if (hasDashboards) {
                throw new Checks.IncorrectArgumentException("Dashboards are not supported for workflows", new Object[0]);
            }
            return;
        }
    }

    private void validateNoLockTaskPresentForWorkflow(Release release) {
        if (release.isWorkflow()) {
            boolean hasLockTasks = CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isLocked()));
            if (hasLockTasks) {
                throw new Checks.IncorrectArgumentException("Lock tasks are not supported for workflows", new Object[0]);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateNoDashboardForWorkflow$1(ReleaseExtension x$1) {
        return x$1 instanceof Dashboard;
    }

    public ReleasePersistenceInterceptor(ReleaseRepository releaseRepository, FolderRepository folderRepository) {
        this.folderRepository = folderRepository;
        releaseRepository.registerPersistenceInterceptor((PersistenceInterceptor)this);
    }
}

