/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache$;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurity;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.FolderVariablesDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.FoldersStoreException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$FolderDataOps$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$NodeFolderDataOps$;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.utils.Tree;
import com.xebialabs.xlrelease.utils.Tree$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.HashSet;
import org.slf4j.Marker;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\rMd\u0001B\u00193\u0001uB\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tM\u0002\u0011\t\u0011)A\u0005O\"A!\u000e\u0001B\u0001B\u0003%1\u000e\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003p\u0011!9\bA!b\u0001\n\u0003A\b\"CA\u0002\u0001\t\u0005\t\u0015!\u0003z\u0011)\t)\u0001\u0001BC\u0002\u0013\r\u0011q\u0001\u0005\u000b\u0003C\u0001!\u0011!Q\u0001\n\u0005%\u0001BCA\u0012\u0001\t\u0015\r\u0011b\u0001\u0002&!Q\u0011Q\u000b\u0001\u0003\u0002\u0003\u0006I!a\n\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z!9\u00111\u000e\u0001\u0005B\u00055\u0004bBAW\u0001\u0011\u0005\u0013q\u0016\u0005\b\u0003{\u0003A\u0011IA`\u0011\u001d\tI\u000e\u0001C\u0001\u00037Dq!a?\u0001\t\u0003\ni\u0010C\u0004\u0003\u0010\u0001!\tE!\u0005\t\u0013\tu\u0001!%A\u0005\u0002\t}\u0001b\u0002B\u001a\u0001\u0011\u0005#Q\u0007\u0005\n\u0005\u001f\u0002\u0011\u0013!C\u0001\u0005?A\u0011B!\u0015\u0001#\u0003%\tAa\b\t\u000f\tM\u0003\u0001\"\u0011\u0003V!9!1\f\u0001\u0005\n\tu\u0003b\u0002B7\u0001\u0011%!q\u000e\u0005\b\u0005g\u0002A\u0011\u0001B;\u0011\u001d\u0011Y\b\u0001C\u0001\u0005{BqAa!\u0001\t\u0003\u0012)\tC\u0004\u0003\u000e\u0002!\tEa$\t\u000f\t}\u0005\u0001\"\u0011\u0003\"\"9!1\u0016\u0001\u0005B\t5\u0006b\u0002B\\\u0001\u0011\u0005#\u0011\u0018\u0005\n\u0005\u0007\u0004\u0011\u0013!C\u0001\u0005\u000bDqA!3\u0001\t\u0003\u0012Y\rC\u0004\u0003V\u0002!\tEa6\t\u0011\t}\u0007\u0001\"\u00013\u0005CD\u0001B!>\u0001\t\u0003\u0011$q\u001f\u0005\t\u00073\u0001A\u0011\u0001\u001a\u0004\u001c!Q1\u0011\u0005\u0001\u0012\u0002\u0013\u0005!G!2\t\u0011\r\r\u0002\u0001\"\u00013\u0007KA!b!\f\u0001#\u0003%\tA\rBc\u0011\u001d\u0019y\u0003\u0001C\u0005\u0007cA\u0011ba\u0010\u0001#\u0003%IA!2\t\u0013\r\u0005\u0003!%A\u0005\n\t}\u0001\u0002CB\"\u0001\u0011\u0005!g!\u0012\t\u0015\r5\u0003!%A\u0005\u0002I\u0012)\r\u0003\u0006\u0004P\u0001\t\n\u0011\"\u00013\u0005?A\u0001b!\u0015\u0001\t\u0003\u001141\u000b\u0005\u000b\u0007S\u0002\u0011\u0013!C\u0001e\t\u0015'aE*rY\u001a{G\u000eZ3s%\u0016\u0004xn]5u_JL(BA\u001a5\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003kY\n!B]3q_NLGo\u001c:z\u0015\t9\u0004(A\u0005yYJ,G.Z1tK*\u0011\u0011HO\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aO\u0001\u0004G>l7\u0001A\n\u0007\u0001y\"\u0005\nV,\u0011\u0005}\u0012U\"\u0001!\u000b\u0003\u0005\u000bQa]2bY\u0006L!a\u0011!\u0003\r\u0005s\u0017PU3g!\t)e)D\u00015\u0013\t9EG\u0001\tG_2$WM\u001d*fa>\u001c\u0018\u000e^8ssB\u0019\u0011J\u0013'\u000e\u0003IJ!a\u0013\u001a\u0003+%sG/\u001a:dKB$X\r\u001a*fa>\u001c\u0018\u000e^8ssB\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\u0007M>dG-\u001a:\u000b\u0005E3\u0014A\u00023p[\u0006Lg.\u0003\u0002T\u001d\n1ai\u001c7eKJ\u0004\"!S+\n\u0005Y\u0013$!D*rYJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002Y;6\t\u0011L\u0003\u0002[7\u0006)1\u000f\u001c45U*\tA,\u0001\u0005he&T(\u0010\\3e\u0013\tq\u0016LA\u0004M_\u001e<\u0017N\\4\u0002#\u0019|G\u000eZ3s!\u0016\u00148/[:uK:\u001cW\r\u0005\u0002bI6\t!M\u0003\u0002de\u0005Y\u0001/\u001a:tSN$XM\\2f\u0013\t)'MA\tG_2$WM\u001d)feNL7\u000f^3oG\u0016\f!C]3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dKB\u0011\u0011\r[\u0005\u0003S\n\u0014!CU3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dK\u0006qA/Z1n%\u0016\u0004xn]5u_JL\bCA#m\u0013\tiGG\u0001\bUK\u0006l'+\u001a9pg&$xN]=\u0002%A,'/\\5tg&|g.\u00128g_J\u001cWM\u001d\t\u0003aVl\u0011!\u001d\u0006\u0003eN\f\u0001b]3dkJLG/\u001f\u0006\u0003ib\n\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003mF\u0014!\u0003U3s[&\u001c8/[8o\u000b:4wN]2fe\u0006\u0001B-Z2pe\u0006$xN]*feZL7-Z\u000b\u0002sB\u0011!p`\u0007\u0002w*\u0011A0`\u0001\tS:$XM\u001d8bY*\u0011aPN\u0001\u0004CBL\u0017bAA\u0001w\n\u0001\u0013J\u001c;fe:\fG.T3uC\u0012\fG/\u0019#fG>\u0014\u0018\r^8s'\u0016\u0014h/[2f\u0003E!WmY8sCR|'oU3sm&\u001cW\rI\u0001\rU\u0012\u00147\rV3na2\fG/Z\u000b\u0003\u0003\u0013\u0001B!a\u0003\u0002\u001e5\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"\u0001\u0003d_J,'\u0002BA\n\u0003+\tAA\u001b3cG*!\u0011qCA\r\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA\u000e\u0003\ry'oZ\u0005\u0005\u0003?\tiA\u0001\u0007KI\n\u001cG+Z7qY\u0006$X-A\u0007kI\n\u001cG+Z7qY\u0006$X\rI\u0001\bI&\fG.Z2u+\t\t9\u0003\u0005\u0003\u0002*\u0005=c\u0002BA\u0016\u0003\u0013rA!!\f\u0002F9!\u0011qFA!\u001d\u0011\t\t$a\u0010\u000f\t\u0005M\u0012Q\b\b\u0005\u0003k\tY$\u0004\u0002\u00028)\u0019\u0011\u0011\b\u001f\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0014BA\u001d;\u0013\t9\u0004(C\u0002\u0002DY\n!\u0001\u001a2\n\u0007M\n9EC\u0002\u0002DYJA!a\u0013\u0002N\u0005Q1+\u001d7Ck&dG-\u001a:\u000b\u0007M\n9%\u0003\u0003\u0002R\u0005M#a\u0002#jC2,7\r\u001e\u0006\u0005\u0003\u0017\ni%\u0001\u0005eS\u0006dWm\u0019;!\u0003\u0019a\u0014N\\5u}Q\u0001\u00121LA/\u0003?\n\t'a\u0019\u0002f\u0005\u001d\u0014\u0011\u000e\t\u0003\u0013\u0002AQaX\u0006A\u0002\u0001DQAZ\u0006A\u0002\u001dDQA[\u0006A\u0002-DQA\\\u0006A\u0002=DQa^\u0006A\u0002eDq!!\u0002\f\u0001\b\tI\u0001C\u0004\u0002$-\u0001\u001d!a\n\u0002\r\u0015D\u0018n\u001d;t)\u0011\ty'!\u001e\u0011\u0007}\n\t(C\u0002\u0002t\u0001\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002x1\u0001\r!!\u001f\u0002\u0011\u0019|G\u000eZ3s\u0013\u0012\u0004B!a\u001f\u0002\u0004:!\u0011QPA@!\r\t)\u0004Q\u0005\u0004\u0003\u0003\u0003\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0006\u0006\u001d%AB*ue&twMC\u0002\u0002\u0002\u0002C3\u0001DAF!\u0011\ti)a%\u000e\u0005\u0005=%\u0002BAI\u0003\u001b\n1\u0002\u001e:b]N\f7\r^5p]&!\u0011QSAH\u0005)I5OU3bI>sG.\u001f\u0015\u0004\u0019\u0005e\u0005\u0003BAN\u0003Sk!!!(\u000b\t\u0005}\u0015\u0011U\u0001\u000bC:tw\u000e^1uS>t'\u0002BAR\u0003K\u000bq!\\3ue&\u001c7OC\u0002\u0002(j\n\u0001bY8eC\"\fG.Z\u0005\u0005\u0003W\u000biJA\u0003US6,G-\u0001\u0005hKR$\u0016\u000e\u001e7f)\u0011\t\t,a.\u0011\u000b}\n\u0019,!\u001f\n\u0007\u0005U\u0006I\u0001\u0004PaRLwN\u001c\u0005\b\u0003oj\u0001\u0019AA=Q\ri\u00111\u0012\u0015\u0004\u001b\u0005e\u0015aB4fiB\u000bG\u000f\u001b\u000b\u0005\u0003\u0003\f\u0019\u000e\u0005\u0004\u0002D\u00065\u0017\u0011\u0010\b\u0005\u0003\u000b\fIM\u0004\u0003\u00026\u0005\u001d\u0017\"A!\n\u0007\u0005-\u0007)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0017\u0011\u001b\u0002\u0004'\u0016\f(bAAf\u0001\"9\u0011q\u000f\bA\u0002\u0005e\u0004f\u0001\b\u0002\f\"\u001aa\"!'\u0002\r\u001d,G/V5e)\u0011\ti.!>\u0011\t\u0005}\u0017q\u001e\b\u0005\u0003C\fiO\u0004\u0003\u0002d\u0006-h\u0002BAs\u0003StA!a\f\u0002h&\u0011QGN\u0005\u0003gQJ!a\u0019\u001a\n\u0007\u0005-'-\u0003\u0003\u0002r\u0006M(!B\"j+&$'bAAfE\"9\u0011qO\bA\u0002\u0005e\u0004fA\b\u0002\f\"\u001aq\"!'\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012$b!a@\u0003\u0002\t\r\u0001\u0003B \u000242Cq!a\u001e\u0011\u0001\u0004\tI\bC\u0005\u0003\u0006A\u0001\n\u00111\u0001\u0003\b\u0005)A-\u001a9uQB\u0019qH!\u0003\n\u0007\t-\u0001IA\u0002J]RD3\u0001EAM\u0003]1\u0017N\u001c3WS\u0016<\u0018M\u00197f\r>dG-\u001a:t\u0005fLE\r\u0006\u0005\u0002\u0000\nM!Q\u0003B\f\u0011\u001d\t9(\u0005a\u0001\u0003sB\u0011B!\u0002\u0012!\u0003\u0005\rAa\u0002\t\u0013\te\u0011\u0003%AA\u0002\u0005=\u0014!E3oM>\u00148-\u001a)fe6L7o]5p]\"\u001a\u0011#!'\u0002C\u0019Lg\u000e\u001a,jK^\f'\r\\3G_2$WM]:Cs&#G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t\u0005\"\u0006BA8\u0005GY#A!\n\u0011\t\t\u001d\"qF\u0007\u0003\u0005SQAAa\u000b\u0003.\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003?\u0003\u0015\u0002\u0002B\u0019\u0005S\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Ma\u0017n\u001d;WS\u0016<\u0018M\u00197f\r>dG-\u001a:t))\u00119D!\u000f\u0003>\t\u001d#1\n\t\u0006\u0003\u0007\fi\r\u0014\u0005\b\u0005w\u0019\u0002\u0019AA=\u0003!\u0001\u0018M]3oi&#\u0007b\u0002B '\u0001\u0007!\u0011I\u0001\u0005a\u0006<W\rE\u0002F\u0005\u0007J1A!\u00125\u0005\u0011\u0001\u0016mZ3\t\u0013\t%3\u0003%AA\u0002\u0005=\u0014a\u00063fG>\u0014\u0018\r^3XSRD\u0007+\u001a:nSN\u001c\u0018n\u001c8t\u0011%\u0011Ib\u0005I\u0001\u0002\u0004\ty\u0007K\u0002\u0014\u00033\u000bQ\u0004\\5tiZKWm^1cY\u00164u\u000e\u001c3feN$C-\u001a4bk2$HeM\u0001\u001eY&\u001cHOV5fo\u0006\u0014G.\u001a$pY\u0012,'o\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005qb-\u001b8e\u001dVl'-\u001a:PM\u000eC\u0017\u000e\u001c3sK:4uN]!G_2$WM\u001d\u000b\u0005\u0005\u000f\u00119\u0006C\u0004\u0002xY\u0001\r!!\u001f)\u0007Y\tI*\u0001\u000eeK\u000e|'/\u0019;f/&$\b.\u00123jiB+'/\\5tg&|g\u000e\u0006\u0004\u0003`\t\u0015$\u0011\u000e\t\u0004\u007f\t\u0005\u0014b\u0001B2\u0001\n!QK\\5u\u0011\u001d\u00119g\u0006a\u0001\u0005o\tqAZ8mI\u0016\u00148\u000fC\u0004\u0003l]\u0001\r!!1\u0002\u001f\u0019|G\u000eZ3sg^KG\u000f[#eSR\f!\u0004Z3d_J\fG/Z,ji\"4\u0016.Z<QKJl\u0017n]:j_:$BAa\u0018\u0003r!9!q\r\rA\u0002\t]\u0012\u0001G:fi\u0006\u001bXI\u001a4fGRLg/Z*fGV\u0014\u0018\u000e^=JIR!!q\fB<\u0011\u001d\t9(\u0007a\u0001\u0003sB3!GAM\u0003iIg\u000e[3sSR,eMZ3di&4XmU3dkJLG/_%e)\u0011\u0011yFa \t\u000f\u0005]$\u00041\u0001\u0002z!\u001a!$!'\u0002\r\r\u0014X-\u0019;f)\u0015a%q\u0011BE\u0011\u001d\u0011Yd\u0007a\u0001\u0003sBQaT\u000eA\u00021C3aGAM\u0003\u0019!W\r\\3uKR1!q\fBI\u0005'Cq!a\u001e\u001d\u0001\u0004\tI\bC\u0005\u0003\u0016r\u0001\n\u00111\u0001\u0003\u0018\u0006iA-\u001a7fi\u0016\u0014V\r\\3bg\u0016\u0004\u0012b\u0010BM\u0005\u000f\tIHa\u0018\n\u0007\tm\u0005IA\u0005Gk:\u001cG/[8oe!\u001aA$!'\u0002\rI,g.Y7f)\u0015a%1\u0015BS\u0011\u001d\t9(\ba\u0001\u0003sBqAa*\u001e\u0001\u0004\tI(A\u0004oK^t\u0015-\\3)\u0007u\tI*\u0001\u0003n_Z,G#\u0002'\u00030\nE\u0006bBA<=\u0001\u0007\u0011\u0011\u0010\u0005\b\u0005gs\u0002\u0019AA=\u0003-qWm\u001e)be\u0016tG/\u00133)\u0007y\tI*\u0001\u0006gS:$')\u001f)bi\"$R\u0001\u0014B^\u0005\u007fCqA!0 \u0001\u0004\tI(A\u0005uSRdW\rU1uQ\"I!QA\u0010\u0011\u0002\u0003\u0007!q\u0001\u0015\u0004?\u0005e\u0015\u0001\u00064j]\u0012\u0014\u0015\u0010U1uQ\u0012\"WMZ1vYR$#'\u0006\u0002\u0003H*\"!q\u0001B\u0012\u0003Q1\u0017N\u001c3Tk\n4u\u000e\u001c3fe\nKH+\u001b;mKR1\u0011q Bg\u0005\u001fDqAa\u000f\"\u0001\u0004\tI\bC\u0004\u0003R\u0006\u0002\r!!\u001f\u0002\t9\fW.\u001a\u0015\u0004C\u0005e\u0015!E5t\r>dG-\u001a:J]\",'/\u001b;fIR!\u0011q\u000eBm\u0011\u001d\t9H\ta\u0001\u0003sB3AIAFQ\r\u0011\u0013\u0011T\u0001\u0019M&tGmU;c\r>dG-\u001a:ECR\f')\u001f+ji2,GC\u0002Br\u0005c\u0014\u0019\u0010E\u0003@\u0003g\u0013)\u000f\u0005\u0003\u0003h\n5XB\u0001Bu\u0015\r\u0011YOY\u0001\u0005I\u0006$\u0018-\u0003\u0003\u0003p\n%(!\u0003$pY\u0012,'OU8x\u0011\u001d\t9h\ta\u0001\u0003sBqA!5$\u0001\u0004\tI(\u0001\u0006j]N,'\u000f\u001e(pI\u0016$\u0002B!?\u0004\u0010\rE1Q\u0003\t\u0007\u0005w\u001cIA!:\u000f\t\tu81\u0001\b\u0005\u0003_\u0011y0C\u0002\u0004\u0002Y\nQ!\u001e;jYNLAa!\u0002\u0004\b\u0005!AK]3f\u0015\r\u0019\tAN\u0005\u0005\u0007\u0017\u0019iA\u0001\u0003O_\u0012,'\u0002BB\u0003\u0007\u000fAqA!5%\u0001\u0004\tI\bC\u0004\u0004\u0014\u0011\u0002\r!!\u001f\u0002\u000f\u001dLg/\u001a8JI\"91q\u0003\u0013A\u0002\u0005E\u0016a\u00039be\u0016tG/\u00133PaR\fABZ5oI:{G-\u001a\"z\u0013\u0012$bA!?\u0004\u001e\r}\u0001bBA<K\u0001\u0007\u0011\u0011\u0010\u0005\n\u0005\u000b)\u0003\u0013!a\u0001\u0005\u000f\taCZ5oI:{G-\u001a\"z\u0013\u0012$C-\u001a4bk2$HEM\u0001\u000eM&tGMT8eK\nKX+\u001b3\u0015\r\te8qEB\u0016\u0011\u001d\u0019Ic\na\u0001\u0003;\fQaY5VS\u0012D\u0011B!\u0002(!\u0003\u0005\rAa\u0002\u0002/\u0019Lg\u000e\u001a(pI\u0016\u0014\u00150V5eI\u0011,g-Y;mi\u0012\u0012\u0014!\u00057jgR4\u0016.Z<bE2,gj\u001c3fgRA11GB\u001d\u0007w\u0019i\u0004\u0005\u0004\u0002D\u000eU\"\u0011`\u0005\u0005\u0007o\t\tN\u0001\u0003MSN$\bbBA<S\u0001\u0007\u0011\u0011\u0010\u0005\n\u0005\u000bI\u0003\u0013!a\u0001\u0005\u000fA\u0011B!\u0007*!\u0003\u0005\r!a\u001c\u000271L7\u000f\u001e,jK^\f'\r\\3O_\u0012,7\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003ma\u0017n\u001d;WS\u0016<\u0018M\u00197f\u001d>$Wm\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005)b-\u001b8e-&,w/\u00192mK:{G-Z:Cs&#G\u0003\u0003B}\u0007\u000f\u001aIea\u0013\t\u000f\u0005]D\u00061\u0001\u0002z!I!Q\u0001\u0017\u0011\u0002\u0003\u0007!q\u0001\u0005\n\u00053a\u0003\u0013!a\u0001\u0003_\nqDZ5oIZKWm^1cY\u0016tu\u000eZ3t\u0005fLE\r\n3fM\u0006,H\u000e\u001e\u00133\u0003}1\u0017N\u001c3WS\u0016<\u0018M\u00197f\u001d>$Wm\u001d\"z\u0013\u0012$C-\u001a4bk2$HeM\u0001\u0018M&tG-\u00123ji\u0006\u0014G.\u001a$pY\u0012,'o\u001d\"z\u0013\u0012$ba!\u0016\u0004f\r\u001d\u0004CBB,\u0007C\u0012)/\u0004\u0002\u0004Z)!11LB/\u0003\u001diW\u000f^1cY\u0016T1aa\u0018A\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0007G\u001aIF\u0001\u0004Ck\u001a4WM\u001d\u0005\b\u0003oz\u0003\u0019AA=\u0011%\u0011)a\fI\u0001\u0002\u0004\u00119!A\u0011gS:$W\tZ5uC\ndWMR8mI\u0016\u00148OQ=JI\u0012\"WMZ1vYR$#\u0007K\u0002\u0001\u0007[\u0002B!!$\u0004p%!1\u0011OAH\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007")
public class SqlFolderRepository
implements FolderRepository,
InterceptedRepository<Folder>,
SqlRepository {
    private final FolderPersistence folderPersistence;
    private final ReleasePersistence releasePersistence;
    private final TeamRepository teamRepository;
    private final PermissionEnforcer permissionEnforcer;
    private final InternalMetadataDecoratorService decoratorService;
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Folder>> persistenceInterceptors;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public void registerPersistenceInterceptor(PersistenceInterceptor<Folder> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    public Function2<Object, String, BoxedUnit> delete$default$2() {
        return FolderRepository.delete$default$2$((FolderRepository)this);
    }

    public int findById$default$2() {
        return FolderRepository.findById$default$2$((FolderRepository)this);
    }

    public int findViewableFoldersById$default$2() {
        return FolderRepository.findViewableFoldersById$default$2$((FolderRepository)this);
    }

    public void checkFolderExists(String folderId) {
        FolderRepository.checkFolderExists$((FolderRepository)this, (String)folderId);
    }

    public void checkNameIsUnique(String parentId, String name) {
        FolderRepository.checkNameIsUnique$((FolderRepository)this, (String)parentId, (String)name);
    }

    public scala.collection.immutable.Seq<Folder> paginate(scala.collection.immutable.Seq<Folder> folders, Page page) {
        return FolderRepository.paginate$((FolderRepository)this, folders, (Page)page);
    }

    public scala.collection.immutable.Seq<Folder> decorateWithEffectiveSecurity(scala.collection.immutable.Seq<Folder> folders, DecoratorsCache cache) {
        return FolderRepository.decorateWithEffectiveSecurity$((FolderRepository)this, folders, (DecoratorsCache)cache);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Folder>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Folder>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlFolderRepository sqlFolderRepository = this;
        synchronized (sqlFolderRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public InternalMetadataDecoratorService decoratorService() {
        return this.decoratorService;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String folderId) {
        return this.folderPersistence.exists(folderId);
    }

    @Timed
    @IsReadOnly
    public Option<String> getTitle(String folderId) {
        return this.findById(folderId, 0).map((Function1 & Serializable)x$1 -> x$1.getTitle());
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> getPath(String folderId) {
        return this.folderPersistence.getFolderPathSegments(folderId);
    }

    @Timed
    @IsReadOnly
    public Integer getUid(String folderId) {
        return this.folderPersistence.getUid(folderId);
    }

    @Timed
    public Option<Folder> findById(String folderId, int depth) {
        return Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(this.findNodeById(folderId, depth))).map((Function1 & Serializable)tree -> {
            Folder folder = FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)tree));
            this.decoratorService().decorate((ConfigurationItem)folder, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY(), (List)new .colon.colon((Object)FolderVariablesDecorator$.MODULE$.FOLDER_VARIABLES(), (List)Nil$.MODULE$))).asJava());
            return folder;
        });
    }

    @Timed
    public Option<Folder> findViewableFoldersById(String folderId, int depth, boolean enforcePermission) {
        DecoratorsCache cache = new DecoratorsCache(DecoratorsCache$.MODULE$.$lessinit$greater$default$1());
        return Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(this.findViewableNodesById(folderId, depth, enforcePermission))).map((Function1 & Serializable)tree -> {
            Folder folder = FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)tree));
            this.decoratorService().decorate((ConfigurationItem)folder, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY(), (List)new .colon.colon((Object)FolderVariablesDecorator$.MODULE$.FOLDER_VARIABLES(), (List)Nil$.MODULE$))).asJava(), cache);
            folder.setChildren(CollectionConverters$.MODULE$.SetHasAsJava((Set)this.decorateWithEffectiveSecurity((scala.collection.immutable.Seq<Folder>)CollectionConverters$.MODULE$.SetHasAsScala(folder.getChildren()).asScala().toSeq(), cache).toSet()).asJava());
            return folder;
        });
    }

    public boolean findViewableFoldersById$default$3() {
        return true;
    }

    @Timed
    public scala.collection.immutable.Seq<Folder> listViewableFolders(String parentId, Page page, boolean decorateWithPermissions, boolean enforcePermission) {
        scala.collection.immutable.Seq<Folder> viewableResults = this.paginate((scala.collection.immutable.Seq<Folder>)this.listViewableNodes(parentId, page.depth(), enforcePermission).map((Function1 & Serializable)x$2 -> FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)x$2))), page);
        if (decorateWithPermissions) {
            DecoratorsCache decoratorsCache = new DecoratorsCache(DecoratorsCache$.MODULE$.$lessinit$greater$default$1());
            return this.decorateWithEffectiveSecurity(viewableResults, decoratorsCache);
        }
        Buffer<FolderRow> editableResults = this.findEditableFoldersById(parentId, page.depth());
        this.decorateWithViewPermission(viewableResults);
        this.decorateWithEditPermission(viewableResults, (scala.collection.immutable.Seq<String>)((IterableOnceOps)editableResults.map((Function1 & Serializable)x$3 -> FolderRow$FolderDataOps$.MODULE$.asFolder$extension(FolderRow$.MODULE$.FolderDataOps((FolderRow)x$3)).getId())).toSeq());
        return viewableResults;
    }

    public boolean listViewableFolders$default$3() {
        return true;
    }

    public boolean listViewableFolders$default$4() {
        return true;
    }

    @Timed
    public int findNumberOfChildrenForAFolder(String folderId) {
        return this.folderPersistence.findNumberOfChildrenForAFolder(folderId);
    }

    private void decorateWithEditPermission(scala.collection.immutable.Seq<Folder> folders, scala.collection.immutable.Seq<String> foldersWithEdit) {
        folders.foreach((Function1 & Serializable)f -> {
            SqlFolderRepository.$anonfun$decorateWithEditPermission$1(this, foldersWithEdit, f);
            return BoxedUnit.UNIT;
        });
    }

    private void decorateWithViewPermission(scala.collection.immutable.Seq<Folder> folders) {
        folders.foreach((Function1 & Serializable)f -> {
            SqlFolderRepository.$anonfun$decorateWithViewPermission$1(this, f);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void setAsEffectiveSecurityId(String folderId) {
        this.folderPersistence.setAsEffectiveSecuredCi(folderId);
    }

    @Timed
    public void inheritEffectiveSecurityId(String folderId) {
        this.folderPersistence.inheritEffectiveSecuredCi(folderId);
    }

    @Timed
    public Folder create(String parentId, Folder folder) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.interceptCreate((ConfigurationItem)folder);
            return this.insertNode(folder.getTitle(), folder.getId(), (Option<String>)new Some((Object)parentId));
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Tree.Node created = (Tree.Node)success.value();
            return FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)created));
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().error((Function0 & Serializable)() -> e);
            throw new FoldersStoreException("Cannot create folder " + folder.getId() + " under " + parentId);
        }
        throw new MatchError((Object)try_);
    }

    @Timed
    public void delete(String folderId, Function2<Object, String, BoxedUnit> deleteRelease) {
        Integer ciUid = ((FolderRow)this.findNodeById(folderId, 0).value()).uid();
        this.folderPersistence.deleteReleases(ciUid, deleteRelease);
        Tree.TreeOps$.MODULE$.bottomUp$extension(Tree$.MODULE$.TreeOps(this.findNodeById(folderId, this.findNodeById$default$2()))).foreach((Function1 & Serializable)data -> {
            SqlFolderRepository.$anonfun$delete$1(this, data);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Folder rename(String folderId, String newName) {
        return this.folderPersistence.rename(folderId, newName, this.folderPersistence.rename$default$3());
    }

    @Timed
    public Folder move(String folderId, String newParentId) {
        Integer oldSubtreeSecurityUid = ((FolderRow)this.findNodeById(folderId, 0).value()).securityUid();
        Tree.Node<FolderRow> moved = this.folderPersistence.move(folderId, newParentId, this.folderPersistence.move$default$3());
        Integer newSubtreeSecurityUid = ((FolderRow)moved.value()).securityUid();
        this.releasePersistence.replaceSecurityUid(((FolderRow)moved.value()).uid(), oldSubtreeSecurityUid, newSubtreeSecurityUid);
        return FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps(moved));
    }

    @Timed
    public Folder findByPath(String titlePath, int depth) {
        if (Strings.isEmpty((String)titlePath)) {
            throw new NotFoundException("Cannot find folder by empty path: " + titlePath, new Object[0]);
        }
        String pathFromRoot = titlePath.startsWith("/") ? titlePath.substring(1) : titlePath;
        this.logger().debug((Function0 & Serializable)() -> "Finding folder by path " + pathFromRoot);
        String[] pathElements = (String[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])pathFromRoot.split("/")), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isEmpty()));
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])pathElements))) {
            throw new IllegalArgumentException("No folder path specified, the root path is not supported");
        }
        Option option = ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])pathElements));
        if (None$.MODULE$.equals(option)) {
            throw new NotFoundException("Cannot find folder by empty path: " + titlePath, new Object[0]);
        }
        if (!(option instanceof Some)) {
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String topName = (String)some.value();
        Option<FolderRow> topLevelData = this.findSubFolderDataByTitle(Ids.ROOT_FOLDER_ID, topName);
        Integer topLevelUid = (Integer)topLevelData.map((Function1 & Serializable)x$5 -> x$5.uid()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find folder [" + ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])pathElements)).getOrElse((Function0 & Serializable)() -> "") + "] in path [" + titlePath + "]", new Object[0]);
        });
        Tree.Node topNode = (Tree.Node)Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(this.findNodeByUid(topLevelUid, Math.max(depth, ((String[])ArrayOps$.MODULE$.tail$extension(Predef$.MODULE$.refArrayOps((Object[])pathElements))).length)))).get();
        return FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)((Tree.Node)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.tail$extension(Predef$.MODULE$.refArrayOps((Object[])pathElements))), (Object)topNode, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tree.Node node = (Tree.Node)tuple2._1();
                String pathElement = (String)tuple2._2();
                return (Tree.Node)node.children().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SqlFolderRepository.$anonfun$findByPath$7(pathElement, x$6))).getOrElse((Function0 & Serializable)() -> {
                    throw new NotFoundException("Could not find folder [" + pathElement + "] in path [" + titlePath + "]", new Object[0]);
                });
            }
            throw new MatchError((Object)tuple2);
        }))));
    }

    public int findByPath$default$2() {
        return Integer.MAX_VALUE;
    }

    @Timed
    public Option<Folder> findSubFolderByTitle(String parentId, String name) {
        return this.findSubFolderDataByTitle(parentId, name).map((Function1 & Serializable)x$7 -> FolderRow$FolderDataOps$.MODULE$.asFolder$extension(FolderRow$.MODULE$.FolderDataOps((FolderRow)x$7)));
    }

    @Timed
    @IsReadOnly
    public boolean isFolderInherited(String folderId) {
        return this.folderPersistence.isInherited(folderId);
    }

    public Option<FolderRow> findSubFolderDataByTitle(String folderId, String name) {
        return this.folderPersistence.findSubFolderByTitle(name, folderId);
    }

    public Tree.Node<FolderRow> insertNode(String name, String givenId, Option<String> parentIdOpt) {
        return this.folderPersistence.create(name, givenId, parentIdOpt);
    }

    public Tree.Node<FolderRow> findNodeById(String folderId, int depth) {
        return this.folderPersistence.findById(folderId, depth);
    }

    public int findNodeById$default$2() {
        return Integer.MAX_VALUE;
    }

    public Tree.Node<FolderRow> findNodeByUid(Integer ciUid, int depth) {
        Tree.Node<FolderRow> viewableTree = this.permissionEnforcer.isCurrentUserAdmin() || this.permissionEnforcer.hasLoggedInUserPermission(new Permission[]{XLReleasePermissions.AUDIT_ALL}) ? this.folderPersistence.findByUid(ciUid, depth) : this.folderPersistence.findByUidHavingPermission(ciUid, XLReleasePermissions.VIEW_FOLDER, (Iterable<String>)CollectionConverters$.MODULE$.CollectionHasAsScala(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala(), depth);
        return viewableTree;
    }

    public int findNodeByUid$default$2() {
        return Integer.MAX_VALUE;
    }

    private List<Tree.Node<FolderRow>> listViewableNodes(String folderId, int depth, boolean enforcePermission) {
        Tree.Node<FolderRow> viewableTree = this.findViewableNodesById(folderId, depth, enforcePermission);
        return (List)Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(viewableTree)).fold((Function0 & Serializable)() -> package$.MODULE$.List().empty(), (Function1 & Serializable)x$8 -> x$8.children());
    }

    private int listViewableNodes$default$2() {
        return Integer.MAX_VALUE;
    }

    private boolean listViewableNodes$default$3() {
        return true;
    }

    public Tree.Node<FolderRow> findViewableNodesById(String folderId, int depth, boolean enforcePermission) {
        Tree.Node<FolderRow> viewableTree = !enforcePermission || this.permissionEnforcer.isCurrentUserAdmin() || this.permissionEnforcer.hasLoggedInUserPermission(new Permission[]{XLReleasePermissions.AUDIT_ALL}) ? this.folderPersistence.findById(folderId, depth) : this.folderPersistence.findByIdHavingPermission(folderId, XLReleasePermissions.VIEW_FOLDER, (Iterable<String>)CollectionConverters$.MODULE$.CollectionHasAsScala(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala(), depth);
        return viewableTree;
    }

    public int findViewableNodesById$default$2() {
        return Integer.MAX_VALUE;
    }

    public boolean findViewableNodesById$default$3() {
        return true;
    }

    public Buffer<FolderRow> findEditableFoldersById(String folderId, int depth) {
        Buffer<FolderRow> folders = this.permissionEnforcer.isCurrentUserAdmin() || this.permissionEnforcer.hasLoggedInUserPermission(new Permission[]{XLReleasePermissions.AUDIT_ALL}) ? this.folderPersistence.findDescendantsById(folderId, depth) : this.folderPersistence.findDescendantsByIdHavingPermission(folderId, XLReleasePermissions.EDIT_FOLDER, (Iterable<String>)CollectionConverters$.MODULE$.CollectionHasAsScala(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala(), depth);
        return folders;
    }

    public int findEditableFoldersById$default$2() {
        return Integer.MAX_VALUE;
    }

    public static final /* synthetic */ void $anonfun$decorateWithEditPermission$1(SqlFolderRepository $this, scala.collection.immutable.Seq foldersWithEdit$1, Folder f) {
        Object object;
        if (foldersWithEdit$1.contains((Object)f.getId())) {
            EffectiveSecurity effectiveSecurity = (EffectiveSecurity)f.get$metadata().get("security");
            object = BoxesRunTime.boxToBoolean((boolean)effectiveSecurity.getPermissions().add(XLReleasePermissions.EDIT_FOLDER.getPermissionName()));
        } else {
            object = BoxedUnit.UNIT;
        }
        $this.decorateWithEditPermission((scala.collection.immutable.Seq<Folder>)CollectionConverters$.MODULE$.SetHasAsScala(f.getChildren()).asScala().toSeq(), (scala.collection.immutable.Seq<String>)foldersWithEdit$1);
    }

    public static final /* synthetic */ void $anonfun$decorateWithViewPermission$1(SqlFolderRepository $this, Folder f) {
        HashSet<String> permissions = new HashSet<String>();
        permissions.add(XLReleasePermissions.VIEW_FOLDER.getPermissionName());
        f.get$metadata().put("security", new EffectiveSecurity(permissions, java.util.Set.of()));
        $this.decorateWithViewPermission((scala.collection.immutable.Seq<Folder>)CollectionConverters$.MODULE$.SetHasAsScala(f.getChildren()).asScala().toSeq());
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlFolderRepository $this, FolderRow data) {
        if (data.hasSecurity()) {
            $this.teamRepository.deleteTeamsFromPlatform(data.folderId().absolute());
        }
        $this.folderPersistence.deleteByUid(data.uid());
        $this.interceptDelete(data.folderId().absolute());
    }

    public static final /* synthetic */ boolean $anonfun$findByPath$7(String pathElement$1, Tree.Node x$6) {
        String string = ((FolderRow)x$6.value()).name();
        String string2 = pathElement$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SqlFolderRepository(FolderPersistence folderPersistence, ReleasePersistence releasePersistence, TeamRepository teamRepository, PermissionEnforcer permissionEnforcer, InternalMetadataDecoratorService decoratorService, JdbcTemplate jdbcTemplate, SqlBuilder.Dialect dialect) {
        this.folderPersistence = folderPersistence;
        this.releasePersistence = releasePersistence;
        this.teamRepository = teamRepository;
        this.permissionEnforcer = permissionEnforcer;
        this.decoratorService = decoratorService;
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        Logging.$init$((Logging)this);
        FolderRepository.$init$((FolderRepository)this);
        InterceptedRepository.$init$((InterceptedRepository)this);
    }
}

