package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.db.sql.SqlBuilder.{Dialect, MSSQLDialect}
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport
import com.xebialabs.xlrelease.repository.sql.persistence.Utils._
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema.ROLES
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.UpgradeSupport.TransactionSupport
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Component
import org.springframework.transaction.support.TransactionTemplate


@Component
class XLRelease980TeamsTrimName @Autowired()(@Qualifier("xlrRepositoryJdbcTemplate") val jdbcTemplate: JdbcTemplate,
                                             @Qualifier("xlrRepositorySqlDialect") implicit val dialect: Dialect,
                                             @Qualifier("xlrRepositoryTransactionTemplate") val transactionTemplate: TransactionTemplate,
                                             xlrConfig: XlrConfig)
  extends Upgrade
    with PersistenceSupport
    with Logging
    with TransactionSupport {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "9.8.0#1")

  override def doUpgrade(): Boolean = {
    logger.info("Starting trimming names of all teams")

    updateTeams()

    logger.info("Finished trimming names of all teams")
    true
  }

  private def trim(column: String): String = dialect match {
    case MSSQLDialect(_) => s"LTRIM(RTRIM($column))"
    case _ => s"TRIM($column)"
  }

  private val STMT_UPDATE_TEAM_NAME =
    s"""UPDATE ${ROLES.TABLE}
       |         SET ${ROLES.name} = ${trim(ROLES.name)}
       |""".stripMargin

  private def updateTeams(): Unit = {
    sqlUpdate(STMT_UPDATE_TEAM_NAME,
      params(),
      identity
    )
  }
}
