package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.security.PermissionEditor
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence
import com.xebialabs.xlrelease.security.XLReleasePermissions.{ADVANCE_TASK_TRANSITION, TASK_TRANSITION}
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Component

@Component
class XLRelease221AdvanceTaskTransitionPermissionUpgrader(folderPersistence: FolderPersistence,
                                                          permissionEditor: PermissionEditor,
                                                          @Qualifier("xlrRepositoryJdbcTemplate") val jdbcTemplate: JdbcTemplate,
                                                          @Qualifier("xlrRepositorySqlDialect") implicit val dialect: Dialect
                                                         )
  extends Upgrade with BasePermissionUpgrade {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "22.1.0#1")

  override def doUpgrade(): Boolean = {
    logger.info("Started Advance task transition Permission upgrade.")
    upgradePermission(folderPersistence, permissionEditor, TASK_TRANSITION, ADVANCE_TASK_TRANSITION)
    logger.info("Finished Advance task transition Permission upgrade.")
    true
  }
}
