/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ExtendedValidationContext;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext$;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.configuration.ThemeSettings;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.repository.CiProperty;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.query.ReleaseBasicData;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.ReferencedEntity;
import com.xebialabs.xlrelease.repository.sql.SqlConfigurationRepository$;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ReleaseConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.TriggerConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ConfigurationReferenceRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ConfigurationReferenceRow$;
import com.xebialabs.xlrelease.scheduler.filters.JobFilters;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import com.xebialabs.xlrelease.service.ConfigurationVariableService$;
import com.xebialabs.xlrelease.utils.FolderId;
import com.xebialabs.xlrelease.utils.TypeHelper$;
import com.xebialabs.xlrelease.validation.ExtendedValidationContextImpl;
import com.xebialabs.xlrelease.validation.XlrValidationsFailedException;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0011-c\u0001\u0002!B\u00011C\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tQ\u0002\u0011\t\u0011)A\u0005S\"AA\u000e\u0001B\u0001B\u0003%Q\u000e\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003r\u0011!)\bA!A!\u0002\u00131\b\u0002\u0003>\u0001\u0005\u0003\u0005\u000b\u0011B>\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b!Y\u0011q\u0003\u0001A\u0002\u0003\u0007I\u0011AA\r\u0011-\t\t\u0003\u0001a\u0001\u0002\u0004%\t!a\t\t\u0017\u0005=\u0002\u00011A\u0001B\u0003&\u00111\u0004\u0005\n\u0003\u001f\u0002!\u0019!C\u0005\u0003#B\u0001\"!\u001b\u0001A\u0003%\u00111\u000b\u0005\n\u0003W\u0002!\u0019!C\u0005\u0003#B\u0001\"!\u001c\u0001A\u0003%\u00111\u000b\u0005\n\u0003_\u0002!\u0019!C\u0005\u0003#B\u0001\"!\u001d\u0001A\u0003%\u00111\u000b\u0005\n\u0003g\u0002!\u0019!C\u0005\u0003kB\u0001\"a#\u0001A\u0003%\u0011q\u000f\u0005\b\u0003\u001b\u0003A\u0011IAH\u0011\u001d\ti\t\u0001C!\u0003\u000bDq!a?\u0001\t\u0013\ti\u0010C\u0004\u0003\u0004\u0001!IA!\u0002\t\u000f\t=\u0001\u0001\"\u0011\u0003\u0012!9!q\u0004\u0001\u0005B\t\u0005\u0002b\u0002B\u0010\u0001\u0011\u0005#Q\u0006\u0005\b\u0005w\u0001A\u0011\tB\u001f\u0011\u001d\u0011\u0019\b\u0001C!\u0005kBqAa\u001d\u0001\t\u0003\u00129\tC\u0005\u0003$\u0002\t\n\u0011\"\u0001\u0003&\"9!Q\u0018\u0001\u0005\n\t}\u0006b\u0002Br\u0001\u0011\u0005!Q\u001d\u0005\b\u0005c\u0004A\u0011\u0001Bz\u0011\u001d\u0011I\u0010\u0001C\u0001\u0005wD\u0011ba\u0007\u0001#\u0003%\ta!\b\t\u000f\r\u0005\u0002\u0001\"\u0011\u0004$!91\u0011\u0005\u0001\u0005B\rU\u0002bBB,\u0001\u0011\u00053\u0011\f\u0005\b\u0007C\u0002A\u0011BB2\u0011\u001d\u0019i\t\u0001C!\u0007\u001fCqa!&\u0001\t\u0003\u00199\nC\u0004\u0004$\u0002!\ta!*\t\u000f\r%\u0006\u0001\"\u0011\u0004,\"91q\u0018\u0001\u0005\n\r\u0005\u0007bBBq\u0001\u0011\u000531\u001d\u0005\b\u0007S\u0004A\u0011IBv\u0011\u001d\u0019\u0019\u0010\u0001C\u0005\u0007k<q\u0001\"\u0001B\u0011\u0003!\u0019A\u0002\u0004A\u0003\"\u0005AQ\u0001\u0005\b\u0003\u000b\u0001D\u0011\u0001C\u0004\r\u0019!I\u0001M\u0003\u0005\f!QAQ\u0002\u001a\u0003\u0002\u0003\u0006IA!\u0017\t\u000f\u0005\u0015!\u0007\"\u0001\u0005\u0010!9Aq\u0003\u001a\u0005\u0002\u0011e\u0001b\u0002C\u000ee\u0011\u0005AQ\u0004\u0005\n\tG\u0001\u0014\u0011!C\u0006\tK1a\u0001\"\u000b1\u000b\u0011-\u0002B\u0003C\u0017q\t\u0005\t\u0015!\u0003\u0002$\"9\u0011Q\u0001\u001d\u0005\u0002\u0011=\u0002\"\u0003B,q\t\u0007I\u0011\u0002C\u001b\u0011!!9\u0004\u000fQ\u0001\n\te\u0003b\u0002C\fq\u0011\u0005A\u0011\u0004\u0005\b\tsAD\u0011\u0001C\u001e\u0011%!)\u0005MA\u0001\n\u0017!9E\u0001\u000eTc2\u001cuN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018P\u0003\u0002C\u0007\u0006\u00191/\u001d7\u000b\u0005\u0011+\u0015A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011aiR\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001S%\u0002\u0013a,'-[1mC\n\u001c(\"\u0001&\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001i5k\u0016\t\u0003\u001dFk\u0011a\u0014\u0006\u0002!\u0006)1oY1mC&\u0011!k\u0014\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Q+V\"A\"\n\u0005Y\u001b%aF\"p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z!\tAV,D\u0001Z\u0015\tQ6,A\u0003tY\u001a$$NC\u0001]\u0003!9'/\u001b>{Y\u0016$\u0017B\u00010Z\u0005\u001daunZ4j]\u001e\f\u0001dY8oM&<WO]1uS>t\u0007+\u001a:tSN$XM\\2f!\t\tg-D\u0001c\u0015\t\u0019G-A\u0007d_:4\u0017nZ;sCRLwN\u001c\u0006\u0003K\u0006\u000b1\u0002]3sg&\u001cH/\u001a8dK&\u0011qM\u0019\u0002\u0019\u0007>tg-[4ve\u0006$\u0018n\u001c8QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\u0001\u000b:fY\u0016\f7/Z\"p]\u001aLw-\u001e:bi&|gNU3gKJ,gnY3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007CA1k\u0013\tY'M\u0001\u0015SK2,\u0017m]3D_:4\u0017nZ;sCRLwN\u001c*fM\u0016\u0014XM\\2f!\u0016\u00148/[:uK:\u001cW-\u0001\u0015ue&<w-\u001a:D_:4\u0017nZ;sCRLwN\u001c*fM\u0016\u0014XM\\2f!\u0016\u00148/[:uK:\u001cW\r\u0005\u0002b]&\u0011qN\u0019\u0002))JLwmZ3s\u0007>tg-[4ve\u0006$\u0018n\u001c8SK\u001a,'/\u001a8dKB+'o]5ti\u0016t7-Z\u0001\u0015gFd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0011\u0005I\u001cX\"A!\n\u0005Q\f%\u0001F*rYJ+\u0007o\\:ji>\u0014\u00180\u00113baR,'/A\tg_2$WM\u001d)feNL7\u000f^3oG\u0016\u0004\"a\u001e=\u000e\u0003\u0011L!!\u001f3\u0003#\u0019{G\u000eZ3s!\u0016\u00148/[:uK:\u001cW-A\u0007k_\n\u0014V\r]8tSR|'/\u001f\t\u0004y\u0006\u0005Q\"A?\u000b\u0005\u0011s(BA@F\u0003%\u00198\r[3ek2,'/C\u0002\u0002\u0004u\u0014QBS8c%\u0016\u0004xn]5u_JL\u0018A\u0002\u001fj]&$h\b\u0006\b\u0002\n\u0005-\u0011QBA\b\u0003#\t\u0019\"!\u0006\u0011\u0005I\u0004\u0001\"B0\b\u0001\u0004\u0001\u0007\"\u00025\b\u0001\u0004I\u0007\"\u00027\b\u0001\u0004i\u0007\"\u00029\b\u0001\u0004\t\b\"B;\b\u0001\u00041\b\"\u0002>\b\u0001\u0004Y\u0018!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssV\u0011\u00111\u0004\t\u0004)\u0006u\u0011bAA\u0010\u0007\n\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\u0002+I,G.Z1tKJ+\u0007o\\:ji>\u0014\u0018p\u0018\u0013fcR!\u0011QEA\u0016!\rq\u0015qE\u0005\u0004\u0003Sy%\u0001B+oSRD\u0011\"!\f\n\u0003\u0003\u0005\r!a\u0007\u0002\u0007a$\u0013'\u0001\nsK2,\u0017m]3SKB|7/\u001b;pef\u0004\u0003f\u0001\u0006\u00024A!\u0011QGA&\u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012AC1o]>$\u0018\r^5p]*!\u0011QHA \u0003\u001d1\u0017m\u0019;pefTA!!\u0011\u0002D\u0005)!-Z1og*!\u0011QIA$\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA%\u0003\ry'oZ\u0005\u0005\u0003\u001b\n9DA\u0005BkR|w/\u001b:fI\u00069!+\u0012'F\u0003N+UCAA*!\u0011\t)&a\u0019\u000f\t\u0005]\u0013q\f\t\u0004\u00033zUBAA.\u0015\r\tifS\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0005t*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003K\n9G\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003Cz\u0015\u0001\u0003*F\u0019\u0016\u000b5+\u0012\u0011\u0002\u0011Q+U\n\u0015'B)\u0016\u000b\u0011\u0002V#N!2\u000bE+\u0012\u0011\u0002\u000fQ\u0013\u0016jR$F%\u0006AAKU%H\u000f\u0016\u0013\u0006%\u0001\u0004nCB\u0004XM]\u000b\u0003\u0003o\u0002B!!\u001f\u0002\b6\u0011\u00111\u0010\u0006\u0005\u0003{\ny(\u0001\u0005eCR\f'-\u001b8e\u0015\u0011\t\t)a!\u0002\u000f)\f7m[:p]*\u0019\u0011QQ%\u0002\u0013\u0019\f7\u000f^3sq6d\u0017\u0002BAE\u0003w\u0012Ab\u00142kK\u000e$X*\u00199qKJ\fq!\\1qa\u0016\u0014\b%\u0001\u0004de\u0016\fG/Z\u000b\u0005\u0003#\u000b9\n\u0006\u0003\u0002\u0014\u0006=\u0006\u0003BAK\u0003/c\u0001\u0001B\u0004\u0002\u001aN\u0011\r!a'\u0003\u0003Q\u000bB!!(\u0002$B\u0019a*a(\n\u0007\u0005\u0005vJA\u0004O_RD\u0017N\\4\u0011\t\u0005\u0015\u00161V\u0007\u0003\u0003OS1!!+F\u0003\u0019!w.\\1j]&!\u0011QVAT\u0005E\u0011\u0015m]3D_:4\u0017nZ;sCRLwN\u001c\u0005\u0007GN\u0001\r!a%)\u0007M\t\u0019\f\u0005\u0003\u00026\u0006\u0005WBAA\\\u0015\u0011\tI$!/\u000b\t\u0005m\u0016QX\u0001\b[\u0016$(/[2t\u0015\r\ty,S\u0001\tG>$\u0017\r[1mK&!\u00111YA\\\u0005\u0015!\u0016.\\3e+\u0011\t9-a3\u0015\r\u0005%\u0017QZAh!\u0011\t)*a3\u0005\u000f\u0005eEC1\u0001\u0002\u001c\"11\r\u0006a\u0001\u0003\u0013Dq!!5\u0015\u0001\u0004\t\u0019.A\u0006g_2$WM]\"j+&$\u0007\u0003BAk\u0003gtA!a6\u0002p:!\u0011\u0011\\Aw\u001d\u0011\tY.a;\u000f\t\u0005u\u0017\u0011\u001e\b\u0005\u0003?\f9O\u0004\u0003\u0002b\u0006\u0015h\u0002BA-\u0003GL\u0011AS\u0005\u0003\u0011&K!AR$\n\u0005\u0011+\u0015B\u0001\"D\u0013\t)\u0017)C\u0002\u0002r\u0012\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002v\u0006](!B\"j+&$'bAAyI\"\u001aA#a-\u0002\u001d\u001d,GOR8mI\u0016\u00148)[+jIR!\u00111[A\u0000\u0011\u001d\u0011\t!\u0006a\u0001\u0003'\n\u0001BZ8mI\u0016\u0014\u0018\nZ\u0001\u0011G\",7m[\"be\u0012Lg.\u00197jif,BAa\u0002\u0003\u000eQ!\u0011Q\u0005B\u0005\u0011\u0019\u0019g\u00031\u0001\u0003\fA!\u0011Q\u0013B\u0007\t\u001d\tIJ\u0006b\u0001\u00037\u000bAA]3bIV!!1\u0003B\f)\u0011\u0011)B!\u0007\u0011\t\u0005U%q\u0003\u0003\b\u00033;\"\u0019AAN\u0011\u001d\u0011Yb\u0006a\u0001\u0003'\nqbY8oM&<WO]1uS>t\u0017\n\u001a\u0015\u0004/\u0005M\u0016AB;qI\u0006$X-\u0006\u0003\u0003$\t\u001dB\u0003\u0002B\u0013\u0005S\u0001B!!&\u0003(\u00119\u0011\u0011\u0014\rC\u0002\u0005m\u0005BB2\u0019\u0001\u0004\u0011)\u0003K\u0002\u0019\u0003g+BAa\f\u00034Q1!\u0011\u0007B\u001b\u0005o\u0001B!!&\u00034\u00119\u0011\u0011T\rC\u0002\u0005m\u0005BB2\u001a\u0001\u0004\u0011\t\u0004C\u0004\u0002Rf\u0001\r!a5)\u0007e\t\u0019,A\u0007gS:$\u0017\t\u001c7CsRK\b/Z\u000b\u0005\u0005\u007f\u0011\u0019\u0006\u0006\u0003\u0003B\tU\u0003C\u0002B\"\u0005\u001b\u0012\t&\u0004\u0002\u0003F)!!q\tB%\u0003\u0011)H/\u001b7\u000b\u0005\t-\u0013\u0001\u00026bm\u0006LAAa\u0014\u0003F\t!A*[:u!\u0011\t)Ja\u0015\u0005\u000f\u0005e%D1\u0001\u0002\u001c\"9!q\u000b\u000eA\u0002\te\u0013AB2j)f\u0004X\r\u0005\u0003\u0003\\\t5TB\u0001B/\u0015\u0011\u0011yF!\u0019\u0002\u000fI,g\r\\3di*!!1\rB3\u0003\r\t\u0007/\u001b\u0006\u0005\u0005O\u0012I'\u0001\u0004qYV<\u0017N\u001c\u0006\u0004\u0005W:\u0015\u0001\u00033fa2|\u00170\u001b;\n\t\t=$Q\f\u0002\u0005)f\u0004X\rK\u0002\u001b\u0003g\u000bQCZ5oI\u0006cGNQ=UsB,\u0017I\u001c3USRdW-\u0006\u0003\u0003x\tuDC\u0002B=\u0005\u007f\u0012\t\t\u0005\u0004\u0003D\t5#1\u0010\t\u0005\u0003+\u0013i\bB\u0004\u0002\u001an\u0011\r!a'\t\u000f\t]3\u00041\u0001\u0003Z!9!1Q\u000eA\u0002\u0005M\u0013!\u0002;ji2,\u0007fA\u000e\u00024V!!\u0011\u0012BH))\u0011YI!%\u0003\u0014\nU%q\u0013\t\u0007\u0005\u0007\u0012iE!$\u0011\t\u0005U%q\u0012\u0003\b\u00033c\"\u0019AAN\u0011\u001d\u00119\u0006\ba\u0001\u00053B\u0011Ba!\u001d!\u0003\u0005\r!a\u0015\t\u000f\t\u0005A\u00041\u0001\u0002T!9!\u0011\u0014\u000fA\u0002\tm\u0015A\u00034pY\u0012,'o\u00148msB\u0019aJ!(\n\u0007\t}uJA\u0004C_>dW-\u00198)\u0007q\t\u0019,A\u0010gS:$\u0017\t\u001c7CsRK\b/Z!oIRKG\u000f\\3%I\u00164\u0017-\u001e7uII*BAa*\u0003<V\u0011!\u0011\u0016\u0016\u0005\u0003'\u0012Yk\u000b\u0002\u0003.B!!q\u0016B\\\u001b\t\u0011\tL\u0003\u0003\u00034\nU\u0016!C;oG\",7m[3e\u0015\r\tIdT\u0005\u0005\u0005s\u0013\tLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$q!!'\u001e\u0005\u0004\tY*A\tsK\u0006$7i\u001c8gS\u001e,(/\u0019;j_:,BA!1\u0003LR!!1\u0019Bg!\u0015q%Q\u0019Be\u0013\r\u00119m\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005U%1\u001a\u0003\b\u00033s\"\u0019AAN\u0011\u001d\u0011yM\ba\u0001\u0005#\f1A]8x!\u0011\u0011\u0019N!8\u000f\t\tU'\u0011\u001c\b\u0005\u0003/\u00149.\u0003\u0002dI&\u0019!1\u001c2\u00021\r{gNZ5hkJ\fG/[8o!\u0016\u00148/[:uK:\u001cW-\u0003\u0003\u0003`\n\u0005(\u0001E\"p]\u001aLw-\u001e:bi&|gNU8x\u0015\r\u0011YNY\u0001\tM&tGMQ=JIV!!q\u001dBw)\u0011\t)C!;\t\u000f\t-x\u00041\u0001\u0002T\u0005A1m\u001c8gS\u001eLE\rB\u0004\u0002\u001a~\u0011\r!a')\u0007}\t\u0019,\u0001\u000egS:$7i\u001c8gS\u001e,(/\u0019;j_:$\u0016\u000e\u001e7f\u0005fLE\r\u0006\u0003\u0002T\tU\bb\u0002BvA\u0001\u0007\u00111\u000b\u0015\u0004A\u0005M\u0016\u0001F3ySN$8OQ=UsB,\u0017I\u001c3USRdW-\u0006\u0003\u0003~\u000e\rAC\u0002BN\u0005\u007f\u001c\t\u0001C\u0004\u0003X\u0005\u0002\rA!\u0017\t\u0013\t\r\u0015\u0005%AA\u0002\u0005MCaBAMC\t\u0007\u00111\u0014\u0015\u0004C\r\u001d\u0001\u0003BB\u0005\u0007+i!aa\u0003\u000b\t\r51qB\u0001\fiJ\fgn]1di&|gNC\u0002C\u0007#Q1aa\u0005F\u0003\t!'-\u0003\u0003\u0004\u0018\r-!AC%t%\u0016\fGm\u00148ms\"\u001a\u0011%a-\u0002=\u0015D\u0018n\u001d;t\u0005f$\u0016\u0010]3B]\u0012$\u0016\u000e\u001e7fI\u0011,g-Y;mi\u0012\u0012T\u0003\u0002BT\u0007?!q!!'#\u0005\u0004\tY*A\bgS:$g)\u001b:ti\nKH+\u001f9f+\u0011\u0019)ca\f\u0015\t\r\u001d2\u0011\u0007\t\u0007\u0005\u0007\u001aIc!\f\n\t\r-\"Q\t\u0002\t\u001fB$\u0018n\u001c8bYB!\u0011QSB\u0018\t\u001d\tIj\tb\u0001\u00037CqAa\u0016$\u0001\u0004\u0011I\u0006K\u0002$\u0003g+Baa\u000e\u0004>Q11\u0011HB \u0007\u0003\u0002bAa\u0011\u0004*\rm\u0002\u0003BAK\u0007{!q!!'%\u0005\u0004\tY\nC\u0004\u0003X\u0011\u0002\rA!\u0017\t\u000f\r\rC\u00051\u0001\u0004F\u000591m\u001c8uKb$\b\u0003BB$\u0007#j!a!\u0013\u000b\t\r-3QJ\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\t\r=#\u0011N\u0001\ta2,XNY5oO&!11KB%\u0005E\u0011Vm]8mkRLwN\\\"p]R,\u0007\u0010\u001e\u0015\u0004I\u0005M\u0016AB3ySN$8\u000f\u0006\u0003\u0003\u001c\u000em\u0003b\u0002B\u000eK\u0001\u0007\u00111\u000b\u0015\u0004K\r\u001d\u0001fA\u0013\u00024\u00069r-\u001a;D_:4\u0017n\u001a*fM\u0016\u0014XM\\2fIJ{wo\u001d\u000b\u0007\u0007K\u001a\tia!\u0011\r\r\u001d4qNB;\u001d\u0011\u0019Ig!\u001c\u000f\t\u0005e31N\u0005\u0002!&\u0019\u0011\u0011_(\n\t\rE41\u000f\u0002\u0004'\u0016\f(bAAy\u001fB!1qOB?\u001b\t\u0019IHC\u0002\u0004|\u0011\fA\u0001Z1uC&!1qPB=\u0005e\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+g-\u001a:f]\u000e,'k\\<\t\u000f\tma\u00051\u0001\u0002T!91Q\u0011\u0014A\u0002\r\u001d\u0015!I2p]\u001aLw-\u001e:bi&|gNU3gKJ,gnY3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007cA1\u0004\n&\u001911\u00122\u0003C\r{gNZ5hkJ\fG/[8o%\u00164WM]3oG\u0016\u0004VM]:jgR,gnY3\u0002\r\u0011,G.\u001a;f)\u0011\t)c!%\t\u000f\tmq\u00051\u0001\u0002T!\u001aq%a-\u0002-\u001d,GOS8c%Vtg.\u001a:SK\u001a,'/\u001a8dKN$Ba!'\u0004\"B11qMB8\u00077\u00032A]BO\u0013\r\u0019y*\u0011\u0002\u0011%\u00164WM]3oG\u0016$WI\u001c;jifDqAa\u0007)\u0001\u0004\t\u0019&\u0001\u000fhKR\u001cuN\u001c4jOJ+g-\u001a:f]\u000e,7/\u00138SK2,\u0017m]3\u0015\t\re5q\u0015\u0005\b\u00057I\u0003\u0019AA*\u0003Q9W\r\u001e*fM\u0016\u0014XM\\2f%\u0016dW-Y:fgR!1QVB^!\u0019\u0011\u0019E!\u0014\u00040B!1\u0011WB\\\u001b\t\u0019\u0019LC\u0002\u00046\u000e\u000bQ!];fefLAa!/\u00044\n\u0001\"+\u001a7fCN,')Y:jG\u0012\u000bG/\u0019\u0005\b\u00057Q\u0003\u0019AA*Q\rQ\u00131W\u0001\u0011O\u0016$\u0018\t\u001c7Tk\n$\u0016\u0010]3t\u001f\u001a,Baa1\u0004`R!1QYBo!\u0019\u00199m!5\u0004T6\u00111\u0011\u001a\u0006\u0005\u0007\u0017\u001ci-A\u0005j[6,H/\u00192mK*\u00191qZ(\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004r\r%\u0007\u0003BBk\u00077l!aa6\u000b\t\re'\u0011J\u0001\u0005Y\u0006tw-\u0003\u0003\u0002f\r]\u0007b\u0002B,W\u0001\u0007!\u0011\f\u0003\b\u00033[#\u0019AAN\u0003-9W\r^!mYRK\b/Z:\u0016\u0005\r\u0015\bCBB4\u0007_\n\u0019\u0006K\u0002-\u0003g\u000bQ\u0002Z3mKR,')\u001f+za\u0016\u001cH\u0003BA\u0013\u0007[Dqaa<.\u0001\u0004\u0019)/A\u0004dSRK\b/Z:)\u00075\n\u0019,\u0001\u0005wC2LG-\u0019;f)\u0011\t)ca>\t\r\rt\u0003\u0019AARQ\r\u000111 \t\u0005\u0007\u0013\u0019i0\u0003\u0003\u0004\u0000\u000e-!aD%t)J\fgn]1di&|g.\u00197\u00025M\u000bHnQ8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0011\u0005I\u00044C\u0001\u0019N)\t!\u0019AA\u0004UsB,w\n]:\u0014\u0005Ij\u0015A\u0002=m)f\u0004X\r\u0006\u0003\u0005\u0012\u0011U\u0001c\u0001C\ne5\t\u0001\u0007C\u0004\u0005\u000eQ\u0002\rA!\u0017\u0002\u001d!\f7oQ1sI&t\u0017\r\\5usV\u0011!1T\u0001\fQ\u0006\u001c\bK]8qKJ$\u0018\u0010\u0006\u0003\u0003\u001c\u0012}\u0001b\u0002C\u0011m\u0001\u0007\u00111K\u0001\raJ|\u0007/\u001a:us:\u000bW.Z\u0001\b)f\u0004Xm\u00149t)\u0011!\t\u0002b\n\t\u000f\u00115q\u00071\u0001\u0003Z\t!\")Y:f\u0007>tg-[4ve\u0006$\u0018n\u001c8PaN\u001c\"\u0001O'\u0002\u0005\rLG\u0003\u0002C\u0019\tg\u00012\u0001b\u00059\u0011\u001d!iC\u000fa\u0001\u0003G+\"A!\u0017\u0002\u000f\rLG+\u001f9fA\u0005qq-\u001a;DCJ$\u0017N\\1mSRLXC\u0001C\u001f!\u0015q%Q\u0019C !\rqE\u0011I\u0005\u0004\t\u0007z%aA%oi\u0006!\")Y:f\u0007>tg-[4ve\u0006$\u0018n\u001c8PaN$B\u0001\"\r\u0005J!9AQF A\u0002\u0005\r\u0006")
public class SqlConfigurationRepository
implements ConfigurationRepository,
Logging {
    private final ConfigurationPersistence configurationPersistence;
    private final ReleaseConfigurationReferencePersistence releaseConfigurationReferencePersistence;
    private final TriggerConfigurationReferencePersistence triggerConfigurationReferencePersistence;
    private final SqlRepositoryAdapter sqlRepositoryAdapter;
    private final FolderPersistence folderPersistence;
    private final JobRepository jobRepository;
    @Autowired
    private ReleaseRepository releaseRepository;
    private final String RELEASE;
    private final String TEMPLATE;
    private final String TRIGGER;
    private final ObjectMapper mapper;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private scala.collection.immutable.Seq<PersistenceInterceptor<BaseConfiguration>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public ThemeSettings getThemeSettings() {
        return ConfigurationRepository.getThemeSettings$((ConfigurationRepository)this);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<BaseConfiguration> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlConfigurationRepository sqlConfigurationRepository = this;
        synchronized (sqlConfigurationRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<BaseConfiguration>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<BaseConfiguration>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    public void releaseRepository_$eq(ReleaseRepository x$1) {
        this.releaseRepository = x$1;
    }

    private String RELEASE() {
        return this.RELEASE;
    }

    private String TEMPLATE() {
        return this.TEMPLATE;
    }

    private String TRIGGER() {
        return this.TRIGGER;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    @Timed
    public <T extends BaseConfiguration> T create(T configuration) {
        return this.create(configuration, this.getFolderCiUid(configuration.getFolderId()));
    }

    @Timed
    public <T extends BaseConfiguration> T create(T configuration, Integer folderCiUid) {
        this.checkCardinality(configuration);
        this.validate(configuration);
        this.interceptCreate((ConfigurationItem)configuration);
        this.configurationPersistence.insert(configuration, folderCiUid);
        this.afterCreate((ConfigurationItem)configuration);
        return configuration;
    }

    private Integer getFolderCiUid(String folderId) {
        Integer n;
        block3: {
            String string = folderId;
            switch (string == null ? 0 : string.hashCode()) {
                case 0: {
                    if (string != null) break;
                    n = null;
                    break block3;
                }
            }
            n = this.folderPersistence.getUid(string);
        }
        return n;
    }

    private <T extends BaseConfiguration> void checkCardinality(T configuration) {
        Type configurationType = Type.valueOf(BaseConfiguration.class);
        if (SqlConfigurationRepository$.MODULE$.com$xebialabs$xlrelease$repository$sql$SqlConfigurationRepository$$BaseConfigurationOps(configuration).hasCardinality()) {
            Type configGroupType = (Type)SqlConfigurationRepository.groupType$1(configuration, configurationType).getOrElse((Function0 & Serializable)() -> configuration.getType());
            Buffer foundConfigs = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.findAllByTypeAndTitle(configGroupType, null, configuration.getFolderId(), false)).asScala().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SqlConfigurationRepository.$anonfun$checkCardinality$3(configuration, x$2)));
            Option<Object> cardinality = SqlConfigurationRepository$.MODULE$.com$xebialabs$xlrelease$repository$sql$SqlConfigurationRepository$$BaseConfigurationOps(configuration).getCardinality();
            if (cardinality.isDefined() && foundConfigs.size() >= BoxesRunTime.unboxToInt((Object)cardinality.get())) {
                String folderId = configuration.getFolderId() == null ? Ids.ROOT_FOLDER_ID : configuration.getFolderId();
                throw new ItemAlreadyExistsException(new StringBuilder(60).append("There are already ").append(foundConfigs.length()).append(" items of type '").append(configGroupType).append("' defined on the folder '").append(folderId).append("'").toString(), new Object[0]);
            }
        }
    }

    @Timed
    public <T extends BaseConfiguration> T read(String configurationId) {
        return (T)((BaseConfiguration)Option$.MODULE$.apply(this.sqlRepositoryAdapter.read(configurationId)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(24).append("Configuration ").append(configurationId).append(" not found").toString(), new Object[0]);
        }));
    }

    @Timed
    public <T extends BaseConfiguration> T update(T configuration) {
        return this.update(configuration, this.getFolderCiUid(configuration.getFolderId()));
    }

    @Timed
    public <T extends BaseConfiguration> T update(T configuration, Integer folderCiUid) {
        this.validate(configuration);
        this.interceptUpdate((ConfigurationItem)configuration);
        this.configurationPersistence.update(configuration);
        this.afterUpdate((ConfigurationItem)configuration);
        return configuration;
    }

    @Timed
    public <T extends BaseConfiguration> List<T> findAllByType(Type ciType) {
        return CollectionConverters$.MODULE$.BufferHasAsJava(((IterableOnceOps)this.configurationPersistence.findByTypes(this.getAllSubTypesOf(ciType)).flatMap((Function1 & Serializable)row -> this.readConfiguration((Tuple2<Option<FolderId>, String>)row))).toBuffer()).asJava();
    }

    @Timed
    public <T extends BaseConfiguration> List<T> findAllByTypeAndTitle(Type ciType, String title) {
        return this.findAllByTypeAndTitle(ciType, title, null, false);
    }

    @Timed
    public <T extends BaseConfiguration> List<T> findAllByTypeAndTitle(Type ciType, String title, String folderId, boolean folderOnly) {
        return CollectionConverters$.MODULE$.BufferHasAsJava(((IterableOnceOps)this.configurationPersistence.findByTypesTitleAndFolder(this.getAllSubTypesOf(ciType), (Option<String>)Option$.MODULE$.apply((Object)title).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$3.trim())))), (Option<Either<String, String>>)Option$.MODULE$.apply((Object)folderId).map((Function1)(folderOnly ? (Function1 & Serializable)value -> package$.MODULE$.Right().apply(value) : (Function1 & Serializable)value -> package$.MODULE$.Left().apply(value)))).flatMap((Function1 & Serializable)row -> this.readConfiguration((Tuple2<Option<FolderId>, String>)row))).toBuffer()).asJava();
    }

    public <T extends BaseConfiguration> String findAllByTypeAndTitle$default$2() {
        return null;
    }

    private <T extends BaseConfiguration> Option<T> readConfiguration(Tuple2<Option<FolderId>, String> row) {
        Tuple2<Option<FolderId>, String> tuple2 = row;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option folderIdOpt = (Option)tuple2._1();
        String rawConfiguration = (String)tuple2._2();
        Option option = this.sqlRepositoryAdapter.deserialize(rawConfiguration).map((Function1 & Serializable)conf -> (BaseConfiguration)folderIdOpt.fold((Function0 & Serializable)() -> conf, (Function1 & Serializable)folderId -> {
            conf.setFolderId(folderId.absolute());
            return conf;
        }));
        return option;
    }

    @Timed
    public <T extends BaseConfiguration> void findById(String configId) {
        this.configurationPersistence.findById(configId);
    }

    @Timed
    public String findConfigurationTitleById(String configId) {
        return this.configurationPersistence.findConfigurationTitleById(configId);
    }

    @Timed
    @IsReadOnly
    public <T extends BaseConfiguration> boolean existsByTypeAndTitle(Type ciType, String title) {
        return this.configurationPersistence.existsByTypeAndTitle(this.getAllSubTypesOf(ciType), title);
    }

    @Timed
    public <T extends BaseConfiguration> Optional<T> findFirstByType(Type ciType) {
        return this.findFirstByType(ciType, ResolutionContext$.MODULE$.GLOBAL());
    }

    @Timed
    public <T extends BaseConfiguration> Optional<T> findFirstByType(Type ciType, ResolutionContext context) {
        return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.configurationPersistence.findFirstByTypes(this.getAllSubTypesOf(ciType), (Option<String>)context.folderId()).flatMap((Function1 & Serializable)row -> this.readConfiguration((Tuple2<Option<FolderId>, String>)row))));
    }

    @Timed
    @IsReadOnly
    public boolean exists(String configurationId) {
        return this.configurationPersistence.exists(configurationId);
    }

    public <T extends BaseConfiguration> String existsByTypeAndTitle$default$2() {
        return null;
    }

    private scala.collection.immutable.Seq<ConfigurationReferenceRow> getConfigReferencedRows(String configurationId, ConfigurationReferencePersistence configurationReferencePersistence) {
        return configurationReferencePersistence.isReferenced(configurationId) ? configurationReferencePersistence.getReferencingEntities(configurationId) : (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    @Timed
    public void delete(String configurationId) {
        SeqOps seqOps;
        scala.collection.immutable.Seq allReferences;
        scala.collection.immutable.Seq seq;
        Object config = this.read(configurationId);
        if (config.getType().isSubTypeOf(Type.valueOf(JobRunner.class))) {
            seq = this.getJobRunnerReferences(configurationId);
        } else {
            scala.collection.immutable.Seq<ReferencedEntity> configReferencesInRelease = this.getConfigReferencesInRelease(configurationId);
            scala.collection.immutable.Seq configReferencesInTrigger = (scala.collection.immutable.Seq)this.getConfigReferencedRows(configurationId, this.triggerConfigurationReferencePersistence).map((Function1 & Serializable)configRef -> new ReferencedEntity(configRef.id(), configRef.title(), "Trigger"));
            seq = (scala.collection.immutable.Seq)configReferencesInRelease.$plus$plus((IterableOnce)configReferencesInTrigger);
        }
        scala.collection.immutable.Seq seq2 = allReferences = seq;
        if (seq2 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq2)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) != 0) {
            this.mapper().registerModule((Module)DefaultScalaModule$.MODULE$);
            String json = this.mapper().writeValueAsString((Object)allReferences);
            throw new ItemInUseException("%s", new Object[]{json});
        }
        this.interceptDelete(configurationId);
        this.configurationPersistence.delete(configurationId);
        this.afterDelete(configurationId);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public scala.collection.immutable.Seq<ReferencedEntity> getJobRunnerReferences(String configurationId) {
        JobFilters jobFilters = new JobFilters();
        jobFilters.runnerId_$eq(configurationId);
        Page jobs = this.jobRepository.findAllJobOverview(jobFilters, Pageable.unpaged());
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(jobs.getContent()).asScala().map((Function1 & Serializable)overview -> new ReferencedEntity(overview.taskId(), overview.taskTitle(), "Task"))).toSeq();
    }

    public scala.collection.immutable.Seq<ReferencedEntity> getConfigReferencesInRelease(String configurationId) {
        scala.collection.immutable.Seq<ConfigurationReferenceRow> configReferences = this.getConfigReferencedRows(configurationId, this.releaseConfigurationReferencePersistence);
        scala.collection.immutable.Seq ids = (scala.collection.immutable.Seq)configReferences.map((Function1 & Serializable)ref -> Ids.getFolderlessId((String)ref.id()));
        scala.collection.immutable.Seq statusesWithIds = this.releaseRepository().getStatusesWithIds(ids);
        scala.collection.immutable.Seq configRefsWithFolderlessIds = (scala.collection.immutable.Seq)configReferences.map((Function1 & Serializable)ref -> new ConfigurationReferenceRow(ref.title(), ref.id()));
        return (scala.collection.immutable.Seq)configRefsWithFolderlessIds.map((Function1 & Serializable)reference -> {
            String folderlessId = Ids.getFolderlessId((String)reference.id());
            ReleaseStatus status = (ReleaseStatus)((Tuple2)((IterableOps)statusesWithIds.filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)SqlConfigurationRepository.$anonfun$getConfigReferencesInRelease$4(folderlessId, t)))).head())._2();
            ReleaseStatus releaseStatus = status;
            String string = ReleaseStatus.TEMPLATE.equals(releaseStatus) ? "Template" : "Release";
            String referencedBy = string;
            return new ReferencedEntity(reference.id(), reference.title(), referencedBy);
        });
    }

    @Timed
    public List<ReleaseBasicData> getReferenceReleases(String configurationId) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.releaseConfigurationReferencePersistence.getReferencingEntities(configurationId).map((Function1 & Serializable)x$4 -> ConfigurationReferenceRow$.MODULE$.ConfigurationReferenceDataOps((ConfigurationReferenceRow)x$4).asReleaseData())).asJava();
    }

    private <T extends BaseConfiguration> scala.collection.immutable.Seq<String> getAllSubTypesOf(Type ciType) {
        return (scala.collection.immutable.Seq)TypeHelper$.MODULE$.getAllSubtypesOf(ciType).map((Function1 & Serializable)x$5 -> x$5.toString());
    }

    @Timed
    public scala.collection.immutable.Seq<String> getAllTypes() {
        return this.configurationPersistence.findAllConfigurationTypes();
    }

    @Timed
    public void deleteByTypes(scala.collection.immutable.Seq<String> ciTypes) {
        scala.collection.immutable.Seq<Integer> configurationCiUids = this.configurationPersistence.findUidsByTypes(ciTypes);
        this.releaseConfigurationReferencePersistence.deleteRefsByConfigurationUids(configurationCiUids);
        this.triggerConfigurationReferencePersistence.deleteRefsByConfigurationUids(configurationCiUids);
        this.configurationPersistence.deleteByTypes(ciTypes);
    }

    private void validate(BaseConfiguration configuration) {
        ListBuffer passVarUsagePoints = ListBuffer$.MODULE$.empty();
        BaseConfiguration baseConfiguration = configuration;
        if (baseConfiguration instanceof Configuration) {
            Configuration configuration2 = (Configuration)baseConfiguration;
            ConfigurationVariableService$.MODULE$.getUsagePointsByVars((Iterable)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Configuration[]{configuration2}))).values().foreach((Function1 & Serializable)usagePoints -> {
                usagePoints.foreach((Function1 & Serializable)up -> {
                    CiProperty targetProperty = up.getTargetProperty();
                    PropertyDescriptor desc = targetProperty.getDescriptor();
                    PropertyKind propertyKind = desc.getKind();
                    PropertyKind propertyKind2 = PropertyKind.STRING;
                    Checks.checkArgument((!(propertyKind != null ? !propertyKind.equals(propertyKind2) : propertyKind2 != null) && desc.isPassword() ? 1 : 0) != 0, (String)"Non-password-type variables in configuration variableMapping are not supported", (Object[])new Object[0]);
                    targetProperty.setValue((Object)"<temporary_value>");
                    return (ListBuffer)passVarUsagePoints$1.$plus$eq(up);
                });
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Descriptor desc = configuration.getType().getDescriptor();
        ExtendedValidationContextImpl extendedValidationContext = new ExtendedValidationContextImpl((ConfigurationItem)configuration);
        desc.validate((ExtendedValidationContext)extendedValidationContext, (ConfigurationItem)configuration);
        List messages = extendedValidationContext.getMessages();
        Object object = !messages.isEmpty() ? BoxesRunTime.boxToBoolean((boolean)configuration.get$validationMessages().addAll(messages)) : BoxedUnit.UNIT;
        if (!configuration.get$validationMessages().isEmpty()) {
            throw new XlrValidationsFailedException((ConfigurationItem)configuration);
        }
        passVarUsagePoints.toList().foreach((Function1 & Serializable)up -> {
            SqlConfigurationRepository.$anonfun$validate$3(up);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$checkCardinality$1(Type configurationType$1, BaseConfiguration configuration$1, Type superType) {
        if (!superType.isSubTypeOf(configurationType$1)) return false;
        if (!SqlConfigurationRepository$.MODULE$.com$xebialabs$xlrelease$repository$sql$SqlConfigurationRepository$$TypeOps(superType).hasCardinality()) return false;
        Integer n = BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)superType.getDescriptor().getPropertyDescriptor("cardinality").getDefaultValue()));
        Option<Object> option = SqlConfigurationRepository$.MODULE$.com$xebialabs$xlrelease$repository$sql$SqlConfigurationRepository$$BaseConfigurationOps(configuration$1).getCardinality();
        if (n != null) {
            if (!((Object)n).equals(option)) return false;
            return true;
        }
        if (option == null) return true;
        return false;
    }

    private static final Option groupType$1(BaseConfiguration configuration, Type configurationType$1) {
        List superClasses = configuration.getType().getDescriptor().getSuperClasses();
        return CollectionConverters$.MODULE$.ListHasAsScala(superClasses).asScala().find((Function1 & Serializable)superType -> BoxesRunTime.boxToBoolean((boolean)SqlConfigurationRepository.$anonfun$checkCardinality$1(configurationType$1, configuration, superType)));
    }

    public static final /* synthetic */ boolean $anonfun$checkCardinality$3(BaseConfiguration configuration$2, BaseConfiguration x$2) {
        String string = x$2.getFolderId();
        String string2 = configuration$2.getFolderId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConfigReferencesInRelease$4(String folderlessId$1, Tuple2 t) {
        return ((String)t._1()).equals(folderlessId$1);
    }

    public static final /* synthetic */ void $anonfun$validate$3(UsagePoint up) {
        up.getTargetProperty().setValue(null);
    }

    public SqlConfigurationRepository(ConfigurationPersistence configurationPersistence, ReleaseConfigurationReferencePersistence releaseConfigurationReferencePersistence, TriggerConfigurationReferencePersistence triggerConfigurationReferencePersistence, SqlRepositoryAdapter sqlRepositoryAdapter, FolderPersistence folderPersistence, JobRepository jobRepository) {
        this.configurationPersistence = configurationPersistence;
        this.releaseConfigurationReferencePersistence = releaseConfigurationReferencePersistence;
        this.triggerConfigurationReferencePersistence = triggerConfigurationReferencePersistence;
        this.sqlRepositoryAdapter = sqlRepositoryAdapter;
        this.folderPersistence = folderPersistence;
        this.jobRepository = jobRepository;
        InterceptedRepository.$init$((InterceptedRepository)this);
        ConfigurationRepository.$init$((ConfigurationRepository)this);
        Logging.$init$((Logging)this);
        this.RELEASE = "Release";
        this.TEMPLATE = "Template";
        this.TRIGGER = "Trigger";
        this.mapper = new ObjectMapper();
    }

    private static class BaseConfigurationOps {
        private final BaseConfiguration ci;
        private final Type ciType;

        private Type ciType() {
            return this.ciType;
        }

        public boolean hasCardinality() {
            return this.ci.hasProperty("cardinality");
        }

        public Option<Object> getCardinality() {
            return this.hasCardinality() ? new Some((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)this.ciType().getDescriptor().getPropertyDescriptor("cardinality").getDefaultValue()))) : None$.MODULE$;
        }

        public BaseConfigurationOps(BaseConfiguration ci) {
            this.ci = ci;
            this.ciType = ci.getType();
        }
    }

    private static class TypeOps {
        private final Type xlType;

        public boolean hasCardinality() {
            return this.hasProperty("cardinality");
        }

        public boolean hasProperty(String propertyName) {
            return this.xlType.getDescriptor().getPropertyDescriptor(propertyName) != null;
        }

        public TypeOps(Type xlType) {
            this.xlType = xlType;
        }
    }
}

