package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.repository.RepositoryAdapter
import com.xebialabs.deployit.service.validation.Validator
import com.xebialabs.xlrelease.db.ArchivedReleases
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional
import com.xebialabs.xlrelease.domain._
import com.xebialabs.xlrelease.repository.sql.persistence.CiId._
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationPersistence.ConfigurationRow
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow
import com.xebialabs.xlrelease.repository.sql.persistence.{DependencyPersistence, FacetPersistence, ReleasePersistence, TaskPersistence}
import com.xebialabs.xlrelease.repository.sql.proxy.{CiReferenceTargetTypeResolver, ProxyBasedResolverRepository}
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions
import com.xebialabs.xlrelease.service.NonDecryptingPasswordEncrypter
import grizzled.slf4j.Logging

import java.util
import scala.jdk.CollectionConverters._

@IsTransactional
class SqlRepositoryAdapter(val releasePersistence: ReleasePersistence,
                           dependencyPersistence: DependencyPersistence,
                           val configurationPersistence: ConfigurationReferencePersistence,
                           facetPersistence: FacetPersistence,
                           taskPersistence: TaskPersistence,
                           validator: Validator,
                           encrypter: NonDecryptingPasswordEncrypter,
                           val referenceTargetTypeResolver: CiReferenceTargetTypeResolver,
                           archivedReleases: ArchivedReleases
                          )
  extends RepositoryAdapter(null, null, null, null)
    with Logging
    with ProxyBasedResolverRepository {

  def repositoryWithCache(resolveOptions: ResolveOptions = ResolveOptions.WITH_DECORATORS) = {
    val repo = SqlRepositoryAdapterWithReadsCache(
      releasePersistence,
      dependencyPersistence,
      configurationPersistence,
      facetPersistence,
      taskPersistence,
      validator,
      encrypter,
      referenceTargetTypeResolver,
      archivedReleases,
      resolveOptions
    )
    repo.setApplicationContext(this.applicationContext)
    repo
  }

  override def read[T <: ConfigurationItem](id: CiId): T = {
    repositoryWithCache(ResolveOptions.WITH_DECORATORS.withReferences).read(id)
  }

  def read[T <: ConfigurationItem](id: CiId, resolveOptions: ResolveOptions): T = {
    repositoryWithCache(resolveOptions).read(id)
  }

  override def read[T <: ConfigurationItem](ids: util.List[CiId], depth: Integer): util.List[T] = {
    ids.asScala.map(repositoryWithCache().read[T]).filter(_ != null).asJava
  }

  override def read[T <: ConfigurationItem](id: String, target: ConfigurationItem): T = {
    repositoryWithCache().read(id, target)
  }

  def deserialize(releaseData: ReleaseRow): Release = {
    repositoryWithCache().deserializeRelease(releaseData)
  }

  def tryDeserialize(releaseData: ReleaseRow): Option[Release] = {
    repositoryWithCache().tryDeserializeRelease(releaseData)
  }

  def deserialize[T <: ConfigurationItem](json: String): Option[T] = {
    repositoryWithCache().deserialize[T](json)
  }

  def readConfiguration[T <: BaseConfiguration](configurationRow: ConfigurationRow): Option[T] = {
    repositoryWithCache().readConfiguration[T](configurationRow)
  }
}
