package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.session.jdbc.JdbcIndexedSessionRepository
import org.springframework.stereotype.Component
import org.springframework.transaction.support.TransactionTemplate

@Component
class CleanSpringSessionUpgrader @Autowired()(@Qualifier("xlrRepositoryJdbcTemplate") val jdbcTemplate: JdbcTemplate,
                                              @Qualifier("xlrRepositorySqlDialect") implicit val dialect: Dialect,
                                              @Qualifier("xlrRepositoryTransactionTemplate") val transactionTemplate: TransactionTemplate)
  extends Upgrade with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "23.1.0#0")

  override def doUpgrade(): Boolean = {
    logger.info("Cleaning existing spring-session data")
    jdbcTemplate.execute(s"DELETE FROM ${JdbcIndexedSessionRepository.DEFAULT_TABLE_NAME}")
    true
  }

}
